/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.util;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.threading.NotifyingThread;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.TimeDiff;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongRunningOperationCompleteListener<T>
implements NotifyingThread.ThreadCompleteListener<T> {
    private static final Logger log = LoggerFactory.getLogger(LongRunningOperationCompleteListener.class);
    private Set<String> usernames = new HashSet<String>();

    public LongRunningOperationCompleteListener(String username) {
        this.usernames.add(username);
    }

    public LongRunningOperationCompleteListener(Set<String> usernames) {
        this.usernames = usernames;
    }

    @Override
    public void completed(NotifyingThread<T> thread) {
        SystemMessageDAO smdao = Context.get(SystemMessageDAO.class);
        UserDAO uDao = Context.get(UserDAO.class);
        Date now = new Date();
        for (String username : this.usernames) {
            User user;
            try {
                user = uDao.findByUsername(username);
                if (user == null) {
                    throw new PersistenceException("Unexisting user " + username);
                }
            }
            catch (PersistenceException e) {
                log.warn("Error retrieving user {}", (Object)username);
                continue;
            }
            Recipient recipient = new Recipient();
            recipient.setName(user.getUsername());
            recipient.setAddress(user.getUsername());
            recipient.setType(0);
            recipient.setMode("message");
            HashSet<Recipient> recipients = new HashSet<Recipient>();
            recipients.add(recipient);
            SystemMessage sysmess = new SystemMessage();
            sysmess.setAuthor("SYSTEM");
            sysmess.setRecipients(recipients);
            sysmess.setSubject(I18N.message("operationcompleted2", user.getLocale(), thread.getName()));
            if (thread.getError() == null) {
                sysmess.setMessageText(I18N.message("longrunningoperationcompleted", user.getLocale(), new Object[]{thread.getName(), TimeDiff.printDuration(thread.getElapsedTime())}));
                sysmess.setPrio(0);
            } else {
                sysmess.setMessageText(I18N.message("longrunningoperationcompletedwitherror", user.getLocale(), new Object[]{thread.getName(), TimeDiff.printDuration(thread.getElapsedTime()), thread.getError().getMessage()}));
                sysmess.setPrio(2);
                if (log.isErrorEnabled()) {
                    log.error("Thread {} ended in error after {}", thread.getName(), TimeDiff.printDuration(thread.getElapsedTime()), thread.getError());
                }
            }
            sysmess.setSentDate(now);
            sysmess.setConfirmation(0);
            sysmess.setDateScope(1);
            try {
                smdao.store(sysmess);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
    }
}

