/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.util;

import com.logicaldoc.web.util.VirtualHostHelper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseURL {
    private static final Logger log = LoggerFactory.getLogger(BaseURL.class);

    private BaseURL() {
    }

    public static String getServerURL(ServletRequest request, boolean local) {
        return VirtualHostHelper.getServerURL(request, local);
    }

    public static String getWebAppName(HttpServletRequest request) {
        String baseURL = request.getContextPath();
        if (baseURL == null) {
            return "logicaldoc";
        }
        baseURL = baseURL.replace("/", "");
        return baseURL;
    }

    public static String getBaseURL(ServletRequest request) {
        return VirtualHostHelper.getBaseURL(request);
    }

    public static String getLocalBaseURL(HttpServletRequest request) {
        String localURL = null;
        String serverUrl = BaseURL.getServerURL((ServletRequest)request, true);
        if (serverUrl != null && !(localURL = serverUrl + BaseURL.getWebAppName(request)).endsWith("/")) {
            localURL = localURL + "/";
        }
        if (localURL == null) {
            log.error("Could not retrieve loacl url correctly");
        }
        return localURL;
    }
}

