/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.stat;

import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.gui.common.client.beans.GUIParameter;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.web.service.SystemServiceImpl;
import com.logicaldoc.web.stat.ChartDrawingSupplier;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatChartServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(StatChartServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        block10: {
            File chartFile = null;
            try {
                Session session = ServletUtil.validateSession(request);
                response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
                response.setHeader("Expires", "0");
                response.setHeader("Pragma", "no-cache");
                User user = session.getUser();
                chartFile = FileUtil.createTempFile("chart", ".png");
                String chart = request.getParameter("chart");
                SystemServiceImpl service = new SystemServiceImpl();
                List<List<GUIParameter>> parameters = service.getStatistics(user.getLanguage());
                DefaultPieDataset dataset = this.prepareDataSet(parameters, chart, user);
                Font font = this.prepareFont();
                JFreeChart chrt = ChartFactory.createPieChart((String)(font != null ? I18N.message(chart, user.getLocale()) : null), (PieDataset)dataset, (font != null ? 1 : 0) != 0, (boolean)false, (boolean)false);
                chrt.setBorderVisible(false);
                PiePlot plot = (PiePlot)chrt.getPlot();
                plot.setLabelGenerator(null);
                if (font == null) {
                    log.warn("cannot find any usable font");
                    chrt.setTitle(null);
                } else {
                    chrt.getTitle().setPaint((Paint)new Color(110, 110, 110));
                    chrt.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
                    plot.setLabelFont(font);
                    plot.setLabelGap(0.02);
                }
                plot.setNoDataMessage("No data available");
                plot.setCircular(true);
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setIgnoreNullValues(false);
                plot.setDrawingSupplier((DrawingSupplier)new ChartDrawingSupplier());
                if (plot instanceof PiePlot) {
                    plot.setInteriorGap(0.05);
                }
                ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)chrt, (int)250, (int)250);
                ServletUtil.downloadFile(request, response, chartFile, chart + ".png");
            }
            catch (IOException ioe) {
                log.error("Error generating the chart", ioe);
                FileUtil.delete(chartFile);
                break block10;
            }
            catch (Exception ex) {
                try {
                    log.error(ex.getMessage(), ex);
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FileUtil.delete(chartFile);
                }
            }
            FileUtil.delete(chartFile);
        }
    }

    private Font prepareFont() {
        Font font = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge != null) {
                String[] fontNames;
                String[] stringArray = fontNames = ge.getAvailableFontFamilyNames();
                int n = fontNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if ("arial".equalsIgnoreCase(name)) {
                        font = new Font("Arial", 0, 12);
                    } else if ("helvetica".equalsIgnoreCase(name)) {
                        font = new Font("Helvetica", 0, 12);
                    } else if ("Times New Roman".equalsIgnoreCase(name)) {
                        font = new Font("Times New Roman", 0, 12);
                    }
                    ++n2;
                }
                if (font == null && fontNames != null && fontNames.length > 0) {
                    font = new Font(fontNames[0], 0, 12);
                }
            }
        }
        catch (Exception t) {
            log.warn(t.getMessage());
        }
        return font;
    }

    private DefaultPieDataset prepareDataSet(List<List<GUIParameter>> parameters, String chart, User user) {
        int index = this.getIndex(chart);
        DefaultPieDataset dataset = new DefaultPieDataset();
        long total = 0L;
        for (GUIParameter param : parameters.get(index)) {
            if (param == null) continue;
            total += this.parseLong(param);
        }
        for (GUIParameter param : parameters.get(index)) {
            double val = this.parseLong(param);
            if (total <= 0L || !((val = val * 100.0 / (double)total) >= 1.0)) continue;
            dataset.setValue((Comparable)((Object)I18N.message(param.getName(), user.getLocale())), val);
        }
        return dataset;
    }

    private long parseLong(GUIParameter param) {
        return Long.parseLong(param.getValue() != null ? param.getValue() : "0");
    }

    private int getIndex(String chart) {
        int index = 0;
        if ("repository".equals(chart)) {
            index = 0;
        } else if ("documents".equals(chart)) {
            index = 1;
        } else if ("pages".equals(chart)) {
            index = 2;
        }
        if ("folders".equals(chart)) {
            index = 3;
        }
        return index;
    }
}

