/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.TagCloud;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIParameter;
import com.logicaldoc.gui.common.client.beans.GUITag;
import com.logicaldoc.gui.frontend.client.services.TagService;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagServiceImpl
extends AbstractRemoteService
implements TagService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(TagServiceImpl.class);

    public List<GUITag> getTagCloud() throws ServerException {
        Session session = this.validateSession();
        try {
            ArrayList<GUITag> ret = new ArrayList<GUITag>();
            DocumentDAO dao = Context.get(DocumentDAO.class);
            List<TagCloud> list = dao.getTagCloud(session.getSid());
            for (TagCloud tagCloud : list) {
                GUITag c = new GUITag();
                c.setScale(tagCloud.getScale());
                c.setTag(tagCloud.getTag());
                c.setCount(tagCloud.getCount());
                ret.add(c);
            }
            return ret;
        }
        catch (Exception t) {
            return (List)this.throwServerException(session, log, t);
        }
    }

    public void delete(String tag) {
    }

    public void rename(String tag, String newTag) {
    }

    public void addTag(String tag) throws ServerException {
    }

    public void removeTag(String tag) throws ServerException {
    }

    public List<GUIParameter> getSettings() throws ServerException {
        Session session = this.validateSession();
        ContextProperties conf = Context.get().getProperties();
        ArrayList<GUIParameter> params = new ArrayList<GUIParameter>();
        for (Object name : conf.keySet()) {
            if (!name.toString().startsWith(session.getTenantName() + ".tag.") && !name.toString().startsWith(session.getTenantName() + ".tagcloud.")) continue;
            if (name.equals(session.getTenantName() + ".tag.mode")) {
                params.add(new GUIParameter(name.toString(), "free"));
                continue;
            }
            params.add(new GUIParameter(name.toString(), conf.getProperty(name.toString())));
        }
        return params;
    }

    class TagCloudComparatorName
    implements Comparator<TagCloud> {
        TagCloudComparatorName() {
        }

        @Override
        public int compare(TagCloud tc0, TagCloud tc1) {
            return tc0.getTag().compareTo(tc1.getTag());
        }
    }
}

