/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.dbinit.PluginDbInit;
import com.logicaldoc.core.document.AbstractDocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.history.History;
import com.logicaldoc.core.job.JobManager;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskManager;
import com.logicaldoc.core.task.TaskScheduling;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.gui.common.client.AccessDeniedException;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIHistory;
import com.logicaldoc.gui.common.client.beans.GUIParameter;
import com.logicaldoc.gui.common.client.beans.GUIScheduling;
import com.logicaldoc.gui.common.client.beans.GUITask;
import com.logicaldoc.gui.common.client.beans.GUIUser;
import com.logicaldoc.gui.common.client.beans.GUIValue;
import com.logicaldoc.gui.frontend.client.services.SystemService;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.config.LogConfigurator;
import com.logicaldoc.util.config.PluginDescriptorConfigurator;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.plugin.LogicalDOCPlugin;
import com.logicaldoc.util.plugin.PluginException;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import com.logicaldoc.web.UploadServlet;
import com.logicaldoc.web.data.LogDataServlet;
import com.logicaldoc.web.listener.ApplicationListener;
import com.logicaldoc.web.service.AbstractRemoteService;
import com.logicaldoc.web.service.InfoServiceImpl;
import com.logicaldoc.web.service.SecurityServiceImpl;
import com.logicaldoc.web.websockets.WebsocketTool;
import jakarta.persistence.Table;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.java.plugin.registry.PluginDescriptor;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.jdbc.core.RowMapper;

public class SystemServiceImpl
extends AbstractRemoteService
implements SystemService {
    private static final String AND = " and ";
    private static final String SECONDS = "seconds";
    private static final String TRASH = "trash";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SystemServiceImpl.class);
    protected static File defaultWebappRootFolder = null;

    public boolean disableTask(String taskName) throws ServerException {
        Session session = this.validateSession();
        Task task = this.getTask(taskName);
        if (task == null) {
            throw new ServerException("Cannot find task named " + taskName);
        }
        task.getScheduling().setEnabled(false);
        try {
            task.getScheduling().save();
            return true;
        }
        catch (IOException | ParseException e) {
            return (Boolean)this.throwServerException(session, log, e);
        }
    }

    public boolean enableTask(String taskName) throws ServerException {
        Session session = this.validateSession();
        Task task = this.getTask(taskName);
        if (task == null) {
            throw new ServerException("Cannot find task named " + taskName);
        }
        try {
            TaskScheduling scheduling = task.getScheduling();
            if (scheduling != null) {
                task.getScheduling().setEnabled(true);
                task.getScheduling().save();
            } else {
                log.warn("No scheduling informations found for task {}", (Object)taskName);
            }
            return true;
        }
        catch (IOException | ParseException e) {
            return (Boolean)this.throwServerException(session, log, e);
        }
    }

    public List<List<GUIParameter>> getStatistics(String locale) throws ServerException {
        Session session = this.validateSession();
        try {
            GenericDAO genDao = Context.get(GenericDAO.class);
            ArrayList<List<GUIParameter>> parameters = new ArrayList<List<GUIParameter>>();
            Generic gen = genDao.findByAlternateKey("stat", TRASH, null, session.getTenantId());
            GUIParameter trashSize = new GUIParameter();
            trashSize.setName(TRASH);
            this.setLongValue(gen, trashSize);
            gen = genDao.findByAlternateKey("stat", "docdir", null, session.getTenantId());
            GUIParameter docDirSize = new GUIParameter();
            docDirSize.setName("documents");
            this.setLongValue(gen, docDirSize);
            docDirSize.setValue(Long.toString(Long.parseLong(docDirSize.getValue()) - Long.parseLong(trashSize.getValue())));
            gen = genDao.findByAlternateKey("stat", "userdir", null, -1L);
            GUIParameter userDirSize = new GUIParameter();
            userDirSize.setName("users");
            this.setLongValue(gen, userDirSize);
            gen = genDao.findByAlternateKey("stat", "indexdir", null, -1L);
            GUIParameter indexDirSize = new GUIParameter();
            indexDirSize.setName("fulltextindex");
            this.setLongValue(gen, indexDirSize);
            gen = genDao.findByAlternateKey("stat", "importdir", null, -1L);
            GUIParameter importDirSize = new GUIParameter();
            importDirSize.setName("iimport");
            this.setLongValue(gen, importDirSize);
            gen = genDao.findByAlternateKey("stat", "exportdir", null, -1L);
            GUIParameter exportDirSize = new GUIParameter();
            exportDirSize.setName("eexport");
            this.setLongValue(gen, exportDirSize);
            gen = genDao.findByAlternateKey("stat", "plugindir", null, -1L);
            GUIParameter pluginsDirSize = new GUIParameter();
            pluginsDirSize.setName("plugins");
            this.setLongValue(gen, pluginsDirSize);
            gen = genDao.findByAlternateKey("stat", "dbdir", null, -1L);
            GUIParameter dbDirSize = new GUIParameter();
            dbDirSize.setName("database");
            this.setLongValue(gen, dbDirSize);
            gen = genDao.findByAlternateKey("stat", "logdir", null, -1L);
            GUIParameter logsDirSize = new GUIParameter();
            logsDirSize.setName("logs");
            this.setLongValue(gen, logsDirSize);
            parameters.add(Arrays.asList(docDirSize, trashSize, userDirSize, indexDirSize, importDirSize, exportDirSize, pluginsDirSize, dbDirSize, logsDirSize));
            gen = genDao.findByAlternateKey("stat", "notindexeddocs", null, session.getTenantId());
            GUIParameter notIndexed = new GUIParameter();
            notIndexed.setName("notindexed");
            this.setLongValue(gen, notIndexed);
            gen = genDao.findByAlternateKey("stat", "notindexabledocs", null, session.getTenantId());
            GUIParameter notIndexableDocs = new GUIParameter();
            notIndexableDocs.setName("notindexabledocs");
            notIndexableDocs.setLabel("notindexable");
            this.setLongValue(gen, notIndexableDocs);
            gen = genDao.findByAlternateKey("stat", "indexeddocs", null, session.getTenantId());
            GUIParameter indexed = new GUIParameter();
            indexed.setName("indexed");
            this.setLongValue(gen, indexed);
            gen = genDao.findByAlternateKey("stat", "deleteddocs", null, session.getTenantId());
            GUIParameter deletedDocs = new GUIParameter();
            deletedDocs.setName("docstrash");
            deletedDocs.setLabel(TRASH);
            this.setLongValue(gen, deletedDocs);
            gen = genDao.findByAlternateKey("stat", "archiveddocs", null, session.getTenantId());
            GUIParameter archivedDocs = new GUIParameter();
            archivedDocs.setName("archiveddocs");
            archivedDocs.setLabel("archiveds");
            this.setLongValue(gen, archivedDocs);
            parameters.add(Arrays.asList(notIndexed, notIndexableDocs, indexed, deletedDocs, archivedDocs));
            gen = genDao.findByAlternateKey("stat", "notindexedpages", null, session.getTenantId());
            GUIParameter notIndexedPages = new GUIParameter();
            notIndexedPages.setName("notindexed");
            this.setLongValue(gen, notIndexedPages);
            gen = genDao.findByAlternateKey("stat", "notindexablepages", null, session.getTenantId());
            GUIParameter notIndexablePages = new GUIParameter();
            notIndexablePages.setName("notindexablepages");
            notIndexablePages.setLabel("notindexable");
            this.setLongValue(gen, notIndexablePages);
            gen = genDao.findByAlternateKey("stat", "indexedpages", null, session.getTenantId());
            GUIParameter indexedPages = new GUIParameter();
            indexedPages.setName("indexed");
            this.setLongValue(gen, indexedPages);
            gen = genDao.findByAlternateKey("stat", "deletedpages", null, session.getTenantId());
            GUIParameter deletedPages = new GUIParameter();
            deletedPages.setName("pagestrash");
            deletedPages.setLabel(TRASH);
            this.setLongValue(gen, deletedPages);
            gen = genDao.findByAlternateKey("stat", "archivedpages", null, session.getTenantId());
            GUIParameter archivedPages = new GUIParameter();
            archivedPages.setName("archivedpages");
            archivedPages.setLabel("archiveds");
            this.setLongValue(gen, archivedPages);
            parameters.add(Arrays.asList(notIndexedPages, notIndexableDocs, indexedPages, deletedPages, archivedPages));
            gen = genDao.findByAlternateKey("stat", "withdocs", null, session.getTenantId());
            GUIParameter notEmptyFolders = new GUIParameter();
            notEmptyFolders.setName("withdocs");
            this.setLongValue(gen, notEmptyFolders);
            gen = genDao.findByAlternateKey("stat", "empty", null, session.getTenantId());
            GUIParameter emptyFolders = new GUIParameter();
            emptyFolders.setName("empty");
            this.setLongValue(gen, emptyFolders);
            gen = genDao.findByAlternateKey("stat", "deletedfolders", null, session.getTenantId());
            GUIParameter deletedFolders = new GUIParameter();
            deletedFolders.setName("folderstrash");
            deletedFolders.setLabel(TRASH);
            this.setLongValue(gen, deletedFolders);
            parameters.add(Arrays.asList(notEmptyFolders, emptyFolders, deletedFolders));
            gen = genDao.findByAlternateKey("stat", "lastrun", null, -1L);
            Date date = gen != null ? gen.getDate1() : null;
            GUIParameter lastrun = new GUIParameter();
            lastrun.setName("lastrun");
            if (date != null) {
                SimpleDateFormat df2 = new SimpleDateFormat(I18N.message("format_date", locale));
                lastrun.setValue(df2.format(date));
            } else {
                lastrun.setValue("");
            }
            parameters.add(Arrays.asList(lastrun));
            return parameters;
        }
        catch (PersistenceException e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    private void setLongValue(Generic generic, GUIParameter parameter) {
        if (generic != null && generic.getInteger1() != null) {
            parameter.setValue(Long.toString(generic.getInteger1()));
        } else {
            parameter.setValue("0");
        }
    }

    public GUITask getTaskByName(String taskName, String locale) throws ServerException {
        this.validateSession();
        Task tsk = this.getTask(taskName);
        if (tsk == null) {
            return null;
        }
        GUITask task = new GUITask();
        task.setName(tsk.getName());
        task.setStatus(tsk.getStatus());
        task.setProgress((int)tsk.getProgress());
        task.setSize(tsk.getSize());
        task.setCompletionPercentage(tsk.getCompletionPercentage());
        task.setIndeterminate(tsk.isIndeterminate());
        task.setSendActivityReport(tsk.isSendActivityReport());
        this.setScheduling(task, tsk, locale);
        this.addReportRecipients(task, tsk);
        return task;
    }

    private Task getTask(String taskName) {
        TaskManager manager = Context.get(TaskManager.class);
        Task tsk = null;
        for (Task t : manager.getTasks()) {
            if (!t.getName().equals(taskName)) continue;
            tsk = t;
            break;
        }
        return tsk;
    }

    private void setScheduling(GUITask guiTask, Task task, String locale) {
        GUIScheduling scheduling = new GUIScheduling(task.getName());
        scheduling.setEnabled(task.getScheduling().isEnabled());
        scheduling.setMode(task.getScheduling().getMode());
        if (task.getScheduling().getMode().equals("simple")) {
            scheduling.setSimple(true);
            scheduling.setDelay(task.getScheduling().getDelaySeconds());
            scheduling.setInterval(task.getScheduling().getIntervalSeconds());
            guiTask.setSchedulingLabel(I18N.message("each", locale) + " " + task.getScheduling().getIntervalSeconds() + " " + I18N.message(SECONDS, locale).toLowerCase());
        } else {
            scheduling.setSimple(false);
            scheduling.setCronExpression(task.getScheduling().getCronExpression());
        }
        scheduling.setMaxLength(task.getScheduling().getMaxLength());
        guiTask.setScheduling(scheduling);
    }

    private void addReportRecipients(GUITask guiTask, Task task) {
        UserDAO dao = Context.get(UserDAO.class);
        if (StringUtils.isNotEmpty(task.getReportRecipients())) {
            StringTokenizer st = new StringTokenizer(task.getReportRecipients(), ",", false);
            while (st.hasMoreTokens()) {
                try {
                    User user = (User)dao.findById(Long.parseLong(st.nextToken()));
                    if (user == null) continue;
                    GUIUser u = new GUIUser();
                    u.setId(user.getId());
                    u.setUsername(user.getUsername());
                    u.setName(user.getName());
                    u.setFirstName(user.getFirstName());
                    guiTask.addReportRecipient(u);
                }
                catch (PersistenceException | NumberFormatException e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }

    public List<GUITask> loadTasks(String locale) throws ServerException {
        this.validateSession();
        TaskManager manager = Context.get(TaskManager.class);
        ArrayList<GUITask> tasks = new ArrayList<GUITask>();
        for (Task t : manager.getTasks()) {
            GUITask task = new GUITask();
            task.setName(t.getName());
            task.setStatus(t.getStatus());
            task.setProgress((int)t.getProgress());
            task.setSize(t.getSize());
            task.setIndeterminate(t.isIndeterminate());
            task.setCompletionPercentage(t.getCompletionPercentage());
            GUIScheduling scheduling = new GUIScheduling(t.getName());
            scheduling.setEnabled(t.getScheduling().isEnabled());
            scheduling.setMode(t.getScheduling().getMode());
            if (t.getScheduling().getMode().equals("simple")) {
                scheduling.setSimple(true);
                scheduling.setDelay(t.getScheduling().getDelay());
                scheduling.setInterval(t.getScheduling().getIntervalSeconds());
                task.setSchedulingLabel(I18N.message("each", locale) + " " + t.getScheduling().getIntervalSeconds() + " " + I18N.message(SECONDS, locale).toLowerCase());
            } else if (t.getScheduling().getMode().equals("cron")) {
                scheduling.setSimple(false);
                scheduling.setCronExpression(t.getScheduling().getCronExpression());
                task.setSchedulingLabel(t.getScheduling().getCronExpression());
            }
            scheduling.setMaxLength(t.getScheduling().getMaxLength());
            scheduling.setPreviousFireTime(t.getScheduling().getPreviousFireTime());
            scheduling.setNextFireTime(t.getScheduling().getNextFireTime());
            task.setScheduling(scheduling);
            task.setSendActivityReport(t.isSendActivityReport());
            tasks.add(task);
        }
        return tasks;
    }

    public GUITask saveTask(GUITask guiTask, String locale) throws ServerException {
        this.validateSession();
        TaskManager manager = Context.get(TaskManager.class);
        Task task = null;
        for (Task t : manager.getTasks()) {
            if (!t.getName().equals(guiTask.getName())) continue;
            task = t;
            break;
        }
        if (task != null) {
            task.getScheduling().setEnabled(guiTask.getScheduling().isEnabled());
            if (guiTask.getScheduling().isSimple()) {
                task.getScheduling().setMode("simple");
                task.getScheduling().setDelay(guiTask.getScheduling().getDelay() * 1000L);
                task.getScheduling().setInterval(guiTask.getScheduling().getInterval() * 1000L);
                task.getScheduling().setIntervalSeconds(guiTask.getScheduling().getInterval());
                guiTask.setSchedulingLabel(I18N.message("each", locale) + " " + task.getScheduling().getIntervalSeconds() + " " + I18N.message(SECONDS, locale).toLowerCase());
            } else {
                task.getScheduling().setMode("cron");
                InfoServiceImpl service = new InfoServiceImpl();
                service.getCronDescription(guiTask.getScheduling().getCronExpression(), locale);
                task.getScheduling().setCronExpression(guiTask.getScheduling().getCronExpression());
                guiTask.setSchedulingLabel(task.getScheduling().getCronExpression());
            }
            task.getScheduling().setMaxLength(guiTask.getScheduling().getMaxLength());
            task.setSendActivityReport(guiTask.isSendActivityReport());
            task.setReportRecipients(guiTask.getReportRecipients().stream().map(u -> Long.toString(u.getId())).collect(Collectors.joining(",")));
            this.saveTask(task);
        }
        return guiTask;
    }

    private void saveTask(Task tsk) {
        try {
            tsk.save();
        }
        catch (IOException | ParseException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void startTask(String taskName) {
        TaskManager manager = Context.get(TaskManager.class);
        for (Task task : manager.getTasks()) {
            if (!task.getName().equals(taskName)) continue;
            Thread thread = new Thread(task);
            thread.start();
            break;
        }
    }

    public void stopTask(String taskName) {
        TaskManager manager = Context.get(TaskManager.class);
        for (Task task : manager.getTasks()) {
            if (!task.getName().equals(taskName)) continue;
            task.interrupt();
            break;
        }
    }

    public void setGUILanguageStatus(String language, boolean active) throws ServerException {
        Session session = this.validateSession();
        ContextProperties conf = Context.get().getProperties();
        conf.setProperty(session.getTenantName() + ".lang." + language + ".gui", active ? "enabled" : "disabled");
        try {
            conf.write();
        }
        catch (IOException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void confirmUpdate() throws ServerException {
        Session session = this.validateSession();
        ContextProperties conf = Context.get().getProperties();
        String prevRunLevel = conf.getProperty("runlevel.back", RunLevel.DEFAULT.toString());
        conf.setProperty("runlevel", prevRunLevel);
        try {
            conf.write();
            log.info("Update confirmed");
        }
        catch (IOException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void restart() throws ServerException {
        this.validateSession();
        try {
            log.warn("Alerting the connected users about the shutdown");
            List<Session> sessions = SessionManager.get().getSessions();
            WebsocketTool websocket = new WebsocketTool();
            for (Session session : sessions) {
                websocket.showMessage(session, I18N.message("systemisshuttingdown", session.getUser().getLocale()), "warn");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        try {
            SecurityServiceImpl secService = new SecurityServiceImpl();
            secService.logout();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        ContextProperties config = Context.get().getProperties();
        File restartFile = new File(config.getProperty("LDOCHOME") + "/updates/restart");
        if (restartFile.exists()) {
            FileUtils.deleteQuietly(restartFile);
        }
        restartFile.getParentFile().mkdirs();
        try {
            if (!restartFile.createNewFile()) {
                throw new ServerException("Unable to write file " + restartFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new ServerException("Unable to write file " + restartFile.getAbsolutePath());
        }
    }

    private static Class<?> getClassByTable(String table) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Table.class));
        for (BeanDefinition bd : scanner.findCandidateComponents("com.logicaldoc")) {
            String beanClassName = bd.getBeanClassName();
            try {
                Class<?> beanClass = Class.forName(beanClassName);
                Table annotation = beanClass.getAnnotation(Table.class);
                if (annotation == null || !table.equals(annotation.name())) continue;
                return beanClass;
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return null;
    }

    public List<GUIHistory> search(Long userId, Date from, Date till, int maxResult, String historySid, List<String> events, Long rootFolderId) throws ServerException {
        Session session = this.validateSession();
        int i = 0;
        StringBuilder query = new StringBuilder();
        for (String table : History.eventTables()) {
            if (rootFolderId != null && !AbstractDocumentHistory.class.isAssignableFrom(SystemServiceImpl.getClassByTable(table))) continue;
            String tableAlias = "A" + i++;
            this.appendUnion(query);
            this.appendSelect(table, tableAlias, query);
            query.append(" from TABLE A where A.ld_tenantid = ".replace("TABLE", table).replace("A", tableAlias));
            query.append(Long.toString(session.getTenantId()));
            this.appendUserCondition(tableAlias, userId, query);
            this.appendSessionCondition(tableAlias, historySid, query);
            this.appendDatesCondition(tableAlias, from, till, query);
            this.appendFolderCondition(tableAlias, rootFolderId, query);
            this.appendEventsCondition(tableAlias, events, query);
        }
        query.append(" order by 3 desc ");
        try {
            return this.executeQuery(query.toString(), maxResult, session);
        }
        catch (PersistenceException e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    protected void appendSelect(String table, String tableAlias, StringBuilder query) {
        if (log.isDebugEnabled()) {
            log.debug("Appending table {} with alias {}", (Object)table, (Object)tableAlias);
        }
        query.append("select ");
        if (this.doesNotProvideDocumentReference(table)) {
            query.append("''");
        } else {
            query.append("A.ld_username".replace("A", tableAlias));
        }
        query.append(", A.ld_event, A.ld_date,".replace("A", tableAlias));
        if (this.doesNotProvideDocumentReference(table)) {
            query.append("'', null");
        } else {
            query.append("A.ld_filename, A.ld_folderid".replace("A", tableAlias));
        }
        query.append(", A.ld_path, A.ld_sessionid".replace("A", tableAlias));
        if (this.doesNotProvideDocumentReference(table)) {
            query.append(", ''");
        } else {
            query.append(", A.ld_docid".replace("A", tableAlias));
        }
        query.append(", A.ld_userid, A.ld_ip as ip, A.ld_userlogin, A.ld_comment".replace("A", tableAlias));
        if (this.doesNotProvideReason(table)) {
            query.append(", ''");
        } else {
            query.append(", A.ld_reason".replace("A", tableAlias));
        }
        query.append(", A.ld_device, A.ld_geolocation, A.ld_keylabel ".replace("A", tableAlias));
    }

    protected void appendUnion(StringBuilder query) {
        if (!query.isEmpty()) {
            query.append(" union ");
        }
    }

    private boolean doesNotProvideReason(String table) {
        return this.doesNotProvideDocumentReference(table) || table.equals("ld_user_history");
    }

    private boolean doesNotProvideDocumentReference(String table) {
        return table.equals("ld_webservicecall") || table.equals("ld_aimodel_history") || table.equals("ld_robot_history") || table.equals("ld_chatmessage");
    }

    private void appendEventsCondition(String tableAlias, List<String> events, StringBuilder query) {
        if (CollectionUtils.isNotEmpty(events)) {
            query.append(" and (");
            query.append(events.stream().map(e -> " " + tableAlias + ".ld_event = '" + SqlUtil.doubleQuotes(e) + "'").collect(Collectors.joining(" or ")));
            query.append(" ) ");
        }
    }

    private void appendDatesCondition(String tableAlias, Date from, Date till, StringBuilder query) {
        if (from != null) {
            query.append(AND + tableAlias + ".ld_date > '" + String.valueOf(new Timestamp(from.getTime())) + "' ");
        }
        if (till != null) {
            query.append(AND + tableAlias + ".ld_date < '" + String.valueOf(new Timestamp(till.getTime())) + "' ");
        }
    }

    private void appendSessionCondition(String tableAlias, String historySid, StringBuilder query) {
        if (historySid != null && StringUtils.isNotEmpty(historySid)) {
            query.append(AND + tableAlias + ".ld_sessionid='" + historySid + "' ");
        }
    }

    private void appendUserCondition(String tableAlias, Long userId, StringBuilder query) {
        if (userId != null) {
            query.append(AND + tableAlias + ".ld_userid = " + String.valueOf(userId));
        }
    }

    private List<GUIHistory> executeQuery(String query, int maxResult, final Session session) throws PersistenceException {
        DocumentHistoryDAO dao = Context.get(DocumentHistoryDAO.class);
        return dao.query(query, new RowMapper<GUIHistory>(){

            public GUIHistory mapRow(ResultSet rs, int row) throws SQLException {
                GUIHistory history = new GUIHistory();
                history.setTenant(session.getTenantName());
                history.setTenantId(Long.valueOf(session.getTenantId()));
                history.setUsername(rs.getString(1));
                history.setEvent(rs.getString(2));
                history.setDate(SqlUtil.getColumnDateValue(rs, 3));
                history.setFileName(rs.getString(4));
                history.setFolderId(rs.getLong(5));
                history.setPath(rs.getString(6));
                history.setSessionId(rs.getString(7));
                history.setDocId(rs.getLong(8));
                history.setUserId(rs.getLong(9));
                history.setIp(rs.getString(10));
                history.setUserLogin(rs.getString(11));
                history.setComment(rs.getString(12));
                history.setReason(rs.getString(13));
                history.setDevice(rs.getString(14));
                history.setGeolocation(rs.getString(15));
                history.setKeyLabel(rs.getString(16));
                if (history.getFileName() != null && history.getDocId() != 0L) {
                    history.setIcon(IconSelector.selectIcon(history.getFileName()));
                } else if (history.getFileName() != null && history.getDocId() == 0L && history.getFolderId() != 0L) {
                    history.setIcon("folder");
                }
                return history;
            }
        }, maxResult);
    }

    private void appendFolderCondition(String tableAlias, Long rootFolderId, StringBuilder query) {
        if (rootFolderId == null) {
            return;
        }
        StringBuilder folderPredicate = new StringBuilder();
        FolderDAO fDao = Context.get(FolderDAO.class);
        Collection<Long> tree = fDao.findFolderIdInTree(rootFolderId, false);
        if (fDao.isOracle()) {
            folderPredicate.append(" and (" + tableAlias + ".ld_folderid,0) in ( ");
            folderPredicate.append(tree.stream().map(id -> "(" + Long.toString(id) + ",0)").collect(Collectors.joining(",")));
            folderPredicate.append(" )");
        } else {
            folderPredicate.append(AND + tableAlias + ".ld_folderid in ( ");
            folderPredicate.append(tree.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")));
            folderPredicate.append(" )");
        }
        query.append(folderPredicate.toString());
    }

    public List<GUIHistory> searchApiCalls(Long userId, Date from, Date till, String callSid, String protocol, String uri, int maxResult) throws ServerException {
        Session session = this.validateSession();
        try {
            TenantDAO dao = Context.get(TenantDAO.class);
            final Map<Long, String> tenants = dao.findAll().stream().collect(Collectors.toMap(PersistentObject::getId, Tenant::getName));
            tenants.put(-1L, "system");
            StringBuilder query = new StringBuilder("select ld_username, ld_date, ld_path, ld_sessionid, ld_userid, ld_ip as ip, ld_userlogin, ld_comment, ld_device, ld_geolocation, ld_protocol, ld_tenantId, ld_keylabel from ld_webservicecall where 1 = 1 ");
            if (userId != null) {
                query.append(" and ld_userid = " + String.valueOf(userId));
            }
            if (callSid != null && StringUtils.isNotEmpty(callSid)) {
                query.append(" and ld_sessionid='" + callSid + "' ");
            }
            if (from != null) {
                query.append(" and ld_date > '" + String.valueOf(new Timestamp(from.getTime())) + "' ");
            }
            if (till != null) {
                query.append(" and ld_date < '" + String.valueOf(new Timestamp(till.getTime())) + "' ");
            }
            if (protocol != null) {
                query.append(" and ld_protocol = '" + protocol + "' ");
            }
            if (session.getTenantId() != 1L) {
                query.append(" and ld_tenantid = " + session.getTenantId());
            }
            query.append(" order by ld_date desc ");
            return dao.query(query.toString(), new RowMapper<GUIHistory>(){

                public GUIHistory mapRow(ResultSet rs, int arg1) throws SQLException {
                    GUIHistory history = new GUIHistory();
                    history.setUsername(rs.getString(1));
                    history.setDate(SqlUtil.getColumnDateValue(rs, 2));
                    history.setPath(rs.getString(3));
                    history.setSessionId(rs.getString(4));
                    history.setUserId(rs.getLong(5));
                    history.setIp(rs.getString(6));
                    history.setUserLogin(rs.getString(7));
                    history.setComment(rs.getString(8));
                    history.setDevice(rs.getString(9));
                    history.setGeolocation(rs.getString(10));
                    history.setProtocol(rs.getString(11));
                    history.setTenantId(Long.valueOf(rs.getLong(12)));
                    history.setTenant((String)tenants.get(history.getTenantId()));
                    history.setKeyLabel(rs.getString(13));
                    return history;
                }
            }, maxResult);
        }
        catch (PersistenceException e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public void unscheduleJobs(List<GUIValue> jobs) throws ServerException {
        Session session = this.validateSession();
        JobManager jobManager = Context.get(JobManager.class);
        for (GUIValue trigger : jobs) {
            try {
                jobManager.unscheduleTrigger(trigger.getCode(), trigger.getValue());
            }
            catch (SchedulerException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    private File getPluginArchive(String pluginId) {
        String location = PluginRegistry.getInstance().getPlugin(pluginId).getLocation().toString().substring(9);
        return new File(location.substring(0, location.lastIndexOf(33)));
    }

    public void uninstallPlugin(String pluginId) throws ServerException {
        Session session = this.validateSession();
        if (!session.getUser().isMemberOf("admin") || session.getTenantId() != 1L) {
            throw new AccessDeniedException();
        }
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        PluginDescriptor plugin = pluginRegistry.getPlugin(pluginId);
        if (plugin == null) {
            return;
        }
        if (plugin.getAttribute("removable") == null || "false".equals(plugin.getAttribute("removable").getValue())) {
            throw new ServerException("The plugin " + pluginId + " cannot be uninstalled");
        }
        File pluginJarFile = this.getPluginArchive(pluginId);
        pluginRegistry.getManager().deactivatePlugin(pluginId);
        FileUtil.delete(PluginRegistry.getPluginHome(pluginId));
        FileUtil.delete(pluginJarFile);
        if (pluginJarFile.exists()) {
            try {
                FileUtils.forceDelete(pluginJarFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (pluginJarFile.exists()) {
            throw new ServerException("Cannot remove plugin file " + pluginJarFile.getAbsolutePath() + ". Please stop the application and delete that file manually.");
        }
    }

    public void initializePlugin(String pluginId) throws ServerException {
        Session session = this.validateSession();
        if (!session.getUser().isMemberOf("admin") || session.getTenantId() != 1L) {
            throw new AccessDeniedException();
        }
        try {
            PluginDescriptor plugin = PluginRegistry.getInstance().getPlugin(pluginId);
            if (plugin.getPluginClassName() != null) {
                LogicalDOCPlugin pluginInstance = (LogicalDOCPlugin)((Object)Class.forName(plugin.getPluginClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                pluginInstance.install();
            }
            ContextProperties config = Context.get().getProperties();
            PluginDbInit dbInit = new PluginDbInit();
            dbInit.setDbms(config.getProperty("jdbc.dbms"));
            dbInit.setDriver(config.getProperty("jdbc.driver"));
            dbInit.setUrl(config.getProperty("jdbc.url"));
            dbInit.setUsername(config.getProperty("jdbc.username"));
            dbInit.setPassword(config.getProperty("jdbc.password"));
            if (!dbInit.testConnection()) {
                log.debug("connection failure");
                throw new ServerException("Database Connection failure.");
            }
            dbInit.init(Set.of(pluginId));
        }
        catch (ServerException | PluginException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void installPlugin() throws ServerException {
        Session session = this.validateSession();
        if (!session.getUser().isMemberOf("admin") || session.getTenantId() != 1L) {
            throw new AccessDeniedException();
        }
        Map<String, File> uploadedFilesMap = UploadServlet.getUploads(session.getSid());
        if (uploadedFilesMap == null || uploadedFilesMap.size() < 1) {
            throw new ServerException("Cannot find a plugin package to install");
        }
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ZipUtil zipUtil = new ZipUtil();){
                    File pluginPackage = uploadedFilesMap.values().iterator().next();
                    ContextProperties config = Context.get().getProperties();
                    File rootFolder = this.getThreadLocalRequest() != null ? new File(this.getThreadLocalRequest().getSession().getServletContext().getRealPath("/")) : defaultWebappRootFolder;
                    String pluginId = null;
                    String pluginVersion = null;
                    String pluginJar = null;
                    Throwable throwable2 = null;
                    Object var13_17 = null;
                    try (InputStream pluginStream = zipUtil.getEntryStream(pluginPackage, "/plugin.xml");){
                        if (pluginStream == null) {
                            throw new ServerException("The plugin package does not include the descriptor plugin.xml");
                        }
                        PluginDescriptorConfigurator pd = new PluginDescriptorConfigurator(pluginStream);
                        pluginId = pd.getId();
                        pluginVersion = pd.getVersion();
                        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
                        Set<String> dependencies = pd.getDependencies();
                        for (String dependency : dependencies) {
                            PluginDescriptor dep = pluginRegistry.getPlugin(dependency);
                            if (dep != null) continue;
                            throw new ServerException("The dependency from plugin " + dependency + " cannot be resolved");
                        }
                        pluginJar = pluginId + "-" + pluginVersion + "-plugin.jar";
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    List<String> entries = zipUtil.listEntries(pluginPackage);
                    if (!entries.contains("WEB-INF/lib/" + pluginJar)) {
                        throw new ServerException("The plugin package does not include the plugin file WEB-INF/lib/" + pluginJar);
                    }
                    log.info("Unpacking plugin package {} into {}", (Object)pluginPackage.getName(), (Object)rootFolder.getAbsolutePath());
                    zipUtil.unzip(pluginPackage, rootFolder);
                    FileUtils.deleteQuietly(new File(rootFolder, "plugin.xml"));
                    File pluginHome = PluginRegistry.getPluginHome(pluginId);
                    if (pluginHome.exists()) {
                        FileUtil.delete(pluginHome);
                        log.info("Deleted existing plugin home {}", (Object)pluginHome.getAbsolutePath());
                    }
                    File pluginsDir = new File(config.getProperty("conf.plugindir"));
                    File targetFile = new File(pluginsDir, pluginId + "-" + pluginVersion + "-plugin.zip.installed");
                    log.info("Copying plugin package {} into {}", (Object)pluginPackage.getName(), (Object)targetFile.getAbsolutePath());
                    FileUtil.copyFile(pluginPackage, targetFile);
                    ApplicationListener.restartRequired();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (ServerException | IOException | IllegalArgumentException e) {
                this.throwServerException(session, log, e);
                UploadServlet.cleanUploads(session.getSid());
            }
        }
        finally {
            UploadServlet.cleanUploads(session.getSid());
        }
    }

    public List<GUIValue> getPlugins() throws ServerException {
        this.validateSession();
        Collection<PluginDescriptor> descriptors = PluginRegistry.getInstance().getPlugins();
        ArrayList<GUIValue> plugins = new ArrayList<GUIValue>();
        for (PluginDescriptor descriptor : descriptors) {
            GUIValue plugin = new GUIValue();
            plugin.setCode(descriptor.getId());
            plugin.setValue(descriptor.getVersion().toString());
            plugins.add(plugin);
        }
        if (plugins.size() > 1) {
            Collections.sort(plugins, (c1, c2) -> {
                int compare;
                if (c1.getCode() != null && c2.getCode() != null && (compare = c1.getCode().compareTo(c2.getCode())) != 0) {
                    return compare;
                }
                return c1.getValue().compareTo(c2.getValue());
            });
        }
        return plugins;
    }

    public void saveLogger(String name, String level, boolean additivity) throws ServerException {
        Session session = this.validateSession();
        if (session.getTenantId() != 1L) {
            throw new AccessDeniedException("Not enough permissions");
        }
        this.checkMenu(72L);
        LogConfigurator conf = new LogConfigurator();
        if ("root".equals(name)) {
            conf.setRootLevel(level);
        } else {
            conf.setLogger(name, additivity, StringUtils.defaultIfEmpty(level, "info"), null);
        }
        conf.write();
        conf.initializeLogging();
    }

    public void removeLogger(String name) throws ServerException {
        Session session = this.validateSession();
        if (session.getTenantId() != 1L || LogDataServlet.isLoggerReserved(name)) {
            throw new AccessDeniedException("Not enough permissions");
        }
        this.checkMenu(72L);
        LogConfigurator conf = new LogConfigurator();
        conf.removeLogger(name);
        conf.write();
        conf.initializeLogging();
    }
}

