/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.dbinit.PluginDbInit;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.gui.common.client.AccessDeniedException;
import com.logicaldoc.gui.common.client.InvalidSessionServerException;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.setup.client.SetupInfo;
import com.logicaldoc.gui.setup.client.services.SetupService;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.config.LogConfigurator;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.java.plugin.registry.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupServiceImpl
extends AbstractRemoteService
implements SetupService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SetupServiceImpl.class);

    public void setup(SetupInfo data) throws ServerException {
        this.securityCheck();
        data.setRepositoryFolder(data.getRepositoryFolder().replace("\\", "/"));
        File repoFolder = new File(data.getRepositoryFolder());
        log.warn("Initialize system using repository {}", (Object)repoFolder);
        try {
            this.makeWorkingDir(repoFolder);
            this.createDB(data);
            this.writeRegConfig(data);
            this.setLogFolder();
            this.markInitialized();
            Context.get().refresh();
        }
        catch (IOException | SQLException caught) {
            throw new ServerException(caught.getMessage(), (Throwable)caught);
        }
    }

    private void markInitialized() {
        try {
            ContextProperties pbean = new ContextProperties();
            pbean.setProperty("initialized", "true");
            pbean.write();
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
    }

    private void setLogFolder() {
        try {
            ContextProperties pbean = new ContextProperties();
            LogConfigurator lconf = new LogConfigurator();
            lconf.setLogsRoot(pbean.getProperty("conf.logdir"));
            lconf.write();
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
    }

    private void writeDBConfig(SetupInfo data) throws IOException {
        ContextProperties pbean = new ContextProperties();
        pbean.setProperty("jdbc.driver", data.getDbDriver() != null ? data.getDbDriver() : "");
        pbean.setProperty("jdbc.url", data.getDbUrl() != null ? data.getDbUrl() : "");
        pbean.setProperty("jdbc.username", data.getDbUsername() != null ? data.getDbUsername() : "");
        pbean.setProperty("jdbc.password", data.getDbPassword() != null ? data.getDbPassword() : "");
        String dbmms = data.getDbEngine().toLowerCase();
        if (dbmms.startsWith("postgre")) {
            dbmms = "postgres";
        }
        pbean.setProperty("jdbc.dbms", dbmms);
        if (StringUtils.isNotEmpty(data.getDbValidationQuery())) {
            pbean.setProperty("jdbc.validationQuery", data.getDbValidationQuery());
        } else {
            pbean.setProperty("jdbc.validationQuery", "");
        }
        pbean.setProperty("hibernate.dialect", data.getDbDialect());
        pbean.write();
        log.info("configuration data written successfully.");
    }

    private void writeRegConfig(SetupInfo data) throws IOException {
        ContextProperties pbean = new ContextProperties();
        pbean.setProperty("reg.name", data.getRegName() != null ? data.getRegName() : "");
        pbean.setProperty("reg.website", data.getRegWebsite() != null ? data.getRegWebsite() : "");
        pbean.setProperty("reg.organization", data.getRegOrganization() != null ? data.getRegOrganization() : "");
        pbean.setProperty("reg.email", data.getRegEmail() != null ? data.getRegEmail() : "");
        pbean.write();
        log.info("configuration data written successfully.");
    }

    private void reloadContext() {
        Context.get().refresh();
        ContextProperties conf = Context.get().getProperties();
        SearchEngine indexer = Context.get(SearchEngine.class);
        indexer.close();
        indexer.init();
        Collection<PluginDescriptor> descriptors = PluginRegistry.getInstance().getPlugins();
        for (PluginDescriptor descriptor : descriptors) {
            try {
                File file = new File(conf.getProperty("conf.plugindir"), descriptor.getId());
                file.mkdirs();
                file.mkdir();
                file = new File(file, "plugin.properties");
                if (file.createNewFile()) continue;
                throw new IOException("Cannot create file " + file.getAbsolutePath());
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public void makeWorkingDir(File repoFolder) throws IOException {
        repoFolder.mkdirs();
        repoFolder.mkdir();
        File dbDir = new File(repoFolder, "db");
        FileUtils.forceMkdir(dbDir);
        String docDir = FilenameUtils.separatorsToUnix(repoFolder.getPath() + "/docs/");
        FileUtils.forceMkdir(new File(docDir));
        String indexDir = FilenameUtils.separatorsToUnix(repoFolder.getPath() + "/index/");
        FileUtils.forceMkdir(new File(indexDir));
        String userDir = FilenameUtils.separatorsToUnix(repoFolder.getPath() + "/users/");
        FileUtils.forceMkdir(new File(userDir));
        String pluginDir = FilenameUtils.separatorsToUnix(repoFolder.getPath() + "/plugins/");
        FileUtils.forceMkdir(new File(pluginDir));
        String importDir = FilenameUtils.separatorsToUnix(repoFolder.getPath() + "/impex/in/");
        FileUtils.forceMkdir(new File(importDir));
        String exportDir = FilenameUtils.separatorsToUnix(repoFolder.getPath() + "/impex/out/");
        FileUtils.forceMkdir(new File(exportDir));
        String logDir = FilenameUtils.separatorsToUnix(repoFolder.getPath() + "/logs/");
        FileUtils.forceMkdir(new File(logDir));
        String dbDirectory = FilenameUtils.separatorsToSystem(repoFolder.getPath() + "/db/");
        ContextProperties pbean = Context.get().getProperties();
        pbean.setProperty("store.1.dir", docDir);
        pbean.setProperty("store.write", "1");
        pbean.setProperty("index.dir", indexDir);
        pbean.setProperty("conf.userdir", userDir);
        pbean.setProperty("conf.plugindir", pluginDir);
        pbean.setProperty("conf.importdir", importDir);
        pbean.setProperty("conf.exportdir", exportDir);
        pbean.setProperty("conf.logdir", logDir);
        pbean.setProperty("conf.dbdir", dbDirectory);
        pbean.write();
        String log4jPath = URLDecoder.decode(((Object)((Object)this)).getClass().getResource("/log.xml").getPath(), "UTF-8");
        Logger console = LoggerFactory.getLogger("console");
        try {
            console.info("Taking log configuration from {}", (Object)log4jPath);
            Throwable throwable = null;
            Object var15_17 = null;
            try (FileInputStream inputStream = new FileInputStream(log4jPath);){
                ConfigurationSource source = new ConfigurationSource(inputStream);
                Configurator.initialize(null, source);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            console.error("Cannot access log file {}", (Object)log4jPath);
        }
        this.reloadContext();
    }

    private void createDB(SetupInfo info) throws IOException, SQLException {
        this.writeDBConfig(info);
        if (!info.getDbEngine().toLowerCase().contains("oracle") && !info.getDbEngine().toLowerCase().contains("hsqldb")) {
            String dbName = info.getDbUrl().substring(info.getDbUrl().lastIndexOf(47) + 1);
            if (dbName.contains("?")) {
                dbName = dbName.substring(0, dbName.indexOf(63));
            }
            log.warn("Detected dabase name {}", (Object)dbName);
            String queryString = "";
            if (info.getDbUrl().contains("?")) {
                queryString = info.getDbUrl().substring(info.getDbUrl().indexOf(63));
            }
            log.warn("Detected query string {}", (Object)queryString);
            String adminjdbcUrl = info.getDbUrl().substring(0, info.getDbUrl().lastIndexOf(47)) + queryString;
            log.warn("Using adminUrl {}", (Object)adminjdbcUrl);
            if (StringUtils.isNotEmpty(dbName)) {
                try {
                    PluginDbInit init = new PluginDbInit();
                    init.setDbms(info.getDbEngine());
                    init.setDriver(info.getDbDriver());
                    init.setUrl(adminjdbcUrl);
                    init.setUsername(info.getDbUsername());
                    init.setPassword(info.getDbPassword());
                    if (init.testConnection()) {
                        init.executeSql("create database " + dbName);
                    }
                }
                catch (Exception t) {
                    log.warn("Unable to create the database schema, perhaps it already exists");
                }
            }
        }
        this.doInit(info);
    }

    private void doInit(SetupInfo info) throws SQLException {
        PluginDbInit init = new PluginDbInit();
        init.setDbms(info.getDbEngine());
        init.setDriver(info.getDbDriver());
        init.setUrl(info.getDbUrl());
        init.setUsername(info.getDbUsername());
        init.setPassword(info.getDbPassword());
        if (init.testConnection()) {
            init.init();
            if (StringUtils.isNotEmpty(info.getLanguage())) {
                init.executeSql("update ld_user set ld_language='" + info.getLanguage() + "';");
            }
        } else {
            log.debug("connection failure");
            throw new SQLException("Database Connection failure.");
        }
    }

    public void securityCheck() throws ServerException {
        User user = null;
        try {
            user = this.getSessionUser(this.getThreadLocalRequest());
        }
        catch (InvalidSessionServerException invalidSessionServerException) {
            // empty catch block
        }
        if (user != null && !"admin".equals(user.getUsername())) {
            log.error("User {} cannot setup the application", (Object)user);
            throw new AccessDeniedException("Only admin user is allowed to setup the application");
        }
    }
}

