/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.SystemInfo;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIEmailSettings;
import com.logicaldoc.gui.common.client.beans.GUIParameter;
import com.logicaldoc.gui.frontend.client.services.SettingService;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.http.HttpUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import com.logicaldoc.web.firewall.HttpFirewall;
import com.logicaldoc.web.service.AbstractRemoteService;
import com.logicaldoc.web.service.FolderServiceImpl;
import com.logicaldoc.web.util.ServletUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingServiceImpl
extends AbstractRemoteService
implements SettingService {
    private static final String CONVERTER_ALIAS = "converter.alias.";
    private static final String GUI_TAG_VOCABULARY = "gui.tag.vocabulary";
    private static final String GUISETTING = "guisetting";
    private static final String GUI_WELCOME = "gui.welcome";
    private static final String CHARSET = ".charset";
    private static final String HIDDEN = ".hidden";
    private static final String SMTP_SAVE_FOLDER_ID = ".smtp.save.folderId";
    private static final String SMTP_SAVE_FOLDERING = ".smtp.save.foldering";
    private static final String SMTP_USERASFROM = ".smtp.userasfrom";
    private static final String SMTP_SENDER = ".smtp.sender";
    private static final String SMTP_AUTH_ENCRYPTED = ".smtp.authEncrypted";
    private static final String SMTP_CONNECTION_SECURITY = ".smtp.connectionSecurity";
    private static final String SMTP_PASSWORD = ".smtp.password";
    private static final String SMTP_USERNAME = ".smtp.username";
    private static final String SMTP_CLIENTSECRET = ".smtp.clientSecret";
    private static final String SMTP_CLIENTID = ".smtp.clientId";
    private static final String SMTP_CLIENTTENANT = ".smtp.clientTenant";
    private static final String SMTP_PROTOCOL = ".smtp.protocol";
    private static final String SMTP_PORT = ".smtp.port";
    private static final String SMTP_HOST = ".smtp.host";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);

    public GUIEmailSettings loadEmailSettings() throws ServerException {
        Session session = this.checkMenu(this.getThreadLocalRequest(), 7L);
        GUIEmailSettings emailSettings = new GUIEmailSettings();
        try {
            ContextProperties conf = Context.get().getProperties();
            emailSettings.setProtocol(conf.getProperty(session.getTenantName() + SMTP_PROTOCOL, "smtp"));
            emailSettings.setServer(conf.getProperty(session.getTenantName() + SMTP_HOST));
            emailSettings.setPort(conf.getInt(session.getTenantName() + SMTP_PORT));
            emailSettings.setUsername(conf.getProperty(session.getTenantName() + SMTP_USERNAME, "").trim());
            emailSettings.setPwd(conf.getProperty(session.getTenantName() + SMTP_PASSWORD, "").trim());
            emailSettings.setConnSecurity(conf.getProperty(session.getTenantName() + SMTP_CONNECTION_SECURITY));
            emailSettings.setSecureAuth("true".equals(conf.getProperty(session.getTenantName() + SMTP_AUTH_ENCRYPTED)));
            emailSettings.setSenderEmail(conf.getProperty(session.getTenantName() + SMTP_SENDER));
            emailSettings.setUserAsFrom(conf.getBoolean(session.getTenantName() + SMTP_USERASFROM, true));
            emailSettings.setFoldering(conf.getInt(session.getTenantName() + SMTP_SAVE_FOLDERING, 3));
            emailSettings.setTargetFolder(new FolderServiceImpl().getFolder(session, conf.getLong(session.getTenantName() + SMTP_SAVE_FOLDER_ID, 0L)));
            emailSettings.setClientSecret(conf.getProperty(session.getTenantName() + SMTP_CLIENTSECRET, "").trim());
            emailSettings.setClientId(conf.getProperty(session.getTenantName() + SMTP_CLIENTID, "").trim());
            emailSettings.setClientTenant(conf.getProperty(session.getTenantName() + SMTP_CLIENTTENANT, "").trim());
            log.info("Email settings data loaded successfully.");
        }
        catch (Exception e) {
            log.error("Exception loading Email settings data", e);
        }
        return emailSettings;
    }

    public void saveEmailSettings(GUIEmailSettings settings) throws ServerException {
        Session session = this.checkMenu(this.getThreadLocalRequest(), 7L);
        try {
            ContextProperties conf = Context.get().getProperties();
            conf.setProperty(session.getTenantName() + SMTP_PROTOCOL, settings.getProtocol());
            conf.setProperty(session.getTenantName() + SMTP_HOST, settings.getServer());
            conf.setProperty(session.getTenantName() + SMTP_PORT, Integer.toString(settings.getPort()));
            conf.setProperty(session.getTenantName() + SMTP_USERNAME, StringUtils.defaultString(settings.getUsername(), ""));
            conf.setProperty(session.getTenantName() + SMTP_PASSWORD, StringUtils.defaultString(settings.getPwd(), ""));
            conf.setProperty(session.getTenantName() + SMTP_CONNECTION_SECURITY, settings.getConnSecurity());
            conf.setProperty(session.getTenantName() + SMTP_AUTH_ENCRYPTED, settings.isSecureAuth() ? "true" : "false");
            conf.setProperty(session.getTenantName() + SMTP_SENDER, settings.getSenderEmail());
            conf.setProperty(session.getTenantName() + SMTP_USERASFROM, "" + settings.isUserAsFrom());
            conf.setProperty(session.getTenantName() + SMTP_SAVE_FOLDERING, Integer.toString(settings.getFoldering()));
            conf.setProperty(session.getTenantName() + SMTP_SAVE_FOLDER_ID, settings.getTargetFolder() != null ? Long.toString(settings.getTargetFolder().getId()) : "");
            conf.setProperty(session.getTenantName() + SMTP_CLIENTID, StringUtils.defaultString(settings.getClientId()));
            conf.setProperty(session.getTenantName() + SMTP_CLIENTSECRET, StringUtils.defaultString(settings.getClientSecret()));
            conf.setProperty(session.getTenantName() + SMTP_CLIENTTENANT, StringUtils.defaultString(settings.getClientTenant()));
            conf.write();
            EMailSender sender = Context.get(EMailSender.class);
            sender.setHost(conf.getProperty("default.smtp.host"));
            sender.setPort(Integer.parseInt(conf.getProperty("default.smtp.port")));
            sender.setUsername(conf.getProperty("default.smtp.username"));
            sender.setPassword(conf.getProperty("default.smtp.password"));
            sender.setSender(conf.getProperty("default.smtp.sender"));
            sender.setAuthEncrypted("true".equals(conf.getProperty("default.smtp.authEncrypted")));
            sender.setConnectionSecurity(Integer.parseInt(conf.getProperty("default.smtp.connectionSecurity")));
            sender.setFoldering(conf.getInt("default.smtp.save.foldering", 2));
            sender.setFolderId(conf.getProperty("default.smtp.save.folderId") != null ? Long.valueOf(conf.getLong("default.smtp.save.folderId", 0L)) : null);
            log.info("Email settings data written successfully.");
        }
        catch (Exception e) {
            log.error("Exception writing Email settings data", e);
        }
    }

    public List<GUIParameter> loadSettings() throws ServerException {
        this.checkMenu(this.getThreadLocalRequest(), 7L);
        TreeSet<String> sortedSet = new TreeSet<String>();
        ContextProperties conf = Context.get().getProperties();
        for (Object key : conf.keySet()) {
            String name = key.toString();
            if (name.endsWith(HIDDEN) || name.endsWith("readonly") || conf.containsKey(name + HIDDEN) && "true".equals(conf.getProperty(name + HIDDEN)) || name.startsWith("product") || name.startsWith("skin") || name.startsWith("conf") || name.startsWith("ldap") || name.startsWith("schedule") || name.contains(".smtp.") || name.contains("password") || name.startsWith("ad") || name.startsWith("webservice") || name.startsWith("webdav") || name.startsWith("cmis") || name.startsWith("runlevel") || name.startsWith("aspect.") || name.startsWith("stat") || name.contains("index") || name.equals("id") || name.contains(".lang.") || name.startsWith("reg.") || name.startsWith("ocr.") || name.contains(".ocr.") || name.contains("barcode") || name.startsWith("task.") || name.startsWith("store") || name.startsWith("advancedocr.") || name.startsWith("command.") || name.contains(".gui.") || name.contains(".upload.") || name.equals("userno") || name.contains(".search.") || name.contains("tag.") || name.startsWith("cluster") || name.startsWith("ip.") || name.contains(".extcall.") || name.contains("anonymous") || name.startsWith("hibernate.") || name.contains(".session.") || name.contains("antivirus.") || name.startsWith("login.") || name.equals("upload.maxsize") || name.startsWith("news.") || name.equals("registry") || name.equals("searchengine") || name.equals("load") || name.startsWith("ssl.") || name.contains(".tagcloud.") || name.startsWith("throttle.") || name.contains("security.") || name.contains("parser.") || name.startsWith("quota.") || name.equals("initialized") || name.startsWith("converter.") || name.startsWith("firewall.") || name.contains(".2fa.") || name.startsWith("ftp.") || name.startsWith("cas.") || name.startsWith("cache.") || name.startsWith("jdbc.") || name.startsWith("comparator.") || name.contains(".via.") || name.contains(".downloadticket.") || name.startsWith("zonalocr.") || name.endsWith(CHARSET) || name.startsWith("policy.") || name.startsWith("cookies.") || name.startsWith("saml.") || name.startsWith("history.") || name.startsWith("proxy.")) continue;
            sortedSet.add(key.toString());
        }
        ArrayList<GUIParameter> params = new ArrayList<GUIParameter>();
        for (String key : sortedSet) {
            params.add(new GUIParameter(key, conf.getProperty(key)));
        }
        return params;
    }

    public List<GUIParameter> loadProtocolSettings() throws ServerException {
        this.checkMenu(this.getThreadLocalRequest(), 7L);
        ContextProperties conf = Context.get().getProperties();
        ArrayList<GUIParameter> params = new ArrayList<GUIParameter>();
        for (Object key : conf.keySet()) {
            if (!key.toString().startsWith("webservice.") && !key.toString().startsWith("webdav.") && !key.toString().startsWith("cmis.") && !key.toString().startsWith("ftp.")) continue;
            params.add(new GUIParameter(key.toString(), conf.getProperty(key.toString())));
        }
        return params;
    }

    public void saveSettings(List<GUIParameter> settings) throws ServerException {
        Session session = this.checkMenu(this.getThreadLocalRequest(), 2L);
        try {
            GenericDAO genericDao = Context.get(GenericDAO.class);
            int counter = 0;
            ContextProperties conf = Context.get().getProperties();
            for (GUIParameter setting : settings) {
                this.saveSetting(setting, session, genericDao, conf);
                ++counter;
            }
            conf.write();
            log.info("Successfully saved {} parameters", (Object)counter);
        }
        catch (Exception e) {
            this.throwServerException(session, log, e);
        }
    }

    private void saveSetting(GUIParameter parameter, Session session, GenericDAO genericDao, ContextProperties conf) throws PersistenceException {
        if (parameter == null || StringUtils.isEmpty(parameter.getName())) {
            return;
        }
        if (parameter.getName().endsWith(GUI_WELCOME)) {
            Generic setting = genericDao.findByAlternateKey(GUISETTING, GUI_WELCOME, 0L, session.getTenantId());
            if (setting == null) {
                setting = new Generic(GUISETTING, GUI_WELCOME, 0L, session.getTenantId());
            }
            setting.setString1(parameter.getValue());
            genericDao.store(setting);
        } else if (parameter.getName().endsWith(GUI_TAG_VOCABULARY)) {
            Generic setting = genericDao.findByAlternateKey(GUISETTING, GUI_TAG_VOCABULARY, 0L, session.getTenantId());
            if (setting == null) {
                setting = new Generic(GUISETTING, GUI_TAG_VOCABULARY, 0L, session.getTenantId());
            }
            setting.setString1(parameter.getValue());
            genericDao.store(setting);
        } else {
            conf.setProperty(parameter.getName(), parameter.getValue() != null ? parameter.getValue() : "");
        }
    }

    public void saveFirewallSettings(List<GUIParameter> settings) throws ServerException {
        this.saveSettings(settings);
        HttpFirewall firewall = Context.get(HttpFirewall.class);
        ContextProperties config = Context.get().getProperties();
        firewall.setAllowBackSlash(config.getBoolean("firewall.allowBackSlash", false));
        firewall.setAllowSemicolon(config.getBoolean("firewall.allowSemicolon", false));
        firewall.setAllowUrlEncodedPercent(config.getBoolean("firewall.allowUrlEncodedPercent", false));
        firewall.setAllowUrlEncodedSlash(config.getBoolean("firewall.allowUrlEncodedSlash", false));
        firewall.setAllowUrlEncodedPeriod(config.getBoolean("firewall.allowUrlEncodedPeriod", false));
    }

    public void saveStoreSettings(List<GUIParameter> settings) throws ServerException {
        this.saveSettings(settings);
        Store store = Context.get(Store.class);
        store.init();
    }

    public List<String> removeStore(int storeId) throws ServerException {
        Session session = this.checkMenu(this.getThreadLocalRequest(), 2L);
        try {
            ContextProperties config = Context.get().getProperties();
            if (storeId == config.getInt("store.write")) {
                throw new ServerException("You cannot delete the store " + storeId + " because it is the current default");
            }
            FolderDAO dao = Context.get(FolderDAO.class);
            List<Long> folderIds = dao.queryForList("select ld_folderid from ld_folder_store where ld_storeid = " + storeId + " and ld_nodeid = '" + SqlUtil.doubleQuotesAndBackslashes(config.getProperty("id")) + "'", Long.class);
            if (!folderIds.isEmpty()) {
                List<String> paths = folderIds.stream().map(f -> {
                    try {
                        return dao.computePathExtended((long)f);
                    }
                    catch (PersistenceException e) {
                        log.error(e.getMessage(), e);
                        return "";
                    }
                }).collect(Collectors.toList());
                paths.sort(null);
                return paths;
            }
            Map<String, String> settings = config.getProperties("store." + storeId + ".");
            for (String setting : settings.keySet()) {
                config.remove("store." + storeId + "." + setting);
            }
            config.write();
            return new ArrayList<String>();
        }
        catch (Exception e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public List<GUIParameter> loadSettingsByNames(List<String> names) throws ServerException {
        Session session = this.validateSession();
        ArrayList<GUIParameter> values = new ArrayList<GUIParameter>();
        try {
            ContextProperties conf = Context.get().getProperties();
            for (String name : names) {
                if (name.endsWith("*")) {
                    Map<String, String> map = conf.getProperties(name.substring(0, name.length() - 1));
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        values.add(new GUIParameter(entry.getKey(), entry.getValue()));
                    }
                    continue;
                }
                values.add(new GUIParameter(name, conf.getProperty(name)));
            }
        }
        catch (Exception e) {
            this.throwServerException(session, log, e);
        }
        return values;
    }

    public List<GUIParameter> loadGUISettings() throws ServerException {
        Session session = this.checkMenu(this.getThreadLocalRequest(), 7L);
        String tenantName = session.getTenantName();
        ContextProperties conf = Context.get().getProperties();
        ArrayList<GUIParameter> params = new ArrayList<GUIParameter>();
        for (Object name : conf.keySet()) {
            if (!name.toString().startsWith(tenantName + ".gui")) continue;
            params.add(new GUIParameter(name.toString(), conf.getProperty(name.toString())));
        }
        params.add(new GUIParameter(tenantName + ".upload.maxsize", conf.getProperty(tenantName + ".upload.maxsize")));
        params.add(new GUIParameter(tenantName + ".upload.disallow", conf.getProperty(tenantName + ".upload.disallow")));
        params.add(new GUIParameter(tenantName + ".search.hits", conf.getProperty(tenantName + ".search.hits")));
        params.add(new GUIParameter(tenantName + ".search.extattr", conf.getProperty(tenantName + ".search.extattr")));
        params.add(new GUIParameter(tenantName + ".session.timeout", conf.getProperty(tenantName + ".session.timeout")));
        params.add(new GUIParameter(tenantName + ".session.heartbeat", conf.getProperty(tenantName + ".session.heartbeat")));
        params.add(new GUIParameter(tenantName + ".downloadticket.behavior", conf.getProperty(tenantName + ".downloadticket.behavior")));
        params.add(new GUIParameter(tenantName + CHARSET, conf.getProperty(tenantName + CHARSET)));
        try {
            GenericDAO gDao = Context.get(GenericDAO.class);
            List<Generic> generics = gDao.findByTypeAndSubtype(GUISETTING, null, null, session.getTenantId());
            for (Generic gen : generics) {
                params.add(new GUIParameter(tenantName + "." + gen.getSubtype(), gen.getString1()));
            }
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
        return params;
    }

    public boolean testEmail(String email) throws ServerException {
        Session session = this.validateSession();
        ContextProperties config = Context.get().getProperties();
        EMailSender sender = new EMailSender(session.getTenantName());
        try {
            EMail mail = new EMail();
            mail.setAccountId(-1L);
            mail.setAuthor(config.getProperty(session.getTenantName() + SMTP_SENDER));
            mail.setAuthorAddress(config.getProperty(session.getTenantName() + SMTP_SENDER));
            mail.parseRecipients(email);
            mail.setFolder("outbox");
            mail.setSentDate(new Date());
            mail.setSubject("Hello from " + SystemInfo.get().getProduct());
            mail.setMessageText("This is a test email from " + SystemInfo.get().getProduct());
            log.info("Sending test email to {}", (Object)email);
            sender.send(mail);
            log.info("Test email sent");
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    public boolean testStore(int id) throws ServerException {
        this.validateSession();
        try {
            Store manager = Context.get(Store.class);
            Store store = manager.newStore(id);
            log.info("Testing store {}", (Object)store);
            return store.test();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    public void saveRegistration(String name, String email, String organization, String website) throws ServerException {
        Session session = this.validateSession();
        try {
            ContextProperties conf = Context.get().getProperties();
            conf.setProperty("reg.name", name != null ? name : "");
            conf.setProperty("reg.email", email != null ? email : "");
            conf.setProperty("reg.organization", organization != null ? organization : "");
            conf.setProperty("reg.website", website != null ? website : "");
            conf.write();
            log.info("Successfully saved registration informations");
        }
        catch (Exception e) {
            this.throwServerException(session, log, e);
        }
    }

    public List<GUIParameter> loadConverterParameters(String converter) throws ServerException {
        Session session = this.validateSession();
        ArrayList<GUIParameter> parameters = new ArrayList<GUIParameter>();
        try {
            ServletUtil.checkMenu(this.getThreadLocalRequest(), 1750L);
            FormatConverter conv = (FormatConverter)Class.forName(converter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (String name : conv.getParameterNames()) {
                parameters.add(new GUIParameter(name, conv.getParameter(name)));
            }
            return parameters;
        }
        catch (Exception e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public void saveExtensionAliases(String extension, String aliases) throws ServerException {
        Session session = this.validateSession();
        try {
            ContextProperties config = Context.get().getProperties();
            Map<String, String> aliasMap = config.getProperties(CONVERTER_ALIAS);
            Set keys = aliasMap.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), extension)).map(Map.Entry::getKey).collect(Collectors.toSet());
            for (String key : keys) {
                config.remove(CONVERTER_ALIAS + key);
            }
            if (StringUtils.isNotEmpty(aliases)) {
                String[] tokens;
                String[] stringArray = tokens = aliases.split(",");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    config.setProperty(CONVERTER_ALIAS + token.toLowerCase().trim().replace(" ", "").replace(".", "").replace("=", ""), extension);
                    ++n2;
                }
            }
            config.write();
        }
        catch (Exception e) {
            this.throwServerException(session, log, e);
        }
    }

    public List<GUIParameter> loadWebserviceStats(Long tenantId) throws ServerException {
        Session session = this.validateSession();
        try {
            this.checkMenu(this.getThreadLocalRequest(), 7L);
            ArrayList<GUIParameter> params = new ArrayList<GUIParameter>();
            SequenceDAO dao = Context.get(SequenceDAO.class);
            GUIParameter p = new GUIParameter("webservice.apicalls", "" + dao.getCurrentValue("wscall", 0L, tenantId != null ? tenantId : -1L));
            params.add(p);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
            p = new GUIParameter("webservice.apicalls.current", "" + dao.getCurrentValue("wscall-" + df.format(new Date()), 0L, tenantId != null ? tenantId : -1L));
            params.add(p);
            return params;
        }
        catch (Exception e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public List<GUIParameter> loadAuditingSettings() throws ServerException {
        Session session = this.checkMenu(this.getThreadLocalRequest(), 106L);
        String tenantName = session.getTenantName();
        ContextProperties conf = Context.get().getProperties();
        ArrayList<GUIParameter> params = new ArrayList<GUIParameter>();
        for (Object name : conf.keySet()) {
            if (!name.toString().startsWith(tenantName + ".history") && !name.toString().startsWith("history.") && !name.toString().equals("webservice.call.ttl")) continue;
            params.add(new GUIParameter(name.toString(), conf.getProperty(name.toString())));
        }
        return params;
    }

    public Boolean testProxy(String host, int port, String username, String password) throws ServerException {
        Session session = this.validateSession();
        HttpGet get = new HttpGet("https://activation.logicaldoc.com");
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(40, host, port, username, password);){
                return (Boolean)httpClient.execute((ClassicHttpRequest)get, (HttpClientResponseHandler)new AbstractHttpClientResponseHandler<Boolean>(){

                    public Boolean handleResponse(ClassicHttpResponse response) throws IOException {
                        int responseStatusCode = response.getCode();
                        String responseBody = HttpUtil.getBodyString(response);
                        String responseReasonPhrase = StringUtils.defaultString(response.getReasonPhrase());
                        log.debug("Received LM response {} - {} - {}", responseStatusCode, responseReasonPhrase, responseBody);
                        if (responseStatusCode == 200 && responseBody.toLowerCase().contains("<body")) {
                            return true;
                        }
                        return false;
                    }

                    public Boolean handleEntity(HttpEntity arg0) throws IOException {
                        return Boolean.FALSE;
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return (Boolean)this.throwServerException(session, log, e);
        }
    }
}

