/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.BookmarkDAO;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.core.i18n.LanguageManager;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.searchengine.FulltextSearchOptions;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.Search;
import com.logicaldoc.core.searchengine.SearchOptions;
import com.logicaldoc.core.searchengine.folder.FolderCriterion;
import com.logicaldoc.core.searchengine.folder.FolderSearchOptions;
import com.logicaldoc.core.searchengine.saved.SavedSearch;
import com.logicaldoc.core.searchengine.saved.SearchDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIAttribute;
import com.logicaldoc.gui.common.client.beans.GUICriterion;
import com.logicaldoc.gui.common.client.beans.GUIDocument;
import com.logicaldoc.gui.common.client.beans.GUIResult;
import com.logicaldoc.gui.common.client.beans.GUISearchOptions;
import com.logicaldoc.gui.frontend.client.services.SearchService;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import com.logicaldoc.web.service.DocumentServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchServiceImpl
extends AbstractRemoteService
implements SearchService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);

    public GUIResult search(GUISearchOptions options) throws ServerException {
        Session session = this.validateSession();
        options.setUserId(session.getUserId());
        GUIResult result = new GUIResult();
        try {
            List<Hit> hits = this.doSearch(options, session, result);
            BookmarkDAO bDao = Context.get(BookmarkDAO.class);
            List<Long> bookmarks = bDao.findBookmarkedDocs(session.getUserId());
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            ArrayList<GUIDocument> guiResults = new ArrayList<GUIDocument>();
            DocumentServiceImpl documentServiceImpl = new DocumentServiceImpl();
            for (Hit hit : hits) {
                GUIDocument guiHit = null;
                if (hit.getType().startsWith("folder")) {
                    guiHit = documentServiceImpl.fromDocument(hit, null, null);
                    guiHit.setIcon(hit.getType());
                } else {
                    Document doc = (Document)docDao.findById(hit.getId());
                    docDao.initialize(doc);
                    if (doc != null) {
                        guiHit = documentServiceImpl.fromDocument(doc, null, null);
                    } else {
                        log.debug("Unexisting document {}", (Object)hit.getId());
                        continue;
                    }
                }
                this.prepareHit(hit, guiHit, bookmarks);
                guiResults.add(guiHit);
            }
            result.setHits(guiResults);
            return result;
        }
        catch (Exception t) {
            return (GUIResult)this.throwServerException(session, log, t);
        }
    }

    private void prepareHit(Hit hit, GUIDocument guiHit, List<Long> bookmarks) {
        guiHit.setScore(hit.getScore());
        guiHit.setSummary(hit.getSummary());
        guiHit.setBookmarked(bookmarks.contains(hit.getId()) || bookmarks.contains(hit.getDocRef()));
        if ("folder".equals(hit.getType())) {
            guiHit.setIcon("folder_closed");
        } else if ("folderalias".equals(hit.getType())) {
            guiHit.setIcon("folder_alias_closed");
        } else if ("pdf".equals(hit.getDocRefType())) {
            guiHit.setIcon("pdf");
        } else {
            guiHit.setIcon(FileUtil.getBaseName(hit.getIcon()));
        }
        ArrayList<GUIAttribute> extList = new ArrayList<GUIAttribute>();
        for (String name : hit.getAttributeNames()) {
            Attribute e = hit.getAttributes().get(name);
            GUIAttribute ext = new GUIAttribute();
            ext.setName(name);
            ext.setHidden(e.getHidden() == 1);
            ext.setReadonly(e.getReadonly() == 1);
            ext.setMultiple(e.getMultiple() == 1);
            ext.setSetId(e.getSetId());
            ext.setDateValue(e.getDateValue());
            ext.setStringValue(e.getStringValue());
            ext.setIntValue(e.getIntValue());
            ext.setDoubleValue(e.getDoubleValue());
            ext.setBooleanValue(e.getBooleanValue());
            ext.setType(e.getType());
            ext.setParent(e.getParent());
            ext.setStringValues(e.getStringValues());
            if (e.getType() == 4) {
                ext.setUsername(ext.getStringValue());
            }
            extList.add(ext);
        }
        guiHit.setAttributes(extList);
    }

    private List<Hit> doSearch(GUISearchOptions options, Session session, GUIResult result) {
        SearchOptions searchOptions = this.prepareSearchOptions(options, session);
        Search search = Search.get(searchOptions);
        try {
            log.info("Searching max {} hits", (Object)searchOptions.getMaxHits());
            search.search();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        result.setEstimatedHits(search.getEstimatedHitsNumber());
        List<Hit> hits = search.getHits();
        result.setTime(search.getExecTime());
        result.setHasMore(search.isMoreHitsPresent());
        return hits;
    }

    private SearchOptions prepareSearchOptions(GUISearchOptions options, Session session) {
        SearchOptions searchOptions = this.toSearchOptions(options);
        searchOptions.setTenantId(session.getTenantId());
        searchOptions.setTransaction(new UserHistory(session));
        if (searchOptions instanceof FulltextSearchOptions) {
            FulltextSearchOptions fulltextOptions = (FulltextSearchOptions)searchOptions;
            Locale exprLoc = LocaleUtil.toLocale(options.getExpressionLanguage());
            Language lang = LanguageManager.getInstance().getLanguage(exprLoc);
            if (lang == null && (exprLoc = LocaleUtil.toLocale(exprLoc.getLanguage())) != null) {
                fulltextOptions.setExpressionLanguage(exprLoc.getLanguage());
            }
        }
        return searchOptions;
    }

    public boolean save(GUISearchOptions options) throws ServerException {
        Session session = this.validateSession();
        try {
            SearchOptions opt = this.toSearchOptions(options);
            SavedSearch search = new SavedSearch();
            search.setName(options.getName());
            search.setUserId(session.getUserId());
            search.setTenantId(session.getTenantId());
            search.setDescription(options.getDescription());
            search.saveOptions(opt);
            SearchDAO dao = Context.get(SearchDAO.class);
            dao.store(search);
            log.debug("Saved search {}", (Object)opt.getName());
            return true;
        }
        catch (Exception t) {
            return (Boolean)this.throwServerException(session, log, t);
        }
    }

    public void delete(List<String> names) throws ServerException {
        Session session = this.validateSession();
        SearchDAO dao = Context.get(SearchDAO.class);
        try {
            for (String name : names) {
                SavedSearch search = dao.findByUserIdAndName(session.getUserId(), name);
                if (search == null) continue;
                dao.delete(search.getId());
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public GUISearchOptions load(String name) throws ServerException {
        Session session = this.validateSession();
        SearchDAO dao = Context.get(SearchDAO.class);
        try {
            SavedSearch search = dao.findByUserIdAndName(session.getUserId(), name);
            return this.toGUIOptions(search.readOptions());
        }
        catch (Exception t) {
            return (GUISearchOptions)this.throwServerException(session, log, t);
        }
    }

    public static List<SearchOptions> getSearches(Session session) throws PersistenceException {
        SearchDAO dao = Context.get(SearchDAO.class);
        HashMap<String, SearchOptions> map = new HashMap<String, SearchOptions>();
        List<SavedSearch> searches = dao.findByUserId(session.getUserId());
        for (SavedSearch search : searches) {
            try {
                map.put(search.getName(), search.readOptions());
            }
            catch (Exception e) {
                log.error("Cannot process saved search {} of user {}", (Object)search.getName(), (Object)session.getUsername());
                log.error(e.getMessage(), e);
            }
        }
        return map.values().stream().sorted((s1, s2) -> s1.getName().compareTo(s2.getName())).toList();
    }

    protected GUISearchOptions toGUIOptions(SearchOptions searchOptions) {
        GUISearchOptions op = new GUISearchOptions();
        op.setType(searchOptions.getType());
        op.setDescription(searchOptions.getDescription());
        op.setExpression(searchOptions.getExpression());
        op.setMaxHits(searchOptions.getMaxHits());
        op.setName(searchOptions.getName());
        op.setUserId(searchOptions.getUserId());
        op.setTopOperator(searchOptions.getTopOperator());
        op.setFolder(searchOptions.getFolderId());
        op.setSearchInSubPath(searchOptions.isSearchInSubPath());
        op.setTemplate(searchOptions.getTemplate());
        op.setCaseSensitive(searchOptions.isCaseSensitive() ? 1 : 0);
        op.setRetrieveAliases(searchOptions.isRetrieveAliases() ? 1 : 0);
        if (searchOptions.getType() == 0) {
            op.setDateFrom(((FulltextSearchOptions)searchOptions).getDateFrom());
            op.setDateTo(((FulltextSearchOptions)searchOptions).getDateTo());
            op.setCreationFrom(((FulltextSearchOptions)searchOptions).getCreationFrom());
            op.setCreationTo(((FulltextSearchOptions)searchOptions).getCreationTo());
            op.setExpressionLanguage(((FulltextSearchOptions)searchOptions).getExpressionLanguage());
            op.setFields(new ArrayList<String>(((FulltextSearchOptions)searchOptions).getFields()));
            op.setFormat(((FulltextSearchOptions)searchOptions).getFormat());
            op.setLanguage(((FulltextSearchOptions)searchOptions).getLanguage());
            op.setSizeMax(((FulltextSearchOptions)searchOptions).getSizeMax());
            op.setSizeMin(((FulltextSearchOptions)searchOptions).getSizeMin());
        } else if (searchOptions.getType() == 3) {
            ArrayList<GUICriterion> criteria = new ArrayList<GUICriterion>();
            for (FolderCriterion crit : ((FolderSearchOptions)searchOptions).getCriteria()) {
                GUICriterion criterion = new GUICriterion();
                criterion.setField(crit.getField());
                if (crit.getType() == 3) {
                    criterion.setDateValue(crit.getDateValue());
                } else if (crit.getType() == 1 || crit.getType() == 101 || crit.getType() == 4 || crit.getType() == 5) {
                    criterion.setLongValue(crit.getLongValue());
                } else if (crit.getType() == 2) {
                    criterion.setDoubleValue(crit.getDoubleValue());
                } else if (crit.getType() == 0 || crit.getType() == 100) {
                    criterion.setStringValue(crit.getStringValue());
                }
                criterion.setOperator(crit.getOperator().toLowerCase());
                criteria.add(criterion);
            }
            op.setCriteria(criteria);
        }
        op.setFilterIds(new ArrayList<Long>(searchOptions.getFilterIds()));
        return op;
    }

    public void shareSearch(String name, List<Long> userIds, List<Long> groupIds) throws ServerException {
        Session session = this.validateSession();
        try {
            SavedSearch search = this.loadSavedSearch(name, session);
            if (search == null) {
                return;
            }
            ArrayList<Long> allUsers = new ArrayList<Long>();
            allUsers.addAll(userIds);
            this.addUsersFromGroups(groupIds, allUsers);
            for (Long userId : allUsers) {
                this.store(search, userId);
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    private void store(SavedSearch search, Long userId) {
        try {
            SearchDAO dao = Context.get(SearchDAO.class);
            SavedSearch clone = new SavedSearch(search);
            clone.setUserId(userId);
            dao.store(clone);
        }
        catch (Exception t) {
            log.warn("Cannot save search {} for user {}", search.getName(), userId, t);
        }
    }

    private void addUsersFromGroups(Collection<Long> groupIds, Collection<Long> users) throws PersistenceException {
        UserDAO gDao = Context.get(UserDAO.class);
        for (Long gId : groupIds) {
            Set<User> usrs = gDao.findByGroup(gId);
            for (User user : usrs) {
                if (users.contains(user.getId())) continue;
                users.add(user.getId());
            }
        }
    }

    private SavedSearch loadSavedSearch(String name, Session session) throws PersistenceException {
        SearchDAO dao = Context.get(SearchDAO.class);
        return dao.findByUserIdAndName(session.getUserId(), name);
    }

    protected Date convertToJavaDate(Date source) {
        if (source == null) {
            return source;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(source);
        return cal.getTime();
    }

    protected SearchOptions toSearchOptions(GUISearchOptions options) {
        SearchOptions searchOptions = Search.newOptions(options.getType());
        searchOptions.setTopOperator(options.getTopOperator());
        searchOptions.setDescription(options.getDescription());
        searchOptions.setExpression(options.getExpression());
        searchOptions.setMaxHits(options.getMaxHits());
        searchOptions.setName(options.getName());
        searchOptions.setUserId(options.getUserId());
        searchOptions.setCaseSensitive(options.getCaseSensitive() == 1);
        searchOptions.setRetrieveAliases(options.getRetrieveAliases() == 1);
        searchOptions.setFolderId(options.getFolder());
        searchOptions.setSearchInSubPath(options.isSearchInSubPath());
        searchOptions.setTemplate(options.getTemplate());
        if (options.getType() == 0) {
            ((FulltextSearchOptions)searchOptions).setDateFrom(this.convertToJavaDate(options.getDateFrom()));
            ((FulltextSearchOptions)searchOptions).setDateTo(this.convertToJavaDate(options.getDateTo()));
            ((FulltextSearchOptions)searchOptions).setCreationFrom(this.convertToJavaDate(options.getCreationFrom()));
            ((FulltextSearchOptions)searchOptions).setCreationTo(this.convertToJavaDate(options.getCreationTo()));
            ((FulltextSearchOptions)searchOptions).setExpressionLanguage(options.getExpressionLanguage());
            ((FulltextSearchOptions)searchOptions).setFields(new HashSet<String>(options.getFields()));
            ((FulltextSearchOptions)searchOptions).setFormat(options.getFormat());
            ((FulltextSearchOptions)searchOptions).setLanguage(options.getLanguage());
            ((FulltextSearchOptions)searchOptions).setSizeMax(options.getSizeMax());
            ((FulltextSearchOptions)searchOptions).setSizeMin(options.getSizeMin());
        } else if (options.getType() == 3) {
            ArrayList<FolderCriterion> criteria = new ArrayList<FolderCriterion>();
            for (GUICriterion crit : options.getCriteria()) {
                FolderCriterion c = new FolderCriterion();
                c.setField(crit.getField());
                c.setComposition(options.getTopOperator());
                String operator = null;
                operator = "icontains".equals(crit.getOperator()) || "inotcontains".equals(crit.getOperator()) ? crit.getOperator().substring(1) : crit.getOperator();
                c.setOperator(operator);
                if (crit.getLongValue() != null) {
                    c.setLongValue(crit.getLongValue());
                } else if (crit.getDateValue() != null) {
                    c.setDateValue(this.convertToJavaDate(crit.getDateValue()));
                } else if (crit.getDoubleValue() != null) {
                    c.setDoubleValue(crit.getDoubleValue());
                } else {
                    c.setValue((Serializable)((Object)crit.getStringValue()));
                }
                criteria.add(c);
            }
            ((FolderSearchOptions)searchOptions).setCriteria(criteria);
        }
        searchOptions.setFilterIds(new HashSet<Long>(options.getFilterIds()));
        return searchOptions;
    }
}

