/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.communication.MessageTemplate;
import com.logicaldoc.core.communication.MessageTemplateDAO;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIMessage;
import com.logicaldoc.gui.common.client.beans.GUIMessageTemplate;
import com.logicaldoc.gui.frontend.client.services.MessageService;
import com.logicaldoc.util.html.HTMLSanitizer;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageServiceImpl
extends AbstractRemoteService
implements MessageService {
    private static final String TEMPLATES_HAVE_NOT_BEEN_SAVED = "Templates have not been saved";
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    private static final long serialVersionUID = 1L;

    public void delete(List<Long> ids) throws ServerException {
        this.validateSession();
        SystemMessageDAO dao = Context.get(SystemMessageDAO.class);
        for (long id : ids) {
            try {
                dao.delete(id);
            }
            catch (PersistenceException e) {
                throw new ServerException("Messages have not been deleted");
            }
        }
    }

    public GUIMessage getMessage(long messageId, boolean markAsRead) throws ServerException {
        Session session = this.validateSession();
        try {
            SystemMessageDAO dao = Context.get(SystemMessageDAO.class);
            SystemMessage message = (SystemMessage)dao.findById(messageId);
            dao.initialize(message);
            GUIMessage m = new GUIMessage();
            m.setId(message.getId());
            m.setSubject(message.getSubject());
            m.setConfirmation(message.getConfirmation() == 1);
            m.setMessage(message.getMessageText());
            m.setValidity(Integer.valueOf(message.getDateScope()));
            if (!message.wasReadBy(session.getUsername())) {
                Recipient rec = message.getRecipient(session.getUsername());
                if (rec != null) {
                    rec.setRead(1);
                    dao.store(message);
                }
                if (message.getConfirmation() == 1) {
                    Date date = new Date();
                    Recipient recipient = new Recipient();
                    recipient.setName(message.getAuthor());
                    recipient.setAddress(message.getAuthor());
                    recipient.setType(0);
                    recipient.setRead(0);
                    recipient.setMode("");
                    HashSet<Recipient> recipients = new HashSet<Recipient>();
                    recipients.add(recipient);
                    SystemMessage sysmess = new SystemMessage();
                    sysmess.setAuthor("SYSTEM");
                    sysmess.setRecipients(recipients);
                    sysmess.setSubject("Confirmation");
                    sysmess.setMessageText("To: " + recipient.getName() + "\nMessage: " + message.getMessageText());
                    sysmess.setSentDate(date);
                    sysmess.setConfirmation(0);
                    sysmess.setPrio(message.getPrio());
                    sysmess.setDateScope(message.getDateScope());
                    dao.store(sysmess);
                }
            }
            return m;
        }
        catch (Exception e) {
            return (GUIMessage)this.throwServerException(session, log, e);
        }
    }

    public void save(GUIMessage message, List<Long> recipientIds) throws ServerException {
        Session session = this.validateSession();
        try {
            for (Long id : recipientIds) {
                this.saveMessage(message, session, id);
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    private void saveMessage(GUIMessage message, Session session, long recipientId) throws ServerException {
        Context context = Context.get();
        SystemMessageDAO dao = context.getBean(SystemMessageDAO.class);
        UserDAO uDao = context.getBean(UserDAO.class);
        try {
            User user = (User)uDao.findById(recipientId);
            SystemMessage m = new SystemMessage();
            m.setTenantId(session.getTenantId());
            m.setAuthor(session.getUsername());
            m.setSentDate(new Date());
            m.setStatus(0);
            m.setType(0);
            m.setLastNotified(new Date());
            m.setMessageText(HTMLSanitizer.sanitizeSimpleText(message.getMessage()));
            m.setSubject(HTMLSanitizer.sanitizeSimpleText(message.getSubject()));
            Recipient recipient = new Recipient();
            recipient.setName(user.getUsername());
            recipient.setAddress(user.getUsername());
            recipient.setType(0);
            recipient.setMode("message");
            HashSet<Recipient> recipients = new HashSet<Recipient>();
            recipients.add(recipient);
            m.setRecipients(recipients);
            m.setDateScope(message.getValidity());
            m.setPrio(message.getPriority());
            m.setConfirmation(message.isConfirmation() ? 1 : 0);
            dao.store(m);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            throw new ServerException("Message has not been saved");
        }
    }

    public List<GUIMessageTemplate> loadTemplates(String language, String type) throws ServerException {
        Session session = this.validateSession();
        Context context = Context.get();
        try {
            MessageTemplateDAO dao = context.getBean(MessageTemplateDAO.class);
            ArrayList<GUIMessageTemplate> buf = new ArrayList<GUIMessageTemplate>();
            List<MessageTemplate> standardTemplates = dao.findByTypeAndLanguage(type, "en", session.getTenantId());
            HashMap<String, MessageTemplate> templates = new HashMap<String, MessageTemplate>();
            List<MessageTemplate> tmp = dao.findByTypeAndLanguage(type, language, session.getTenantId());
            for (MessageTemplate m : tmp) {
                templates.put(m.getName(), m);
            }
            Iterator<MessageTemplate> iterator = standardTemplates.iterator();
            while (iterator.hasNext()) {
                MessageTemplate test;
                MessageTemplate template = test = iterator.next();
                if (templates.containsKey(test.getName())) {
                    template = (MessageTemplate)templates.get(test.getName());
                }
                GUIMessageTemplate t = new GUIMessageTemplate();
                t.setId(Long.valueOf(template.getId()));
                t.setLanguage(language);
                t.setName(template.getName());
                t.setSubject(template.getSubject());
                t.setBody(template.getBody());
                t.setType(template.getType());
                buf.add(t);
            }
            buf.sort((s1, s2) -> s1.getType().compareTo(s2.getType()));
            return buf;
        }
        catch (Exception t) {
            return (List)this.throwServerException(session, log, t);
        }
    }

    public void saveTemplates(List<GUIMessageTemplate> templates) throws ServerException {
        Session session = this.validateSession();
        try {
            MessageTemplateDAO dao = Context.get(MessageTemplateDAO.class);
            for (GUIMessageTemplate t : templates) {
                MessageTemplate template = dao.findByNameAndLanguage(t.getName(), t.getLanguage(), session.getTenantId());
                if (template == null || !template.getLanguage().equals(t.getLanguage())) {
                    template = new MessageTemplate();
                }
                template.setTenantId(session.getTenantId());
                template.setName(t.getName());
                template.setLanguage(t.getLanguage());
                template.setSubject(t.getSubject());
                template.setBody(t.getBody());
                template.setType(t.getType());
                this.storeTemplate(template);
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    private void storeTemplate(MessageTemplate template) throws ServerException {
        try {
            MessageTemplateDAO dao = Context.get(MessageTemplateDAO.class);
            dao.store(template);
        }
        catch (Exception e) {
            throw new ServerException(TEMPLATES_HAVE_NOT_BEEN_SAVED);
        }
    }

    public void deleteTemplates(List<Long> ids) throws ServerException {
        Session session = this.validateSession();
        try {
            MessageTemplateDAO dao = Context.get(MessageTemplateDAO.class);
            for (Long id : ids) {
                MessageTemplate template = (MessageTemplate)dao.findById(id);
                if (template == null || "en".equals(template.getLanguage())) continue;
                this.delete(id);
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    private void delete(long id) throws ServerException {
        try {
            MessageTemplateDAO dao = Context.get(MessageTemplateDAO.class);
            dao.delete(id);
        }
        catch (Exception e) {
            throw new ServerException(TEMPLATES_HAVE_NOT_BEEN_SAVED, (Throwable)e);
        }
    }

    public void deleteTemplates(String name) throws ServerException {
        Session session = this.validateSession();
        try {
            MessageTemplateDAO dao = Context.get(MessageTemplateDAO.class);
            List<MessageTemplate> templates = dao.findByName(name, session.getTenantId());
            for (MessageTemplate template : templates) {
                if (template.getType().equals("system")) continue;
                this.delete(template.getId());
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public GUIMessageTemplate getTemplate(long templateId) throws ServerException {
        MessageTemplate template;
        block3: {
            Session session = this.validateSession();
            try {
                MessageTemplateDAO dao = Context.get(MessageTemplateDAO.class);
                template = (MessageTemplate)dao.findById(templateId);
                if (template != null) break block3;
                return null;
            }
            catch (Exception t) {
                return (GUIMessageTemplate)this.throwServerException(session, log, t);
            }
        }
        GUIMessageTemplate t = new GUIMessageTemplate();
        t.setId(Long.valueOf(template.getId()));
        t.setLanguage(template.getLanguage());
        t.setName(template.getName());
        t.setSubject(template.getSubject());
        t.setBody(template.getBody());
        t.setType(template.getType());
        return t;
    }
}

