/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.google.gwt.user.server.rpc.jakarta.RemoteServiceServlet;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.security.DeviceDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.core.security.user.UserHistoryDAO;
import com.logicaldoc.core.ticket.Ticket;
import com.logicaldoc.core.ticket.TicketDAO;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIParameter;
import com.logicaldoc.gui.common.client.beans.GUIUser;
import com.logicaldoc.gui.common.client.beans.GUIValue;
import com.logicaldoc.gui.login.client.services.LoginService;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.security.PasswordGenerator;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.SecurityServiceImpl;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServiceImpl
extends RemoteServiceServlet
implements LoginService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);

    public GUIValue changePassword(long userId, String oldPassword, String newPassword) {
        SecurityServiceImpl ser = new SecurityServiceImpl();
        return ser.changePassword(userId, userId, oldPassword, newPassword, false);
    }

    public GUIUser getUser(String username) {
        try {
            UserDAO userDao = Context.get(UserDAO.class);
            UserHistoryDAO userHistoryDao = Context.get(UserHistoryDAO.class);
            TenantDAO tenantDao = Context.get(TenantDAO.class);
            User user = this.pickUser(username);
            GUIUser usr = new GUIUser();
            usr.setId(user.getId());
            usr.setEnabled(user.getEnabled() == 1);
            usr.setUsername(user.getUsername());
            usr.setTenant(SecurityServiceImpl.getTenant(user.getTenantId()));
            usr.setPasswordExpires(user.getPasswordExpires() == 1);
            usr.setPasswordExpired(userDao.isPasswordExpired(username));
            usr.setEmail(user.getEmail());
            usr.setEmail2(user.getEmail2());
            usr.setName(user.getName());
            usr.setFirstName(user.getFirstName());
            usr.setSecondFactor(user.getSecondFactor());
            Tenant tenant = (Tenant)tenantDao.findById(user.getTenantId());
            ContextProperties config = Context.get().getProperties();
            usr.setPasswordMinLenght(config.getInt(tenant.getName() + ".password.size", 6));
            List<UserHistory> failures = userHistoryDao.findByUserIdAndEvent(user.getId(), UserEvent.LOGIN_FAILED.toString());
            if (failures != null && !failures.isEmpty()) {
                usr.setLastLoginFailureReason(failures.get(0).getComment());
            }
            return usr;
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
            return null;
        }
    }

    public void resetPassword(String username, String emailAddress, String productName) throws ServerException {
        User user = this.pickUser(username);
        if (!user.getEmail().trim().equals(emailAddress.trim())) {
            throw new ServerException(String.format("Email %s is wrong", emailAddress));
        }
        try {
            String ticketid = UUID.randomUUID().toString();
            Ticket ticket = new Ticket();
            ticket.setTicketId(ticketid);
            ticket.setDocId(0L);
            ticket.setUserId(user.getId());
            ticket.setTenantId(user.getTenantId());
            ticket.setType(1);
            Calendar cal = Calendar.getInstance();
            cal.add(12, 15);
            ticket.setExpired(cal.getTime());
            TicketDAO ticketDao = Context.get(TicketDAO.class);
            ticketDao.store(ticket);
            ticketDao.deleteExpired();
            Locale locale = user.getLocale();
            EMail email = new EMail();
            email.setHistoricyze(false);
            email.setHtml(1);
            email.setTenantId(user.getTenantId());
            Recipient recipient = new Recipient();
            recipient.setAddress(user.getEmail());
            recipient.setRead(1);
            email.addRecipient(recipient);
            email.setFolder("outbox");
            email.setLocale(locale);
            email.setSentDate(new Date());
            email.setUsername(user.getUsername());
            HttpServletRequest request = this.getThreadLocalRequest();
            String urlPrefix = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            String address = urlPrefix + "/pswrecovery?ticketId=" + ticketid + "&userId=" + user.getId();
            HashMap<String, Object> dictionary = new HashMap<String, Object>();
            dictionary.put("product", productName);
            dictionary.put("url", address);
            dictionary.put("user", user);
            dictionary.put("locale", locale);
            EMailSender sender = new EMailSender(user.getTenantId());
            sender.send(email, "psw.rec2", dictionary);
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage());
        }
    }

    private User pickUser(String username) throws ServerException {
        User user;
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            user = userDao.getUser(username);
        }
        catch (PersistenceException e) {
            throw new ServerException(String.format("Error in the data layer for user %s", username));
        }
        if (user == null) {
            throw new ServerException(String.format("User %s not found", username));
        }
        return user;
    }

    public boolean isSecretKeyRequired(String username, String deviceId) throws ServerException {
        User user;
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            user = this.pickUser(username);
            userDao.initialize(user);
        }
        catch (PersistenceException | ServerException e) {
            log.warn(e.getMessage(), e);
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)user.getSecondFactor())) {
            return false;
        }
        TenantDAO tDao = Context.get(TenantDAO.class);
        String tenant = "system";
        try {
            tenant = tDao.getTenantName(user.getTenantId());
        }
        catch (PersistenceException e) {
            log.warn("Cannot retrieve tenant name of user {}", (Object)user.getUsername());
        }
        ContextProperties config = Context.get().getProperties();
        if (!config.getBoolean(tenant + ".2fa.enabled", false) || !config.getBoolean(tenant + ".2fa." + user.getSecondFactor().toLowerCase() + ".enabled", false)) {
            return false;
        }
        if (config.getBoolean(tenant + ".2fa.allowtrusted", true)) {
            HttpServletRequest request = this.getThreadLocalRequest();
            request.setAttribute("device", (Object)deviceId);
            DeviceDAO deviceDao = Context.get(DeviceDAO.class);
            try {
                return !deviceDao.isTrustedDevice(user.getUsername(), request);
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage(), e);
                return false;
            }
        }
        return true;
    }

    public String generatePassword(String username) {
        User user;
        try {
            user = this.pickUser(username);
        }
        catch (ServerException e) {
            log.warn(e.getMessage(), e);
            return "";
        }
        TenantDAO tDao = Context.get(TenantDAO.class);
        String tenant = "default";
        try {
            tenant = tDao.getTenantName(user.getTenantId());
        }
        catch (PersistenceException e) {
            log.warn("Cannot retrieve tenant name of user {}", (Object)user.getUsername());
        }
        ContextProperties config = Context.get().getProperties();
        return PasswordGenerator.generate(config.getInt(tenant + ".password.size", 8), config.getInt(tenant + ".password.uppercase", 2), config.getInt(tenant + ".password.lowercase", 2), config.getInt(tenant + ".password.digit", 1), config.getInt(tenant + ".password.special", 1), config.getInt(tenant + ".password.sequence", 4), config.getInt(tenant + ".password.occurrence", 3));
    }

    public List<GUIParameter> getLegalsToConfirm(String username) throws ServerException {
        try {
            ArrayList<GUIParameter> legals = new ArrayList<GUIParameter>();
            UserDAO userDao = Context.get(UserDAO.class);
            userDao.queryForResultSet("select ld_name, ld_title from ld_legal where not exists (select * from ld_legal_confirmation where ld_username = :username and ld_legal=ld_name) order by ld_sort", Map.of("username", username), null, rows -> {
                while (rows.next()) {
                    legals.add(new GUIParameter(rows.getString(1), rows.getString(2)));
                }
            });
            return legals;
        }
        catch (PersistenceException e) {
            throw new ServerException(e.getMessage());
        }
    }

    public void confirmLegal(String username, String legal) throws ServerException {
        User user;
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            user = userDao.findByUsername(username);
            userDao.jdbcUpdate("insert into ld_legal_confirmation(ld_username, ld_user, ld_legal, ld_date) values (:username, :user, :legal, CURRENT_TIMESTAMP)", Map.of("username", user.getUsername(), "user", user.getFullName(), "legal", legal));
            log.info("User {} confirmed legal {}", (Object)username, (Object)legal);
        }
        catch (PersistenceException e) {
            throw new ServerException(e.getMessage());
        }
        try {
            UserHistoryDAO hDao = Context.get(UserHistoryDAO.class);
            UserHistory event = new UserHistory();
            event.setUser(user);
            event.setEvent(UserEvent.LEGAL_CONFIRMED);
            event.setComment(hDao.queryForString("select ld_title from ld_legal where ld_name = :legal", Map.of("legal", legal)) + " - " + legal);
            hDao.store(event);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }
}

