/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import com.logicaldoc.core.SystemInfo;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.core.i18n.LanguageManager;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.AttributeSetDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.gui.common.client.InvalidSessionServerException;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIAttribute;
import com.logicaldoc.gui.common.client.beans.GUIAttributeSet;
import com.logicaldoc.gui.common.client.beans.GUIInfo;
import com.logicaldoc.gui.common.client.beans.GUIMessage;
import com.logicaldoc.gui.common.client.beans.GUIParameter;
import com.logicaldoc.gui.common.client.beans.GUITenant;
import com.logicaldoc.gui.common.client.beans.GUIValue;
import com.logicaldoc.gui.common.client.services.InfoService;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.IOUtil;
import com.logicaldoc.util.io.ResourceUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.listener.ApplicationListener;
import com.logicaldoc.web.service.AbstractRemoteService;
import com.logicaldoc.web.service.AttributeSetServiceImpl;
import com.logicaldoc.web.service.SecurityServiceImpl;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoServiceImpl
extends AbstractRemoteService
implements InfoService {
    private static final String ENABLED = "enabled";
    private static final String LANG = ".lang.";
    private static final Logger log = LoggerFactory.getLogger(InfoServiceImpl.class);
    private static final long serialVersionUID = 1L;

    public GUIInfo getInfo(String locale, String tenantName, boolean login) throws ServerException {
        GUIInfo info = null;
        try {
            info = InfoServiceImpl.getInfo(tenantName);
            info.setBundle(InfoServiceImpl.getBundle(locale, tenantName));
            Locale withLocale = LocaleUtil.toLocale(locale);
            this.setSupportedGUILanguages(tenantName, info, withLocale);
            LanguageManager manager = LanguageManager.getInstance();
            List<Language> languages = manager.getActiveLanguages(tenantName);
            ArrayList<GUIValue> supportedLanguages = new ArrayList<GUIValue>();
            for (Language language : languages) {
                Locale lc = language.getLocale();
                GUIValue l = new GUIValue();
                l.setCode(lc.toString());
                l.setValue(lc.getDisplayName(withLocale));
                supportedLanguages.add(l);
            }
            info.setSupportedLanguages(supportedLanguages);
            ArrayList<GUIMessage> alerts = new ArrayList<GUIMessage>();
            ContextProperties config = Context.get().getProperties();
            boolean needSetup = config.getProperty("jdbc.url").startsWith("jdbc:hsqldb:mem:");
            if (!needSetup) {
                boolean bl = needSetup = !config.getBoolean("initialized", true);
            }
            if (needSetup) {
                GUIMessage setupReminder = new GUIMessage();
                setupReminder.setMessage(this.getValue(info, "setup.reminder"));
                HttpServletRequest request = this.getThreadLocalRequest();
                if (request != null) {
                    String urlPrefix = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                    setupReminder.setUrl(urlPrefix + "/setup");
                }
                alerts.add(setupReminder);
            } else {
                this.checkRestrartRequired(info, locale, alerts);
            }
            info.setAlerts(alerts);
            this.setAttributes(info, tenantName);
            return info;
        }
        catch (Exception t) {
            throw new ServerException(t.getMessage());
        }
    }

    private static String loadChangelog() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream is = IOUtil.getLimitedStream(ResourceUtil.getInputStream("CHANGELOG.txt"), 5000L);){
                String changelog = IOUtil.readStream(is);
                return changelog.replace("logicaldoc", "").replace("LogicalDOC", "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return "";
        }
    }

    private void setAttributes(GUIInfo info, String tenantName) {
        TenantDAO tDAO = Context.get(TenantDAO.class);
        AttributeSetDAO aDAO = Context.get(AttributeSetDAO.class);
        try {
            Tenant tenant = tDAO.findByName(tenantName);
            if (tenant == null) {
                log.debug("Tenant with name {} not found, fallback to the default", (Object)tenantName);
                tenant = (Tenant)tDAO.findById(1L);
            }
            Map<String, Attribute> attributes = aDAO.findAttributes(tenant.getId(), null);
            ArrayList<GUIAttribute> guiAttributes = new ArrayList<GUIAttribute>();
            for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
                Attribute att = entry.getValue();
                GUIAttribute guiAtt = new GUIAttribute();
                guiAtt.setName(entry.getKey());
                guiAtt.setStringValue(att.getStringValue());
                guiAtt.setBooleanValue(att.getBooleanValue());
                guiAtt.setDoubleValue(att.getDoubleValue());
                guiAtt.setEditor(att.getEditor());
                guiAtt.setHidden(att.getHidden() == 1);
                guiAtt.setReadonly(att.getReadonly() == 1);
                guiAtt.setIntValue(att.getIntValue());
                guiAtt.setLabel(att.getLabel());
                guiAtt.setMandatory(att.getMandatory() == 1);
                guiAtt.setMultiple(att.getMultiple() == 1);
                guiAtt.setPosition(att.getPosition());
                guiAtt.setSetId(att.getSetId());
                guiAtt.setType(att.getType());
                guiAttributes.add(guiAtt);
            }
            info.setAttributeDefinitions(guiAttributes);
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
    }

    private void checkRestrartRequired(GUIInfo info, String locale, List<GUIMessage> alerts) {
        if (ApplicationListener.isRestartRequired()) {
            GUIMessage restartReminder = new GUIMessage();
            restartReminder.setMessage(this.getValue(info, "needrestart"));
            alerts.add(restartReminder);
        } else {
            UserDAO dao = Context.get(UserDAO.class);
            int test = -1;
            try {
                test = dao.queryForInt("select count(*) from ld_user");
            }
            catch (Exception t) {
                test = -1;
            }
            if (test < 1) {
                info.setDatabaseConnected(false);
                GUIMessage m = new GUIMessage();
                m.setMessage(I18N.message("databasenotconnected", locale));
                alerts.add(m);
            }
        }
    }

    private void setSupportedGUILanguages(String tenantName, GUIInfo info, Locale withLocale) {
        ArrayList<GUIValue> supportedLanguages = new ArrayList<GUIValue>();
        List<String> installedLocales = I18N.getLocales();
        for (String loc : installedLocales) {
            if (!ENABLED.equals(Context.get().getProperties().getProperty(tenantName + LANG + loc + ".gui"))) continue;
            Locale lc = LocaleUtil.toLocale(loc);
            GUIValue l = new GUIValue();
            l.setCode(loc);
            l.setValue(lc.getDisplayName(withLocale));
            supportedLanguages.add(l);
        }
        info.setSupportedGUILanguages(supportedLanguages);
    }

    public static GUIInfo getInfo(String tenantName) {
        ContextProperties config = Context.get().getProperties();
        String tname = tenantName;
        if (tname == null) {
            tname = "default";
        }
        GUITenant tenant = null;
        try {
            tenant = SecurityServiceImpl.getTenant(tname);
        }
        catch (Exception t) {
            log.warn(t.getMessage());
        }
        if (tenant == null) {
            tenant = new GUITenant();
            tenant.setName("default");
            tenant.setId(1L);
        }
        GUIInfo guiInfo = new GUIInfo();
        guiInfo.setTenant(tenant);
        guiInfo.setSessionHeartbeat(config.getInt(tname + ".session.heartbeat", 60));
        SystemInfo info = SystemInfo.get(tenant.getId());
        guiInfo.setLicensee(info.getLicensee());
        guiInfo.setRelease(info.getRelease());
        guiInfo.setRunLevel(info.getRunLevel());
        guiInfo.setYear(info.getYear());
        guiInfo.setHostName(info.getHostName());
        guiInfo.setDate(info.getDate());
        guiInfo.setInstallationId(info.getInstallationId());
        guiInfo.getFeatures().addAll(info.getFeatures());
        guiInfo.getBranding().setBugs(info.getBugs());
        guiInfo.getBranding().setForum(info.getForum());
        guiInfo.getBranding().setEvaluation(info.getEvaluation());
        guiInfo.getBranding().setHelp(info.getHelp());
        guiInfo.getBranding().setProduct(info.getProduct());
        guiInfo.getBranding().setProductName(info.getProductName());
        guiInfo.getBranding().setSupport(info.getSupport());
        guiInfo.getBranding().setUrl(info.getUrl());
        guiInfo.getBranding().setVendor(info.getVendor());
        guiInfo.getBranding().setVendorAddress(info.getVendorAddress());
        guiInfo.getBranding().setVendorCap(info.getVendorCap());
        guiInfo.getBranding().setVendorCity(info.getVendorCity());
        guiInfo.getBranding().setVendorCountry(info.getVendorCountry());
        try {
            ArrayList<GUIValue> values = new ArrayList<GUIValue>();
            for (Object key : config.keySet()) {
                GUIValue pair = new GUIValue();
                String keyString = (String)key;
                pair.setCode(keyString);
                pair.setValue(config.getProperty(keyString));
                values.add(pair);
            }
            InfoServiceImpl.loadGUISettingsFromDB(tenant, values);
            guiInfo.setConfig(values);
        }
        catch (Exception t) {
            log.warn("cannot load GUI settings", t);
        }
        try {
            GUIAttributeSet defaultSet = new AttributeSetServiceImpl().getAttributeSet("default");
            guiInfo.setDefaultAttributeSet(defaultSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        guiInfo.setChangelog(InfoServiceImpl.loadChangelog());
        return guiInfo;
    }

    private static void loadGUISettingsFromDB(GUITenant tenant, List<GUIValue> values) {
        try {
            GenericDAO dao = Context.get(GenericDAO.class);
            List<Generic> dbSettings = dao.findByTypeAndSubtype("guisetting", null, 0L, tenant.getId());
            for (Generic generic : dbSettings) {
                values.add(new GUIValue(generic.getSubtype(), generic.getString1()));
            }
        }
        catch (Exception t) {
            log.warn("cannot load GUI settings from the database", t);
        }
    }

    protected static List<GUIValue> getBundle(String locale, String tenantName) {
        Locale l = InfoServiceImpl.getLocaleForBundle(tenantName, LocaleUtil.toLocale(locale));
        ResourceBundle rb = ResourceBundle.getBundle("i18n.messages", l);
        ArrayList<GUIValue> buf = new ArrayList<GUIValue>();
        for (String key : rb.keySet()) {
            GUIValue entry = new GUIValue();
            entry.setCode(key);
            entry.setValue(rb.getString(key));
            buf.add(entry);
        }
        return buf;
    }

    private static Locale getLocaleForBundle(String tenantName, Locale proposedLocale) {
        List<String> installedLocales = I18N.getLocales();
        ContextProperties config = Context.get().getProperties();
        Locale locale = null;
        for (String loc : installedLocales) {
            if (!ENABLED.equals(config.getProperty(tenantName + LANG + loc + ".gui")) || !loc.equals(proposedLocale.toString())) continue;
            locale = LocaleUtil.toLocale(loc);
            break;
        }
        if (locale == null) {
            for (String loc : installedLocales) {
                if (!ENABLED.equals(config.getProperty(tenantName + LANG + loc + ".gui"))) continue;
                Locale x = LocaleUtil.toLocale(loc);
                if (!proposedLocale.getLanguage().equals(x.getLanguage())) continue;
                locale = LocaleUtil.toLocale(loc);
                break;
            }
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    protected String getValue(GUIInfo info, String message) {
        for (GUIValue valuePair : info.getBundle()) {
            if (!valuePair.getCode().equals(message)) continue;
            return valuePair.getValue();
        }
        return "";
    }

    public List<GUIParameter> getSessionInfo() throws InvalidSessionServerException {
        Session session = this.validateSession();
        log.debug("Requested info for session {}", (Object)session.getSid());
        try {
            SystemMessageDAO messageDao = Context.get(SystemMessageDAO.class);
            ArrayList<GUIParameter> parameters = new ArrayList<GUIParameter>();
            GUIParameter messages = new GUIParameter("messages", "" + messageDao.getUnreadCount(session.getUsername(), 0));
            parameters.add(messages);
            parameters.add(new GUIParameter("valid", "" + SessionManager.get().isOpen(session.getSid())));
            return parameters;
        }
        catch (Exception t) {
            throw new InvalidSessionServerException(t.getMessage());
        }
    }

    public boolean ping() throws InvalidSessionServerException {
        try {
            Session session = this.validateSession();
            return session != null;
        }
        catch (Exception t) {
            return false;
        }
    }

    public String getCronDescription(String expression, String locale) throws ServerException {
        Session session = this.validateSession();
        try {
            CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
            CronParser parser = new CronParser(cronDefinition);
            CronDescriptor descriptor = CronDescriptor.instance((Locale)LocaleUtil.toLocale(locale));
            return descriptor.describe(parser.parse(expression));
        }
        catch (Exception e) {
            return (String)this.throwServerException(session, log, e);
        }
    }
}

