/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.FolderAccessControlEntry;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderEvent;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.gui.common.client.AccessDeniedException;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIAccessControlEntry;
import com.logicaldoc.gui.common.client.beans.GUIAttribute;
import com.logicaldoc.gui.common.client.beans.GUIFolder;
import com.logicaldoc.gui.common.client.beans.GUIValue;
import com.logicaldoc.gui.frontend.client.services.FolderService;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderServiceImpl
extends AbstractRemoteService
implements FolderService {
    private static final String FOLDER = "Folder ";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FolderServiceImpl.class);

    public GUIFolder inheritACL(long folderId, long rightsFolderId) throws ServerException {
        Session session = this.validateSession();
        FolderHistory transaction = new FolderHistory();
        transaction.setSession(session);
        try {
            FolderDAO fdao = Context.get(FolderDAO.class);
            fdao.updateSecurityRef(folderId, rightsFolderId, transaction);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
        return this.getFolder(session, folderId);
    }

    public void saveACL(GUIFolder guiFolder, boolean subtree) throws ServerException {
        Session session = this.validateSession();
        FolderDAO fdao = Context.get(FolderDAO.class);
        try {
            Folder folder = (Folder)fdao.findById(guiFolder.getId());
            fdao.initialize(folder);
            if (subtree) {
                this.executeLongRunningOperation("Apply Rights to Tree", () -> {
                    FolderHistory history = new FolderHistory();
                    history.setSession(session);
                    history.setEvent(FolderEvent.PERMISSION);
                    try {
                        fdao.applySecurityToTree(guiFolder.getId(), history);
                    }
                    catch (PersistenceException e) {
                        log.error(e.getMessage(), e);
                    }
                    return null;
                }, session);
            } else {
                this.saveACL(session, folder, guiFolder.getAccessControlList());
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void applyMetadata(long parentId) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Apply Metadata to Tree", () -> {
            FolderDAO fdao = Context.get(FolderDAO.class);
            FolderHistory transaction = new FolderHistory();
            transaction.setSession(session);
            try {
                fdao.applyMetadataToTree(parentId, transaction);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    public void delete(List<Long> folderIds) throws ServerException {
        Session session = this.validateSession();
        for (long folderId : folderIds) {
            try {
                this.delete(session, folderId);
            }
            catch (PersistenceException | PermissionException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    private void delete(Session session, long folderId) throws PermissionException, PersistenceException {
        FolderDAO dao = Context.get(FolderDAO.class);
        if (!dao.isPermissionAllowed(Permission.DELETE, folderId, session.getUserId())) {
            throw new PermissionException(session.getUsername(), FOLDER + folderId, Permission.DELETE);
        }
        FolderHistory transaction = new FolderHistory();
        transaction.setSession(session);
        transaction.setEvent(FolderEvent.DELETED);
        dao.deleteTree(folderId, 1, transaction);
    }

    public GUIFolder fromFolder(Folder folder, boolean computePath) throws PersistenceException {
        FolderDAO dao = Context.get(FolderDAO.class);
        dao.initialize(folder);
        GUIFolder guiFolder = new GUIFolder();
        guiFolder.setId(folder.getId());
        guiFolder.setName(folder.getId() != 5L ? folder.getName() : "/");
        guiFolder.setParentId(folder.getParentId());
        guiFolder.setDescription(folder.getDescription());
        guiFolder.setCreation(folder.getCreation());
        guiFolder.setCreator(folder.getCreator());
        guiFolder.setCreatorId(folder.getCreatorId());
        guiFolder.setType(folder.getType());
        guiFolder.setPosition(folder.getPosition());
        guiFolder.setQuotaDocs(folder.getQuotaDocs());
        guiFolder.setQuotaSize(folder.getQuotaSize());
        guiFolder.setFoldRef(folder.getFoldRef());
        guiFolder.setStore(folder.getStore());
        guiFolder.setMaxVersions(folder.getMaxVersions());
        guiFolder.setColor(folder.getColor());
        guiFolder.setTile(folder.getTile());
        guiFolder.setGrid(folder.getGrid());
        guiFolder.setQuotaThreshold(folder.getQuotaThreshold());
        guiFolder.setQuotaAlertRecipients(folder.getQuotaAlertRecipientsAsList());
        guiFolder.setOcrTemplateId(folder.getOcrTemplateId());
        guiFolder.setBarcodeTemplateId(folder.getBarcodeTemplateId());
        if (computePath) {
            guiFolder.setPathExtended(dao.computePathExtended(folder.getId()));
        }
        if (guiFolder.isWorkspace()) {
            SequenceDAO seqDao = Context.get(SequenceDAO.class);
            guiFolder.setDocumentsTotal(seqDao.getCurrentValue("wsdocs", folder.getId(), folder.getTenantId()));
            guiFolder.setSizeTotal(seqDao.getCurrentValue("wssize", folder.getId(), folder.getTenantId()));
        }
        if (folder.getSecurityRef() != null) {
            GUIFolder secRef = new GUIFolder();
            secRef.setId(folder.getSecurityRef().longValue());
            if (computePath) {
                secRef.setPathExtended(dao.computePathExtended(folder.getSecurityRef()));
            }
            guiFolder.setSecurityRef(secRef);
        }
        if (folder.getTemplate() != null) {
            guiFolder.setTemplateId(Long.valueOf(folder.getTemplate().getId()));
            guiFolder.setTemplate(folder.getTemplate().getName());
            guiFolder.setTemplateLocked(folder.getTemplateLocked());
            guiFolder.setAttributes(this.prepareGUIAttributes(folder.getTemplate(), folder));
        }
        guiFolder.setTags(new ArrayList<String>(folder.getTagsAsWords()));
        guiFolder.setColor(folder.getColor());
        return guiFolder;
    }

    public List<Long> computeStats(long folderId) throws ServerException {
        Session session = this.validateSession();
        try {
            long[] docs = FolderServiceImpl.countDocsInTree(folderId);
            return Arrays.asList(docs[0], FolderServiceImpl.countSubfoldersInTree(folderId), docs[1]);
        }
        catch (PersistenceException e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    private static long[] countDocsInTree(long folderId) throws PersistenceException {
        FolderDAO dao = Context.get(FolderDAO.class);
        Folder root = (Folder)dao.findById(folderId);
        String pathPrefix = root.getPath();
        long[] stats = new long[2];
        dao.queryForResultSet("select count(D.ld_id), sum(D.ld_filesize) from ld_document D, ld_folder F where D.ld_deleted=0 and F.ld_deleted=0 and D.ld_folderid=F.ld_id and (F.ld_id=" + folderId + " or F.ld_path like '" + pathPrefix + "/%')  and not ld_status=" + DocumentStatus.ARCHIVED.ordinal(), null, null, rows -> {
            if (rows.next()) {
                lArray[0] = rows.getLong(1);
                lArray[1] = rows.getLong(2);
            }
        });
        return stats;
    }

    private static long countSubfoldersInTree(long folderId) throws PersistenceException {
        FolderDAO dao = Context.get(FolderDAO.class);
        Folder root = (Folder)dao.findById(folderId);
        String pathPrefix = root.getPath();
        return dao.queryForLong("select count(ld_id) from ld_folder where ld_deleted=0 and (ld_parentid=" + folderId + " or ld_path like '" + pathPrefix + "/%')");
    }

    private static int countDirectDocs(long folderId) throws PersistenceException {
        FolderDAO dao = Context.get(FolderDAO.class);
        return dao.queryForInt("select count(ld_id) from ld_document where ld_deleted=0 and ld_folderid=" + folderId + " and not ld_status=" + DocumentStatus.ARCHIVED.ordinal());
    }

    private static int countDirectSubfolders(long folderId) throws PersistenceException {
        int count = 0;
        FolderDAO dao = Context.get(FolderDAO.class);
        count = dao.queryForInt("select count(ld_id) from ld_folder where not ld_id=ld_parentid and ld_deleted=0 and ld_parentid=" + folderId);
        return count;
    }

    public GUIFolder getFolder(Session session, long folderId) throws ServerException {
        return this.getFolder(session, folderId, false);
    }

    public GUIFolder getFolder(Session session, long folderId, boolean computePath) throws ServerException {
        if (session != null) {
            this.validateSession(session.getSid());
        }
        FolderDAO dao = Context.get(FolderDAO.class);
        try {
            Folder f;
            if (session != null) {
                this.checkPermission(Permission.READ, session.getUser(), folderId);
            }
            Folder folder = null;
            Folder test = (Folder)dao.findById(folderId);
            if (test == null) {
                throw new ServerException("Unexisting folder " + folderId);
            }
            dao.initialize(test);
            GUIFolder guiFolder = null;
            if (test.getFoldRef() != null) {
                folder = (Folder)dao.findById(test.getFoldRef());
                dao.initialize(folder);
                guiFolder = this.fromFolder(folder, computePath);
                guiFolder.setName(test.getName());
                guiFolder.setDescription(test.getDescription());
                guiFolder.setColor(test.getColor());
                guiFolder.setTile(test.getTile());
                guiFolder.setPosition(test.getPosition());
                guiFolder.setFoldRef(test.getFoldRef());
                guiFolder.setId(test.getId());
                guiFolder.setType(2);
                this.setSecurityRef(session, test, guiFolder);
            } else {
                folder = test;
                guiFolder = this.fromFolder(folder, computePath);
            }
            FolderServiceImpl.setAllowedPermissions(session, folderId, guiFolder);
            Folder securityRef = folder;
            if (test.getSecurityRef() != null && (f = (Folder)dao.findById(test.getSecurityRef())) != null) {
                securityRef = f;
            }
            dao.initialize(securityRef);
            FolderServiceImpl.setACL(securityRef, guiFolder);
            return guiFolder;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private void setSecurityRef(Session session, Folder test, GUIFolder guiFolder) throws ServerException {
        if (test.getSecurityRef() != null) {
            guiFolder.setSecurityRef(this.getFolder(session, test.getSecurityRef()));
        } else {
            guiFolder.setSecurityRef(null);
        }
    }

    private static void setACL(Folder securityRef, GUIFolder guiFolder) {
        ArrayList<GUIAccessControlEntry> acl = new ArrayList<GUIAccessControlEntry>();
        if (securityRef != null && securityRef.getAccessControlList() != null) {
            for (FolderAccessControlEntry ace : securityRef.getAccessControlList()) {
                GUIAccessControlEntry guiAce = new GUIAccessControlEntry();
                guiAce.setEntityId(ace.getGroupId());
                guiAce.setAdd(ace.getAdd() == 1);
                guiAce.setWrite(ace.getWrite() == 1);
                guiAce.setCustomid(ace.getCustomid() == 1);
                guiAce.setRevision(ace.getRevision() == 1);
                guiAce.setSecurity(ace.getSecurity() == 1);
                guiAce.setImmutable(ace.getImmutable() == 1);
                guiAce.setDelete(ace.getDelete() == 1);
                guiAce.setRename(ace.getRename() == 1);
                guiAce.setImport(ace.getImport() == 1);
                guiAce.setExport(ace.getExport() == 1);
                guiAce.setSign(ace.getSign() == 1);
                guiAce.setArchive(ace.getArchive() == 1);
                guiAce.setWorkflow(ace.getWorkflow() == 1);
                guiAce.setDownload(ace.getDownload() == 1);
                guiAce.setCalendar(ace.getCalendar() == 1);
                guiAce.setSubscription(ace.getSubscription() == 1);
                guiAce.setPassword(ace.getPassword() == 1);
                guiAce.setMove(ace.getMove() == 1);
                guiAce.setEmail(ace.getEmail() == 1);
                guiAce.setAutomation(ace.getAutomation() == 1);
                guiAce.setStore(ace.getStore() == 1);
                acl.add(guiAce);
            }
        }
        guiFolder.setAccessControlList(acl);
    }

    private static void setAllowedPermissions(Session session, long folderId, GUIFolder guiFolder) throws PersistenceException {
        if (session != null) {
            FolderDAO dao = Context.get(FolderDAO.class);
            Set<Permission> permissions = dao.getAllowedPermissions(folderId, session.getUserId());
            guiFolder.setAllowedPermissions(new GUIAccessControlEntry(permissions.stream().map(p -> p.name().toLowerCase()).toList().toArray(new String[0])));
        }
    }

    public GUIFolder getFolder(long folderId, boolean computePath, boolean computeDocs, boolean computeSubfolders) throws ServerException {
        Session session = this.validateSession();
        GUIFolder folder = this.getFolder(session, folderId);
        if (folder == null) {
            return null;
        }
        try {
            if (computeDocs) {
                folder.setDocumentCount((long)FolderServiceImpl.countDirectDocs(folder.getId()));
            }
            if (computeSubfolders) {
                folder.setSubfolderCount((long)FolderServiceImpl.countDirectSubfolders(folder.getId()));
            }
            if (computePath) {
                folder.setPath(this.computePath(folderId, session.getTenantId(), computeSubfolders));
            }
            return folder;
        }
        catch (PersistenceException e) {
            return (GUIFolder)this.throwServerException(session, log, e);
        }
    }

    private List<GUIFolder> computePath(long folderId, long tenantId, boolean computeSubfolders) throws PersistenceException, ServerException {
        FolderDAO dao = Context.get(FolderDAO.class);
        String pathExtended = dao.computePathExtended(folderId);
        StringTokenizer st = new StringTokenizer(pathExtended, "/", false);
        ArrayList<GUIFolder> path = new ArrayList<GUIFolder>();
        Folder parent = dao.findRoot(tenantId);
        while (st.hasMoreTokens()) {
            String text = st.nextToken();
            List<Folder> list = dao.findByName(parent, text, null, true);
            if (list.isEmpty()) {
                return path;
            }
            if (parent.getId() == 5L || parent.getId() == parent.getParentId()) {
                GUIFolder f = new GUIFolder(parent.getId());
                f.setName("/");
                f.setParentId(parent.getId());
                if (computeSubfolders) {
                    f.setSubfolderCount((long)FolderServiceImpl.countDirectSubfolders(f.getId()));
                }
                path.add(f);
            } else {
                path.add(this.getFolder(parent.getId(), false, false, computeSubfolders));
            }
            parent = list.get(0);
        }
        return path;
    }

    public void copyFolders(List<Long> folderIds, long targetId, boolean foldersOnly, String securityOption, GUIFolder model) throws ServerException {
        Session session = this.validateSession();
        try {
            for (long folderId : folderIds) {
                this.copyFolder(session, folderId, targetId, foldersOnly, securityOption, model);
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    private void copyFolder(Session session, long folderId, long targetId, boolean foldersOnly, String securityOption, GUIFolder model) throws PersistenceException, ServerException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folderToCopy = (Folder)folderDao.findById(folderId);
        Folder destParentFolder = folderDao.findFolder(targetId);
        if (targetId == 0L || folderDao.isInPath(folderToCopy.getId(), destParentFolder.getId())) {
            return;
        }
        folderDao.initialize(folderToCopy);
        if (destParentFolder.getId() == folderToCopy.getParentId()) {
            throw new SecurityException("No Changes");
        }
        if (destParentFolder.getId() == folderToCopy.getId()) {
            throw new SecurityException("Not Allowed");
        }
        boolean addchildEnabled = folderDao.isPermissionAllowed(Permission.ADD, destParentFolder.getId(), session.getUserId());
        if (!addchildEnabled) {
            throw new SecurityException("Add Child body not granted to this user in the target folder");
        }
        FolderHistory transaction = new FolderHistory();
        transaction.setSession(session);
        String modelName = model == null ? null : model.getName();
        Folder createdFolder = folderDao.copy(folderToCopy, destParentFolder, modelName, foldersOnly, securityOption, transaction);
        if (model != null) {
            model.setId(createdFolder.getId());
            folderDao.initialize(createdFolder);
            this.save(model);
        }
    }

    public void move(List<Long> folderIds, long targetId) throws ServerException {
        Session session = this.validateSession();
        try {
            for (long folderId : folderIds) {
                this.move(session, folderId, targetId);
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    private void move(Session session, long folderId, long targetId) throws PersistenceException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folderToMove = (Folder)folderDao.findById(folderId);
        if (targetId == 0L || folderDao.isInPath(folderToMove.getId(), targetId)) {
            return;
        }
        Folder destParentFolder = folderDao.findFolder(targetId);
        if (targetId == folderToMove.getParentId()) {
            throw new SecurityException("No Changes");
        }
        if (targetId == folderToMove.getId()) {
            throw new SecurityException("Not Allowed");
        }
        Folder sourceParent = (Folder)folderDao.findById(folderToMove.getParentId());
        boolean sourceParentMoveEnabled = folderDao.isPermissionAllowed(Permission.MOVE, sourceParent.getId(), session.getUserId());
        if (!sourceParentMoveEnabled) {
            throw new SecurityException(String.format("User %s has not the MOVE permission on folder %s", session.getUsername(), sourceParent.getName()));
        }
        boolean addchildEnabled = folderDao.isPermissionAllowed(Permission.ADD, destParentFolder.getId(), session.getUserId());
        if (!addchildEnabled) {
            throw new SecurityException(String.format("User %s has not the ADD CHILD permission on folder %s", session.getUsername(), sourceParent.getName()));
        }
        FolderHistory transaction = new FolderHistory();
        transaction.setSession(session);
        folderDao.move(folderToMove, destParentFolder, transaction);
    }

    public void rename(long folderId, String name) throws ServerException {
        Session session = this.validateSession();
        FolderDAO dao = Context.get(FolderDAO.class);
        try {
            List<Folder> folders = dao.findByNameAndParentId(name, ((Folder)dao.findById(folderId)).getParentId());
            if (!folders.isEmpty() && folders.get(0).getId() != folderId) {
                return;
            }
            Folder folder = (Folder)dao.findById(folderId);
            dao.initialize(folder);
            FolderHistory history = new FolderHistory();
            history.setFilenameOld(folder.getName());
            history.setPathOld(dao.computePathExtended(folderId));
            history.setEvent(FolderEvent.RENAMED);
            history.setSession(session);
            folder.setName(name.trim());
            dao.store(folder, history);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public GUIFolder save(GUIFolder guiFolder) throws ServerException {
        Session session = this.validateSession();
        FolderDAO folderDao = Context.get(FolderDAO.class);
        try {
            Folder folder = (Folder)folderDao.findById(guiFolder.getId());
            folderDao.initialize(folder);
            FolderHistory saveTransaction = new FolderHistory();
            saveTransaction.setSession(session);
            FolderHistory renameTransaction = null;
            String folderName = guiFolder.getName().replace("/", "");
            if (guiFolder.getFoldRef() != null) {
                folder.setName(folderName);
                folder.setPosition(guiFolder.getPosition());
                folder.setColor(guiFolder.getColor());
                folderDao.store(folder);
                folder = (Folder)folderDao.findById(guiFolder.getFoldRef());
                folderDao.initialize(folder);
            } else {
                folder.setType(guiFolder.getType());
                folder.setStore(guiFolder.getStore());
                folder.setPosition(guiFolder.getPosition());
                folder.setColor(guiFolder.getColor());
                if (folder.isWorkspace()) {
                    folder.setMaxVersions(guiFolder.getMaxVersions());
                }
                saveTransaction.setEvent(FolderEvent.CHANGED);
                if (!folder.getName().trim().equals(folderName)) {
                    folder.setName(folderName.trim());
                    renameTransaction = new FolderHistory();
                    renameTransaction.setEvent(FolderEvent.RENAMED);
                    renameTransaction.setFilenameOld(folder.getName());
                    renameTransaction.setPathOld(folderDao.computePathExtended(folder.getId()));
                    renameTransaction.setSession(session);
                    renameTransaction.setNotifyEvent(true);
                }
                folder.setName(folderName);
            }
            folder.setDescription(guiFolder.getDescription());
            folder.setTile(guiFolder.getTile());
            folder.setTemplateLocked(guiFolder.getTemplateLocked());
            folder.setQuotaDocs(guiFolder.getQuotaDocs());
            folder.setQuotaSize(guiFolder.getQuotaSize());
            folder.setQuotaThreshold(guiFolder.getQuotaThreshold());
            folder.setQuotaAlertRecipients(guiFolder.getQuotaAlertRecipientsAsString());
            folder.setGrid(guiFolder.getGrid());
            folder.setOcrTemplateId(guiFolder.getOcrTemplateId());
            folder.setBarcodeTemplateId(guiFolder.getBarcodeTemplateId());
            this.updateExtendedAttributes(folder, guiFolder);
            if (!guiFolder.getTags().isEmpty()) {
                folder.setTagsFromWords(new HashSet<String>(guiFolder.getTags()));
            } else {
                folder.getTags().clear();
            }
            folderDao.store(folder, saveTransaction);
            if (renameTransaction != null) {
                folderDao.saveFolderHistory(folder, renameTransaction);
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
        return this.getFolder(session, guiFolder.getId());
    }

    public GUIFolder create(GUIFolder newFolder, boolean inheritSecurity) throws ServerException {
        Session session = this.validateSession();
        FolderDAO folderDao = Context.get(FolderDAO.class);
        String folderName = newFolder.getName().replace("/", "");
        FolderHistory transaction = new FolderHistory();
        transaction.setSession(session);
        transaction.setEvent(FolderEvent.CREATED);
        Folder folderVO = new Folder();
        folderVO.setName(folderName);
        folderVO.setType(newFolder.getType());
        folderVO.setTenantId(session.getTenantId());
        Folder root = null;
        try {
            root = folderDao.findRoot(session.getTenantId());
        }
        catch (PersistenceException e) {
            return (GUIFolder)this.throwServerException(session, log, e);
        }
        if (newFolder.getType() == 1) {
            newFolder.setParentId(root.getId());
        }
        Folder f = null;
        try {
            Folder parent = (Folder)folderDao.findById(newFolder.getParentId());
            if (parent.getFoldRef() != null) {
                folderVO.setParentId(parent.getFoldRef());
            }
            f = newFolder.getType() == 1 ? folderDao.create(root, folderVO, inheritSecurity, transaction) : folderDao.create((Folder)folderDao.findById(newFolder.getParentId()), folderVO, inheritSecurity, transaction);
        }
        catch (PersistenceException e) {
            return (GUIFolder)this.throwServerException(session, log, e);
        }
        if (f == null) {
            throw new ServerException("Folder not stored");
        }
        return this.getFolder(session, f.getId());
    }

    public GUIFolder createAlias(long parentId, long foldRef) throws ServerException {
        Folder f;
        Session session = this.validateSession();
        FolderDAO folderDao = Context.get(FolderDAO.class);
        FolderHistory transaction = new FolderHistory();
        transaction.setSession(session);
        transaction.setEvent(FolderEvent.CREATED);
        try {
            f = folderDao.createAlias(parentId, foldRef, transaction);
        }
        catch (PersistenceException e) {
            return (GUIFolder)this.throwServerException(session, log, e);
        }
        return this.getFolder(session, f.getId());
    }

    private int booleanToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    private void saveACL(Session session, Folder folder, List<GUIAccessControlEntry> acl) throws PersistenceException {
        FolderDAO fdao = Context.get(FolderDAO.class);
        log.info("Applying {} aces to folder {}", (Object)acl.size(), (Object)folder.getId());
        folder.setSecurityRef(null);
        HashSet<FolderAccessControlEntry> grps = new HashSet<FolderAccessControlEntry>();
        for (GUIAccessControlEntry ace : acl) {
            FolderAccessControlEntry fg = new FolderAccessControlEntry();
            fg.setGroupId(ace.getEntityId());
            grps.add(fg);
            fg.setRead(this.booleanToInt(ace.isRead()));
            fg.setPreview(this.booleanToInt(ace.isPreview()));
            fg.setPrint(this.booleanToInt(ace.isPrint()));
            fg.setWrite(this.booleanToInt(ace.isWrite()));
            fg.setAdd(this.booleanToInt(ace.isAdd()));
            fg.setSecurity(this.booleanToInt(ace.isSecurity()));
            fg.setImmutable(this.booleanToInt(ace.isImmutable()));
            fg.setDelete(this.booleanToInt(ace.isDelete()));
            fg.setRename(this.booleanToInt(ace.isRename()));
            fg.setImport(this.booleanToInt(ace.isImport()));
            fg.setExport(this.booleanToInt(ace.isExport()));
            fg.setArchive(this.booleanToInt(ace.isArchive()));
            fg.setWorkflow(this.booleanToInt(ace.isWorkflow()));
            fg.setSign(this.booleanToInt(ace.isSign()));
            fg.setDownload(this.booleanToInt(ace.isDownload()));
            fg.setCalendar(this.booleanToInt(ace.isCalendar()));
            fg.setSubscription(this.booleanToInt(ace.isSubscription()));
            fg.setPassword(this.booleanToInt(ace.isPassword()));
            fg.setMove(this.booleanToInt(ace.isMove()));
            fg.setEmail(this.booleanToInt(ace.isEmail()));
            fg.setAutomation(this.booleanToInt(ace.isAutomation()));
            fg.setStore(this.booleanToInt(ace.isStore()));
            fg.setReadingreq(this.booleanToInt(ace.isReadingreq()));
            fg.setCustomid(this.booleanToInt(ace.isCustomid()));
            fg.setRevision(this.booleanToInt(ace.isRevision()));
        }
        folder.getAccessControlList().clear();
        folder.getAccessControlList().addAll(grps);
        FolderHistory history = new FolderHistory();
        history.setEvent(FolderEvent.PERMISSION);
        history.setSession(session);
        fdao.store(folder, history);
    }

    public void paste(List<Long> docIds, long folderId, String action, boolean links, boolean notes, boolean security) throws ServerException {
        Session session = this.validateSession();
        FolderDAO fdao = Context.get(FolderDAO.class);
        try {
            Folder folder = fdao.findFolder(folderId);
            if (!fdao.isWriteAllowed(folder.getId(), session.getUserId())) {
                throw new ServerException("Cannot write in folder " + folder.getName());
            }
            if (action.equals("cut")) {
                this.cut(session, docIds, folder.getId());
            } else if (action.equals("copy")) {
                this.copy(session, docIds, folder.getId(), links, notes, security);
            }
        }
        catch (PersistenceException e) {
            log.error("Exception moving documents", e);
            this.throwServerException(session, null, e);
        }
    }

    private void cut(Session session, List<Long> docIds, long folderId) throws ServerException {
        DocumentManager docManager = Context.get(DocumentManager.class);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Folder selectedFolderFolder = (Folder)folderDao.findById(folderId);
            for (long id : docIds) {
                Document doc = (Document)docDao.findById(id);
                this.checkPermission(Permission.MOVE, session.getUser(), doc.getFolder().getId());
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                if (doc.getDocRef() != null) {
                    if (doc.getFolder().getId() == selectedFolderFolder.getId()) continue;
                    transaction.setEvent(DocumentEvent.SHORTCUT_MOVED);
                    docManager.moveToFolder(doc, selectedFolderFolder, transaction);
                }
                this.checkImmutable(doc);
                this.checkLocked(doc);
                docManager.moveToFolder(doc, selectedFolderFolder, transaction);
            }
        }
        catch (PersistenceException | PermissionException e) {
            log.error("Exception moving documents", e);
            this.throwServerException(session, null, e);
        }
    }

    private void checkLocked(Document doc) throws PermissionException {
        if (doc.getStatus() != DocumentStatus.UNLOCKED || doc.getExportStatus() != 0) {
            throw new PermissionException("Document " + doc.getId() + " is locked");
        }
    }

    private void checkImmutable(Document doc) throws PermissionException {
        if (doc.getImmutable() == 1) {
            throw new PermissionException("Document " + doc.getId() + " is immutable");
        }
    }

    private void copy(Session session, List<Long> docIds, long folderId, boolean links, boolean notes, boolean security) throws ServerException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        DocumentManager docManager = Context.get(DocumentManager.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Folder selectedFolderFolder = (Folder)folderDao.findById(folderId);
            for (long id : docIds) {
                Document doc = (Document)docDao.findById(id);
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                transaction.setEvent(DocumentEvent.STORED);
                transaction.setComment("");
                if (doc.getDocRef() == null) {
                    docManager.copyToFolder(doc, selectedFolderFolder, transaction, links, notes, security);
                    continue;
                }
                if (doc.getFolder().getId() == selectedFolderFolder.getId()) continue;
                transaction.setEvent(DocumentEvent.SHORTCUT_STORED);
                docManager.copyToFolder(doc, selectedFolderFolder, transaction, false, false, false);
            }
        }
        catch (PersistenceException | IOException e) {
            log.error("Exception copying documents", e);
            this.throwServerException(session, null, e);
        }
    }

    public void pasteAsAlias(List<Long> docIds, long folderId, String type) throws ServerException {
        Session session = this.validateSession();
        FolderDAO folderDao = Context.get(FolderDAO.class);
        DocumentManager docManager = Context.get(DocumentManager.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Folder selectedFolderFolder = folderDao.findFolder(folderId);
            for (long id : docIds) {
                Document doc = (Document)docDao.findById(id);
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                transaction.setEvent(DocumentEvent.SHORTCUT_STORED);
                transaction.setComment("");
                if (doc.getFolder().getId() == selectedFolderFolder.getId()) continue;
                docManager.createAlias(doc, selectedFolderFolder, StringUtils.isNotEmpty(type) ? type : null, transaction);
            }
        }
        catch (PersistenceException e) {
            log.error("Exception copying documents alias", e);
            this.throwServerException(session, null, e);
        }
    }

    public List<GUIValue> loadTemplates() throws ServerException {
        return new ArrayList<GUIValue>();
    }

    public void saveTemplates(List<GUIValue> templates) throws ServerException {
    }

    public void applyTemplate(long folderId, long templateId, boolean inheritSecurity) throws ServerException {
    }

    private void updateExtendedAttributes(Folder folder, GUIFolder f) throws PersistenceException {
        if (f.getTemplateId() == null) {
            folder.setTemplate(null);
            folder.getAttributes().clear();
            return;
        }
        TemplateDAO templateDao = Context.get(TemplateDAO.class);
        Template template = (Template)templateDao.findById(f.getTemplateId());
        templateDao.initialize(template);
        folder.setTemplate(template);
        folder.setTemplateLocked(f.getTemplateLocked());
        folder.getAttributes().clear();
        for (GUIAttribute guiAttribute : f.getAttributes()) {
            Attribute templateAttribute = template.getAttributes().get(guiAttribute.getParent() != null ? guiAttribute.getParent() : guiAttribute.getName());
            if (templateAttribute == null) continue;
            Attribute extAttr = this.newAttribute(guiAttribute, templateAttribute);
            folder.getAttributes().put(guiAttribute.getName(), extAttr);
        }
    }

    private Attribute newAttribute(GUIAttribute guiAttribute, Attribute templateAttribute) {
        Attribute extAttr = new Attribute();
        int extAttrType = guiAttribute.getType();
        int currentTemplateExtAttrType = templateAttribute.getType();
        if (currentTemplateExtAttrType != extAttrType) {
            if (guiAttribute.getValue().toString().trim().isEmpty() && currentTemplateExtAttrType != 0) {
                extAttr.setValue(null);
            } else {
                switch (currentTemplateExtAttrType) {
                    case 2: {
                        extAttr.setValue(Double.parseDouble(guiAttribute.getValue().toString()));
                        break;
                    }
                    case 1: {
                        extAttr.setValue(Long.parseLong(guiAttribute.getValue().toString()));
                        break;
                    }
                    case 5: {
                        extAttr.setValue(guiAttribute.getBooleanValue());
                        extAttr.setType(5);
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 7: {
                        extAttr.setIntValue(guiAttribute.getIntValue());
                        extAttr.setStringValue(guiAttribute.getStringValue());
                        break;
                    }
                    default: {
                        extAttr.setStringValue(guiAttribute.getStringValue());
                        break;
                    }
                }
            }
        } else {
            switch (currentTemplateExtAttrType) {
                case 4: 
                case 6: 
                case 7: {
                    if (guiAttribute.getValue() != null) {
                        extAttr.setStringValue(guiAttribute.getStringValue());
                        extAttr.setIntValue(guiAttribute.getIntValue());
                        break;
                    }
                    extAttr.setStringValue(null);
                    extAttr.setIntValue(null);
                    break;
                }
                case 5: {
                    extAttr.setValue(guiAttribute.getBooleanValue());
                    break;
                }
                case 3: {
                    extAttr.setValue(FolderServiceImpl.fixDateForGUI(guiAttribute.getDateValue()));
                    break;
                }
                default: {
                    extAttr.setValue(guiAttribute.getValue());
                }
            }
        }
        extAttr.setType(currentTemplateExtAttrType);
        extAttr.setParent(guiAttribute.getParent());
        extAttr.setDependsOn(guiAttribute.getDependsOn());
        extAttr.setLabel(templateAttribute.getLabel());
        extAttr.setPosition(templateAttribute.getPosition());
        extAttr.setMandatory(templateAttribute.getMandatory());
        extAttr.setHidden(templateAttribute.getHidden());
        extAttr.setMultiple(templateAttribute.getMultiple());
        return extAttr;
    }

    public void restore(List<Long> folderIds, long parentId) throws ServerException {
        Session session = this.validateSession();
        FolderDAO dao = Context.get(FolderDAO.class);
        for (Long foldId : folderIds) {
            if (foldId == null) continue;
            FolderHistory transaction = new FolderHistory();
            transaction.setSession(session);
            try {
                dao.restore(foldId, parentId, transaction);
            }
            catch (PersistenceException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    public void deleteFromTrash(List<Long> ids) throws ServerException {
        Session session = this.validateSession();
        if (ids.isEmpty()) {
            return;
        }
        try {
            Context.get(FolderDAO.class).jdbcUpdate("update ld_folder set ld_deleted=2 where ld_id in (" + ids.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")) + ")");
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void applyTags(long parentId) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Apply Tags", () -> {
            FolderDAO fdao = Context.get(FolderDAO.class);
            FolderHistory transaction = new FolderHistory();
            transaction.setSession(session);
            try {
                fdao.applyTagsToTree(parentId, transaction);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    public void setFolderPagination(long folderId, Integer startRecord, Integer pageSize) throws ServerException {
        Session session = this.validateSession();
        if (pageSize != null && startRecord != null) {
            session.getDictionary().put("ld-folder-page-size:" + folderId, pageSize);
            session.getDictionary().put("ld-folder-start-gridRecord:" + folderId, startRecord);
        } else {
            session.getDictionary().remove("ld-folder-page-size:" + folderId);
            session.getDictionary().remove("ld-folder-start-gridRecord:" + folderId);
        }
    }

    public void applyGridLayout(long folderId) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Apply Grid Layout", () -> {
            FolderHistory history = new FolderHistory();
            history.setSession(session);
            FolderDAO fdao = Context.get(FolderDAO.class);
            try {
                fdao.applyGridToTree(folderId, history);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    public void applyOCR(long parentId) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Apply OCR", () -> {
            FolderDAO fdao = Context.get(FolderDAO.class);
            FolderHistory transaction = new FolderHistory();
            transaction.setSession(session);
            try {
                fdao.applyOCRToTree(parentId, transaction);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    public void applyStore(long parentId) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Apply Store", () -> {
            try {
                this.checkPermission(Permission.STORE, session.getUser(), parentId);
                FolderDAO fdao = Context.get(FolderDAO.class);
                FolderHistory transaction = new FolderHistory();
                transaction.setSession(session);
                fdao.applyStoreToTree(parentId, transaction);
            }
            catch (PersistenceException | AccessDeniedException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    public void merge(List<Long> folderIds, long targetId) throws ServerException {
        Session session = this.validateSession();
        this.checkPermission(Permission.ADD, session.getUser(), targetId);
        this.checkPermission(Permission.WRITE, session.getUser(), targetId);
        this.checkPermission(Permission.DELETE, session.getUser(), targetId);
        this.executeLongRunningOperation("Merge", () -> {
            try {
                FolderDAO fDao = Context.get(FolderDAO.class);
                Folder target = fDao.findFolder(targetId);
                fDao.initialize(target);
                FolderHistory transaction = new FolderHistory();
                transaction.setSession(session);
                Iterator iterator = folderIds.iterator();
                while (iterator.hasNext()) {
                    long sourceId = (Long)iterator.next();
                    Folder source = (Folder)fDao.findById(sourceId);
                    fDao.merge(source, target, transaction);
                }
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    public String readImage() throws ServerException {
        Session session = this.validateSession();
        List<String> allowedExts = Arrays.asList("png", "gif", "jpg", "jpeg", "webp", "jfif", "svg");
        Map<String, File> uploadedFilesMap = this.getUploadedFiles(session.getSid());
        for (Map.Entry<String, File> entry : uploadedFilesMap.entrySet()) {
            String ext = FileUtil.getExtension(entry.getKey()).toLowerCase();
            if (!allowedExts.contains(ext)) continue;
            StringBuilder sb = new StringBuilder("data:image/");
            sb.append(ext.equals("svg") ? "svg+xml" : ext);
            sb.append(";base64,");
            try {
                sb.append(Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray(entry.getValue())));
            }
            catch (IOException e) {
                this.throwServerException(session, log, e);
            }
            return sb.toString();
        }
        throw new ServerException(I18N.message("unsupportedformat", session.getUser().getLocale()));
    }

    public GUIAccessControlEntry getAllowedPermissions(List<Long> folderIds) throws ServerException {
        Session session = this.validateSession();
        try {
            Set<Permission> commonPermissions = Permission.all();
            if (!session.getUser().isAdmin()) {
                FolderDAO folderDao = Context.get(FolderDAO.class);
                for (long folderId : folderIds) {
                    Set<Permission> folderPermissions = folderDao.getAllowedPermissions(folderId, session.getUserId());
                    for (Permission permission : Permission.all()) {
                        if (folderPermissions.contains((Object)permission)) continue;
                        commonPermissions.remove((Object)permission);
                    }
                }
            }
            return new GUIAccessControlEntry(commonPermissions.stream().map(p -> p.name().toLowerCase()).collect(Collectors.toSet()).toArray(new String[0]));
        }
        catch (PersistenceException e) {
            return (GUIAccessControlEntry)this.throwServerException(session, log, e);
        }
    }
}

