/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.automation.Automation;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailAttachment;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.MailUtil;
import com.logicaldoc.core.communication.MessageTemplate;
import com.logicaldoc.core.communication.MessageTemplateDAO;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.contact.Contact;
import com.logicaldoc.core.contact.ContactDAO;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Bookmark;
import com.logicaldoc.core.document.BookmarkDAO;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentAccessControlEntry;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentFuture;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.document.DocumentLink;
import com.logicaldoc.core.document.DocumentLinkDAO;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.document.Rating;
import com.logicaldoc.core.document.RatingDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.document.thumbnail.ThumbnailManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.imaging.ImageUtil;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.metadata.validation.Validator;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.ticket.Ticket;
import com.logicaldoc.core.ticket.TicketDAO;
import com.logicaldoc.core.transfer.InMemoryZipImport;
import com.logicaldoc.core.transfer.ZipExport;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.gui.common.client.AccessDeniedException;
import com.logicaldoc.gui.common.client.InvalidSessionServerException;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIAccessControlEntry;
import com.logicaldoc.gui.common.client.beans.GUIAttribute;
import com.logicaldoc.gui.common.client.beans.GUIBookmark;
import com.logicaldoc.gui.common.client.beans.GUIContact;
import com.logicaldoc.gui.common.client.beans.GUIDocument;
import com.logicaldoc.gui.common.client.beans.GUIDocumentNote;
import com.logicaldoc.gui.common.client.beans.GUIEmail;
import com.logicaldoc.gui.common.client.beans.GUIFolder;
import com.logicaldoc.gui.common.client.beans.GUIRating;
import com.logicaldoc.gui.common.client.beans.GUIVersion;
import com.logicaldoc.gui.frontend.client.services.DocumentService;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.MimeType;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.html.HTMLSanitizer;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.UploadServlet;
import com.logicaldoc.web.service.AbstractRemoteService;
import com.logicaldoc.web.service.FolderServiceImpl;
import com.logicaldoc.web.service.TemplateServiceImpl;
import com.logicaldoc.web.websockets.WebsocketTool;
import jakarta.mail.MessagingException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cms.CMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class DocumentServiceImpl
extends AbstractRemoteService
implements DocumentService {
    private static final String ERROR = "error";
    private static final String DOCUMENT_STR = "Document ";
    private static final String UNEXISTING_DOCUMENT = "Unexisting document";
    private static final String DOWNLOAD_TICKET = "downloadTicket";
    private static final String MESSAGE = "message";
    private static final String SMTP_USERASFROM = ".smtp.userasfrom";
    private static final String DOCUMENT = "document";
    private static final String OUTBOX = "outbox";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DocumentServiceImpl.class);
    private static EMailSender emailSender;

    public void addBookmarks(List<Long> ids, int type) throws ServerException {
        Session session = this.validateSession();
        BookmarkDAO bookmarkDao = Context.get(BookmarkDAO.class);
        FolderDAO fdao = Context.get(FolderDAO.class);
        DocumentDAO dao = Context.get(DocumentDAO.class);
        for (Long id : ids) {
            try {
                Bookmark bookmark = null;
                if (bookmarkDao.findByUserIdAndDocId(session.getUserId(), id) != null) continue;
                bookmark = new Bookmark();
                bookmark.setTenantId(session.getTenantId());
                bookmark.setType(type);
                bookmark.setTargetId(id);
                bookmark.setUserId(session.getUserId());
                if (type == 0) {
                    Document doc = (Document)dao.findById(id);
                    if (doc == null) {
                        throw new ServerException("Unexisting document " + String.valueOf(id));
                    }
                    bookmark.setTitle(doc.getFileName());
                    bookmark.setFileType(doc.getType());
                } else {
                    Folder f = (Folder)fdao.findById(id);
                    bookmark.setTitle(f.getName());
                }
                bookmarkDao.store(bookmark);
            }
            catch (PersistenceException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    private void index(Long[] docIds, Session session) throws PersistenceException, ParsingException {
        if (docIds == null || docIds.length < 1) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Indexing documents {}", (Object)Stream.of(docIds).map(id -> Long.toString(id)).collect(Collectors.joining(", ")));
        }
        DocumentManager documentManager = Context.get(DocumentManager.class);
        Long[] longArray = docIds;
        int n = docIds.length;
        int n2 = 0;
        while (n2 < n) {
            Long id2 = longArray[n2];
            if (id2 != null) {
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                documentManager.index(id2, null, transaction);
            }
            ++n2;
        }
    }

    public void indexDocuments(List<Long> docIds) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Index Documents", () -> {
            try {
                this.index(docIds.toArray(new Long[0]), session);
            }
            catch (PersistenceException | ParsingException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    private void indexAddedDocs(List<Long> docIdsToIndex, Session session) throws PersistenceException, ParsingException {
        if (!docIdsToIndex.isEmpty()) {
            this.index(docIdsToIndex.toArray(new Long[0]), session);
        }
    }

    public void destroyDocuments(List<Long> docIds) throws ServerException {
        Session session = this.validateSession();
        this.checkMenu(-9L);
        log.info("User {} requested the permanent deletion of docuemnts {}", (Object)session.getUsername(), (Object)docIds);
        DocumentManager manager = Context.get(DocumentManager.class);
        this.executeLongRunningOperation("Destroy Documents", () -> {
            try {
                for (Long docId : docIds) {
                    FolderHistory transaction = new FolderHistory();
                    transaction.setSession(session);
                    manager.destroyDocument(docId, transaction);
                }
            }
            catch (PersistenceException | PermissionException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    public List<GUIDocument> addDocuments(boolean importZip, String charset, boolean immediateIndexing, GUIDocument metadata) throws ServerException {
        Session session = this.validateSession();
        Map<String, File> uploadedFilesMap = this.getUploadedFiles(session.getSid());
        ArrayList<GUIDocument> createdDocs = new ArrayList<GUIDocument>();
        if (log.isDebugEnabled()) {
            log.debug("Uploading {} files", (Object)uploadedFilesMap.size());
        }
        if (uploadedFilesMap.isEmpty()) {
            throw new ServerException("No file uploaded");
        }
        if (this.executeLongRunningOperation("Add Documents", () -> {
            try {
                this.addDocuments(importZip, charset, immediateIndexing, metadata, session, createdDocs);
            }
            catch (PersistenceException | ParsingException | ServerException | IOException e) {
                log.error(e.getMessage(), e);
                new WebsocketTool().showMessage(session, e.getMessage(), ERROR);
            }
            return null;
        }, session)) {
            return createdDocs;
        }
        return new ArrayList<GUIDocument>();
    }

    private void addDocuments(boolean importZip, String charset, boolean immediateIndexing, GUIDocument metadata, Session session, List<GUIDocument> createdDocs) throws PersistenceException, ServerException, ParsingException, IOException, InterruptedException, ExecutionException {
        this.checkWritePermission(metadata, session);
        Map<String, File> uploadedFilesMap = this.getUploadedFiles(session.getSid());
        ArrayList<Document> docs = new ArrayList<Document>();
        DocumentManager documentManager = Context.get(DocumentManager.class);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder parent = folderDao.findFolder(metadata.getFolder().getId());
        ArrayList<Long> docIdsToIndex = new ArrayList<Long>();
        for (Map.Entry<String, File> entry : uploadedFilesMap.entrySet()) {
            String filename = entry.getKey();
            File file = entry.getValue();
            try {
                if (filename.toLowerCase().endsWith(".zip") && importZip) {
                    File tempZip = FileUtil.createTempFile("upload-", ".zip");
                    FileUtils.copyFile(file, tempZip);
                    Thread zipImporter = new Thread(() -> this.importZip(charset, metadata, session, parent, tempZip));
                    zipImporter.start();
                    continue;
                }
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                transaction.setEvent(DocumentEvent.STORED);
                transaction.setComment(HTMLSanitizer.sanitizeSimpleText(metadata.getComment()));
                Document doc = DocumentServiceImpl.toDocument(metadata);
                doc.setTenantId(session.getTenantId());
                doc.setCreation(new Date());
                doc.setFileName(filename);
                DocumentFuture elaboration = documentManager.create(file, doc, transaction);
                doc = (Document)elaboration.get();
                if (immediateIndexing && doc.getIndexed() == IndexingStatus.TO_INDEX) {
                    docIdsToIndex.add(doc.getId());
                }
                createdDocs.add(this.fromDocument(doc, metadata.getFolder(), null));
                docs.add(doc);
            }
            finally {
                FileUtil.delete(file);
            }
        }
        this.cleanUploadedFiles(session);
        this.indexAddedDocs(docIdsToIndex, session);
        this.notifyUsersInNewThread(docs, metadata, "newdoc", session);
    }

    private void checkWritePermission(GUIDocument metadata, Session session) throws PersistenceException, ServerException {
        FolderDAO fdao = Context.get(FolderDAO.class);
        if (!fdao.isWriteAllowed(metadata.getFolder().getId(), session.getUserId())) {
            throw new ServerException("The user doesn't have the write permission on the current folder");
        }
    }

    private void cleanUploadedFiles(Session session) {
        Map<String, File> uploadedFilesMap = this.getUploadedFiles(session.getSid());
        for (File uploadedEntry : uploadedFilesMap.values()) {
            FileUtil.delete(uploadedEntry);
        }
    }

    private void importZip(String charset, GUIDocument metadata, Session session, Folder parent, File zipFile) {
        try {
            try {
                log.debug("zip file = {}", (Object)zipFile);
                Document doc = DocumentServiceImpl.toDocument(metadata);
                doc.setTenantId(session.getTenantId());
                doc.setCreation(new Date());
                InMemoryZipImport importer = new InMemoryZipImport(doc, charset);
                importer.process(zipFile, parent, session.getUserId(), session.getSid());
            }
            catch (PersistenceException e) {
                log.error("Unable to delete temporary file", e);
                FileUtil.delete(zipFile);
            }
        }
        finally {
            FileUtil.delete(zipFile);
        }
    }

    private void notifyUsersInNewThread(List<Document> docs, GUIDocument metadata, String templateName, Session session) {
        if (!metadata.getNotifyUsers().isEmpty()) {
            new Thread(() -> this.notifyDocuments(docs, templateName, metadata.getNotifyMessage(), metadata.getNotifyUsers(), session)).start();
        }
    }

    public GUIDocument checkin(GUIDocument document, boolean major) throws ServerException {
        Document doc;
        Session session = this.validateSession();
        Map<String, File> uploadedFilesMap = this.getUploadedFiles(session.getSid());
        File file = uploadedFilesMap.values().iterator().next();
        String fileName = uploadedFilesMap.keySet().iterator().next();
        if (file == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Checking in file {}", (Object)fileName);
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setEvent(DocumentEvent.CHECKEDIN);
        transaction.setComment(HTMLSanitizer.sanitizeSimpleText(document.getComment()));
        try {
            doc = this.retrieveDocument(document.getId());
        }
        catch (PersistenceException e1) {
            return (GUIDocument)this.throwServerException(session, log, e1);
        }
        DocumentManager documentManager = Context.get(DocumentManager.class);
        try {
            Throwable throwable = null;
            Object var11_14 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                documentManager.checkin(doc.getId(), fis, fileName, major, DocumentServiceImpl.toDocument(document), transaction);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (PersistenceException | IOException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
        UploadServlet.cleanUploads(session.getSid());
        GUIDocument checkedInDocument = this.getById(doc.getId());
        this.notifyUsersInNewThread(Arrays.asList(doc), document, "checkin", session);
        return checkedInDocument;
    }

    private void notifyDocuments(List<Document> docs, String messageTemplate, String notificationMessage, List<Long> recipientIds, Session session) {
        String tile = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNk+M9QDwADhgGAWjR9awAAAABJRU5ErkJggg==";
        try {
            tile = this.prepareTileAsString(session, docs.get(0));
        }
        catch (Exception e) {
            log.warn("Cannot prepare the tile image", e);
        }
        try {
            SystemMessageDAO systemMessageDao = Context.get(SystemMessageDAO.class);
            HashMap<Locale, Set<Recipient>> emailRecipientsMap = new HashMap<Locale, Set<Recipient>>();
            HashMap<Locale, Set<Recipient>> systemRecipientsMap = new HashMap<Locale, Set<Recipient>>();
            this.prepareRecipients(recipientIds, emailRecipientsMap, systemRecipientsMap);
            for (Map.Entry entry : emailRecipientsMap.entrySet()) {
                Locale locale = (Locale)entry.getKey();
                Set recipients = (Set)entry.getValue();
                EMail mail = new EMail();
                mail.setHtml(1);
                mail.setTenantId(session.getTenantId());
                mail.setAccountId(-1L);
                mail.setAuthor(session.getUser().getUsername());
                ContextProperties config = Context.get().getProperties();
                if (config.getBoolean(session.getTenantName() + SMTP_USERASFROM, true)) {
                    mail.setAuthorAddress(session.getUser().getEmail());
                }
                mail.setFolder(OUTBOX);
                mail.setSentDate(new Date());
                mail.setUsername(session.getUsername());
                mail.setRecipients(recipients);
                MessageTemplateDAO tDao = Context.get(MessageTemplateDAO.class);
                MessageTemplate template = tDao.findByNameAndLanguage(messageTemplate, locale.toString(), mail.getTenantId());
                HashMap<String, Object> dictionary = new HashMap<String, Object>();
                dictionary.put("user", session.getUser());
                dictionary.put("creator", session.getUser());
                dictionary.put("documents", docs);
                dictionary.put(DOCUMENT, docs.get(0));
                dictionary.put(MESSAGE, notificationMessage);
                dictionary.put("locale", locale);
                dictionary.put("tile", tile);
                mail.setSubject(template.getFormattedSubject(dictionary));
                mail.setMessageText("<html><body>" + template.getFormattedBody(dictionary) + "</html></body>");
                if (mail != null && !mail.getRecipients().isEmpty()) {
                    log.info("Notify the new documents {} to {}", (Object)docs, (Object)mail.getRecipients());
                }
                DocumentServiceImpl.getEmailSender(session).send(mail);
                SystemMessage sys = new SystemMessage();
                sys.setType(0);
                sys.setAuthor(mail.getAuthor());
                sys.setSentDate(new Date());
                sys.setMessageText(mail.getMessageText());
                sys.setSubject(mail.getSubject());
                sys.setRecipients((Set)systemRecipientsMap.get(locale));
                sys.setHtml(1);
                sys.setTenantId(mail.getTenantId());
                systemMessageDao.store(sys);
            }
        }
        catch (PersistenceException | AutomationException | MessagingException e) {
            log.warn(e.getMessage(), e);
        }
    }

    private Document retrieveDocument(long docId) throws PersistenceException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        return dao.findDocument(docId);
    }

    private void prepareRecipients(List<Long> notifyUserids, Map<Locale, Set<Recipient>> emailRecipientsMap, Map<Locale, Set<Recipient>> systemRecipientsMap) throws PersistenceException {
        String idsString = notifyUserids.stream().map(id -> Long.toString(id)).collect(Collectors.joining(","));
        UserDAO uDao = Context.get(UserDAO.class);
        List users = uDao.findByWhere("_entity.id in (" + idsString + ")", null, null);
        for (User user : users) {
            HashSet<Recipient> recipients;
            if (user.getEmail() != null && StringUtils.isNotEmpty(user.getEmail().trim())) {
                Recipient recipient = new Recipient();
                recipient.setName(user.getName());
                recipient.setAddress(user.getEmail());
                recipient.setType(1);
                recipient.setMode("BCC");
                recipient.setRead(1);
                if (emailRecipientsMap.containsKey(user.getLocale())) {
                    emailRecipientsMap.get(user.getLocale()).add(recipient);
                } else {
                    recipients = new HashSet();
                    recipients.add(recipient);
                    emailRecipientsMap.put(user.getLocale(), recipients);
                }
            }
            Recipient rec = new Recipient();
            rec.setName(user.getUsername());
            rec.setAddress(user.getEmail());
            rec.setType(0);
            if (systemRecipientsMap.containsKey(user.getLocale())) {
                systemRecipientsMap.get(user.getLocale()).add(rec);
                continue;
            }
            recipients = new HashSet<Recipient>();
            recipients.add(rec);
            systemRecipientsMap.put(user.getLocale(), recipients);
        }
    }

    public List<GUIDocument> addDocuments(String language, long folderId, boolean importZip, String charset, boolean immediateIndexing, Long templateId) throws ServerException {
        Session session = this.validateSession();
        FolderDAO fdao = Context.get(FolderDAO.class);
        try {
            if (folderId == fdao.findRoot(session.getTenantId()).getId()) {
                throw new PermissionException("Cannot add documents in the root");
            }
            GUIDocument metadata = new GUIDocument();
            metadata.setLanguage(language);
            metadata.setFolder(new GUIFolder(folderId));
            metadata.setTemplateId(templateId);
            return this.addDocuments(importZip, charset, immediateIndexing, metadata);
        }
        catch (PersistenceException | PermissionException | ServerException e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public GUIDocument promoteVersion(long docId, String version) throws ServerException {
        Session session = this.validateSession();
        log.debug("Promoting version {} of document {}", (Object)version, (Object)docId);
        try {
            Document doc = this.retrieveDocument(docId);
            if (doc == null) {
                throw new ServerException(UNEXISTING_DOCUMENT);
            }
            FolderDAO fDao = Context.get(FolderDAO.class);
            if (!fDao.isWriteAllowed(doc.getFolder().getId(), session.getUserId())) {
                throw new PermissionException(session.getUsername(), DOCUMENT_STR + docId, Permission.WRITE);
            }
            if (doc.getStatus() != DocumentStatus.UNLOCKED) {
                throw new PermissionException("The document " + docId + " is locked");
            }
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setDocument(doc);
            DocumentManager manager = Context.get(DocumentManager.class);
            manager.promoteVersion(doc.getId(), version, transaction);
            return this.getById(doc.getId());
        }
        catch (PersistenceException | PermissionException | ServerException | IOException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public void checkout(List<Long> docIds) throws ServerException {
        Session session = this.validateSession();
        DocumentManager documentManager = Context.get(DocumentManager.class);
        DocumentDAO dao = Context.get(DocumentDAO.class);
        try {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setEvent(DocumentEvent.CHECKEDOUT);
            for (long id : docIds) {
                Document doc = dao.findDocument(id);
                if (doc == null) continue;
                documentManager.checkout(doc.getId(), new DocumentHistory(transaction));
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void lock(List<Long> docIds, String comment) throws ServerException {
        Session session = this.validateSession();
        DocumentManager documentManager = Context.get(DocumentManager.class);
        DocumentDAO dao = Context.get(DocumentDAO.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setEvent(DocumentEvent.LOCKED);
        transaction.setComment(HTMLSanitizer.sanitizeSimpleText(comment));
        try {
            for (long id : docIds) {
                Document doc = dao.findDocument(id);
                if (doc == null) continue;
                documentManager.lock(doc.getId(), DocumentStatus.LOCKED, new DocumentHistory(transaction));
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void delete(List<Long> ids) throws ServerException {
        Session session = this.validateSession();
        for (long docId : ids) {
            try {
                this.deleteDocument(docId, session);
            }
            catch (PersistenceException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    private void deleteDocument(long docId, Session session) throws PersistenceException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        Document doc = (Document)dao.findById(docId);
        if (doc == null) {
            return;
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setEvent(DocumentEvent.DELETED);
        transaction.setComment("");
        if (doc.getDocRef() != null || doc.getImmutable() == 1 && !transaction.getUser().isMemberOf("admin")) {
            transaction.setEvent(DocumentEvent.SHORTCUT_DELETED);
            dao.delete(doc.getId(), transaction);
            return;
        }
        if (doc.getImmutable() == 1 && !transaction.getUser().isMemberOf("admin")) {
            log.debug("Document {} was not deleted because immutable", (Object)docId);
            return;
        }
        if (doc.getStatus() == DocumentStatus.LOCKED) {
            log.debug("Document {} was not deleted because locked", (Object)docId);
            return;
        }
        for (Long shortcutId : dao.findAliasIds(doc.getId())) {
            dao.delete(shortcutId);
        }
        dao.delete(doc.getId(), transaction);
    }

    public void deleteBookmarks(List<Long> bookmarkIds) throws ServerException {
        this.validateSession();
        BookmarkDAO dao = Context.get(BookmarkDAO.class);
        for (long id : bookmarkIds) {
            try {
                dao.delete(id);
            }
            catch (Exception e) {
                throw new ServerException("Bookmarks have not been deleted", (Throwable)e);
            }
        }
    }

    public void deleteLinks(List<Long> ids) throws ServerException {
        this.validateSession();
        DocumentLinkDAO dao = Context.get(DocumentLinkDAO.class);
        for (long id : ids) {
            try {
                dao.delete(id);
            }
            catch (Exception e) {
                throw new ServerException("Bookmarks have not been deleted", (Throwable)e);
            }
        }
    }

    public GUIDocument getById(long docId) throws ServerException {
        Session session = this.validateSession();
        try {
            return this.getDocument(session, docId);
        }
        catch (PersistenceException | PermissionException | InvalidSessionServerException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public boolean isPasswordProtected(long docId) throws ServerException {
        Session session = this.validateSession();
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            return docDao.queryForInt("select count(ld_id) from ld_document where ld_deleted=0 and not ld_password = null and ld_id=" + docId) > 0;
        }
        catch (PersistenceException e) {
            return (Boolean)this.throwServerException(session, log, e);
        }
    }

    public GUIDocument getDocument(Session session, long docId) throws InvalidSessionServerException, PersistenceException, PermissionException {
        if (session != null) {
            this.validateSession(session.getSid());
        }
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document document = (Document)docDao.findById(docId);
        GUIDocument guiDocument = null;
        GUIFolder folder = null;
        if (document != null) {
            FolderDAO fDao = Context.get(FolderDAO.class);
            fDao.initialize(document.getFolder());
            folder = new FolderServiceImpl().fromFolder(document.getFolder(), false);
            if (session != null) {
                DocumentServiceImpl.checkPublished(session.getUser(), document);
            }
            docDao.initialize(document);
            guiDocument = this.fromDocument(document, folder, session != null ? session.getUser() : null);
            DocumentServiceImpl.setAllowedPermissions(session, docId, guiDocument);
            if (session != null && folder != null) {
                FolderDAO fdao = Context.get(FolderDAO.class);
                Set<Permission> permissions = fdao.getAllowedPermissions(document.getFolder().getId(), session.getUserId());
                ArrayList<String> permissionsList = new ArrayList<String>();
                for (Permission permission : permissions) {
                    permissionsList.add(permission.name().toLowerCase());
                }
                folder.setAllowedPermissions(new GUIAccessControlEntry(permissionsList.toArray(new String[0])));
            }
        }
        return guiDocument;
    }

    public GUIDocument fromDocument(Document doc, GUIFolder folder, User sessionUser) throws PersistenceException {
        boolean isFolder = doc.getType() != null && doc.getType().startsWith("folder");
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        if (doc.getId() != 0L && !isFolder) {
            docDao.initialize(doc);
        }
        Document realDoc = doc;
        GUIDocument guiDocument = new GUIDocument();
        guiDocument.setId(doc.getId());
        guiDocument.setDocRef(doc.getDocRef());
        guiDocument.setTenantId(doc.getTenantId());
        if (!isFolder && doc.getDocRef() != null && doc.getDocRef() != 0L) {
            realDoc = (Document)docDao.findById(doc.getDocRef());
            docDao.initialize(realDoc);
            guiDocument.setDocRef(doc.getDocRef());
            guiDocument.setDocRefType(doc.getDocRefType());
        }
        guiDocument.setCustomId(realDoc.getCustomId());
        guiDocument.setRevision(realDoc.getRevision());
        guiDocument.setTags(new ArrayList<String>(realDoc.getTagsAsWords()));
        guiDocument.setType(doc.getType());
        guiDocument.setFileName(doc.getFileName());
        guiDocument.setColor(doc.getColor());
        guiDocument.setVersion(realDoc.getVersion());
        guiDocument.setCreation(realDoc.getCreation());
        guiDocument.setCreator(realDoc.getCreator());
        guiDocument.setCreatorId(Long.valueOf(realDoc.getCreatorId()));
        guiDocument.setDate(realDoc.getDate());
        guiDocument.setPublisher(realDoc.getPublisher());
        guiDocument.setPublisherId(Long.valueOf(realDoc.getPublisherId()));
        guiDocument.setFileVersion(realDoc.getFileVersion());
        guiDocument.setLanguage(realDoc.getLanguage());
        guiDocument.setTemplateId(realDoc.getTemplateId());
        guiDocument.setLastModified(realDoc.getLastModified());
        guiDocument.setLockUserId(realDoc.getLockUserId());
        guiDocument.setLockUser(realDoc.getLockUser());
        guiDocument.setComment(realDoc.getComment());
        guiDocument.setLastNote(realDoc.getLastNote());
        guiDocument.setStatus(realDoc.getStatus().ordinal());
        guiDocument.setWorkflowStatus(realDoc.getWorkflowStatus());
        guiDocument.setWorkflowStatusDisplay(realDoc.getWorkflowStatusDisplay());
        guiDocument.setImmutable(realDoc.getImmutable());
        guiDocument.setFileSize(realDoc.getFileSize());
        guiDocument.setStartPublishing(realDoc.getStartPublishing());
        guiDocument.setStopPublishing(realDoc.getStopPublishing());
        guiDocument.setPublished(realDoc.getPublished());
        guiDocument.setSigned(realDoc.getSigned());
        guiDocument.setStamped(realDoc.getStamped());
        guiDocument.setIndexed(realDoc.getIndexed().ordinal());
        guiDocument.setExtResId(realDoc.getExtResId());
        guiDocument.setPages(realDoc.getPages());
        guiDocument.setPreviewPages(realDoc.getPreviewPages());
        guiDocument.setNature(realDoc.getNature());
        guiDocument.setFormId(realDoc.getFormId());
        guiDocument.setIcon(FileUtil.getBaseName(doc.getIcon()));
        guiDocument.setPasswordProtected(realDoc.isPasswordProtected());
        guiDocument.setLinks(realDoc.getLinks());
        guiDocument.setDocAttrs(realDoc.getDocAttrs());
        guiDocument.setOcrd(realDoc.getOcrd());
        guiDocument.setOcrTemplateId(realDoc.getOcrTemplateId());
        guiDocument.setBarcoded(realDoc.getBarcoded());
        guiDocument.setBarcodeTemplateId(realDoc.getBarcodeTemplateId());
        if (realDoc.getRating() != null) {
            guiDocument.setRating(realDoc.getRating().intValue());
        }
        if (realDoc.getCustomId() != null) {
            guiDocument.setCustomId(realDoc.getCustomId());
        } else {
            guiDocument.setCustomId("");
        }
        if (realDoc.getTemplate() != null) {
            guiDocument.setTemplate(realDoc.getTemplate().getName());
            guiDocument.setTemplateId(Long.valueOf(realDoc.getTemplate().getId()));
        }
        this.setBookmarked(guiDocument, isFolder, sessionUser);
        List<GUIAttribute> attributes = new TemplateServiceImpl().prepareGUIAttributes(realDoc.getTemplate(), realDoc, sessionUser);
        guiDocument.setAttributes(attributes);
        if (folder != null) {
            guiDocument.setFolder(folder);
        } else {
            GUIFolder f = new GUIFolder(doc.getFolder().getId());
            f.setName(doc.getFolder().getName());
            guiDocument.setFolder(f);
        }
        FolderDAO fdao = Context.get(FolderDAO.class);
        guiDocument.setPathExtended(fdao.computePathExtended(guiDocument.getFolder().getId()));
        return guiDocument;
    }

    private void setBookmarked(GUIDocument document, boolean isFolder, User sessionUser) throws PersistenceException {
        if (sessionUser != null && !isFolder) {
            BookmarkDAO bDao = Context.get(BookmarkDAO.class);
            document.setBookmarked(bDao.isDocBookmarkedByUser(document.getId(), sessionUser.getId()));
            if (document.getDocRef() != null) {
                document.setBookmarked(bDao.isDocBookmarkedByUser(document.getDocRef(), sessionUser.getId()));
            }
        }
    }

    public List<GUIVersion> getVersionsById(long id1, long id2) throws ServerException {
        Version docVersion;
        Session session = this.validateSession();
        VersionDAO versDao = Context.get(VersionDAO.class);
        try {
            docVersion = (Version)versDao.findById(id1);
            if (docVersion != null) {
                versDao.initialize(docVersion);
            }
        }
        catch (Exception e) {
            return (List)super.throwServerException(session, log, e);
        }
        GUIVersion version1 = null;
        if (docVersion != null) {
            version1 = new GUIVersion();
            version1.setDocId(docVersion.getDocId());
            version1.setUsername(docVersion.getUsername());
            version1.setComment(docVersion.getComment());
            version1.setId(id1);
            version1.setCustomId(docVersion.getCustomId());
            version1.setRevision(docVersion.getRevision());
            version1.setTagsString(docVersion.getTgs());
            version1.setType(docVersion.getType());
            version1.setFileName(docVersion.getFileName());
            version1.setCreation(docVersion.getCreation());
            version1.setCreator(docVersion.getCreator());
            version1.setDate(docVersion.getDate());
            version1.setPublisher(docVersion.getPublisher());
            version1.setVersion(docVersion.getVersion());
            version1.setFileVersion(docVersion.getFileVersion());
            version1.setLanguage(docVersion.getLanguage());
            version1.setTemplateId(docVersion.getTemplateId());
            version1.setFileSize(docVersion.getFileSize());
            version1.setWorkflowStatus(docVersion.getWorkflowStatus());
            version1.setWorkflowStatusDisplay(docVersion.getWorkflowStatusDisplay());
            version1.setColor(docVersion.getColor());
            version1.setStartPublishing(docVersion.getStartPublishing());
            version1.setStopPublishing(docVersion.getStopPublishing());
            version1.setPublished(docVersion.getPublished());
            version1.setPages(docVersion.getPages());
            version1.setOcrd(docVersion.getOcrd());
            version1.setOcrTemplateId(docVersion.getOcrTemplateId());
            this.setGUIExtendedAttributes(docVersion, version1);
            GUIFolder folder1 = new GUIFolder();
            folder1.setName(docVersion.getFolderName());
            folder1.setId(docVersion.getFolderId());
            version1.setFolder(folder1);
        }
        try {
            docVersion = (Version)versDao.findById(id2);
            if (docVersion != null) {
                versDao.initialize(docVersion);
            }
        }
        catch (Exception e) {
            return (List)super.throwServerException(session, log, e);
        }
        GUIVersion version2 = null;
        if (docVersion != null) {
            version2 = new GUIVersion();
            version2.setDocId(docVersion.getDocId());
            version2.setUsername(docVersion.getUsername());
            version2.setComment(docVersion.getComment());
            version2.setId(id1);
            version2.setCustomId(docVersion.getCustomId());
            version2.setRevision(docVersion.getRevision());
            version2.setTagsString(docVersion.getTgs());
            version2.setType(docVersion.getType());
            version2.setFileName(docVersion.getFileName());
            version2.setCreation(docVersion.getCreation());
            version2.setCreator(docVersion.getCreator());
            version2.setDate(docVersion.getDate());
            version2.setPublisher(docVersion.getPublisher());
            version2.setVersion(docVersion.getVersion());
            version2.setFileVersion(docVersion.getFileVersion());
            version2.setLanguage(docVersion.getLanguage());
            version2.setFileSize(docVersion.getFileSize());
            version2.setWorkflowStatus(docVersion.getWorkflowStatus());
            version2.setColor(docVersion.getColor());
            version2.setStartPublishing(docVersion.getStartPublishing());
            version2.setStopPublishing(docVersion.getStopPublishing());
            version2.setPublished(docVersion.getPublished());
            version2.setPages(docVersion.getPages());
            version2.setOcrd(docVersion.getOcrd());
            version2.setOcrTemplateId(docVersion.getOcrTemplateId());
            version2.setBarcodeTemplateId(docVersion.getBarcodeTemplateId());
            this.setGUIExtendedAttributes(docVersion, version2);
            GUIFolder folder2 = new GUIFolder();
            folder2.setName(docVersion.getFolderName());
            folder2.setId(docVersion.getFolderId());
            version2.setFolder(folder2);
        }
        ArrayList<GUIVersion> versions = new ArrayList<GUIVersion>();
        if (version1 != null && version2 != null) {
            versions.add(version1);
            versions.add(version2);
        } else if (version1 != null) {
            versions.add(version1);
        } else if (version2 != null) {
            versions.add(version2);
        }
        return versions;
    }

    private void setGUIExtendedAttributes(Version docVersion, GUIVersion guiVersion) throws ServerException {
        VersionDAO versDao = Context.get(VersionDAO.class);
        guiVersion.setTemplate(docVersion.getTemplateName());
        guiVersion.setTemplateId(docVersion.getTemplateId());
        try {
            versDao.initialize(docVersion);
        }
        catch (PersistenceException e) {
            throw new ServerException(e.getMessage(), (Throwable)e);
        }
        for (String attrName : docVersion.getAttributeNames()) {
            Attribute extAttr = docVersion.getAttributes().get(attrName);
            GUIAttribute att = new GUIAttribute();
            att.setName(attrName);
            att.setSetId(extAttr.getSetId());
            att.setPosition(extAttr.getPosition());
            att.setLabel(extAttr.getLabel());
            att.setMandatory(extAttr.getMandatory() == 1);
            att.setHidden(extAttr.getHidden() == 1);
            att.setReadonly(extAttr.getReadonly() == 1);
            att.setMultiple(extAttr.getMultiple() == 1);
            att.setParent(extAttr.getParent());
            att.setStringValues(extAttr.getStringValues());
            att.setEditor(extAttr.getEditor());
            att.setStringValue(extAttr.getStringValue());
            att.setIntValue(extAttr.getIntValue());
            att.setBooleanValue(extAttr.getBooleanValue());
            att.setDoubleValue(extAttr.getDoubleValue());
            att.setDateValue(extAttr.getDateValue());
            att.setType(extAttr.getType());
            guiVersion.addAttribute(att);
        }
    }

    public void linkDocuments(List<Long> inDocIds, List<Long> outDocIds) throws ServerException {
        Session session = this.validateSession();
        DocumentLinkDAO linkDao = Context.get(DocumentLinkDAO.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        for (Long inDocId : inDocIds) {
            for (Long outDocId : outDocIds) {
                try {
                    DocumentLink link = linkDao.findByDocIdsAndType(inDocId, outDocId, "default");
                    if (link != null) continue;
                    link = new DocumentLink();
                    link.setTenantId(session.getTenantId());
                    link.setDocument1((Document)docDao.findById(inDocId));
                    link.setDocument2((Document)docDao.findById(outDocId));
                    link.setType("default");
                    linkDao.store(link);
                }
                catch (PersistenceException e) {
                    this.throwServerException(session, log, e);
                }
            }
        }
    }

    public void makeImmutable(List<Long> docIds, String comment) throws ServerException {
        Session session = this.validateSession();
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        DocumentManager manager = Context.get(DocumentManager.class);
        try {
            for (long id : docIds) {
                Document doc = (Document)docDao.findById(id);
                if (doc.getImmutable() != 0 || doc.getStatus() != DocumentStatus.UNLOCKED) continue;
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                transaction.setComment(HTMLSanitizer.sanitizeSimpleText(comment));
                manager.makeImmutable(id, transaction);
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void markHistoryAsRead(String event) throws ServerException {
        Session session = this.validateSession();
        DocumentHistoryDAO dao = Context.get(DocumentHistoryDAO.class);
        try {
            dao.markHistoriesAsRead(event, session.getUserId());
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void markIndexable(List<Long> docIds, int policy) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        for (long id : docIds) {
            try {
                manager.changeIndexingStatus((Document)docDao.findById(id), IndexingStatus.values()[policy]);
            }
            catch (PersistenceException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    public void markUnindexable(List<Long> docIds) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        for (long id : docIds) {
            try {
                manager.changeIndexingStatus((Document)docDao.findById(id), IndexingStatus.SKIP);
            }
            catch (PersistenceException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    public void restore(List<Long> docIds, long folderId) throws ServerException {
        Session session = this.validateSession();
        for (Long docId : docIds) {
            if (docId == null) continue;
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            try {
                Context.get(DocumentDAO.class).restore(docId, folderId, transaction);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public void validate(GUIDocument document) throws ServerException {
        Session session = this.validateSession();
        try {
            Document object = DocumentServiceImpl.toDocument(document);
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setEvent(document.getId() == 0L ? DocumentEvent.CHANGED : DocumentEvent.STORED);
            transaction.setComment(HTMLSanitizer.sanitizeSimpleText(document.getComment()));
            Validator validator = new Validator();
            validator.validate(object, object.getTemplate(), transaction);
        }
        catch (PersistenceException | AutomationException e) {
            this.throwServerException(session, log, e);
        }
    }

    public GUIDocument save(GUIDocument guiDocument) throws ServerException {
        Session session = this.validateSession();
        if (guiDocument.getId() == 0L) {
            return null;
        }
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document document = (Document)docDao.findById(guiDocument.getId());
            docDao.initialize(document);
            if (guiDocument.getDocRef() != null) {
                document.setFileName(guiDocument.getFileName());
                document.setColor(guiDocument.getColor());
                document.setType(FileUtil.getExtension(document.getFileName()).toLowerCase());
                docDao.store(document);
                document = (Document)docDao.findById(guiDocument.getDocRef());
                docDao.initialize(document);
            }
            for (GUIAttribute att2 : guiDocument.getAttributes().stream().filter(att -> att.isMultiple()).toList()) {
                DecimalFormat nf = new DecimalFormat("0000");
                List values = guiDocument.getValues(att2.getName());
                int index = 0;
                for (GUIAttribute val : values) {
                    if (index > 0) {
                        val.setName(att2.getName() + "-" + nf.format(index));
                    }
                    ++index;
                }
            }
            Document docVO = DocumentServiceImpl.toDocument(guiDocument);
            if (guiDocument.getDocRef() != null) {
                docVO.setDocRef(null);
                docVO.setFileName(document.getFileName());
                docVO.setColor(document.getColor());
                docVO.setType(FileUtil.getExtension(document.getFileName()).toLowerCase());
            }
            docVO.setTenantId(session.getTenantId());
            docVO.setOcrd(document.getOcrd());
            docVO.setBarcoded(document.getBarcoded());
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setEvent(DocumentEvent.CHANGED);
            transaction.setComment(HTMLSanitizer.sanitizeSimpleText(guiDocument.getComment()));
            DocumentManager documentManager = Context.get(DocumentManager.class);
            documentManager.update(document, docVO, transaction);
            return this.getById(guiDocument.getId());
        }
        catch (PersistenceException | ServerException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    private static void setAllowedPermissions(Session session, long documentId, GUIDocument guiDocument) throws PersistenceException {
        if (session != null) {
            DocumentDAO dao = Context.get(DocumentDAO.class);
            Set<Permission> permissions = dao.getAllowedPermissions(documentId, session.getUserId());
            guiDocument.setAllowedPermissions(new GUIAccessControlEntry(permissions.stream().map(p -> p.name().toLowerCase()).toList().toArray(new String[0])));
        }
    }

    public static Document toDocument(GUIDocument guiDocument) throws PersistenceException {
        Document docVO = new Document();
        docVO.setTagsFromWords(new HashSet<String>(guiDocument.getTags()));
        docVO.setCustomId(HTMLSanitizer.sanitizeSimpleText(guiDocument.getCustomId()));
        docVO.setRevision(HTMLSanitizer.sanitizeSimpleText(guiDocument.getRevision()));
        docVO.setFileName(HTMLSanitizer.sanitizeSimpleText(guiDocument.getFileName()));
        docVO.setVersion(guiDocument.getVersion());
        docVO.setCreation(guiDocument.getCreation());
        docVO.setCreator(guiDocument.getCreator());
        docVO.setDate(guiDocument.getDate());
        docVO.setPublisher(guiDocument.getPublisher());
        docVO.setFileVersion(guiDocument.getFileVersion());
        docVO.setLanguage(guiDocument.getLanguage());
        docVO.setFileSize(guiDocument.getFileSize());
        docVO.setRating(guiDocument.getRating());
        docVO.setComment(HTMLSanitizer.sanitizeSimpleText(guiDocument.getComment()));
        docVO.setWorkflowStatus(guiDocument.getWorkflowStatus());
        docVO.setWorkflowStatusDisplay(guiDocument.getWorkflowStatusDisplay());
        docVO.setColor(guiDocument.getColor());
        docVO.setStartPublishing(guiDocument.getStartPublishing());
        docVO.setStopPublishing(guiDocument.getStopPublishing());
        docVO.setPublished(guiDocument.getPublished());
        docVO.setBarcoded(guiDocument.getBarcoded());
        docVO.setExtResId(guiDocument.getExtResId());
        docVO.setPages(guiDocument.getPages());
        docVO.setPreviewPages(guiDocument.getPreviewPages());
        docVO.setNature(guiDocument.getNature());
        docVO.setFormId(guiDocument.getFormId());
        docVO.setOcrTemplateId(guiDocument.getOcrTemplateId());
        docVO.setBarcodeTemplateId(guiDocument.getBarcodeTemplateId());
        if (guiDocument.getTemplateId() != null) {
            docVO.setTemplateId(guiDocument.getTemplateId());
            TemplateDAO templateDao = Context.get(TemplateDAO.class);
            Template template = (Template)templateDao.findById(guiDocument.getTemplateId());
            templateDao.initialize(template);
            docVO.setTemplate(template);
            if (CollectionUtils.isNotEmpty((Collection)guiDocument.getAttributes())) {
                DocumentServiceImpl.toAttributes(guiDocument, docVO, template);
            }
        }
        docVO.setStatus(guiDocument.getStatus());
        FolderDAO fdao = Context.get(FolderDAO.class);
        if (guiDocument.getFolder() != null) {
            docVO.setFolder((Folder)fdao.findById(guiDocument.getFolder().getId()));
        }
        return docVO;
    }

    private static void toAttributes(GUIDocument guiDocument, Document docVO, Template template) {
        for (GUIAttribute attr : guiDocument.getAttributes()) {
            int extAttrType;
            Attribute templateAttribute = template.getAttributes().get(attr.getParent() != null ? attr.getParent() : attr.getName());
            if (templateAttribute == null) continue;
            Attribute extAttr = new Attribute();
            int templateType = templateAttribute.getType();
            if (templateType != (extAttrType = attr.getType())) {
                DocumentServiceImpl.updateAttributeValue1(attr, extAttr, templateType);
            } else {
                DocumentServiceImpl.updateAttributeValue2(attr, extAttr, templateType);
            }
            extAttr.setParent(attr.getParent());
            extAttr.setDependsOn(attr.getDependsOn());
            extAttr.setStringValues(attr.getStringValues());
            extAttr.setLabel(templateAttribute.getLabel());
            extAttr.setType(templateType);
            extAttr.setPosition(attr.getPosition());
            extAttr.setMandatory(templateAttribute.getMandatory());
            extAttr.setHidden(templateAttribute.getHidden());
            extAttr.setStringValues(attr.getStringValues());
            if (attr.getParent() == null) {
                extAttr.setMultiple(templateAttribute.getMultiple());
            }
            extAttr.setSetId(templateAttribute.getSetId());
            docVO.getAttributes().put(attr.getName(), extAttr);
        }
    }

    private static void updateAttributeValue2(GUIAttribute attr, Attribute extAttr, int templateType) {
        if (templateType == 1) {
            DocumentServiceImpl.setIntValue(attr, extAttr);
        } else if (templateType == 5) {
            DocumentServiceImpl.setBooleanValue(attr, extAttr);
        } else if (templateType == 2) {
            DocumentServiceImpl.setDoubleValue(attr, extAttr);
        } else if (templateType == 3) {
            DocumentServiceImpl.setDateValue(attr, extAttr);
        } else if (templateType == 0) {
            DocumentServiceImpl.setStringValue(attr, extAttr);
        } else if (templateType == 4 || templateType == 6 || templateType == 7) {
            DocumentServiceImpl.setUserValue(attr, extAttr, templateType);
        }
    }

    private static void setUserValue(GUIAttribute attr, Attribute extAttr, int templateType) {
        if (attr.getValue() != null) {
            extAttr.setIntValue(attr.getIntValue());
            extAttr.setStringValue(attr.getStringValue());
        } else {
            extAttr.setIntValue(null);
            extAttr.setStringValue(null);
        }
        extAttr.setType(templateType);
    }

    private static void setStringValue(GUIAttribute attr, Attribute extAttr) {
        if (attr.getValue() != null) {
            extAttr.setStringValue(HTMLSanitizer.sanitizeSimpleText((String)attr.getValue()));
        } else {
            extAttr.setStringValue(null);
        }
    }

    private static void setDateValue(GUIAttribute attr, Attribute extAttr) {
        if (attr.getValue() != null) {
            extAttr.setDateValue(DocumentServiceImpl.fixDateForDB((Date)attr.getValue()));
        } else {
            extAttr.setDateValue(null);
        }
    }

    private static void setDoubleValue(GUIAttribute attr, Attribute extAttr) {
        if (attr.getValue() != null) {
            extAttr.setDoubleValue((Double)attr.getValue());
        } else {
            extAttr.setDoubleValue(null);
        }
    }

    private static void setBooleanValue(GUIAttribute attr, Attribute extAttr) {
        if (attr.getBooleanValue() != null) {
            extAttr.setValue(attr.getBooleanValue());
        } else {
            extAttr.setBooleanValue(null);
        }
    }

    private static void setIntValue(GUIAttribute attr, Attribute extAttr) {
        if (attr.getValue() != null) {
            extAttr.setIntValue((Long)attr.getValue());
        } else {
            extAttr.setIntValue(null);
        }
    }

    private static void updateAttributeValue1(GUIAttribute attr, Attribute extAttr, int templateType) {
        if (attr.getValue() != null && attr.getValue().toString().trim().isEmpty() && templateType != 0) {
            if (templateType == 1 || templateType == 5) {
                extAttr.setIntValue(null);
            } else if (templateType == 2) {
                extAttr.setDoubleValue(null);
            } else if (templateType == 3) {
                extAttr.setDateValue(null);
            }
        } else if (templateType == 2) {
            extAttr.setValue(Double.parseDouble(attr.getValue().toString()));
        } else if (templateType == 1) {
            extAttr.setValue(Long.parseLong(attr.getValue().toString()));
        } else if (templateType == 5) {
            extAttr.setValue(attr.getBooleanValue());
            extAttr.setType(5);
        } else if (templateType == 4 || templateType == 6 || templateType == 7) {
            extAttr.setIntValue(attr.getIntValue());
            extAttr.setStringValue(attr.getStringValue());
            extAttr.setType(templateType);
        }
    }

    public String sendAsEmail(GUIEmail guiMail, String locale) throws ServerException {
        Session session = this.validateSession();
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        EMail mail = new EMail();
        mail.setHtml(1);
        mail.setTenantId(session.getTenantId());
        mail.setAccountId(-1L);
        mail.setFolder(OUTBOX);
        mail.setSentDate(new Date());
        mail.setUsername(session.getUsername());
        this.setAuthorAddress(mail, guiMail, session);
        mail.parseRecipientsBCC(guiMail.getBccs().stream().map(c -> c.getEmail()).collect(Collectors.joining(",")));
        mail.parseRecipientsCC(guiMail.getCcs().stream().map(c -> c.getEmail()).collect(Collectors.joining(",")));
        mail.parseRecipients(guiMail.getTos().stream().map(c -> c.getEmail()).collect(Collectors.joining(",")));
        List<Document> attachedDocs = documentDao.findByIds(guiMail.getDocIds().stream().collect(Collectors.toSet()), null);
        for (Document document : attachedDocs) {
            documentDao.initialize(document);
        }
        Automation engine = new Automation("sendmail", LocaleUtil.toLocale(locale), session.getTenantId());
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        dictionary.put("locale", LocaleUtil.toLocale(locale));
        dictionary.put("sender", session.getUser());
        dictionary.put("documents", attachedDocs);
        dictionary.put(DOCUMENT, attachedDocs.get(0));
        try {
            this.prepareDownloadTicket(guiMail, locale, session, dictionary);
            Object message = engine.evaluate(guiMail.getMessage(), dictionary);
            mail.setSubject(engine.evaluate(guiMail.getSubject(), dictionary));
            if (guiMail.isSendAsTicket()) {
                Document doc;
                if (!guiMail.getMessage().contains(DOWNLOAD_TICKET)) {
                    message = (String)message + "<br/><br/>" + String.valueOf(dictionary.get(DOWNLOAD_TICKET));
                }
                if ((doc = documentDao.findDocument((Long)guiMail.getDocIds().get(0))).getDocRef() != null) {
                    doc = (Document)documentDao.findById(doc.getDocRef());
                }
                this.writeMessageWithThumbnail(mail, doc, (String)message, session);
            } else {
                if (guiMail.isZipCompression()) {
                    this.prepareZipAttachment(mail, guiMail.getDocIds(), guiMail.isPdfConversion(), session);
                } else {
                    Iterator iterator = guiMail.getDocIds().iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        this.createAttachment(mail, id, guiMail.isPdfConversion(), session.getSid());
                    }
                }
                mail.setMessageText("<html><head><meta charset='utf-8' /></head><body>" + (String)message + "</body></html>");
            }
            return this.sendEmail(mail, session, attachedDocs);
        }
        catch (PersistenceException | AutomationException | PermissionException | IOException e) {
            log.warn(e.getMessage(), e);
            return ERROR;
        }
    }

    private void setAuthorAddress(EMail mail, GUIEmail guiMail, Session session) {
        mail.setAuthor(session.getUser().getUsername());
        if (Context.get().getProperties().getBoolean(session.getTenantName() + SMTP_USERASFROM, true)) {
            if (guiMail.getFrom() != null) {
                mail.setAuthorAddress(guiMail.getFrom().getEmail());
            } else {
                mail.setAuthorAddress(session.getUser().getEmail());
            }
        }
    }

    private void prepareZipAttachment(EMail mail, List<Long> docIds, boolean pdfConversion, Session session) throws IOException {
        File zipFile = FileUtil.createTempFile("email", "zip");
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileOutputStream out = new FileOutputStream(zipFile);){
                    DocumentHistory transaction = new DocumentHistory();
                    transaction.setSession(session);
                    transaction.setEvent(DocumentEvent.DOWNLOADED);
                    ZipExport export = new ZipExport();
                    export.process(docIds.toArray(new Long[0]), out, pdfConversion, transaction);
                    this.createAttachment(mail, zipFile);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (PersistenceException | IOException t) {
                log.error(t.getMessage(), t);
                FileUtil.delete(zipFile);
            }
        }
        finally {
            FileUtil.delete(zipFile);
        }
    }

    private void writeMessageWithThumbnail(EMail mail, Document doc, String message, Session session) {
        block6: {
            File thumbnailFile = null;
            try {
                try {
                    thumbnailFile = this.createTile(doc, session.getSid());
                    if (thumbnailFile != null && thumbnailFile.length() > 0L) {
                        message = (String)message + "<p><img src='data:image/png;base64," + ImageUtil.encode(thumbnailFile) + "'/></p>";
                    }
                    mail.setMessageText("<html><head><meta charset='utf-8' /></head><body>" + (String)message + "<rl /></body></html>");
                }
                catch (IOException ioe) {
                    log.warn(ioe.getMessage());
                    FileUtil.delete(thumbnailFile);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(thumbnailFile);
                throw throwable;
            }
            FileUtil.delete(thumbnailFile);
        }
    }

    private void prepareDownloadTicket(GUIEmail email, String locale, Session session, Map<String, Object> dictionary) throws PersistenceException, PermissionException {
        if (email.isSendAsTicket()) {
            DocumentDAO documentDao = Context.get(DocumentDAO.class);
            DocumentManager manager = Context.get(DocumentManager.class);
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            Document doc = documentDao.findDocument((Long)email.getDocIds().get(0));
            Ticket ticket = new Ticket();
            ticket.setTenantId(session.getTenantId());
            ticket.setType(0);
            ticket.setDocId((Long)email.getDocIds().get(0));
            ticket = manager.createTicket(ticket, transaction);
            String ticketDiv = "<div style='margin-top:10px; border-top:1px solid black; background-color:#CCCCCC;'><b>&nbsp;" + I18N.message("clicktodownload", LocaleUtil.toLocale(locale)) + ": <a href='" + ticket.getUrl() + "'>" + doc.getFileName() + "</a></b></div>";
            dictionary.put(DOWNLOAD_TICKET, ticketDiv);
        }
    }

    private String sendEmail(EMail mail, Session session, List<Document> attachedDocs) {
        try {
            DocumentDAO documentDao = Context.get(DocumentDAO.class);
            EMailSender sender = DocumentServiceImpl.getEmailSender(session);
            sender.send(mail);
            FolderDAO fDao = Context.get(FolderDAO.class);
            for (Document d : attachedDocs) {
                Document doc = d;
                if (doc.getDocRef() != null) {
                    doc = (Document)documentDao.findById(doc.getDocRef());
                }
                DocumentHistory history = new DocumentHistory();
                history.setSession(session);
                history.setDocument(doc);
                history.setEvent(DocumentEvent.SENT);
                history.setComment(StringUtils.abbreviate(StringUtil.collectionToString(mail.getRecipients(), ", "), 4000));
                history.setFilename(doc.getFileName());
                history.setVersion(doc.getVersion());
                history.setFileVersion(doc.getFileVersion());
                history.setPath(fDao.computePathExtended(doc.getFolder().getId()));
                documentDao.saveDocumentHistory(doc, history);
            }
            ContactDAO cdao = Context.get(ContactDAO.class);
            for (Recipient recipient : mail.getRecipients()) {
                List<Contact> contacts = cdao.findByUser(session.getUserId(), recipient.getAddress());
                if (!contacts.isEmpty()) continue;
                Contact cont = new Contact();
                cont.setUserId(session.getUserId());
                cont.setEmail(recipient.getAddress().trim());
                cdao.store(cont);
            }
            return "ok";
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
            return ERROR;
        }
    }

    private static EMailSender getEmailSender(Session session) {
        if (emailSender != null) {
            emailSender.setTenant(session.getTenantId());
            return emailSender;
        }
        return new EMailSender(session.getTenantName());
    }

    private File createTile(Document doc, String sid) throws IOException {
        Store store = Context.get(Store.class);
        String tileResource = store.getResourceName(doc, doc.getFileVersion(), "tile.png");
        if (store.size(doc.getId(), tileResource) <= 0L) {
            ThumbnailManager thumbManager = Context.get(ThumbnailManager.class);
            try {
                thumbManager.createTile(doc, doc.getFileVersion(), sid);
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
        if (store.exists(doc.getId(), tileResource)) {
            File file = FileUtil.createTempFile("tile-", ".png");
            store.writeToFile(doc.getId(), tileResource, file);
            return file;
        }
        return null;
    }

    private void createAttachment(EMail email, long docId, boolean pdfConversion, String sid) throws IOException, PersistenceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Store store = Context.get(Store.class);
        Document doc = docDao.findDocument(docId);
        String resource = store.getResourceName(doc, null, null);
        boolean convertToPdf = pdfConversion;
        if (doc.getDocRef() != null && "pdf".equals(doc.getDocRefType())) {
            doc = (Document)docDao.findById(doc.getDocRef());
            convertToPdf = true;
        }
        EMailAttachment att = new EMailAttachment();
        att.setIcon(doc.getIcon());
        att.setFileName(doc.getFileName());
        String extension = doc.getFileExtension();
        att.setMimeType(MimeType.get(extension));
        if (convertToPdf) {
            if (!"pdf".equals(FileUtil.getExtension(doc.getFileName().toLowerCase()))) {
                FormatConverterManager manager = Context.get(FormatConverterManager.class);
                manager.convertToPdf(doc, sid);
                resource = store.getResourceName(doc, null, "conversion.pdf");
            }
            att.setMimeType(MimeType.get("pdf"));
            att.setFileName(FileUtil.getBaseName(doc.getFileName()) + ".pdf");
        }
        att.setData(store.getBytes(doc.getId(), resource));
        email.addAttachment(2 + email.getAttachments().size(), att);
    }

    private void createAttachment(EMail email, File zipFile) {
        EMailAttachment att = new EMailAttachment();
        att.setData(FileUtil.toByteArray(zipFile));
        att.setFileName("doc.zip");
        String extension = "zip";
        att.setMimeType(MimeType.get(extension));
        email.addAttachment(2 + email.getAttachments().size(), att);
    }

    public void unlock(List<Long> docIds) throws ServerException {
        Session session = this.validateSession();
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        try {
            DocumentManager documentManager = Context.get(DocumentManager.class);
            for (long id : docIds) {
                documentManager.unlock(id, transaction);
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void updateBookmark(GUIBookmark bookmark) throws ServerException {
        Session session = this.validateSession();
        BookmarkDAO bookmarkDao = Context.get(BookmarkDAO.class);
        try {
            if (bookmark.getId() == 0L) {
                return;
            }
            Bookmark bk = (Bookmark)bookmarkDao.findById(bookmark.getId());
            bookmarkDao.initialize(bk);
            bk.setTitle(bookmark.getName());
            bk.setDescription(bookmark.getDescription());
            bookmarkDao.store(bk);
            bookmark.setId(bk.getId());
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void updateLink(long id, String type) throws ServerException {
        Session session = this.validateSession();
        DocumentLinkDAO dao = Context.get(DocumentLinkDAO.class);
        try {
            DocumentLink link = (DocumentLink)dao.findById(id);
            dao.initialize(link);
            link.setType(type);
            dao.store(link);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void cleanUploadedFileFolder() throws ServerException {
        Session session = this.validateSession();
        UploadServlet.cleanUploads(session.getSid());
        File dir = new File(System.getProperty("java.io.tmpdir") + "/upload/" + session.getSid());
        if (dir.exists()) {
            FileUtil.delete(dir);
        }
    }

    public GUIRating getRating(long docId) throws ServerException {
        Session session = this.validateSession();
        RatingDAO ratingDao = Context.get(RatingDAO.class);
        try {
            GUIRating rating = new GUIRating();
            Rating rat = ratingDao.findVotesByDocId(docId);
            if (rat != null) {
                ratingDao.initialize(rat);
                rating.setId(rat.getId());
                rating.setDocId(docId);
                if (ratingDao.findByDocIdAndUserId(docId, session.getUserId()) != null) {
                    rating.setUserId(session.getUserId());
                }
                rating.setCount(rat.getCount());
                rating.setAverage(rat.getAverage());
            } else {
                rating.setDocId(docId);
                rating.setCount(Integer.valueOf(0));
                rating.setAverage(Float.valueOf(0.0f));
            }
            return rating;
        }
        catch (PersistenceException e) {
            return (GUIRating)this.throwServerException(session, log, e);
        }
    }

    public int saveRating(GUIRating rating) throws ServerException {
        Session session = this.validateSession();
        RatingDAO ratingDao = Context.get(RatingDAO.class);
        try {
            Rating rat = ratingDao.findByDocIdAndUserId(rating.getDocId(), rating.getUserId());
            if (rat == null) {
                rat = new Rating();
                rat.setTenantId(session.getTenantId());
                rat.setDocId(rating.getDocId());
                rat.setUserId(session.getUserId());
                rat.setUsername(session.getUser().getFullName());
            }
            rat.setVote(rating.getVote());
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            ratingDao.store(rat, transaction);
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document doc = (Document)docDao.findById(rating.getDocId());
            return doc.getRating();
        }
        catch (PersistenceException e) {
            return (Integer)this.throwServerException(session, log, e);
        }
    }

    public long addNote(long docId, String message) throws ServerException {
        Session session = this.validateSession();
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document document = docDao.findDocument(docId);
            if (document == null) {
                throw new ServerException("Unexisting document " + docId);
            }
            DocumentNote note = new DocumentNote();
            note.setTenantId(session.getTenantId());
            note.setDocId(document.getId());
            note.setUserId(session.getUserId());
            note.setUsername(session.getUser().getFullName());
            note.setDate(new Date());
            note.setMessage(message);
            note.setFileName(document.getFileName());
            note.setFileVersion(document.getFileVersion());
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
            dao.store(note, transaction);
            return note.getId();
        }
        catch (PersistenceException | ServerException e) {
            return (Long)this.throwServerException(session, log, e);
        }
    }

    public List<GUIDocumentNote> getNotes(long docId, String fileVersion, Collection<String> types) throws ServerException {
        Session session = this.validateSession();
        try {
            Document document = this.retrieveDocument(docId);
            if (document == null) {
                throw new ServerException("Unexisting document " + docId);
            }
            ArrayList<GUIDocumentNote> guiNotes = new ArrayList<GUIDocumentNote>();
            DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
            List<DocumentNote> notes = dao.findByDocIdAndTypes(document.getId(), fileVersion != null ? fileVersion : document.getFileVersion(), types);
            for (DocumentNote note : notes) {
                GUIDocumentNote guiNote = new GUIDocumentNote();
                guiNote.setColor(note.getColor());
                guiNote.setDate(note.getDate());
                guiNote.setDocId(document.getId());
                guiNote.setFileName(note.getFileName());
                guiNote.setHeight(note.getHeight());
                guiNote.setId(note.getId());
                guiNote.setLeft(note.getLeft());
                guiNote.setMessage(note.getMessage());
                guiNote.setOpacity(note.getOpacity());
                guiNote.setPage(note.getPage());
                guiNote.setTop(note.getTop());
                guiNote.setUserId(note.getUserId());
                guiNote.setUsername(note.getUsername());
                guiNote.setWidth(note.getWidth());
                guiNote.setFileVersion(note.getFileVersion());
                guiNote.setType(note.getType());
                guiNote.setRecipient(note.getRecipient());
                guiNote.setRecipientEmail(note.getRecipientEmail());
                guiNote.setLineColor(note.getLineColor());
                guiNote.setLineWidth(note.getLineWidth());
                guiNote.setLineOpacity(note.getLineOpacity());
                guiNote.setShape(note.getShape());
                guiNote.setRotation(note.getRotation());
                guiNotes.add(guiNote);
            }
            return guiNotes;
        }
        catch (PersistenceException e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public void saveNotes(long docId, String fileVersion, List<GUIDocumentNote> notes, Collection<String> types) throws ServerException {
        Session session = this.validateSession();
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        Document document = null;
        try {
            document = this.retrieveDocument(docId);
            if (document == null) {
                throw new UnexistingResourceException(DOCUMENT_STR + docId);
            }
            List<DocumentNote> documentNotes = dao.findByDocIdAndTypes(document.getId(), fileVersion != null ? fileVersion : document.getFileVersion(), types);
            List<Long> actualNoteIds = documentNotes.stream().map(PersistentObject::getId).toList();
            List<Long> noteIds = notes.stream().map(GUIDocumentNote::getId).toList();
            for (Long actualNoteId : actualNoteIds) {
                if (noteIds.contains(actualNoteId)) continue;
                dao.delete(actualNoteId);
            }
            for (GUIDocumentNote guiNote : notes) {
                this.saveNote(session, document, guiNote);
            }
        }
        catch (PersistenceException | UnexistingResourceException e) {
            this.throwServerException(session, log, e);
        }
    }

    private void saveNote(Session session, Document document, GUIDocumentNote guiNote) throws ServerException, PersistenceException {
        ContactDAO cDao;
        List<Contact> contacts;
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        DocumentNote note = null;
        try {
            note = (DocumentNote)dao.findById(guiNote.getId());
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        if (note == null) {
            note = new DocumentNote();
            note.setTenantId(session.getTenantId());
            note.setDocId(document.getId());
            note.setFileVersion(guiNote.getFileVersion() != null ? guiNote.getFileVersion() : document.getFileVersion());
            note.setUserId(session.getUserId());
            note.setUsername(session.getUser().getFullName());
            note.setDate(new Date());
            note.setPage(guiNote.getPage());
        }
        note.setFileName(document.getFileName());
        note.setMessage(guiNote.getMessage());
        note.setColor(guiNote.getColor());
        note.setTop(guiNote.getTop());
        note.setLeft(guiNote.getLeft());
        note.setWidth(guiNote.getWidth());
        note.setHeight(guiNote.getHeight());
        note.setType(guiNote.getType());
        note.setRecipient(guiNote.getRecipient());
        note.setRecipientEmail(guiNote.getRecipientEmail());
        note.setShape(guiNote.getShape());
        note.setLineColor(guiNote.getLineColor());
        note.setLineOpacity(guiNote.getLineOpacity());
        note.setLineWidth(guiNote.getLineWidth());
        note.setRotation(guiNote.getRotation());
        this.saveNote(note, session);
        if (StringUtils.isNotEmpty(note.getRecipientEmail()) && (contacts = (cDao = Context.get(ContactDAO.class)).findByUser(session.getUserId(), note.getRecipientEmail())).isEmpty()) {
            String firstName = note.getRecipient();
            String lastName = null;
            if (firstName.contains(" ")) {
                firstName = firstName.substring(0, note.getRecipient().lastIndexOf(32)).trim();
                lastName = note.getRecipient().substring(note.getRecipient().lastIndexOf(32)).trim();
            }
            Contact contact = new Contact();
            contact.setUserId(session.getUserId());
            contact.setFirstName(firstName);
            contact.setLastName(lastName);
            contact.setEmail(note.getRecipientEmail());
            this.saveContact(contact);
        }
    }

    private void saveNote(DocumentNote note, Session session) throws ServerException {
        try {
            DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
            if (note.getId() == 0L) {
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                dao.store(note, transaction);
            } else {
                dao.store(note);
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    private void saveContact(Contact contact) {
        try {
            ContactDAO cDao = Context.get(ContactDAO.class);
            cDao.store(contact);
        }
        catch (PersistenceException e) {
            log.warn("Error storing new contact {}", (Object)contact.getEmail(), (Object)e);
        }
    }

    public void deleteNotes(List<Long> ids) throws ServerException {
        this.validateSession();
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        for (long id : ids) {
            try {
                dao.delete(id);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public List<GUIDocument> bulkUpdate(List<Long> ids, GUIDocument vo, boolean ignoreEmptyFields) throws ServerException {
        Session session = this.validateSession();
        ArrayList<GUIDocument> updatedDocs = new ArrayList<GUIDocument>();
        for (long docId : ids) {
            try {
                GUIDocument buf = this.bulkUpdateDocument(docId, vo, ignoreEmptyFields, session);
                if (buf == null) continue;
                GUIDocument document = this.save(buf);
                updatedDocs.add(document);
                document.setAccessControlList(vo.getAccessControlList());
                this.saveACL(document);
            }
            catch (ServerException e) {
                log.error(e.getMessage(), e);
            }
        }
        return updatedDocs;
    }

    private GUIDocument bulkUpdateDocument(long docId, GUIDocument model, boolean ignoreEmptyFields, Session session) throws ServerException {
        GUIDocument document = this.getById(docId);
        if (document.getImmutable() == 1 || document.getStatus() != DocumentStatus.UNLOCKED.ordinal()) {
            log.warn("Skip document {} because immutable or locked", (Object)docId);
            return null;
        }
        try {
            this.checkPermission(Permission.WRITE, session.getUser(), document.getFolder().getId());
        }
        catch (AccessDeniedException e) {
            log.warn("Skip document {} because  user {} does not have write permission", (Object)docId, (Object)session.getUsername());
            return null;
        }
        document.setComment(HTMLSanitizer.sanitizeSimpleText(model.getComment() != null ? model.getComment() : ""));
        if (model.getPublished() > -1) {
            document.setPublished(model.getPublished());
        }
        if (model.getStartPublishing() != null) {
            document.setStartPublishing(model.getStartPublishing());
        }
        if (model.getStopPublishing() != null) {
            document.setStopPublishing(model.getStopPublishing());
        }
        if (StringUtils.isNotEmpty(model.getLanguage())) {
            document.setLanguage(model.getLanguage());
        }
        if (StringUtils.isNotEmpty(model.getColor())) {
            document.setColor(model.getColor());
        }
        document.setTags(model.getTags());
        if (model.getTemplateId() != null) {
            document.setTemplateId(model.getTemplateId());
        }
        this.setOcrTemplate(model, ignoreEmptyFields, document);
        this.setBarcodeTemplate(model, ignoreEmptyFields, document);
        this.setExtendedAttributes(model, ignoreEmptyFields, document);
        return document;
    }

    private void setExtendedAttributes(GUIDocument model, boolean ignoreEmptyFields, GUIDocument document) {
        if (model.getAttributes().isEmpty()) {
            return;
        }
        if (ignoreEmptyFields) {
            HashMap<String, GUIAttribute> attributes = new HashMap<String, GUIAttribute>();
            for (GUIAttribute att : document.getAttributes()) {
                attributes.put(att.getName(), att);
            }
            for (GUIAttribute att : model.getAttributes()) {
                if (att.getValue() == null || !StringUtils.isNotEmpty(att.getValue().toString())) continue;
                attributes.put(att.getName(), att);
            }
            document.setAttributes(attributes.values().stream().toList());
        } else {
            document.setAttributes(model.getAttributes());
        }
    }

    private void setBarcodeTemplate(GUIDocument model, boolean ignoreEmptyFields, GUIDocument document) {
        if (model.getBarcodeTemplateId() != null) {
            document.setBarcodeTemplateId(model.getBarcodeTemplateId());
        } else if (!ignoreEmptyFields) {
            document.setBarcodeTemplateId(null);
        }
    }

    private void setOcrTemplate(GUIDocument model, boolean ignoreEmptyFields, GUIDocument document) {
        if (model.getOcrTemplateId() != null) {
            document.setOcrTemplateId(model.getOcrTemplateId());
        } else if (!ignoreEmptyFields) {
            document.setOcrTemplateId(null);
        }
    }

    protected static void checkPublished(User user, Document doc) throws PermissionException {
        if (!(user.isMemberOf("admin") || user.isMemberOf("publisher") || doc.isPublishing())) {
            throw new PermissionException("Document not published");
        }
    }

    public void updateNote(long docId, long noteId, String fileVersion, String message) throws ServerException {
        Session session = this.validateSession();
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document document = docDao.findDocument(docId);
            if (document == null) {
                throw new ServerException("Unexisting document " + docId);
            }
            DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
            DocumentNote note = (DocumentNote)dao.findById(noteId);
            if (note == null) {
                note = new DocumentNote();
                note.setTenantId(session.getTenantId());
                note.setDocId(document.getId());
                note.setUserId(session.getUserId());
                note.setUsername(session.getUser().getFullName());
                note.setColor(null);
            }
            note.setFileName(document.getFileName());
            note.setFileVersion(StringUtils.defaultIfEmpty(fileVersion, document.getFileVersion()));
            note.setMessage(message);
            note.setUserId(session.getUser().getId());
            note.setUsername(session.getUser().getFullName());
            note.setMessage(message);
            this.saveNote(note, session);
        }
        catch (PersistenceException | ServerException e) {
            this.throwServerException(session, log, e);
        }
    }

    public GUIDocument deleteVersions(List<Long> ids) throws ServerException {
        Session session = this.validateSession();
        long docId = 0L;
        DocumentManager manager = Context.get(DocumentManager.class);
        for (long id : ids) {
            Version version;
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            try {
                version = manager.deleteVersion(id, transaction);
            }
            catch (Exception e) {
                return (GUIDocument)this.throwServerException(session, log, e);
            }
            docId = version.getDocId();
        }
        return this.getById(docId);
    }

    public GUIDocument createWithContent(GUIDocument vo, String content, boolean checkout) throws ServerException {
        Session session = this.validateSession();
        try {
            DocumentManager documentManager = Context.get(DocumentManager.class);
            FolderDAO fdao = Context.get(FolderDAO.class);
            if (!fdao.isWriteAllowed(vo.getFolder().getId(), session.getUserId())) {
                throw new PermissionException(session.getUsername(), "Folder " + vo.getFolder().getId(), Permission.WRITE);
            }
            Document doc = DocumentServiceImpl.toDocument(vo);
            doc.setId(0L);
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setEvent(DocumentEvent.STORED);
            Document document = StringUtils.isEmpty(content) ? (Document)documentManager.create(IOUtils.toInputStream(" ", StandardCharsets.UTF_8), doc, transaction).getObject() : (Document)documentManager.create(IOUtils.toInputStream(content, StandardCharsets.UTF_8), doc, transaction).getObject();
            if (checkout) {
                transaction = new DocumentHistory();
                transaction.setSession(session);
                documentManager.checkout(document.getId(), transaction);
            }
            return this.fromDocument(document, vo.getFolder(), null);
        }
        catch (PersistenceException | PermissionException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public void deleteFromTrash(List<Long> ids) throws ServerException {
        Session session = this.validateSession();
        if (ids.isEmpty()) {
            return;
        }
        String idsStr = Arrays.asList(ids).toString().replace('[', '(').replace(']', ')');
        try {
            Context.get(DocumentDAO.class).jdbcUpdate("update ld_document set ld_deleted=2 where ld_id in " + idsStr);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void emptyTrash() throws ServerException {
        Session session = this.validateSession();
        try {
            Context.get(DocumentDAO.class).jdbcUpdate("update ld_document set ld_deleted=2 where ld_deleted=1 and  ld_deleteuserid=" + session.getUserId());
            Context.get(FolderDAO.class).jdbcUpdate("update ld_folder set ld_deleted=2 where ld_deleted=1 and  ld_deleteuserid=" + session.getUserId());
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void archiveDocuments(List<Long> docIds, String comment) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        try {
            manager.archiveDocuments(docIds.stream().collect(Collectors.toSet()), transaction);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public long archiveFolder(long folderId, String comment) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setComment(HTMLSanitizer.sanitizeSimpleText(comment));
        try {
            return manager.archiveFolder(folderId, transaction);
        }
        catch (PersistenceException e) {
            return (Long)this.throwServerException(session, log, e);
        }
    }

    public void unarchiveDocuments(List<Long> docIds) throws ServerException {
        Session session = this.validateSession();
        DocumentDAO dao = Context.get(DocumentDAO.class);
        for (long id : docIds) {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            try {
                dao.unarchive(id, transaction);
            }
            catch (PersistenceException e) {
                this.throwServerException(session, log, e);
            }
        }
    }

    public long countDocuments(List<Long> folderIds, int status) throws ServerException {
        this.validateSession();
        long count = 0L;
        for (long folderId : folderIds) {
            count += this.countDocuments(folderId, status);
        }
        return count;
    }

    private long countDocuments(long folderId, int status) {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        FolderDAO fdao = Context.get(FolderDAO.class);
        List<Long> childrenFolderIds = fdao.findIdsByParentId(folderId);
        childrenFolderIds = new ArrayList<Long>(childrenFolderIds);
        childrenFolderIds.add(folderId);
        StringBuilder query = new StringBuilder("select count(ld_id) from ld_document where ld_deleted=0 and ld_status=" + status);
        query.append(" and ld_folderid in (" + childrenFolderIds.toString().substring(1).replace("]", ")"));
        try {
            return dao.queryForLong(query.toString());
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return 0L;
        }
    }

    public List<String> createDownloadTicket(long docId, int type, String suffix, Integer expireHours, Date expireDate, Integer maxDownloads, Integer maxViews) throws ServerException {
        Session session = this.validateSession();
        Object urlPrefix = "";
        HttpServletRequest request = this.getThreadLocalRequest();
        if (request != null) {
            urlPrefix = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        }
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        try {
            Ticket ticket = new Ticket();
            ticket.setTenantId(session.getTenantId());
            ticket.setType(type);
            ticket.setDocId(docId);
            ticket.setSuffix(suffix);
            ticket.setExpireHours(expireHours);
            ticket.setExpired(expireDate);
            ticket.setMaxCount(maxDownloads);
            ticket.setMaxViews(maxViews);
            ticket = manager.createTicket(ticket, transaction);
            ArrayList<String> result = new ArrayList<String>();
            result.add(ticket.getTicketId());
            result.add(ticket.getUrl());
            result.add(new URI(ticket.getUrl().replace((CharSequence)urlPrefix, Context.get().getProperties().getProperty("server.url"))).normalize().toString());
            return result;
        }
        catch (PersistenceException | PermissionException | URISyntaxException e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public void setPassword(long docId, String password) throws ServerException {
        Session session = this.validateSession();
        DocumentDAO dao = Context.get(DocumentDAO.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setComment("");
        try {
            Document doc = (Document)dao.findById(docId);
            this.checkPermission(Permission.PASSWORD, session.getUser(), doc.getFolder().getId());
            dao.setPassword(docId, password, transaction);
        }
        catch (PersistenceException | AccessDeniedException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void unsetPassword(long docId, String currentPassword) throws ServerException {
        Session session = this.validateSession();
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setComment("");
        DocumentDAO dao = Context.get(DocumentDAO.class);
        try {
            Document doc = dao.findDocument(docId);
            if (!session.getUser().isMemberOf("admin") && !doc.isGranted(currentPassword)) {
                throw new ServerException("You cannot access the document");
            }
            dao.unsetPassword(docId, transaction);
        }
        catch (PersistenceException | ServerException e) {
            this.throwServerException(session, log, e);
        }
    }

    public boolean unprotect(long docId, String password) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        return manager.unprotect(session.getSid(), docId, password);
    }

    public String getContentAsString(long docId) throws ServerException {
        Session session = this.validateSession();
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document doc = (Document)docDao.findById(docId);
            if (doc == null) {
                throw new ServerException(UNEXISTING_DOCUMENT);
            }
            FolderDAO fDao = Context.get(FolderDAO.class);
            if (!fDao.isDownloadllowed(doc.getFolder().getId(), session.getUserId())) {
                throw new IOException("You don't have the DOWNLOAD permission");
            }
            if (doc.getDocRef() != null) {
                doc = (Document)docDao.findById(doc.getDocRef());
            }
            Store store = Context.get(Store.class);
            String resource = store.getResourceName(doc, null, null);
            return store.getString(doc.getId(), resource);
        }
        catch (PersistenceException | ServerException | IOException e) {
            return (String)this.throwServerException(session, log, e);
        }
    }

    public GUIDocument checkinContent(long docId, String content) throws ServerException {
        Session session = this.validateSession();
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document doc = docDao.findDocument(docId);
            if (doc == null) {
                throw new ServerException(UNEXISTING_DOCUMENT);
            }
            docDao.isWriteAllowed(docId, session.getUserId());
            if (doc.getStatus() != DocumentStatus.CHECKEDOUT || doc.getLockUserId().longValue() != session.getUserId()) {
                throw new PermissionException("You have not checked out the file " + docId);
            }
            DocumentHistory transaction = new DocumentHistory();
            transaction.setComment("Text content editing");
            transaction.setSession(session);
            DocumentManager manager = Context.get(DocumentManager.class);
            manager.checkin(docId, IOUtils.toInputStream(content, StandardCharsets.UTF_8), doc.getFileName(), false, null, transaction);
            return this.getById(docId);
        }
        catch (PersistenceException | PermissionException | ServerException | IOException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public void replaceFile(long docId, String fileVersion, String comment) throws ServerException {
        Session session = this.validateSession();
        Map<String, File> uploadedFilesMap = this.getUploadedFiles(session.getSid());
        File file = uploadedFilesMap.values().iterator().next();
        if (file == null) {
            return;
        }
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document doc = docDao.findDocument(docId);
            if (doc == null) {
                throw new ServerException(UNEXISTING_DOCUMENT);
            }
            docDao.isWriteAllowed(docId, session.getUserId());
            if (doc.getStatus() != DocumentStatus.UNLOCKED) {
                throw new IOException("The document is locked");
            }
            DocumentHistory transaction = new DocumentHistory();
            transaction.setComment(HTMLSanitizer.sanitizeSimpleText(comment));
            transaction.setSession(session);
            DocumentManager manager = Context.get(DocumentManager.class);
            manager.replaceFile(doc.getId(), fileVersion, file, transaction);
            UploadServlet.cleanUploads(session.getSid());
        }
        catch (PersistenceException | ServerException | IOException e) {
            this.throwServerException(session, log, e);
        }
    }

    public GUIDocument createDocument(GUIDocument document, String content) throws ServerException {
        Session session = this.validateSession();
        try {
            FolderDAO fDao = Context.get(FolderDAO.class);
            if (!fDao.isWriteAllowed(document.getFolder().getId(), session.getUserId())) {
                throw new IOException("You don't have the WRITE permission");
            }
            DocumentHistory transaction = new DocumentHistory();
            transaction.setComment("Text content creation");
            transaction.setSession(session);
            DocumentManager manager = Context.get(DocumentManager.class);
            Document doc = (Document)manager.create(IOUtils.toInputStream(content, StandardCharsets.UTF_8), DocumentServiceImpl.toDocument(document), transaction).getObject();
            return this.getById(doc.getId());
        }
        catch (PersistenceException | ServerException | IOException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public GUIRating getUserRating(long docId) throws ServerException {
        Session session = this.validateSession();
        RatingDAO rDao = Context.get(RatingDAO.class);
        try {
            GUIRating rating = null;
            Rating rat = rDao.findByDocIdAndUserId(docId, session.getUserId());
            if (rat != null) {
                rDao.initialize(rat);
                rating = new GUIRating();
                rating.setId(rat.getId());
                rating.setDocId(docId);
                rating.setUserId(session.getUserId());
                rating.setUsername(session.getUser().getFullName());
                rating.setVote(rat.getVote());
                rating.setAverage(rat.getAverage());
            }
            return rating;
        }
        catch (PersistenceException e) {
            return (GUIRating)this.throwServerException(session, log, e);
        }
    }

    public Integer deleteRating(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            RatingDAO rDao = Context.get(RatingDAO.class);
            Rating rat = (Rating)rDao.findById(id);
            if (rat == null) {
                return 0;
            }
            if (rat.getUserId() != session.getUserId()) {
                throw new ServerException("Cannot delete the rating left by another user");
            }
            rDao.delete(id);
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document doc = (Document)docDao.findById(rat.getDocId());
            return doc.getRating();
        }
        catch (PersistenceException | ServerException e) {
            return (Integer)this.throwServerException(session, log, e);
        }
    }

    public GUIDocument convert(long docId, String fileVersion, String format) throws ServerException {
        Session session = this.validateSession();
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document doc = (Document)docDao.findById(docId);
            if (doc == null) {
                throw new ServerException(UNEXISTING_DOCUMENT);
            }
            FolderDAO fDao = Context.get(FolderDAO.class);
            if (!fDao.isWriteAllowed(doc.getFolder().getId(), session.getUserId())) {
                throw new PermissionException(session.getUsername(), DOCUMENT_STR + doc.getId(), Permission.WRITE);
            }
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            FormatConverterManager manager = Context.get(FormatConverterManager.class);
            Document conversion = manager.convert(doc, fileVersion, format, transaction);
            if (conversion == null) {
                throw new ServerException("Unable to convert");
            }
            return this.getById(conversion.getId());
        }
        catch (Exception e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public GUIEmail extractEmail(long docId, String fileVersion) throws ServerException {
        Session session = this.validateSession();
        DocumentDAO dao = Context.get(DocumentDAO.class);
        Document emailDocument = null;
        try {
            emailDocument = dao.findDocument(docId);
            if (!emailDocument.getFileName().toLowerCase().endsWith(".eml") && !emailDocument.getFileName().toLowerCase().endsWith(".msg")) {
                throw new ServerException("Not an email file");
            }
        }
        catch (PersistenceException e1) {
            return (GUIEmail)this.throwServerException(session, log, e1);
        }
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(docId, fileVersion, null);
        GUIDocument guiDocument = this.getById(docId);
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (InputStream is = store.getStream(emailDocument.getId(), resource);){
                GUIEmail guiMail = new GUIEmail();
                EMail email = this.readEmail(is, emailDocument.getId(), guiDocument);
                if (email != null) {
                    if (email.getFrom() != null) {
                        guiMail.setFrom(new GUIContact(email.getFrom().getName(), null, email.getFrom().getAddress()));
                    }
                    guiMail.setSent(email.getSentDate());
                    guiMail.setReceived(email.getReceivedDate() != null ? email.getReceivedDate() : emailDocument.getCreation());
                    guiMail.setSubject(email.getSubject());
                    guiMail.setMessage(email.isHtml() ? HTMLSanitizer.sanitize(email.getMessageText()) : email.getMessageText());
                    guiMail.setSigned(email.isSigned());
                    this.setEmailRecipients(email, guiMail);
                    this.setEmailAttachments(guiDocument, email, guiMail);
                }
                return guiMail;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            return (GUIEmail)this.throwServerException(session, log, e1);
        }
    }

    private EMail readEmail(InputStream is, long docId, GUIDocument emailDocument) {
        EMail email = null;
        try {
            email = emailDocument.getFileName().toLowerCase().endsWith(".eml") ? MailUtil.messageToMail(is, true) : MailUtil.msgToMail(is, true);
        }
        catch (MessagingException | IOException | CMSException e) {
            log.warn("Cannot render the email document {}", (Object)docId);
        }
        return email;
    }

    private void setEmailAttachments(GUIDocument emailDocument, EMail email, GUIEmail guiMail) {
        ArrayList<GUIDocument> attachments = new ArrayList<GUIDocument>();
        int i = 1;
        while (i <= email.getAttachmentsCount()) {
            EMailAttachment att = email.getAttachment(i);
            GUIDocument d = new GUIDocument();
            d.setFileName(att.getFileName());
            d.setFileSize(att.getSize());
            d.setIcon(IconSelector.selectIcon(att.getFileName()));
            d.setFolder(emailDocument.getFolder());
            attachments.add(d);
            ++i;
        }
        guiMail.setAttachments(attachments);
    }

    private void setEmailRecipients(EMail email, GUIEmail guiMail) {
        Set<Recipient> recipients = email.getRecipients();
        ArrayList<GUIContact> contacts = new ArrayList<GUIContact>();
        for (Recipient rec : recipients) {
            contacts.add(new GUIContact(rec.getName(), null, rec.getAddress()));
        }
        guiMail.setTos(contacts);
        recipients = email.getRecipientsCC();
        contacts = new ArrayList();
        for (Recipient rec : recipients) {
            contacts.add(new GUIContact(rec.getName(), null, rec.getAddress()));
        }
        guiMail.setCcs(contacts);
        recipients = email.getRecipientsBCC();
        contacts = new ArrayList();
        for (Recipient rec : recipients) {
            contacts.add(new GUIContact(rec.getName(), null, rec.getAddress()));
        }
        guiMail.setBccs(contacts);
        recipients = email.getReplyTo();
        contacts = new ArrayList();
        for (Recipient rec : recipients) {
            contacts.add(new GUIContact(rec.getName(), null, rec.getAddress()));
        }
        guiMail.setReplyTo(contacts);
    }

    public GUIDocument saveEmailAttachment(long docId, String fileVersion, String attachmentFileName) throws ServerException {
        GUIDocument gUIDocument;
        Session session = this.validateSession();
        InputStream is = null;
        File tmp = null;
        try {
            tmp = FileUtil.createTempFile("attcopy", null);
            GUIDocument doc = this.getById(docId);
            if (!doc.getFileName().toLowerCase().endsWith(".eml") && !doc.getFileName().toLowerCase().endsWith(".msg")) {
                throw new ServerException("Not an email file");
            }
            this.checkPermission(Permission.WRITE, session.getUser(), doc.getFolder().getId());
            Store store = Context.get(Store.class);
            String resource = store.getResourceName(docId, fileVersion, null);
            is = store.getStream(docId, resource);
            EMail email = MailUtil.messageToMail(is, true);
            EMailAttachment attachment = null;
            if (email.getAttachments().size() > 0) {
                for (EMailAttachment att : email.getAttachments().values()) {
                    if (!attachmentFileName.equals(att.getFileName())) continue;
                    attachment = att;
                    break;
                }
            }
            if (attachment == null) {
                throw new IOException("Attachment not found");
            }
            FileUtils.writeByteArrayToFile(tmp, attachment.getData());
            DocumentManager manager = Context.get(DocumentManager.class);
            FolderDAO fDao = Context.get(FolderDAO.class);
            Document docVO = new Document();
            docVO.setFileName(attachmentFileName);
            docVO.setFileSize(attachment.getSize());
            docVO.setFolder((Folder)fDao.findById(doc.getFolder().getId()));
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            Document d = (Document)manager.create(tmp, docVO, transaction).getObject();
            gUIDocument = this.getById(d.getId());
            IOUtils.closeQuietly(is);
        }
        catch (PersistenceException | MessagingException | IOException e) {
            GUIDocument gUIDocument2 = (GUIDocument)this.throwServerException(session, log, e);
            return gUIDocument2;
        }
        finally {
            IOUtils.closeQuietly(is);
            FileUtil.delete(tmp);
        }
        FileUtil.delete(tmp);
        return gUIDocument;
    }

    public GUIDocument replaceAlias(long aliasId) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        try {
            Document doc = (Document)manager.replaceAlias(aliasId, transaction).getObject();
            return this.getDocument(session, doc.getId());
        }
        catch (PersistenceException | PermissionException | InvalidSessionServerException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public void deDuplicate(Long folderId, boolean retainNewest) throws ServerException {
        final Session session = this.validateSession();
        this.checkMenu(this.getThreadLocalRequest(), 90L);
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            List<String> digests = docDao.findDuplicatedDigests(session.getTenantId(), folderId);
            log.info("Found {} duplicated digests", (Object)digests.size());
            StringBuilder duplicationsQuery = new StringBuilder("select ld_id, ld_digest, ld_date, ld_folderid, ld_filename, ld_version from ld_document where ld_deleted=0 ");
            duplicationsQuery.append(" and ld_tenantid = ");
            duplicationsQuery.append(Long.toString(session.getTenantId()));
            duplicationsQuery.append(" and ld_docref is null and ld_digest in ('");
            duplicationsQuery.append(String.join((CharSequence)"','", digests));
            duplicationsQuery.append("') order by ld_digest asc, ld_date ");
            if (retainNewest) {
                duplicationsQuery.append(" desc ");
            } else {
                duplicationsQuery.append(" asc ");
            }
            final FolderDAO folderDao = Context.get(FolderDAO.class);
            List<Document> duplications = docDao.query(duplicationsQuery.toString(), new RowMapper<Document>(){

                public Document mapRow(ResultSet rs, int rowNum) throws SQLException {
                    Document doc = new Document();
                    doc.setTenantId(session.getTenantId());
                    doc.setId(rs.getLong(1));
                    doc.setDigest(rs.getString(2));
                    doc.setDate(new Date(rs.getTimestamp(3).getTime()));
                    doc.setFileName(rs.getString(5));
                    doc.setVersion(rs.getString(6));
                    Folder folder = new Folder();
                    folder.setId(rs.getLong(4));
                    folder.setTenantId(session.getTenantId());
                    doc.setFolder(folder);
                    try {
                        folder.setPathExtended(folderDao.computePathExtended(folder.getId()));
                    }
                    catch (PersistenceException e) {
                        log.error(e.getMessage(), e);
                    }
                    return doc;
                }
            }, null);
            log.info("Found {} duplicated files to deduplicate", (Object)duplications.size());
            ArrayList<Document> currentDuplications = new ArrayList<Document>();
            String currentDigest = null;
            for (Document doc : duplications) {
                if (currentDigest != null && !currentDigest.equals(doc.getDigest())) {
                    this.deduplicateDocuments(session, currentDuplications);
                }
                currentDuplications.add(doc);
                currentDigest = doc.getDigest();
            }
            if (!currentDuplications.isEmpty()) {
                this.deduplicateDocuments(session, currentDuplications);
            }
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    private void deduplicateDocuments(Session session, List<Document> duplications) throws PersistenceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document maintainedDoc = (Document)docDao.findById(duplications.get(0).getId());
        log.info("Process digest {}, retain document {} dated {}", maintainedDoc.getDigest(), maintainedDoc, maintainedDoc.getDate());
        duplications.remove(0);
        log.debug("Delete {} documents", (Object)duplications.size());
        for (Document doc : duplications) {
            if (doc.getId() == maintainedDoc.getId()) continue;
            doc.setDeleted(1);
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setDocument(doc);
            transaction.setComment("Deleted by deduplication");
            transaction.setEvent(DocumentEvent.DELETED);
            transaction.setFilename(doc.getFileName());
            transaction.setVersion(doc.getVersion());
            transaction.setFileVersion(doc.getFileVersion());
            transaction.setPath(doc.getFolder().getPathExtended());
            docDao.delete(doc.getId(), transaction);
        }
        FolderDAO fDao = Context.get(FolderDAO.class);
        DocumentManager manager = Context.get(DocumentManager.class);
        for (Document duplicate : duplications) {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setComment("Created by deduplication");
            Document alias = manager.createAlias(maintainedDoc, (Folder)fDao.findById(duplicate.getFolder().getId()), null, transaction);
            log.info("Created new alias {}", (Object)alias);
        }
        duplications.clear();
    }

    public void deleteTicket(long ticketId) throws ServerException {
        Session session = this.validateSession();
        TicketDAO dao = Context.get(TicketDAO.class);
        try {
            dao.delete(ticketId);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void enableTicket(long ticketId) throws ServerException {
        Session session = this.validateSession();
        TicketDAO dao = Context.get(TicketDAO.class);
        try {
            Ticket ticket = (Ticket)dao.findById(ticketId);
            ticket.setEnabled(1);
            dao.store(ticket);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void disableTicket(long ticketId) throws ServerException {
        Session session = this.validateSession();
        TicketDAO dao = Context.get(TicketDAO.class);
        try {
            Ticket ticket = (Ticket)dao.findById(ticketId);
            ticket.setEnabled(0);
            dao.store(ticket);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void enforceFilesIntoFolderStore(long folderId) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Enforce Files Into Folder Store", () -> {
            User user = session.getUser();
            DocumentManager manager = Context.get(DocumentManager.class);
            int movedFiles = 0;
            FolderDAO fDao = Context.get(FolderDAO.class);
            String treePath = null;
            try {
                treePath = fDao.computePathExtended(folderId);
                DocumentHistory transaction = new DocumentHistory();
                transaction.setSession(session);
                movedFiles = manager.enforceFilesIntoFolderStore(folderId, transaction);
                log.info("Notify the move of {} files to the right store in the tree {}", (Object)movedFiles, (Object)treePath);
                this.notifyEnforcement(session, I18N.message("enforcementofstoragereport", user.getLocale(), new Object[]{movedFiles, treePath}));
            }
            catch (Exception t) {
                log.error("Error enforcing files store into tree {}", (Object)treePath);
                log.error(t.getMessage(), t);
                try {
                    this.notifyEnforcement(session, I18N.message("enforcementofstorageerror", user.getLocale(), new Object[]{movedFiles, treePath, t.getMessage()}));
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            }
            return null;
        }, session);
    }

    private void notifyEnforcement(Session session, String message) {
        User user = session.getUser();
        Recipient sysRecipient = new Recipient();
        sysRecipient.setName(user.getUsername());
        sysRecipient.setAddress(user.getEmail());
        sysRecipient.setType(0);
        sysRecipient.setMode(MESSAGE);
        SystemMessage sys = new SystemMessage();
        sys.setTenantId(user.getTenantId());
        sys.setType(0);
        sys.setHtml(0);
        sys.setAuthor("SYSTEM");
        sys.setSentDate(new Date());
        sys.setNotify(true);
        sys.getRecipients().add(sysRecipient);
        sys.setMessageText(message);
        sys.setSubject(I18N.message("enforcementofstorage", user.getLocale()));
        try {
            SystemMessageDAO sDao = Context.get(SystemMessageDAO.class);
            sDao.store(sys);
            Recipient emailRecipient = new Recipient();
            emailRecipient.setName(user.getUsername());
            emailRecipient.setAddress(user.getEmail());
            emailRecipient.setType(1);
            emailRecipient.setMode("TO");
            emailRecipient.setRead(1);
            EMail mail = new EMail();
            mail.setHtml(0);
            mail.setTenantId(user.getTenantId());
            mail.setAccountId(-1L);
            mail.setAuthor(user.getUsername());
            mail.setAuthorAddress(user.getEmail());
            mail.setFolder(OUTBOX);
            mail.setSentDate(new Date());
            mail.setUsername(user.getUsername());
            mail.getRecipients().add(emailRecipient);
            mail.setSubject(sys.getSubject());
            mail.setMessageText(message);
            EMailSender sender = DocumentServiceImpl.getEmailSender(session);
            sender.send(mail);
        }
        catch (PersistenceException | MessagingException e) {
            log.warn(e.getMessage(), e);
        }
    }

    public GUIDocument merge(List<Long> docIds, long targetFolderId, String fileName) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        try {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            ArrayList<Document> docs = new ArrayList<Document>();
            for (long docId : docIds) {
                docs.add(docDao.findDocument(docId));
            }
            Document doc = (Document)manager.merge(docs, targetFolderId, (String)(fileName.toLowerCase().endsWith(".pdf") ? fileName : fileName + ".pdf"), transaction).getObject();
            return this.getDocument(session, doc.getId());
        }
        catch (PersistenceException | PermissionException | InvalidSessionServerException | IOException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    public int updatePages(long docId) throws ServerException {
        Session session = this.validateSession();
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Document doc = docDao.findDocument(docId);
            if (doc != null) {
                docDao.initialize(doc);
                int pages = manager.countPages(doc);
                doc.setPages(pages);
                return pages;
            }
            return 1;
        }
        catch (PersistenceException e) {
            return (Integer)this.throwServerException(session, log, e);
        }
    }

    public GUIDocument rename(long documentId, String name) throws ServerException {
        Session session = this.validateSession();
        User user = session.getUser();
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Document doc = (Document)docDao.findById(documentId);
            this.checkPermission(Permission.RENAME, user, doc.getFolder().getId());
            DocumentServiceImpl.checkPublished(user, doc);
            DocumentManager manager = Context.get(DocumentManager.class);
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            transaction.setUser(user);
            manager.rename(documentId, name, transaction);
            return this.getDocument(session, documentId);
        }
        catch (PersistenceException | PermissionException | AccessDeniedException | InvalidSessionServerException e) {
            return (GUIDocument)this.throwServerException(session, log, e);
        }
    }

    private String prepareTileAsString(Session session, Document doc) {
        Object tile;
        block6: {
            tile = null;
            File tileFile = null;
            try {
                try {
                    tileFile = this.createTile(doc, session.getSid());
                    tile = ImageUtil.encode(tileFile);
                    if (tile != null) {
                        tile = "data:image/png;base64," + (String)tile;
                    }
                }
                catch (IOException e) {
                    log.warn("Cannot generate tile of document {}", (Object)doc, (Object)e);
                    FileUtil.delete(tileFile);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(tileFile);
                throw throwable;
            }
            FileUtil.delete(tileFile);
        }
        return tile;
    }

    static void setEmailSender(EMailSender emailSender) {
        DocumentServiceImpl.emailSender = emailSender;
    }

    private int booleanToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    public void saveACL(GUIDocument guiDocument) throws ServerException {
        Session session = this.validateSession();
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Document document = (Document)docDao.findById(guiDocument.getId());
            docDao.initialize(document);
            log.info("Applying {} security policies to document {}", (Object)guiDocument.getAccessControlList().size(), (Object)guiDocument.getId());
            HashSet<DocumentAccessControlEntry> acl = new HashSet<DocumentAccessControlEntry>();
            for (GUIAccessControlEntry guiAce : guiDocument.getAccessControlList()) {
                DocumentAccessControlEntry ace = new DocumentAccessControlEntry();
                ace.setGroupId(guiAce.getEntityId());
                ace.setRead(this.booleanToInt(guiAce.isRead()));
                ace.setPreview(this.booleanToInt(guiAce.isPreview()));
                ace.setPrint(this.booleanToInt(guiAce.isPrint()));
                ace.setWrite(this.booleanToInt(guiAce.isWrite()));
                ace.setSecurity(this.booleanToInt(guiAce.isSecurity()));
                ace.setImmutable(this.booleanToInt(guiAce.isImmutable()));
                ace.setDelete(this.booleanToInt(guiAce.isDelete()));
                ace.setRename(this.booleanToInt(guiAce.isRename()));
                ace.setArchive(this.booleanToInt(guiAce.isArchive()));
                ace.setWorkflow(this.booleanToInt(guiAce.isWorkflow()));
                ace.setSign(this.booleanToInt(guiAce.isSign()));
                ace.setDownload(this.booleanToInt(guiAce.isDownload()));
                ace.setCalendar(this.booleanToInt(guiAce.isCalendar()));
                ace.setSubscription(this.booleanToInt(guiAce.isSubscription()));
                ace.setPassword(this.booleanToInt(guiAce.isPassword()));
                ace.setMove(this.booleanToInt(guiAce.isMove()));
                ace.setEmail(this.booleanToInt(guiAce.isEmail()));
                ace.setAutomation(this.booleanToInt(guiAce.isAutomation()));
                ace.setReadingreq(this.booleanToInt(guiAce.isReadingreq()));
                ace.setCustomid(this.booleanToInt(guiAce.isCustomid()));
                ace.setRevision(this.booleanToInt(guiAce.isRevision()));
                acl.add(ace);
            }
            document.getAccessControlList().clear();
            document.getAccessControlList().addAll(acl);
            DocumentHistory history = new DocumentHistory();
            history.setEvent(DocumentEvent.PERMISSION);
            history.setSession(session);
            docDao.store(document, history);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public void applyParentFolderSecurity(long docId) throws ServerException {
        Session session = this.validateSession();
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSession(session);
            docDao.applyParentFolderSecurity(docId, transaction);
        }
        catch (PersistenceException e) {
            this.throwServerException(session, log, e);
        }
    }

    public GUIAccessControlEntry getAllowedPermissions(List<Long> docIds) throws ServerException {
        Session session = this.validateSession();
        try {
            Set<Permission> commonPermissions = Permission.all();
            if (!session.getUser().isAdmin()) {
                DocumentDAO docDao = Context.get(DocumentDAO.class);
                for (long docId : docIds) {
                    Set<Permission> docPermissions = docDao.getAllowedPermissions(docId, session.getUserId());
                    for (Permission permission : Permission.all()) {
                        if (docPermissions.contains((Object)permission)) continue;
                        commonPermissions.remove((Object)permission);
                    }
                }
            }
            return new GUIAccessControlEntry(commonPermissions.stream().map(p -> p.name().toLowerCase()).collect(Collectors.toSet()).toArray(new String[0]));
        }
        catch (PersistenceException e) {
            return (GUIAccessControlEntry)this.throwServerException(session, log, e);
        }
    }
}

