/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.dashlet.Dashlet;
import com.logicaldoc.core.dashlet.DashletDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIDashlet;
import com.logicaldoc.gui.frontend.client.services.DashletService;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashletServiceImpl
extends AbstractRemoteService
implements DashletService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DashletServiceImpl.class);

    public void save(GUIDashlet guiDashlet) throws ServerException {
        Session session = this.validateSession();
        this.checkMenu(this.getThreadLocalRequest(), 7L);
        try {
            DashletDAO dao = Context.get(DashletDAO.class);
            Dashlet dashlet = dao.findByName(guiDashlet.getName(), session.getTenantId());
            if (dashlet == null) {
                dashlet = this.toDashlet(guiDashlet);
                dashlet.setId(0L);
            }
            dashlet.setContent(guiDashlet.getContent());
            dashlet.setMax(guiDashlet.getMax());
            dashlet.setColumns(guiDashlet.getColumns());
            dashlet.setUnique(guiDashlet.isUnique() ? 1 : 0);
            dashlet.setQuery(guiDashlet.getQuery());
            dashlet.setTitle(guiDashlet.getTitle());
            dashlet.setType(guiDashlet.getType());
            dao.store(dashlet);
        }
        catch (Exception e) {
            this.throwServerException(session, log, e);
        }
    }

    public void saveDashlets(List<GUIDashlet> dashlets) throws ServerException {
        for (GUIDashlet guiDashlet : dashlets) {
            this.save(guiDashlet);
        }
    }

    public List<GUIDashlet> loadDashlets() throws ServerException {
        Session session = this.validateSession();
        try {
            DashletDAO dao = Context.get(DashletDAO.class);
            List dashlets = dao.findAll(session.getTenantId());
            ArrayList<GUIDashlet> guiDashlets = new ArrayList<GUIDashlet>();
            for (Dashlet dashlet : dashlets) {
                guiDashlets.add(this.fromDashlet(dashlet));
            }
            return guiDashlets;
        }
        catch (Exception e) {
            return (List)this.throwServerException(session, log, e);
        }
    }

    public GUIDashlet get(long dashletId) throws ServerException {
        Session session = this.validateSession();
        try {
            DashletDAO dao = Context.get(DashletDAO.class);
            Dashlet dashlet = (Dashlet)dao.findById(dashletId);
            if (dashlet == null) {
                throw new ServerException("Unexisting dashlet " + dashletId);
            }
            return this.fromDashlet(dashlet);
        }
        catch (Exception e) {
            return (GUIDashlet)this.throwServerException(session, log, e);
        }
    }

    public GUIDashlet get(String name) throws ServerException {
        Session session = this.validateSession();
        try {
            DashletDAO dao = Context.get(DashletDAO.class);
            Dashlet dashlet = dao.findByName(name, session.getTenantId());
            if (dashlet == null) {
                throw new ServerException("Unexisting dashlet " + name);
            }
            return this.fromDashlet(dashlet);
        }
        catch (Exception e) {
            return (GUIDashlet)this.throwServerException(session, log, e);
        }
    }

    public void delete(long dashletId) throws ServerException {
        Session session = this.validateSession();
        this.checkMenu(this.getThreadLocalRequest(), 7L);
        try {
            DashletDAO dao = Context.get(DashletDAO.class);
            dao.delete(dashletId);
        }
        catch (Exception e) {
            this.throwServerException(session, log, e);
        }
    }

    public void saveUserDashlets(List<GUIDashlet> dashlets) throws ServerException {
        Session session = this.validateSession();
        GenericDAO gDao = Context.get(GenericDAO.class);
        UserDAO uDao = Context.get(UserDAO.class);
        try {
            Map<String, Generic> settings = uDao.findUserSettings(session.getUserId(), "dashlet");
            for (Generic setting : settings.values()) {
                gDao.delete(setting.getId());
            }
            for (GUIDashlet dashlet : dashlets) {
                Generic generic = new Generic("usersetting", "dashlet-" + dashlet.getName(), session.getUserId());
                generic.setInteger1(dashlet.getId());
                generic.setInteger2(Long.valueOf(dashlet.getColumn()));
                generic.setInteger3(Long.valueOf(dashlet.getRow()));
                generic.setString1(Long.toString(dashlet.getIndex()));
                gDao.store(generic);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private Dashlet toDashlet(GUIDashlet guiDashlet) {
        Dashlet dashlet = new Dashlet();
        dashlet.setId(guiDashlet.getId());
        dashlet.setName(guiDashlet.getName());
        dashlet.setType(guiDashlet.getType());
        dashlet.setTitle(guiDashlet.getTitle());
        dashlet.setQuery(guiDashlet.getQuery());
        dashlet.setContent(guiDashlet.getContent());
        dashlet.setMax(guiDashlet.getMax());
        dashlet.setColumns(guiDashlet.getColumns());
        dashlet.setUnique(guiDashlet.isUnique() ? 1 : 0);
        return dashlet;
    }

    private GUIDashlet fromDashlet(Dashlet dashlet) {
        GUIDashlet guiDashlet = new GUIDashlet();
        guiDashlet.setId(dashlet.getId());
        guiDashlet.setName(dashlet.getName());
        guiDashlet.setType(dashlet.getType());
        guiDashlet.setTitle(dashlet.getTitle());
        guiDashlet.setQuery(dashlet.getQuery());
        guiDashlet.setContent(dashlet.getContent());
        guiDashlet.setMax(dashlet.getMax());
        guiDashlet.setColumns(dashlet.getColumns());
        guiDashlet.setUnique(dashlet.getUnique() == 1);
        return guiDashlet;
    }
}

