/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.contact.Contact;
import com.logicaldoc.core.contact.ContactDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIContact;
import com.logicaldoc.gui.common.client.beans.GUIParseContactsParameters;
import com.logicaldoc.gui.frontend.client.services.ContactService;
import com.logicaldoc.util.csv.CSVFileReader;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.UploadServlet;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactServiceImpl
extends AbstractRemoteService
implements ContactService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ContactServiceImpl.class);

    public void delete(List<Long> ids) throws ServerException {
        this.validateSession();
        try {
            ContactDAO dao = Context.get(ContactDAO.class);
            for (Long id : ids) {
                dao.delete(id);
            }
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void save(GUIContact contact) throws ServerException {
        this.validateSession();
        ContactDAO dao = Context.get(ContactDAO.class);
        try {
            Contact cnt = (Contact)dao.findById(contact.getId());
            if (cnt == null) {
                cnt = new Contact();
            }
            cnt.setEmail(contact.getEmail());
            cnt.setFirstName(contact.getFirstName());
            cnt.setLastName(contact.getLastName());
            cnt.setCompany(contact.getCompany());
            cnt.setAddress(contact.getAddress());
            cnt.setPhone(contact.getPhone());
            cnt.setMobile(contact.getMobile());
            cnt.setUserId(contact.getUserId());
            dao.store(cnt);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public GUIContact load(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            ContactDAO dao = Context.get(ContactDAO.class);
            Contact contact = (Contact)dao.findById(id);
            return this.fromContact(contact);
        }
        catch (PersistenceException e) {
            return (GUIContact)this.throwServerException(session, log, e);
        }
    }

    protected GUIContact fromContact(Contact con) {
        if (con == null) {
            return null;
        }
        GUIContact c = new GUIContact();
        c.setId(con.getId());
        c.setUserId(con.getUserId());
        c.setEmail(con.getEmail());
        c.setFirstName(con.getFirstName());
        c.setLastName(con.getLastName());
        c.setCompany(con.getCompany());
        c.setAddress(con.getAddress());
        c.setPhone(con.getPhone());
        c.setMobile(con.getMobile());
        return c;
    }

    public List<GUIContact> parseContacts(boolean preview, GUIParseContactsParameters parameters) throws ServerException {
        Session session = this.validateSession();
        Map<String, File> uploadedFilesMap = UploadServlet.getUploads(session.getSid());
        File file = uploadedFilesMap.values().iterator().next();
        ContactDAO dao = Context.get(ContactDAO.class);
        ArrayList<GUIContact> contacts = new ArrayList<GUIContact>();
        try {
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (CSVFileReader reader = new CSVFileReader(file.getAbsolutePath(), parameters.getSeparator().charAt(0), parameters.getDelimiter().charAt(0));){
                    if (parameters.isSkipFirstRow()) {
                        reader.readFields();
                    }
                    List<String> fields = reader.readFields();
                    long i = 1L;
                    while (fields != null) {
                        String emailStr = fields.get(parameters.getEmail() - 1);
                        if (StringUtils.isEmpty(emailStr)) {
                            fields = reader.readFields();
                            continue;
                        }
                        Contact contact = null;
                        List<Contact> cont = dao.findByUser(session.getUserId(), emailStr);
                        if (!cont.isEmpty()) {
                            contact = cont.get(0);
                        }
                        if (contact == null) {
                            contact = new Contact();
                            contact.setUserId(session.getUserId());
                            contact.setTenantId(session.getUser().getTenantId());
                        }
                        contact.setEmail(emailStr);
                        contact.setFirstName(fields.get(parameters.getFirstName() - 1));
                        contact.setLastName(fields.get(parameters.getLastName() - 1));
                        contact.setAddress(fields.get(parameters.getAddress() - 1));
                        contact.setCompany(fields.get(parameters.getCompany() - 1));
                        contact.setMobile(fields.get(parameters.getMobile() - 1));
                        contact.setPhone(fields.get(parameters.getPhone() - 1));
                        GUIContact guiContact = this.fromContact(contact);
                        guiContact.setId(i++);
                        contacts.add(guiContact);
                        if (!preview) {
                            dao.store(contact);
                        }
                        fields = reader.readFields();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (PersistenceException | IOException e) {
                log.error("Unable to parse contacs in CSV file", e);
                UploadServlet.cleanUploads(session.getSid());
            }
        }
        finally {
            UploadServlet.cleanUploads(session.getSid());
        }
        return contacts;
    }

    public void shareContacts(List<Long> contactIds, List<Long> userIds, List<Long> groupIds) throws ServerException {
        this.validateSession();
        try {
            this.appendUserIdsFromGroups(groupIds, userIds);
            ContactDAO dao = Context.get(ContactDAO.class);
            for (Long cId : contactIds) {
                Contact originalContact = (Contact)dao.findById(cId);
                for (Long userId : userIds) {
                    List<Contact> userContacts = dao.findByUser(userId, originalContact.getEmail());
                    if (!userContacts.isEmpty()) continue;
                    Contact cloned = new Contact(originalContact);
                    cloned.setId(0L);
                    cloned.setUserId(userId);
                    this.storeContact(cloned);
                }
            }
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    private void storeContact(Contact contact) {
        ContactDAO dao = Context.get(ContactDAO.class);
        try {
            dao.store(contact);
        }
        catch (PersistenceException e) {
            log.warn("Cannot share contact {} with user {}", (Object)contact.getEmail(), (Object)contact.getUserId());
        }
    }

    private void appendUserIdsFromGroups(Collection<Long> groupIds, Collection<Long> users) throws PersistenceException {
        UserDAO gDao = Context.get(UserDAO.class);
        for (Long gId : groupIds) {
            Set<User> usrs = gDao.findByGroup(gId);
            for (User user : usrs) {
                if (users.contains(user.getId())) continue;
                users.add(user.getId());
            }
        }
    }
}

