/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.AttributeOption;
import com.logicaldoc.core.metadata.AttributeOptionDAO;
import com.logicaldoc.core.metadata.AttributeSet;
import com.logicaldoc.core.metadata.AttributeSetDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIAttribute;
import com.logicaldoc.gui.common.client.beans.GUIAttributeSet;
import com.logicaldoc.gui.common.client.beans.GUIValue;
import com.logicaldoc.gui.frontend.client.services.AttributeSetService;
import com.logicaldoc.util.csv.CSVFileReader;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.UploadServlet;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeSetServiceImpl
extends AbstractRemoteService
implements AttributeSetService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AttributeSetServiceImpl.class);

    public void delete(long setId) throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
            dao.delete(setId);
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void saveOptions(long setId, String attribute, List<GUIValue> values) throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeOptionDAO dao = Context.get(AttributeOptionDAO.class);
            dao.deleteBySetIdAndAttribute(setId, attribute);
            int i = 0;
            for (GUIValue value : values) {
                AttributeOption option = new AttributeOption(setId, attribute, value.getValue(), value.getCode());
                option.setPosition(i++);
                this.store(setId, option);
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    private void store(long setId, AttributeOption option) throws ServerException {
        try {
            AttributeOptionDAO dao = Context.get(AttributeOptionDAO.class);
            dao.store(option);
        }
        catch (Exception e) {
            throw new ServerException(String.format("Options have not been %s", setId != 0L ? "updated" : "stored"), (Throwable)e);
        }
    }

    public void deleteOptions(long setId, String attribute, List<String> values) throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeOptionDAO dao = Context.get(AttributeOptionDAO.class);
            List<AttributeOption> options = dao.findByAttribute(setId, attribute);
            block2: for (AttributeOption option : options) {
                for (String value : values) {
                    if (!value.equals(option.getValue())) continue;
                    this.delete(option);
                    continue block2;
                }
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    private void delete(AttributeOption option) throws ServerException {
        try {
            AttributeOptionDAO dao = Context.get(AttributeOptionDAO.class);
            dao.delete(option.getId());
        }
        catch (Exception e) {
            throw new ServerException("Option has not been deleted", (Throwable)e);
        }
    }

    public GUIAttributeSet save(GUIAttributeSet guiAttributeSet) throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeSet attributeSet;
            if (guiAttributeSet.getId() != 0L) {
                AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
                attributeSet = (AttributeSet)dao.findById(guiAttributeSet.getId());
                dao.initialize(attributeSet);
            } else {
                attributeSet = new AttributeSet();
            }
            attributeSet.setTenantId(session.getTenantId());
            attributeSet.setName(guiAttributeSet.getName());
            attributeSet.setLabel(guiAttributeSet.getLabel());
            attributeSet.setDescription(guiAttributeSet.getDescription());
            attributeSet.setReadonly(guiAttributeSet.isReadonly() ? 1 : 0);
            attributeSet.setType(guiAttributeSet.getType());
            this.saveAttributes(guiAttributeSet, attributeSet);
            this.store(guiAttributeSet, attributeSet);
            guiAttributeSet.setId(attributeSet.getId());
        }
        catch (Exception t) {
            return (GUIAttributeSet)this.throwServerException(session, log, t);
        }
        return guiAttributeSet;
    }

    private void store(GUIAttributeSet guiAttributeSet, AttributeSet attributeSet) throws ServerException {
        try {
            AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
            dao.store(attributeSet);
        }
        catch (Exception e) {
            throw new ServerException(String.format("AttributeSet has not been %s", guiAttributeSet.getId() != 0L ? "updated" : "stored"), (Throwable)e);
        }
    }

    private void saveAttributes(GUIAttributeSet guiAttributeSet, AttributeSet attributeSet) {
        HashMap<String, Attribute> attrs = new HashMap<String, Attribute>();
        attributeSet.getAttributes().clear();
        if (guiAttributeSet != null) {
            for (GUIAttribute attribute : guiAttributeSet.getAttributes()) {
                if (attribute == null) continue;
                this.saveAttribute(attribute, guiAttributeSet, attrs);
            }
        }
        if (attrs.size() > 0) {
            attributeSet.setAttributes(attrs);
        }
    }

    private void saveAttribute(GUIAttribute attribute, GUIAttributeSet attributeSet, Map<String, Attribute> attrs) {
        Attribute att = new Attribute();
        att.setSetId(attributeSet.getId());
        att.setPosition(attribute.getPosition());
        att.setMandatory(attribute.isMandatory() ? 1 : 0);
        att.setHidden(attribute.isHidden() ? 1 : 0);
        att.setReadonly(attribute.isReadonly() ? 1 : 0);
        att.setMultiple(attribute.isMultiple() ? 1 : 0);
        att.setParent(attribute.getParent());
        att.setDependsOn(attribute.getDependsOn());
        att.setStringValues(attribute.getStringValues());
        att.setType(attribute.getType());
        att.setLabel(attribute.getLabel());
        att.setEditor(attribute.getEditor());
        att.setValidation(attribute.getValidation());
        att.setInitialization(attribute.getInitialization());
        att.setStringValue(attribute.getStringValue());
        if (StringUtils.isEmpty(attribute.getLabel())) {
            att.setLabel(attribute.getName());
        }
        if (attribute.getValue() instanceof String) {
            att.setStringValue(attribute.getStringValue());
        } else if (attribute.getValue() instanceof Long) {
            att.setIntValue(attribute.getIntValue());
        } else if (attribute.getValue() instanceof Double) {
            att.setDoubleValue(attribute.getDoubleValue());
        } else if (attribute.getValue() instanceof Date) {
            att.setDateValue(attribute.getDateValue());
        } else if (attribute.getValue() instanceof Boolean) {
            att.setBooleanValue(attribute.getBooleanValue());
        }
        attrs.put(attribute.getName(), att);
    }

    public GUIAttributeSet getAttributeSet(String name) throws ServerException {
        Session session = this.validateSession();
        AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
        try {
            AttributeSet set = dao.findByName(name, session.getTenantId());
            if (set != null) {
                return this.getAttributeSet(set.getId());
            }
            return null;
        }
        catch (Exception t) {
            return (GUIAttributeSet)this.throwServerException(session, log, t);
        }
    }

    public GUIAttributeSet getAttributeSet(long setId) throws ServerException {
        AttributeSet attributeSet;
        block3: {
            this.validateSession();
            AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
            try {
                attributeSet = (AttributeSet)dao.findById(setId);
                if (attributeSet != null) break block3;
                return null;
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
                return null;
            }
        }
        GUIAttributeSet attSet = new GUIAttributeSet();
        attSet.setId(setId);
        attSet.setName(attributeSet.getName());
        attSet.setLabel(attributeSet.getLabel());
        attSet.setDescription(attributeSet.getDescription());
        attSet.setReadonly(attributeSet.getReadonly() == 1);
        attSet.setType(attributeSet.getType());
        List<GUIAttribute> attributes = this.readAttributes(attributeSet);
        attributes.sort(null);
        attSet.setAttributes(attributes);
        return attSet;
    }

    private List<GUIAttribute> readAttributes(AttributeSet attributeSet) {
        ArrayList<GUIAttribute> attributes = new ArrayList<GUIAttribute>();
        for (String attrName : attributeSet.getAttributeNames()) {
            attributes.add(this.readAttribute(attrName, attributeSet));
        }
        return attributes;
    }

    private GUIAttribute readAttribute(String attrName, AttributeSet attributeSet) {
        Attribute extAttr = attributeSet.getTemplateAttributes().get(attrName);
        GUIAttribute att = new GUIAttribute();
        att.setName(attrName);
        att.setParent(extAttr.getParent());
        att.setStringValues(extAttr.getStringValues());
        att.setSet(attributeSet.getName());
        att.setSetId(Long.valueOf(attributeSet.getId()));
        att.setPosition(extAttr.getPosition());
        att.setMandatory(this.intToBoolean(extAttr.getMandatory()));
        att.setHidden(this.intToBoolean(extAttr.getHidden()));
        att.setReadonly(this.intToBoolean(extAttr.getReadonly()));
        att.setMultiple(this.intToBoolean(extAttr.getMultiple()));
        att.setType(extAttr.getType());
        att.setValidation(extAttr.getValidation());
        att.setInitialization(extAttr.getInitialization());
        if (StringUtils.isEmpty(extAttr.getLabel())) {
            att.setLabel(attrName);
        } else {
            att.setLabel(extAttr.getLabel());
        }
        if (extAttr.getValue() instanceof String) {
            att.setStringValue(extAttr.getStringValue());
        } else if (extAttr.getValue() instanceof Long) {
            att.setIntValue(extAttr.getIntValue());
        } else if (extAttr.getValue() instanceof Double) {
            att.setDoubleValue(extAttr.getDoubleValue());
        } else if (extAttr.getValue() instanceof Date) {
            att.setDateValue(this.convertToDate(extAttr.getDateValue()));
        } else if (extAttr.getValue() instanceof Boolean) {
            att.setBooleanValue(extAttr.getBooleanValue());
        }
        att.setEditor(extAttr.getEditor());
        if (extAttr.getType() == 4 || extAttr.getEditor() == 1) {
            this.readAttributeOptions(extAttr, att);
        }
        return att;
    }

    private void readAttributeOptions(Attribute extAttr, GUIAttribute att) {
        String buf = extAttr.getStringValue();
        ArrayList<String> list = new ArrayList<String>();
        if (buf != null) {
            if (buf.contains(",")) {
                StringTokenizer st = new StringTokenizer(buf, ",");
                while (st.hasMoreElements()) {
                    String val = (String)st.nextElement();
                    if (list.contains(val)) continue;
                    list.add(val);
                }
            } else {
                list.add(buf.trim());
            }
            att.setStringValue(buf);
        }
        att.setOptions(list);
    }

    private boolean intToBoolean(int val) {
        return val == 1;
    }

    public List<GUIAttributeSet> getAttributeSets() throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
            ArrayList<GUIAttributeSet> guiSets = new ArrayList<GUIAttributeSet>();
            List<Long> setIds = dao.findAllIds(session.getTenantId());
            for (Long setId : setIds) {
                guiSets.add(this.getAttributeSet(setId));
            }
            return guiSets;
        }
        catch (Exception t) {
            return (List)this.throwServerException(session, log, t);
        }
    }

    public List<GUIValue> parseOptions(long setId, String attribute) throws ServerException {
        ArrayList<GUIValue> options;
        block17: {
            Session session = this.validateSession();
            Map<String, File> uploadedFilesMap = UploadServlet.getUploads(session.getSid());
            File file = uploadedFilesMap.values().iterator().next();
            options = new ArrayList<GUIValue>();
            try {
                try {
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (CSVFileReader reader = new CSVFileReader(file.getPath());){
                        List<String> row = reader.readFields();
                        if (row != null && "value".equalsIgnoreCase(row.get(0))) {
                            row = reader.readFields();
                        }
                        while (row != null && !row.isEmpty()) {
                            GUIValue option = new GUIValue();
                            option.setValue(row.get(0));
                            if (row.size() > 1) {
                                option.setCode(row.get(1));
                            }
                            options.add(option);
                            row = reader.readFields();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error("Unable to parse options in CSV file", e);
                    UploadServlet.cleanUploads(session.getSid());
                    break block17;
                }
            }
            catch (Throwable throwable) {
                UploadServlet.cleanUploads(session.getSid());
                throw throwable;
            }
            UploadServlet.cleanUploads(session.getSid());
        }
        this.saveOptions(setId, attribute, options);
        return options;
    }

    public void applyValidationToTemplates(long setId, String attribute) throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
            AttributeSet set = (AttributeSet)dao.findById(setId);
            dao.initialize(set);
            Attribute setAttribute = set.getTemplateAttributes().get(attribute);
            if (setAttribute == null) {
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("validation", setAttribute.getValidation());
            params.put("name", attribute);
            params.put("setId", setId);
            int count = dao.jdbcUpdate("update ld_template_ext set ld_validation = :validation where ld_setid = :setId and ld_name = :name", params);
            log.info("Updated the validation of {} template attributes named {}", (Object)count, (Object)attribute);
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void applyInitializationToTemplates(long setId, String attribute) throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
            AttributeSet set = (AttributeSet)dao.findById(setId);
            dao.initialize(set);
            Attribute setAttribute = set.getTemplateAttributes().get(attribute);
            if (setAttribute == null) {
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("initialization", setAttribute.getInitialization());
            params.put("name", attribute);
            params.put("setId", setId);
            int count = dao.jdbcUpdate("update ld_template_ext set ld_initialization = :initialization where ld_setid = :setId and ld_name = :name", params);
            log.info("Updated the initialization of {} template attributes named {}", (Object)count, (Object)attribute);
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void applyAllToTemplates(long setId, String attributeName) throws ServerException {
        Session session = this.validateSession();
        try {
            AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
            AttributeSet set = (AttributeSet)dao.findById(setId);
            Attribute setAttribute = set.getTemplateAttributes().get(attributeName);
            TemplateDAO templateDao = Context.get(TemplateDAO.class);
            List templates = templateDao.findAll(set.getTenantId());
            for (Template template : templates) {
                templateDao.initialize(template);
                template.getTemplateAttributes().put(attributeName, new Attribute(setAttribute));
                templateDao.store(template);
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }
}

