/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.service;

import com.google.gwt.user.server.rpc.jakarta.RemoteServiceServlet;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.ExtensibleObject;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.metadata.validation.ValidationException;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.authentication.InvalidSessionException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.threading.NotifyingThread;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.gui.common.client.AccessDeniedException;
import com.logicaldoc.gui.common.client.InvalidSessionServerException;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.ServerValidationError;
import com.logicaldoc.gui.common.client.ServerValidationException;
import com.logicaldoc.gui.common.client.beans.GUIAttribute;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.JulianCalendarUtil;
import com.logicaldoc.web.UploadServlet;
import com.logicaldoc.web.util.LongRunningOperationCompleteListener;
import com.logicaldoc.web.util.ServletUtil;
import com.logicaldoc.web.websockets.WebsocketTool;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionSystemException;

public abstract class AbstractRemoteService
extends RemoteServiceServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteService.class);
    protected static final String LOCALE = "locale";
    protected static final String USER = "user";

    protected AbstractRemoteService() {
    }

    protected AbstractRemoteService(Object delegate) {
        super(delegate);
    }

    protected Map<String, File> getUploadedFiles(String sid) {
        return UploadServlet.getUploads(sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadRequest(HttpServletRequest request) {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.perThreadRequest == null) {
                this.perThreadRequest = new ThreadLocal();
            }
            this.perThreadRequest.set(request);
        }
    }

    protected Session validateSession() throws InvalidSessionServerException {
        return this.validateSession(this.getThreadLocalRequest());
    }

    private Session validateSession(HttpServletRequest request) throws InvalidSessionServerException {
        try {
            return ServletUtil.validateSession(request);
        }
        catch (InvalidSessionException e) {
            throw new InvalidSessionServerException(e.getMessage(), (Throwable)e);
        }
    }

    protected Session validateSession(String sid) throws InvalidSessionServerException {
        try {
            return ServletUtil.validateSession(sid);
        }
        catch (InvalidSessionException e) {
            throw new InvalidSessionServerException(e.getMessage());
        }
    }

    protected Session checkEvenOneMenu(HttpServletRequest request, long ... menuIds) throws InvalidSessionServerException, AccessDeniedException {
        try {
            return ServletUtil.checkEvenOneMenu(request, menuIds);
        }
        catch (InvalidSessionException e) {
            throw new InvalidSessionServerException(e.getMessage());
        }
        catch (ServletException e) {
            throw new AccessDeniedException(e.getMessage());
        }
    }

    protected Session checkMenu(HttpServletRequest request, long menuId) throws InvalidSessionServerException, AccessDeniedException {
        try {
            return ServletUtil.checkMenu(request, menuId);
        }
        catch (InvalidSessionException e) {
            throw new InvalidSessionServerException(e.getMessage());
        }
        catch (ServletException e) {
            throw new AccessDeniedException(e.getMessage());
        }
    }

    protected Session checkMenu(long menuId) throws InvalidSessionServerException, AccessDeniedException {
        try {
            return ServletUtil.checkMenu(this.getThreadLocalRequest(), menuId);
        }
        catch (InvalidSessionException e) {
            throw new InvalidSessionServerException(e.getMessage());
        }
        catch (ServletException e) {
            throw new AccessDeniedException(e.getMessage());
        }
    }

    protected void checkPermission(Permission permission, User user, long folderId) throws AccessDeniedException {
        FolderDAO dao = Context.get(FolderDAO.class);
        try {
            if (!dao.isPermissionAllowed(permission, folderId, user.getId())) {
                String message = String.format("User %s doesn't have permission %s on folder %s", user.getUsername(), permission.name(), folderId);
                throw new AccessDeniedException(message);
            }
        }
        catch (PersistenceException e) {
            throw new AccessDeniedException(e.getMessage());
        }
    }

    protected Locale currentLocale(Session session) {
        return (Locale)session.getDictionary().get(LOCALE);
    }

    protected Locale currentLocale(String sid) throws InvalidSessionServerException {
        Session session = this.validateSession(sid);
        return this.currentLocale(session);
    }

    protected User getSessionUser(String sid) throws InvalidSessionServerException {
        Session session = this.validateSession(sid);
        User user = (User)session.getDictionary().get(USER);
        this.initUser(user);
        return user;
    }

    private void initUser(User user) {
        try {
            UserDAO userDao = Context.get(UserDAO.class);
            userDao.initialize(user);
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
    }

    protected User getSessionUser(HttpServletRequest request) throws InvalidSessionServerException {
        Session session = this.validateSession(request);
        User user = (User)session.getDictionary().get(USER);
        this.initUser(user);
        return user;
    }

    protected <R> R throwServerException(Session session, Logger logger, Throwable throwable) throws ServerException {
        Session.Log lastError;
        if (logger != null) {
            logger.error(throwable.getMessage(), throwable);
        }
        String message = throwable.getMessage();
        if (session != null && (lastError = session.getLastError()) != null) {
            message = lastError.getMessage();
            session.getLogs().clear();
        }
        if (message != null) {
            message = message.replace("com.logicaldoc.", "").replace("java.lang.", "");
        }
        if (session != null && (throwable instanceof TransactionException || throwable instanceof HibernateException || throwable instanceof TransactionSystemException)) {
            message = I18N.message("dberrorretry", session.getUser().getLocale());
        }
        if (throwable instanceof ValidationException) {
            ValidationException ie = (ValidationException)throwable;
            throw new ServerValidationException(ie.getMessage(), ie.getErrors().values().stream().map(e -> new ServerValidationError(e.getAttribute(), e.getLabel(), e.getDescription())).collect(Collectors.toList()).toArray(new ServerValidationError[0]));
        }
        if (throwable instanceof PermissionException) {
            throw new AccessDeniedException(throwable.getMessage());
        }
        if (throwable instanceof ServerException) {
            ServerException se = (ServerException)throwable;
            throw se;
        }
        throw new ServerException(message);
    }

    protected Date convertToDate(Date src) {
        if (src == null) {
            return null;
        }
        if (src instanceof Timestamp) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(src.getTime());
            return cal.getTime();
        }
        return src;
    }

    protected boolean executeLongRunningOperation(String name, Callable<Void> callable, Session session) throws ServerException {
        ThreadPools pools = Context.get(ThreadPools.class);
        NotifyingThread<Void> task = new NotifyingThread<Void>(callable, name);
        try {
            pools.schedule(task, "LongRunningOperations", 1L).get(20L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.debug("Timout reached for operation {}", (Object)name);
        }
        catch (ExecutionException e) {
            throw new ServerException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        if (task.isOver() && task.getError() != null) {
            throw new ServerException(task.getError());
        }
        if (!task.isOver()) {
            log.warn("Operation {} invoked by user {} is taking too long and it will continue in background", (Object)name, (Object)session.getUsername());
            new WebsocketTool().showMessage(session, I18N.message("operationtakestoolongotoback", session.getUser().getLocale()), "warn");
            task.addListener(new LongRunningOperationCompleteListener(session.getUsername()));
        }
        return task.isOver();
    }

    protected List<GUIAttribute> prepareGUIAttributes(Template template, ExtensibleObject extensibleObject) {
        TemplateDAO tDao = Context.get(TemplateDAO.class);
        tDao.initialize(template);
        ArrayList<GUIAttribute> attributes = new ArrayList<GUIAttribute>();
        if (template == null || template.getAttributes() == null || template.getAttributes().isEmpty()) {
            return new ArrayList<GUIAttribute>();
        }
        try {
            for (String attrName : template.getAttributeNames()) {
                attributes.add(this.prepareGUIAttribute(attrName, template, attributes, extensibleObject));
            }
            Collections.sort(attributes);
            return attributes;
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
            return new ArrayList<GUIAttribute>();
        }
    }

    private GUIAttribute prepareGUIAttribute(String attrName, Template template, List<GUIAttribute> attributes, ExtensibleObject extensibleObject) {
        List<Attribute> values;
        Attribute templateExtAttr = template.getAttributes().get(attrName);
        GUIAttribute att = new GUIAttribute();
        att.setName(attrName);
        att.setSetId(templateExtAttr.getSetId());
        att.setPosition(templateExtAttr.getPosition());
        att.setLabel(templateExtAttr.getLabel());
        att.setMandatory(templateExtAttr.getMandatory() == 1);
        att.setHidden(templateExtAttr.getHidden() == 1);
        att.setReadonly(templateExtAttr.getReadonly() == 1);
        att.setMultiple(templateExtAttr.getMultiple() == 1);
        att.setParent(templateExtAttr.getParent());
        att.setStringValues(templateExtAttr.getStringValues());
        att.setEditor(templateExtAttr.getEditor());
        att.setStringValue(templateExtAttr.getStringValue());
        att.setIntValue(templateExtAttr.getIntValue());
        att.setBooleanValue(templateExtAttr.getBooleanValue());
        att.setDoubleValue(templateExtAttr.getDoubleValue());
        att.setDateValue(templateExtAttr.getDateValue());
        att.setOptions(Arrays.asList(templateExtAttr.getStringValue()));
        if (extensibleObject != null) {
            Attribute attribute = extensibleObject.getAttribute(attrName);
            if (attribute != null) {
                att.setStringValues(attribute.getStringValues());
                att.setStringValue(attribute.getStringValue());
                att.setIntValue(attribute.getIntValue());
                att.setBooleanValue(attribute.getBooleanValue());
                att.setDoubleValue(attribute.getDoubleValue());
                att.setDateValue(attribute.getDateValue());
            } else {
                att.setValue(templateExtAttr.getValue());
            }
        }
        this.normalizeDate(att);
        att.setType(templateExtAttr.getType());
        if (att.isMultiple() && extensibleObject != null && (values = extensibleObject.getValueAttributes(att.getName())).size() > 1) {
            values.remove(0);
            for (Attribute valAttribute : values) {
                GUIAttribute valAtt = new GUIAttribute(att);
                valAtt.setName(valAttribute.getName());
                valAtt.setParent(att.getName());
                valAtt.setMultiple(false);
                valAtt.setPosition(att.getPosition());
                valAtt.setPosition(att.getPosition());
                valAtt.setBooleanValue(valAttribute.getBooleanValue());
                valAtt.setDateValue(valAttribute.getDateValue());
                valAtt.setDoubleValue(valAttribute.getDoubleValue());
                valAtt.setIntValue(valAttribute.getIntValue());
                valAtt.setStringValue(valAttribute.getStringValue());
                valAtt.setStringValues(null);
                this.normalizeDate(valAtt);
                attributes.add(valAtt);
            }
        }
        return att;
    }

    private void normalizeDate(GUIAttribute att) {
        Object object = att.getValue();
        if (object instanceof Date) {
            Date date = (Date)object;
            att.setValue((Object)this.convertToDate(date));
        }
    }

    protected static final Date fixDateForDB(Date date) {
        if (date != null && JulianCalendarUtil.isJulianDate(date)) {
            date = JulianCalendarUtil.toGregorian(date);
        }
        if (date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.set(11, 12);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        return date;
    }

    protected static final Date fixDateForGUI(Date date) {
        if (date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.set(11, 12);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            date = c.getTime();
        }
        if (date != null && JulianCalendarUtil.isJulianDate(date)) {
            date = JulianCalendarUtil.toJulian(date);
        }
        return date;
    }
}

