/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.listener;

import com.logicaldoc.core.SystemInfo;
import com.logicaldoc.core.security.SessionDAO;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoaderListener;

public class ContextListener
extends ContextLoaderListener {
    private static final Logger log = LoggerFactory.getLogger(ContextListener.class);

    public void contextDestroyed(ServletContextEvent event) {
        this.cleanupSessions();
        log.info("Application shut down");
        super.contextDestroyed(event);
    }

    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        this.cleanupSessions();
        log.info("Application started and ready");
    }

    private void cleanupSessions() {
        try {
            log.info("Cleanup past sessions of the current node {}", (Object)SystemInfo.get().getInstallationId());
            if (Context.get() != null) {
                SessionDAO sessionDAO = Context.get(SessionDAO.class);
                sessionDAO.deleteCurrentNodeSessions();
                ContextProperties config = Context.get().getProperties();
                int sessionTtl = config.getInt("session.ttl", -1);
                sessionDAO.cleanOldSessions(sessionTtl);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }
}

