/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.listener;

import com.logicaldoc.core.automation.Automation;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.config.LogConfigurator;
import com.logicaldoc.util.config.WebConfigurator;
import com.logicaldoc.util.config.WebContextConfigurator;
import com.logicaldoc.util.dbinit.DBInit;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.plugin.PluginException;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.mysql.cj.jdbc.AbandonedConnectionCleanupThread;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationListener
implements ServletContextListener,
HttpSessionListener {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String JDBC_URL = "jdbc.url";
    private static final Logger log = LoggerFactory.getLogger(ApplicationListener.class);
    private boolean pidCreated = false;
    private static boolean restartRequired = false;

    public static boolean isRestartRequired() {
        return restartRequired;
    }

    public static void restartRequired() {
        restartRequired = true;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            ApplicationListener.onShutdown();
        }
        finally {
            if (this.pidCreated) {
                FileUtil.delete(this.getPidFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onShutdown() {
        Thread[] threadArray;
        log.warn("Shutting down the application");
        try {
            ContextProperties config = new ContextProperties();
            if (config.getProperty(JDBC_URL).contains("jdbc:hsqldb")) {
                DBInit dbInit = new DBInit();
                dbInit.setDriver(config.getProperty("jdbc.driver"));
                dbInit.setUrl(config.getProperty(JDBC_URL));
                dbInit.setUsername(config.getProperty("jdbc.username"));
                dbInit.setPassword(config.getProperty("jdbc.password"));
                dbInit.executeSql("shutdown compact");
                log.warn("Embedded database stopped");
            } else if (config.getProperty(JDBC_URL).contains("jdbc:mysql")) {
                AbandonedConnectionCleanupThread.uncheckedShutdown();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        try {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            Driver d = null;
            while (drivers.hasMoreElements()) {
                d = drivers.nextElement();
                ApplicationListener.registerDriver(d);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray2 = threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        int n = threadArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t;
            Thread thread = t = threadArray2[n2];
            synchronized (thread) {
                if ((t.getName().toLowerCase().contains("abandoned connection") || t.getName().startsWith("Scheduler_")) && !Thread.currentThread().equals(t) && !t.isInterrupted()) {
                    ApplicationListener.interruptThread(t);
                }
            }
            ++n2;
        }
        log.warn("Application stopped");
    }

    private static void interruptThread(Thread thread) {
        try {
            thread.interrupt();
            log.warn("Killed thread {}", (Object)thread.getName());
        }
        catch (Exception e) {
            log.warn("Error killing {}", (Object)thread.getName());
        }
    }

    private static void registerDriver(Driver driver) {
        try {
            DriverManager.deregisterDriver(driver);
            if (log.isWarnEnabled()) {
                log.warn(String.format("Driver %s unregistered", driver.getClass().getName()));
            }
        }
        catch (SQLException ex) {
            log.warn(String.format("Error unregistering driver %s", driver), ex);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ContextProperties conf;
            ServletContext context = sce.getServletContext();
            new LogConfigurator().initializeLogging();
            try {
                conf = new ContextProperties();
                String policy = "true".equals(conf.getProperty("ssl.required")) ? "CONFIDENTIAL" : "NONE";
                WebConfigurator configurator = new WebConfigurator(context.getRealPath("/WEB-INF/web.xml"));
                if (configurator.setTransportGuarantee(policy)) {
                    PluginRegistry.getInstance().setRestartRequired();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            try {
                conf = new ContextProperties();
                WebContextConfigurator configurator = new WebContextConfigurator(context.getRealPath("/META-INF/context.xml"));
                if (configurator.setSameSiteCookies(conf.getProperty("cookies.samesite", "lax"))) {
                    PluginRegistry.getInstance().setRestartRequired();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            String pluginsDir = context.getRealPath("/WEB-INF/lib");
            try {
                PluginRegistry.getInstance().init(pluginsDir);
            }
            catch (PluginException e) {
                log.error(e.getMessage(), e);
                this.writePidFile();
                return;
            }
            this.cleanTemporaryFolders(context);
            Automation.initialize();
            try {
                this.unpackPlugins(context);
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
            if (PluginRegistry.getInstance().isRestartRequired()) {
                ApplicationListener.restartRequired();
                log.warn("The application has to be restarted");
                Logger console = LoggerFactory.getLogger("console");
                console.warn("The application has to be restarted");
            }
        }
        finally {
            this.writePidFile();
        }
    }

    private void cleanTemporaryFolders(ServletContext context) {
        File tempDirToDelete = new File(context.getRealPath("upload"));
        try {
            if (tempDirToDelete.exists()) {
                FileUtils.forceDelete(tempDirToDelete);
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
        tempDirToDelete = new File(System.getProperty(JAVA_IO_TMPDIR) + "/upload");
        try {
            if (tempDirToDelete.exists()) {
                FileUtils.forceDelete(tempDirToDelete);
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
        tempDirToDelete = new File(System.getProperty(JAVA_IO_TMPDIR) + "/convertjpg");
        try {
            if (tempDirToDelete.exists()) {
                FileUtils.forceDelete(tempDirToDelete);
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
    }

    private void unpackPlugins(ServletContext context) throws IOException {
        File pluginsDir = PluginRegistry.getPluginsDir();
        File[] archives = pluginsDir.listFiles((dir, fileName) -> fileName.toLowerCase().contains("plugin") && fileName.toLowerCase().endsWith(".zip"));
        File webappDir = new File(context.getRealPath("/"));
        if (archives != null) {
            File[] fileArray = archives;
            int n = archives.length;
            int n2 = 0;
            while (n2 < n) {
                File[] installationMarkers;
                File archive = fileArray[n2];
                log.info("Unpack plugin {}", (Object)archive.getName());
                Throwable throwable = null;
                Object var10_11 = null;
                try (ZipUtil zipUtil = new ZipUtil();){
                    zipUtil.unzip(archive, webappDir);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                FileUtils.deleteQuietly(new File(webappDir, "plugin.xml"));
                FileUtils.moveFile(archive, new File(archive.getParentFile(), archive.getName() + ".installed"));
                String pluginName = archive.getName().replace("-plugin.zip", "");
                pluginName = pluginName.substring(0, pluginName.lastIndexOf(45));
                log.info("Remove installation marker of plugin {}", (Object)pluginName);
                File pluginDir = new File(pluginsDir, pluginName);
                File[] fileArray2 = installationMarkers = pluginDir.listFiles((dir, fileName) -> fileName.toLowerCase().startsWith("install-"));
                int n3 = installationMarkers.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    FileUtils.deleteQuietly(file);
                    ++n4;
                }
                ApplicationListener.restartRequired();
                ++n2;
            }
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        String id = session.getId();
        File uploadFolder = new File(session.getServletContext().getRealPath("upload"));
        uploadFolder = new File(uploadFolder, id);
        try {
            if (uploadFolder.exists()) {
                FileUtils.forceDelete(uploadFolder);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        String sid = (String)session.getAttribute("sid");
        File uploadDir = new File(System.getProperty(JAVA_IO_TMPDIR) + "/upload/" + sid);
        try {
            if (uploadDir.exists()) {
                FileUtils.forceDelete(uploadDir);
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
    }

    private void writePidFile() {
        File pidFile = this.getPidFile();
        if (pidFile.exists()) {
            return;
        }
        long pid = ProcessHandle.current().pid();
        try {
            FileUtils.touch(pidFile);
            FileUtil.writeFile("" + pid, pidFile.getPath());
            this.pidCreated = true;
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            Logger console = LoggerFactory.getLogger("console");
            console.warn("Cannot create pid file {}", (Object)pidFile.getAbsolutePath());
        }
    }

    private File getPidFile() {
        try {
            ContextProperties config = new ContextProperties();
            return new File(config.getProperty("LDOCHOME") + "/bin/pid");
        }
        catch (Exception t) {
            return new File("pid");
        }
    }
}

