/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.junit;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.Device;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.spring.LDAuthenticationToken;
import com.logicaldoc.core.security.spring.LDDeferredSecurityContext;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUISession;
import com.logicaldoc.util.junit.AbstractTestCase;
import com.logicaldoc.util.plugin.PluginException;
import com.logicaldoc.util.servlet.MockServletSession;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.SecurityServiceImpl;
import java.io.IOException;
import java.sql.SQLException;
import org.junit.Assert;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractWebappTestCase
extends AbstractTestCase {
    protected GUISession guiSession;
    protected Session session;
    protected MockServletSession servletSession = new MockServletSession();

    @Override
    public void setUp() throws IOException, SQLException, PluginException {
        super.setUp();
        try {
            this.prepareSession("admin", "admin");
        }
        catch (ServerException e) {
            throw new IOException(e);
        }
        Assert.assertNotNull((Object)this.guiSession);
        Assert.assertNotNull((Object)SessionManager.get().get(this.guiSession.getSid()));
    }

    protected void prepareSession(String username, String password) throws ServerException, PersistenceException {
        UserDAO userDao = Context.get(UserDAO.class);
        this.guiSession = new GUISession();
        Client client = new Client("xyz", "192.168.2.231", "ghost");
        Device device = new Device();
        device.setBrowser("Firefox");
        device.setBrowserVersion("18");
        device.setOperativeSystem("Windows");
        client.setDevice(device);
        this.session = SessionManager.get().newSession(username, password, null, client);
        if (this.session != null) {
            User user = userDao.findByUsernameIgnoreCase(username);
            userDao.initialize(user);
            LDAuthenticationToken token = new LDAuthenticationToken(username);
            token.setSid(this.session.getSid());
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            this.guiSession = new SecurityServiceImpl().loadSession(this.session, null);
            LDDeferredSecurityContext.bindServletSession(this.guiSession.getSid(), this.servletSession);
        }
    }
}

