/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.firewall;

import com.logicaldoc.util.spring.Context;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.web.firewall.FirewalledRequest;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.security.web.firewall.StrictHttpFirewall;

public class HttpFirewall
extends StrictHttpFirewall {
    public FirewalledRequest getFirewalledRequest(HttpServletRequest request) throws RequestRejectedException {
        if (Context.get().getProperties().getBoolean("firewall.enabled", true)) {
            return super.getFirewalledRequest(request);
        }
        return new FirewalledRequest(request){

            public void reset() {
            }
        };
    }

    public HttpServletResponse getFirewalledResponse(HttpServletResponse response) {
        if (Context.get().getProperties().getBoolean("firewall.enabled", true)) {
            return super.getFirewalledResponse(response);
        }
        return response;
    }
}

