/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.filter.xss;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.regex.Pattern;
import org.owasp.esapi.ESAPI;

public class XssRequestWrapper
extends HttpServletRequestWrapper {
    public XssRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return new String[0];
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        int i = 0;
        while (i < count) {
            encodedValues[i] = this.stripXSS(values[i]);
            ++i;
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value != null && ("tenant".equals(parameter) || "skin".equals(parameter))) {
            Pattern scriptPattern = Pattern.compile("[^a-z^0-9^\\-]", 2);
            value = scriptPattern.matcher(value).replaceAll("");
        } else if (value != null && ("version".equals(parameter) || "fileVersion".equals(parameter))) {
            Pattern scriptPattern = Pattern.compile("[^0-9^.]", 2);
            value = scriptPattern.matcher(value).replaceAll("");
        } else if (value != null && "locale".equals(parameter)) {
            Pattern scriptPattern = Pattern.compile("[^a-z\\-]", 2);
            value = scriptPattern.matcher(value).replaceAll("");
        } else if (value != null && "control".equals(parameter)) {
            Pattern scriptPattern = Pattern.compile("[\\W]", 2);
            value = scriptPattern.matcher(value).replaceAll("");
        }
        return this.deepStripXSS(value);
    }

    public String getHeader(String name) {
        return this.stripXSS(super.getHeader(name));
    }

    private String deepStripXSS(String value) {
        if (value != null) {
            boolean strippedSomething = true;
            while (strippedSomething) {
                String strippedValue = this.stripXSS(value);
                strippedSomething = !strippedValue.equalsIgnoreCase(value);
                value = strippedValue;
            }
        }
        return value;
    }

    private String stripXSS(String value) {
        if (value != null) {
            value = ESAPI.encoder().canonicalize(value);
            value = value.replace("", "");
            Pattern scriptPattern = Pattern.compile("\";", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("';", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("\"\\);", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("'\\);", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
        }
        return value;
    }
}

