/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.filter;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheControlFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CacheControlFilter.class);
    private static Map<String, String> mappings = new LinkedHashMap<String, String>();

    public void destroy() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                if (response.isCommitted()) {
                    log.debug("Request already committed {}", (Object)httpRequest.getRequestURL());
                    chain.doFilter(request, response);
                    return;
                }
                String cacheControl = this.getCacheControl(httpRequest.getRequestURI());
                if (log.isDebugEnabled()) {
                    log.debug("{} -> Cache-Control: {}", (Object)httpRequest.getRequestURI(), (Object)cacheControl);
                }
                if (cacheControl != null && !"ignore".equals(cacheControl)) {
                    httpResponse.setHeader("Cache-Control", cacheControl);
                }
                chain.doFilter(request, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private String getCacheControl(String url) {
        for (Map.Entry<String, String> rec : mappings.entrySet()) {
            if (!FileUtil.matches(url, rec.getKey(), null)) continue;
            return rec.getValue();
        }
        return null;
    }

    public void init(FilterConfig arg0) throws ServletException {
        try {
            CacheControlFilter.init(new ContextProperties().getProperty("cachecontrol", "*:no-cache,no-store,must-revalidate"));
        }
        catch (IOException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public static void init(String cacheControlSpecs) {
        StringTokenizer st = new StringTokenizer(cacheControlSpecs, ";", false);
        while (st.hasMoreElements()) {
            String token = (String)st.nextElement();
            token = token.trim();
            try {
                String[] spec = token.split(":");
                mappings.put(spec[0].trim(), spec[1].trim());
            }
            catch (NumberFormatException e) {
                log.warn("Cannot parse cache-control specification {}", (Object)token, (Object)e);
            }
        }
    }
}

