/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class VersionsDataServlet
extends AbstractDataServlet {
    private static final String DOC_ID = "docId";
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        List<?> records = this.executeQuery(request, max);
        DateFormat df = this.getDateFormat();
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        for (Object gridRecord : records) {
            Object[] cols = (Object[])gridRecord;
            writer.print("<version>");
            writer.print("<id>" + String.valueOf(cols[0]) + "</id>");
            writer.print("<user><![CDATA[" + String.valueOf(cols[1] == null ? "" : cols[1]) + "]]></user>");
            writer.print("<event><![CDATA[" + I18N.message((String)cols[2], locale) + "]]></event>");
            writer.print("<version>" + String.valueOf(cols[3]) + "</version>");
            writer.print("<fileVersion>" + String.valueOf(cols[4]) + "</fileVersion>");
            writer.print("<revision>" + String.valueOf(cols[17]) + "</revision>");
            writer.print("<date>" + df.format((Date)cols[5]) + "</date>");
            writer.print("<comment><![CDATA[" + String.valueOf(cols[6] == null ? "" : cols[6]) + "]]></comment>");
            writer.print("<docid>" + String.valueOf(cols[7]) + "</docid>");
            writer.print("<filename><![CDATA[" + (String)cols[8] + "]]></filename>");
            writer.print("<customid><![CDATA[" + String.valueOf(cols[9] == null ? "" : cols[9]) + "]]></customid>");
            writer.print("<size>" + String.valueOf(cols[10]) + "</size>");
            writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon((String)cols[11])) + "</icon>");
            writer.print("<type>" + (String)cols[11] + "</type>");
            if (cols[12] != null) {
                writer.print("<template><![CDATA[" + String.valueOf(cols[12]) + "]]></template>");
            }
            if (cols[13] != null) {
                writer.print("<workflowStatus><![CDATA[" + String.valueOf(cols[13]) + "]]></workflowStatus>");
            }
            if (cols[14] != null) {
                writer.print("<workflowStatusDisplay><![CDATA[" + String.valueOf(cols[14]) + "]]></workflowStatusDisplay>");
            }
            writer.print("<userId>" + String.valueOf(cols[15]) + "</userId>");
            if (cols[16] != null) {
                writer.print("<color><![CDATA[" + String.valueOf(cols[16]) + "]]></color>");
            }
            writer.print("</version>");
        }
        writer.write("</list>");
    }

    private List<?> executeQuery(HttpServletRequest request, Integer max) throws PersistenceException {
        VersionDAO dao = Context.get(VersionDAO.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder("select A.id, A.username, A.event, A.version, A.fileVersion, A.versionDate, A.comment, A.docId, A.fileName, A.customId, A.fileSize, A.type, A.templateName, A.workflowStatus, A.workflowStatusDisplay, A.userId, A.color, A.revision ");
        if (request.getParameter(DOC_ID) != null) {
            long docId = Long.parseLong(request.getParameter(DOC_ID));
            DocumentDAO ddao = Context.get(DocumentDAO.class);
            Document doc = ddao.findDocument(docId);
            if (doc != null) {
                docId = doc.getId();
            }
            query.append(" from Version A where A.deleted = 0 and A.docId = :docId ");
            params.put(DOC_ID, docId);
        } else {
            query.append(" from Version A, Archive B where A.deleted = 0 and A in elements(B.entries) ");
            query.append(" and B.id = :archiveId");
            params.put("archiveId", Long.parseLong(request.getParameter("archiveId")));
        }
        query.append(" order by A.versionDate desc ");
        return dao.findByQuery(query.toString(), params, max != null ? max : 100);
    }
}

