/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class TemplatesDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        Long templateId = StringUtils.isNotEmpty(request.getParameter("templateId")) ? Long.valueOf(Long.parseLong(request.getParameter("templateId"))) : null;
        Integer type = request.getParameter("type") != null ? Integer.valueOf(Integer.parseInt(request.getParameter("type"))) : null;
        TemplateDAO templateDao = Context.get(TemplateDAO.class);
        Template template = templateId != null ? (Template)templateDao.findById(templateId) : null;
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        if ("true".equals(request.getParameter("withempty"))) {
            writer.print("<template>");
            writer.print("<id></id>");
            writer.print("<name> </name>");
            writer.print("<documents>0</documents>");
            writer.print("<readonly>false</readonly>");
            writer.print("</template>");
        }
        List<Object> templates = null;
        templates = type != null ? templateDao.findByType(type, session.getTenantId()) : templateDao.findAll(session.getTenantId());
        for (Template templ : templates) {
            if (!templateDao.isReadEnable(templ.getId(), session.getUserId()) && (template == null || !template.equals(templ))) continue;
            writer.print("<template>");
            writer.print("<id>" + templ.getId() + "</id>");
            writer.print("<name><![CDATA[" + templ.getName() + "]]></name>");
            writer.print("<label><![CDATA[" + StringUtils.defaultIfEmpty(templ.getLabel(), templ.getName()) + "]]></label>");
            writer.print("<description><![CDATA[" + templ.getDescription() + "]]></description>");
            writer.print("<readonly>" + Boolean.toString(templ.getReadonly() == 1) + "</readonly>");
            writer.print("<type>" + templ.getType() + "</type>");
            writer.print("</template>");
        }
        writer.write("</list>");
    }
}

