/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TagsDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        ContextProperties config = Context.get().getProperties();
        String mode = config.getProperty(session.getTenantName() + ".tag.mode");
        String firstLetter = request.getParameter("firstLetter");
        String editing = request.getParameter("editing");
        Long docId = this.getDocId(request);
        Long folderId = this.getFolderId(request);
        long mx = config.getLong(session.getTenantName() + ".tag.select.maxtags", max != null ? max : 100);
        HashMap<String, Long> tagsMap = this.buildTagsMap(session, mode, firstLetter, editing);
        List<String> words = new ArrayList<String>(tagsMap.keySet());
        Collections.sort(words);
        if ((long)words.size() > mx && mx > 0L) {
            words = words.stream().limit(mx).collect(Collectors.toList());
        }
        this.enrichMapWithDocumentTags(docId, tagsMap, words);
        this.enrichMapWithFolderTags(folderId, tagsMap, words);
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        int i = 0;
        for (String tag : words) {
            writer.print("<tag>");
            writer.print("<index>" + i++ + "</index>");
            writer.print("<word><![CDATA[" + tag + "]]></word>");
            writer.print("<count>" + String.valueOf(tagsMap.get(tag)) + "</count>");
            writer.print("</tag>");
        }
        writer.write("</list>");
    }

    private void enrichMapWithFolderTags(Long folderId, HashMap<String, Long> tagsMap, List<String> words) throws PersistenceException {
        FolderDAO fDao = Context.get(FolderDAO.class);
        if (folderId != null) {
            List<String> tags = fDao.findTags(folderId);
            for (String tag : tags) {
                tagsMap.computeIfAbsent(tag, k -> 1L);
                if (words.contains(tag)) continue;
                words.add(tag);
            }
        }
    }

    private void enrichMapWithDocumentTags(Long docId, HashMap<String, Long> tagsMap, List<String> words) throws PersistenceException {
        if (docId != null) {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            List<String> tags = docDao.findTags(docId);
            for (String tag : tags) {
                tagsMap.computeIfAbsent(tag, k -> 1L);
                if (words.contains(tag)) continue;
                words.add(tag);
            }
        }
    }

    private HashMap<String, Long> buildTagsMap(Session session, String mode, String firstLetter, String editing) throws PersistenceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        HashMap tagsMap = new HashMap();
        if (("preset".equals(firstLetter) || "preset".equals(mode)) && "true".equals(editing)) {
            GenericDAO gDao = Context.get(GenericDAO.class);
            List<Generic> buf = gDao.findByTypeAndSubtype("tag", null, null, session.getTenantId());
            for (Generic generic : buf) {
                tagsMap.put(generic.getSubtype(), 0L);
            }
        } else {
            tagsMap = StringUtils.isNotEmpty(firstLetter) ? (HashMap)docDao.findTags(firstLetter, session.getTenantId()) : (HashMap)docDao.findTags(null, session.getTenantId());
        }
        return tagsMap;
    }

    private Long getFolderId(HttpServletRequest request) {
        Long folderId = null;
        if (request.getParameter("folderId") != null) {
            folderId = Long.parseLong(request.getParameter("folderId"));
        }
        return folderId;
    }

    private Long getDocId(HttpServletRequest request) {
        Long docId = null;
        if (request.getParameter("docId") != null) {
            docId = Long.parseLong(request.getParameter("docId"));
        }
        return docId;
    }
}

