/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StoresDataServlet
extends AbstractDataServlet {
    private static final String STORE = "store.";
    private static final String CLOSE_STORE = "</store>";
    private static final String START_STORE = "<store>";
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        boolean types = "true".equals(request.getParameter("types"));
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        if (types) {
            Store manager = Context.get(Store.class);
            Set<String> set = manager.getStoreDefinitions().keySet();
            for (String type : set.stream().sorted().toList()) {
                if (!manager.getStoreDefinitions().get(type).isEnabled()) continue;
                writer.print(START_STORE);
                writer.print("<id>" + type + "</id>");
                writer.print("<name><![CDATA[" + I18N.message(STORE + type, locale) + "]]></name>");
                writer.print("<type>" + type + "</type>");
                writer.print(CLOSE_STORE);
            }
        } else {
            if ("true".equals(request.getParameter("empty"))) {
                writer.print(START_STORE);
                writer.print("<id />");
                writer.print("<name />");
                writer.print("<path />");
                writer.print("<type>fs</type>");
                writer.print(CLOSE_STORE);
            }
            this.printStores(writer, request, session);
        }
        writer.write("</list>");
    }

    private void printStores(PrintWriter writer, HttpServletRequest request, Session session) {
        ContextProperties conf = Context.get().getProperties();
        int i = 1;
        while (i <= 99) {
            String path = conf.getProperty(STORE + i + ".dir");
            if (!StringUtils.isEmpty(path)) {
                writer.print(START_STORE);
                writer.print("<id>" + i + "</id>");
                writer.print("<name>Store " + i + "</name>");
                writer.print("<path><![CDATA[" + path + "]]></path>");
                writer.print("<write>" + Boolean.toString(conf.getInt("store.write") == i) + "</write>");
                String type = conf.getProperty(STORE + i + ".type");
                if (StringUtils.isEmpty(type)) {
                    type = "fs";
                }
                writer.print("<type>" + type + "</type>");
                this.printParameters(writer, request, session, i, type);
                writer.print(CLOSE_STORE);
            }
            ++i;
        }
    }

    private void printParameters(PrintWriter writer, HttpServletRequest request, Session session, int i, String type) {
        Store manager;
        Store st;
        ContextProperties conf = Context.get().getProperties();
        if (this.isParameters(request, session) && (st = (manager = Context.get(Store.class)).getStoreDefinitions().get(type)) != null) {
            for (String name : st.getParameterNames()) {
                String value = conf.getProperty(STORE + i + "." + name, "");
                writer.print("<" + name + "><![CDATA[" + value + "]]></" + name + ">");
            }
        }
    }

    private boolean isParameters(HttpServletRequest request, Session session) {
        boolean parameters = "true".equals(request.getParameter("parameters"));
        if (parameters) {
            MenuDAO mDao = Context.get(MenuDAO.class);
            parameters = session.getTenantId() == 1L && mDao.isReadEnable(105L, session.getUserId());
        }
        return parameters;
    }
}

