/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class OnlineUsersDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        UserDAO userDao = Context.get(UserDAO.class);
        SessionDAO sessionDao = Context.get(SessionDAO.class);
        Session currentSession = ServletUtil.validateSession(request);
        String tenant = currentSession.getTenantName();
        List<Session> sessions = sessionDao.findByNode(null);
        HashSet<User> users = new HashSet<User>();
        for (Session sess : sessions) {
            User user;
            if (sess.getStatus() != 0 || !tenant.equals(sess.getTenantName()) || (user = userDao.findByUsername(sess.getUsername())) == null || users.contains(user)) continue;
            users.add(user);
        }
        PrintWriter writer = response.getWriter();
        writer.print("<list>");
        for (User user : users) {
            writer.print("<user>");
            writer.print("<id>" + user.getId() + "</id>");
            writer.print("<username><![CDATA[" + user.getUsername() + "]]></username>");
            writer.print("<user><![CDATA[" + user.getFullName() + "]]></user>");
            writer.print("</user>");
        }
        writer.print("</list>");
    }
}

