/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class LinksDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        Long docId = this.getDocId(request);
        String parent = this.getParent(request);
        Long parentDocId = this.getParentDocId(docId, parent);
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        DocumentDAO dao = Context.get(DocumentDAO.class);
        StringBuilder query = new StringBuilder("select A.id, 0, A.type, A.document1.id, A.document1.fileName, A.document1.type, A.document2.id, A.document2.fileName, A.document2.type, ");
        query.append(" A.document1.folder.id, A.document2.folder.id, A.document1.color, A.document2.color from DocumentLink A where A.deleted = 0");
        query.append(" and ((A.document1.id = " + String.valueOf(parentDocId) + ")");
        query.append(" or  (A.document2.id = " + String.valueOf(parentDocId) + ")");
        query.append(") ");
        if (!docId.equals(parentDocId)) {
            query.append(" and not A.document1.id = " + String.valueOf(docId));
            query.append(" and not A.document2.id = " + String.valueOf(docId));
        }
        List<Object[]> records = dao.findByQuery(query.toString(), null, null);
        Iterator<Object[]> iterator = records.iterator();
        while (iterator.hasNext()) {
            Object[] gridRecord;
            Object[] cols = gridRecord = iterator.next();
            this.printLink(writer, cols, parent, parentDocId, null);
        }
        this.printAttributesOfTypeDocument(docId, parent, parentDocId, session.getTenantName(), writer);
        writer.write("</list>");
    }

    private void printAttributesOfTypeDocument(Long docId, String parent, Long parentDocId, String tenant, PrintWriter writer) throws PersistenceException {
        if (!Context.get().getProperties().getBoolean(tenant + ".gui.showdocattrsaslinks", false)) {
            return;
        }
        StringBuilder query = new StringBuilder("select DOC1.ld_id, DOC1.ld_folderid, DOC1.ld_filename, DOC1.ld_color, E.ld_name, DOC2.ld_id, DOC2.ld_folderid, E.ld_stringvalue, DOC2.ld_color, E.ld_label ");
        query.append(" from ld_document_ext E, ld_document DOC1, ld_document DOC2 where E.ld_type=7");
        query.append(" and DOC1.ld_deleted=0 and DOC2.ld_deleted=0 and E.ld_intvalue is not null ");
        query.append(" and DOC1.ld_id = E.ld_docid ");
        query.append(" and DOC2.ld_id = E.ld_intvalue ");
        query.append(" and E.ld_docid = ");
        query.append(parentDocId);
        if (!docId.equals(parentDocId)) {
            query.append(" and not DOC1.ld_id = " + String.valueOf(docId));
            query.append(" and not DOC2.ld_id = " + String.valueOf(docId));
        }
        query.append(" UNION ");
        query.append("select DOC1.ld_id, DOC1.ld_folderid, DOC1.ld_filename, DOC1.ld_color, E.ld_name, DOC2.ld_id, DOC2.ld_folderid, DOC2.ld_filename, DOC2.ld_color, E.ld_label ");
        query.append(" from ld_document_ext E, ld_document DOC1, ld_document DOC2 where E.ld_type=7");
        query.append(" and DOC1.ld_deleted=0 and DOC2.ld_deleted=0 and E.ld_intvalue is not null ");
        query.append(" and DOC1.ld_id = E.ld_docid ");
        query.append(" and DOC2.ld_id = E.ld_intvalue ");
        query.append(" and E.ld_intvalue = ");
        query.append(parentDocId);
        if (!docId.equals(parentDocId)) {
            query.append(" and not DOC1.ld_id = " + String.valueOf(docId));
            query.append(" and not DOC2.ld_id = " + String.valueOf(docId));
        }
        DocumentDAO dao = Context.get(DocumentDAO.class);
        dao.queryForResultSet(query.toString(), null, null, rows -> {
            while (rows.next()) {
                ArrayList<Object> cols = new ArrayList<Object>(Collections.nCopies(13, null));
                long docId1 = rows.getLong(1);
                long docId2 = rows.getLong(6);
                String attributeName = rows.getString(5);
                cols.set(0, (-docId1));
                cols.set(1, rows.getLong(2));
                cols.set(2, StringUtils.defaultString(rows.getString(10), attributeName));
                cols.set(3, docId1);
                cols.set(9, rows.getLong(2));
                cols.set(10, rows.getLong(7));
                if (parentDocId == docId1) {
                    cols.set(6, docId2);
                    cols.set(7, rows.getString(8));
                    cols.set(8, rows.getString(8));
                    cols.set(12, rows.getString(9));
                } else {
                    cols.set(3, docId1);
                    cols.set(4, rows.getString(3));
                    cols.set(5, rows.getString(3));
                    cols.set(11, rows.getString(4));
                }
                this.printLink(writer, cols.toArray(new Object[0]), parent, parentDocId, attributeName);
            }
        });
    }

    private void printLink(PrintWriter writer, Object[] cols, String parent, Long parentDocId, String attribute) {
        writer.print("<link>");
        writer.print("<linkId>" + String.valueOf(cols[0]) + "</linkId>");
        writer.print("<folderId>" + String.valueOf(cols[1]) + "</folderId>");
        writer.print("<type>" + String.valueOf(cols[2]) + "</type>");
        writer.print("<parent>" + parent + "</parent>");
        writer.print("<folderId1>" + String.valueOf(cols[9]) + "</folderId1>");
        writer.print("<folderId2>" + String.valueOf(cols[10]) + "</folderId2>");
        if (StringUtils.isNotEmpty(attribute)) {
            writer.print("<attribute>" + attribute + "</attribute>");
        }
        if (parentDocId.longValue() == ((Long)cols[3]).longValue()) {
            writer.print("<documentId>" + parent + "-" + String.valueOf(cols[6]) + "</documentId>");
            writer.print("<filename><![CDATA[" + (String)cols[7] + "]]></filename>");
            writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon((String)cols[8])) + "</icon>");
            writer.print("<direction>out</direction>");
            if (cols[12] != null) {
                writer.print("<color><![CDATA[" + String.valueOf(cols[12]) + "]]></color>");
            }
        } else {
            writer.print("<documentId>" + parent + "-" + String.valueOf(cols[3]) + "</documentId>");
            writer.print("<filename><![CDATA[" + (String)cols[4] + "]]></filename>");
            writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon((String)cols[5])) + "</icon>");
            if (cols[11] != null) {
                writer.print("<color><![CDATA[" + String.valueOf(cols[11]) + "]]></color>");
            }
            writer.print("<direction>in</direction>");
        }
        writer.print("</link>");
    }

    private Long getParentDocId(Long docId, String parent) {
        Long parentDocId = docId;
        if (parent.contains("-")) {
            parentDocId = Long.parseLong(parent.substring(parent.lastIndexOf(45) + 1));
        } else if (!"/".equals(parent)) {
            parentDocId = Long.parseLong(parent);
        }
        return parentDocId;
    }

    private String getParent(HttpServletRequest request) {
        String parent = request.getParameter("parent");
        if (StringUtils.isEmpty(parent)) {
            parent = "/";
        }
        return parent;
    }

    private Long getDocId(HttpServletRequest request) throws PersistenceException, IOException {
        Long docId = null;
        if (StringUtils.isNotEmpty(request.getParameter("docId"))) {
            docId = Long.parseLong(request.getParameter("docId"));
            DocumentDAO ddao = Context.get(DocumentDAO.class);
            Document doc = ddao.findDocument(docId);
            if (doc != null) {
                docId = doc.getId();
            }
        }
        if (docId == null) {
            throw new IOException("No document ID");
        }
        return docId;
    }
}

