/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.job.JobManager;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JobsDataServlet.class);

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        int maxRecords = max != null ? max : 100;
        String group = request.getParameter("group");
        boolean groupsonly = request.getParameter("groupsonly") != null;
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        if (groupsonly) {
            try {
                JobManager jobManager = Context.get(JobManager.class);
                for (String name : jobManager.getGroups()) {
                    writer.print("<job>");
                    writer.print("<group><![CDATA[" + name + "]]></group>");
                    writer.print("</job>");
                }
            }
            catch (SchedulerException e) {
                logger.warn(e.getMessage(), e);
            }
        } else {
            try {
                this.writeJobs(writer, session, maxRecords, group);
            }
            catch (SchedulerException e) {
                logger.warn(e.getMessage(), e);
            }
        }
        writer.write("</list>");
    }

    private void writeJobs(PrintWriter writer, Session session, int maxRecords, String group) throws SchedulerException, PersistenceException {
        DateFormat df = this.getDateFormat();
        TenantDAO tDao = Context.get(TenantDAO.class);
        Map<Long, String> tenants = tDao.findAll().stream().collect(Collectors.toMap(t -> t.getId(), Tenant::getName));
        int count = 0;
        JobManager jobManager = Context.get(JobManager.class);
        for (Trigger trigger : jobManager.getTriggers(group, session.getTenantId() == 1L ? null : Long.valueOf(session.getTenantId()))) {
            JobDetail job;
            if (count++ >= maxRecords) break;
            writer.print("<job>");
            writer.print("<name><![CDATA[" + trigger.getJobKey().getName() + "]]></name>");
            writer.print("<group><![CDATA[" + trigger.getJobKey().getGroup() + "]]></group>");
            writer.print("<trigger><![CDATA[" + trigger.getKey().getName() + "]]></trigger>");
            if (trigger.getJobDataMap() != null && trigger.getJobDataMap().containsKey((Object)"tenantId")) {
                writer.print("<tenantId>" + trigger.getJobDataMap().getLong("tenantId") + "</tenantId>");
                writer.print("<tenant><![CDATA[" + tenants.get(trigger.getJobDataMap().getLong("tenantId")) + "]]></tenant>");
            }
            if ((job = jobManager.getJob(trigger.getJobKey().getName(), trigger.getJobKey().getGroup())).getDescription() != null) {
                writer.print("<description><![CDATA[" + job.getDescription() + "]]></description>");
            }
            Date previousFireTime = trigger.getPreviousFireTime();
            Date nextFireTime = trigger.getNextFireTime();
            if (previousFireTime != null) {
                writer.print("<previousFire>" + df.format(previousFireTime) + "</previousFire>");
                nextFireTime = trigger.getFireTimeAfter(previousFireTime);
            }
            if (nextFireTime != null) {
                writer.print("<nextFire>" + df.format(nextFireTime) + "</nextFire>");
            }
            writer.print("</job>");
        }
    }
}

