/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.searchengine.indexer.IndexerTask;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class IndexingQueueDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(IndexingQueueDataServlet.class);

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        UserDAO dao = Context.get(UserDAO.class);
        User user = (User)dao.findById(session.getUserId());
        dao.initialize(user);
        String where = this.prepareWhere(request, session);
        StringBuilder query = new StringBuilder("select ld_id, ld_customid, ld_docref, ld_type, ld_version, ld_lastModified, ld_date, ld_publisher, ld_creation, ld_creator, ld_filesize, ld_immutable, ld_indexed, ld_lockuserid, ld_filename, ld_status, ld_signed, ld_type, ld_fileversion, ld_color from ld_document where " + where);
        if (log.isDebugEnabled()) {
            log.debug("Running filter query {}", (Object)query);
        }
        List<Object[]> records = dao.query(query.toString(), new RowMapper<Object[]>(){

            public Object[] mapRow(ResultSet rs, int row) throws SQLException {
                Object[] rec = new Object[]{rs.getLong(1), rs.getString(2), rs.getLong(3) != 0L ? Long.valueOf(rs.getLong(3)) : null, rs.getString(4), rs.getString(5), rs.getTimestamp(6), rs.getTimestamp(7), rs.getString(8), rs.getTimestamp(9), rs.getString(10), rs.getLong(11), rs.getInt(12), rs.getInt(13), rs.getLong(14), rs.getString(15), rs.getInt(16), rs.getInt(17), rs.getString(18), rs.getString(19), rs.getString(20)};
                return rec;
            }
        }, max != null ? max : 100);
        if (log.isDebugEnabled()) {
            log.debug("Retrieved {} records", (Object)records.size());
        }
        this.printDocuments(response, session, records);
    }

    private void printDocuments(HttpServletResponse response, Session session, List<Object[]> records) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        ContextProperties config = Context.get().getProperties();
        for (Object[] cols : records) {
            if (!FileUtil.matches(cols[14].toString(), config.getProperty(session.getTenantName() + ".barcode.includes"), config.getProperty(session.getTenantName() + ".barcode.excludes"))) continue;
            this.printDocument(writer, cols);
        }
        writer.write("</list>");
    }

    private void printDocument(PrintWriter writer, Object[] cols) {
        DateFormat df = this.getDateFormat();
        writer.print("<document>");
        writer.print("<id>" + String.valueOf(cols[0]) + "</id>");
        if (cols[1] != null) {
            writer.print("<customId><![CDATA[" + String.valueOf(cols[1]) + "]]></customId>");
        } else {
            writer.print("<customId> </customId>");
        }
        writer.print("<docref>" + String.valueOf(cols[2] != null ? cols[2] : "") + "</docref>");
        writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon((String)cols[3])) + "</icon>");
        writer.print("<version>" + String.valueOf(cols[4]) + "</version>");
        writer.print("<lastModified>" + df.format(cols[5]) + "</lastModified>");
        writer.print("<published>" + df.format(cols[6]) + "</published>");
        writer.print("<publisher><![CDATA[" + String.valueOf(cols[7]) + "]]></publisher>");
        writer.print("<created>" + df.format(cols[8]) + "</created>");
        writer.print("<creator><![CDATA[" + String.valueOf(cols[9]) + "]]></creator>");
        writer.print("<size>" + String.valueOf(cols[10]) + "</size>");
        if (Integer.parseInt(cols[11].toString()) == 0) {
            writer.print("<immutable>blank</immutable>");
        } else if (Integer.parseInt(cols[11].toString()) == 1) {
            writer.print("<immutable>stop</immutable>");
        }
        writer.print("<indexed>" + String.valueOf(cols[12]) + "</indexed>");
        if (Integer.parseInt(cols[15].toString()) == 2) {
            writer.print("<locked>lock</locked>");
        } else if (Integer.parseInt(cols[15].toString()) == 1) {
            writer.print("<locked>page_edit</locked>");
        } else {
            writer.print("<locked>blank</locked>");
        }
        if (cols[14] != null) {
            writer.print("<lockUserId>" + String.valueOf(cols[13]) + "</lockUserId>");
        }
        writer.print("<filename><![CDATA[" + String.valueOf(cols[14]) + "]]></filename>");
        writer.print("<status>" + String.valueOf(cols[15]) + "</status>");
        if (Integer.parseInt(cols[16].toString()) == 0) {
            writer.print("<signed>blank</signed>");
        } else if (Integer.parseInt(cols[16].toString()) == 1) {
            writer.print("<signed>rosette</signed>");
        }
        writer.print("<type>" + String.valueOf(cols[17]) + "</type>");
        writer.print("<fileVersion><![CDATA[" + String.valueOf(cols[18]) + "]]></fileVersion>");
        if (cols[19] != null) {
            writer.print("<color><![CDATA[" + String.valueOf(cols[19]) + "]]></color>");
        }
        writer.print("</document>");
    }

    protected String prepareWhere(HttpServletRequest request, Session session) {
        String[] queryFragments = IndexerTask.prepareQuery();
        StringBuilder where = new StringBuilder(queryFragments[0].replace("_entity.", "ld_"));
        where.append((String)(StringUtils.isNotEmpty(queryFragments[1]) ? " order by " + queryFragments[1].replace("_entity.", "ld_") : ""));
        return where.toString().replace("ld_indexingStatus", "ld_indexed");
    }
}

