/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FolderHistoryDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        MenuDAO mDao = Context.get(MenuDAO.class);
        boolean showSid = mDao.isReadEnable(1601L, session.getUserId());
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        DocumentHistoryDAO dao = Context.get(DocumentHistoryDAO.class);
        StringBuilder query = new StringBuilder("select A.username, A.event, A.date, A.comment, A.filename, A.path, A.sessionId, A.id, A.reason, A.ip, A.device, A.geolocation, A.userId, A.color, A.keyLabel from FolderHistory A where A.deleted = 0 ");
        if (request.getParameter("id") != null) {
            query.append(" and A.folderId=" + request.getParameter("id"));
        }
        query.append(" order by A.date desc ");
        List<Object[]> records = dao.findByQuery(query.toString(), null, max != null ? max : 100);
        Iterator<Object[]> iterator = records.iterator();
        while (iterator.hasNext()) {
            Object[] gridRecord;
            Object[] cols = gridRecord = iterator.next();
            this.printHistory(writer, cols, locale, showSid);
        }
        writer.write("</list>");
    }

    private void printHistory(PrintWriter writer, Object[] cols, Locale locale, boolean showSid) {
        DateFormat df = this.getDateFormat();
        writer.print("<history>");
        writer.print("<id>" + String.valueOf(cols[7]) + "</id>");
        writer.print("<user><![CDATA[" + String.valueOf(cols[0] == null ? "" : cols[0]) + "]]></user>");
        writer.print("<event><![CDATA[" + I18N.message((String)cols[1], locale) + "]]></event>");
        writer.print("<date>" + df.format((Date)cols[2]) + "</date>");
        writer.print("<comment><![CDATA[" + String.valueOf(cols[3] == null ? "" : cols[3]) + "]]></comment>");
        writer.print("<filename><![CDATA[" + String.valueOf(cols[4] == null ? "" : cols[4]) + "]]></filename>");
        this.printIcon(writer, cols);
        writer.print("<path><![CDATA[" + String.valueOf(cols[5] == null ? "" : cols[5]) + "]]></path>");
        this.printSid(writer, cols, showSid);
        writer.print("<reason><![CDATA[" + String.valueOf(cols[8] == null ? "" : cols[8]) + "]]></reason>");
        writer.print("<ip><![CDATA[" + String.valueOf(cols[9] == null ? "" : cols[9]) + "]]></ip>");
        writer.print("<device><![CDATA[" + String.valueOf(cols[10] == null ? "" : cols[10]) + "]]></device>");
        writer.print("<userId>" + String.valueOf(cols[12]) + "</userId>");
        this.printGeolocation(writer, cols);
        if (cols[13] != null) {
            writer.print("<color>" + String.valueOf(cols[13]) + "</color>");
        }
        if (cols[14] != null) {
            writer.print("<key><![CDATA[" + String.valueOf(cols[14]) + "]]></key>");
        }
        writer.print("</history>");
    }

    private void printGeolocation(PrintWriter writer, Object[] cols) {
        if (cols[11] != null) {
            writer.print("<geolocation><![CDATA[" + String.valueOf(cols[11]) + "]]></geolocation>");
        }
    }

    private void printSid(PrintWriter writer, Object[] cols, boolean showSid) {
        if (showSid) {
            writer.print("<sid><![CDATA[" + String.valueOf(cols[6] == null ? "" : cols[6]) + "]]></sid>");
        }
    }

    private void printIcon(PrintWriter writer, Object[] cols) {
        if (cols[4] != null && !FileUtil.getExtension(cols[4].toString()).isEmpty()) {
            writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon(FileUtil.getExtension((String)cols[4]))) + "</icon>");
        } else {
            writer.print("<icon>folder</icon>");
        }
    }
}

