/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class EnvironmentDataServlet
extends AbstractDataServlet {
    private static final String CDATA_VALUE = "]]></value>";
    private static final String VALUE_CDATA = "<value><![CDATA[";
    private static final String ENTRY_CLOSE = "</entry>";
    private static final String ENTRY_SCOPE_DATABASE_SCOPE = "<entry><scope>database</scope>";
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            writer.print("<entry><scope>system</scope>");
            writer.print("<name><![CDATA[" + entry.getKey() + "]]></name>");
            writer.print(VALUE_CDATA + entry.getValue() + CDATA_VALUE);
            writer.print(ENTRY_CLOSE);
        }
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            writer.print("<entry><scope>java</scope>");
            writer.print("<name><![CDATA[" + String.valueOf(entry.getKey()) + "]]></name>");
            writer.print(VALUE_CDATA + String.valueOf(entry.getValue()) + CDATA_VALUE);
            writer.print(ENTRY_CLOSE);
        }
        DocumentDAO dao = Context.get(DocumentDAO.class);
        Map<String, String> meta = dao.getDatabaseMetadata();
        for (Map.Entry<String, String> entry : meta.entrySet()) {
            writer.print(ENTRY_SCOPE_DATABASE_SCOPE);
            writer.print("<name>" + entry.getKey() + "</name>");
            writer.print(VALUE_CDATA + entry.getValue() + CDATA_VALUE);
            writer.print(ENTRY_CLOSE);
        }
        writer.write("</list>");
    }
}

