/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentComparator;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class DocumentsDataServlet
extends AbstractDataServlet {
    private static final String INDEXED = "indexed";
    private static final Logger log = LoggerFactory.getLogger(DocumentsDataServlet.class);
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        int maxRecords = max != null ? max : 100;
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        DocumentDAO dao = Context.get(DocumentDAO.class);
        int page = this.getPage(request);
        Integer status = this.getStatus(request);
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        String sql = "select ld_docid from ld_bookmark where ld_type=0 and ld_deleted = 0 and ld_userid = " + session.getUserId();
        List<Long> bookmarks = dao.queryForList(sql, Long.class);
        ArrayList<Document> documentsInCurrentPage = new ArrayList<Document>();
        ArrayList<String> extendedAttributes = new ArrayList<String>();
        String extendedAttributesSpec = this.prepareExtendedAttributes(request, session, extendedAttributes);
        HashMap<String, Object> extendedAttributesValues = new HashMap<String, Object>();
        Document hiliteDoc = null;
        if (status != null && status.intValue() != DocumentStatus.ARCHIVED.ordinal()) {
            this.findDocumentsByStatus(session, maxRecords, page, status, documentsInCurrentPage);
        } else if (StringUtils.isNotEmpty(request.getParameter("docIds"))) {
            this.findDocumentsByIds(request, session, documentsInCurrentPage);
        } else {
            hiliteDoc = this.findDocumentsByFilters(request, session, locale, maxRecords, page, documentsInCurrentPage, extendedAttributes, extendedAttributesSpec, extendedAttributesValues);
        }
        for (Document document : documentsInCurrentPage) {
            this.printDocument(writer, document, hiliteDoc, bookmarks, extendedAttributes, extendedAttributesValues, session.getTenantName());
        }
        writer.write("</list>");
    }

    private void printDocument(PrintWriter writer, Document document, Document hiliteDoc, List<Long> bookmarks, List<String> extendedAttributes, Map<String, Object> extendedAttributesValues, String tenant) {
        writer.print("<document>");
        writer.print("<id>" + document.getId() + "</id>");
        this.printFolderAndDocRef(writer, document);
        this.printCustomIdAndRevision(writer, document);
        writer.print("<icon>" + FileUtil.getBaseName(document.getIcon()) + "</icon>");
        writer.print("<version>" + document.getVersion() + "</version>");
        this.printDates(writer, document);
        writer.print("<creator><![CDATA[" + document.getCreator() + "]]></creator>");
        writer.print("<size>" + document.getFileSize() + "</size>");
        writer.print("<pages>" + document.getPages() + "</pages>");
        writer.print("<status>" + document.getStatus().ordinal() + "</status>");
        writer.print("<immutable>" + document.getImmutable() + "</immutable>");
        writer.print("<indexed>" + document.getIndexed().ordinal() + "</indexed>");
        writer.print("<password>" + StringUtils.isNotEmpty(document.getPassword()) + "</password>");
        writer.print("<signed>" + document.getSigned() + "</signed>");
        writer.print("<stamped>" + document.getStamped() + "</stamped>");
        writer.print("<bookmarked>" + (bookmarks.contains(document.getId()) || bookmarks.contains(document.getDocRef())) + "</bookmarked>");
        writer.print("<language>" + document.getLanguage() + "</language>");
        writer.print("<links>" + (document.getLinks() + (Context.get().getProperties().getBoolean(tenant + ".gui.showdocattrsaslinks", false) ? document.getDocAttrs() : 0)) + "</links>");
        writer.print("<publisherId>" + document.getPublisherId() + "</publisherId>");
        writer.print("<creatorId>" + document.getCreatorId() + "</creatorId>");
        writer.print("<tenantId>" + document.getTenantId() + "</tenantId>");
        this.printLockUser(writer, document);
        writer.print("<filename><![CDATA[" + document.getFileName() + "]]></filename>");
        writer.print("<type><![CDATA[" + document.getType() + "]]></type>");
        writer.print("<rating>" + String.valueOf(document.getRating() != null ? document.getRating() : "0") + "</rating>");
        writer.print("<fileVersion><![CDATA[" + document.getFileVersion() + "]]></fileVersion>");
        if (StringUtils.isNotEmpty(document.getComment())) {
            writer.print("<comment><![CDATA[" + document.getComment() + "]]></comment>");
        }
        if (StringUtils.isNotEmpty(document.getLastNote())) {
            writer.print("<lastNote><![CDATA[" + document.getLastNote() + "]]></lastNote>");
        }
        if (StringUtils.isNotEmpty(document.getWorkflowStatus())) {
            writer.print("<workflowStatus><![CDATA[" + document.getWorkflowStatus() + "]]></workflowStatus>");
        }
        if (StringUtils.isNotEmpty(document.getWorkflowStatusDisplay())) {
            writer.print("<workflowStatusDisplay><![CDATA[" + document.getWorkflowStatusDisplay() + "]]></workflowStatusDisplay>");
        }
        if (StringUtils.isNotEmpty(document.getColor())) {
            writer.print("<color><![CDATA[" + document.getColor() + "]]></color>");
        }
        writer.print("<publishedStatus>" + (document.isPublishing() ? "yes" : "no") + "</publishedStatus>");
        if (document.getExtResId() != null) {
            writer.print("<extResId><![CDATA[" + document.getExtResId() + "]]></extResId>");
        }
        if (document.getTemplateName() != null) {
            writer.print("<template><![CDATA[" + document.getTemplateName() + "]]></template>");
        }
        if (StringUtils.isNotEmpty(document.getTgs())) {
            writer.print("<tags><![CDATA[" + document.getTgs().substring(1, document.getTgs().length() - 1) + "]]></tags>");
        }
        this.printExtendedAttributes(writer, document, extendedAttributes, extendedAttributesValues);
        if (hiliteDoc != null && document.getId() == hiliteDoc.getId()) {
            writer.print("<order>1</order>");
        }
        writer.print("</document>");
    }

    private void printExtendedAttributes(PrintWriter writer, Document document, List<String> extendedAttributes, Map<String, Object> extendedAttributesValues) {
        DateFormat df = this.getDateFormat();
        if (!extendedAttributesValues.isEmpty()) {
            for (String name : extendedAttributes) {
                Object object;
                Object val = document.getValue(name);
                if (val == null) continue;
                writer.print("<ext_" + name + ">");
                Objects.requireNonNull(val);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Date.class, Integer.class, Long.class, Double.class}, (Object)object, n)) {
                    case 0: {
                        Date date = (Date)object;
                        writer.print(df.format(date));
                        break;
                    }
                    case 1: {
                        Integer intVal = (Integer)object;
                        writer.print(Integer.toString(intVal));
                        break;
                    }
                    case 2: {
                        Long longVal = (Long)object;
                        writer.print(Long.toString(longVal));
                        break;
                    }
                    case 3: {
                        Double doubleVal = (Double)object;
                        writer.print(Double.toString(doubleVal));
                        break;
                    }
                    default: {
                        writer.print("<![CDATA[" + String.valueOf(val) + "]]>");
                    }
                }
                writer.print("</ext_" + name + ">");
            }
        }
    }

    private void printDates(PrintWriter writer, Document document) {
        DateFormat df = this.getDateFormat();
        writer.print("<lastModified>" + (document.getLastModified() != null ? df.format(document.getLastModified()) : "") + "</lastModified>");
        writer.print("<published>" + (document.getDate() != null ? df.format(document.getDate()) : "") + "</published>");
        writer.print("<publisher><![CDATA[" + document.getPublisher() + "]]></publisher>");
        writer.print("<created>" + (document.getCreation() != null ? df.format(document.getCreation()) : "") + "</created>");
        if (document.getStartPublishing() != null) {
            writer.print("<startPublishing>" + df.format(document.getStartPublishing()) + "</startPublishing>");
        } else {
            writer.print("<startPublishing></startPublishing>");
        }
        if (document.getStopPublishing() != null) {
            writer.print("<stopPublishing>" + df.format(document.getStopPublishing()) + "</stopPublishing>");
        } else {
            writer.print("<stopPublishing></stopPublishing>");
        }
    }

    private void printLockUser(PrintWriter writer, Document document) {
        if (document.getLockUserId() != null) {
            writer.print("<lockUserId>" + String.valueOf(document.getLockUserId()) + "</lockUserId>");
        }
        if (document.getLockUser() != null) {
            writer.print("<lockUser><![CDATA[" + document.getLockUser() + "]]></lockUser>");
        }
    }

    private void printFolderAndDocRef(PrintWriter writer, Document document) {
        if (document.getFolder() != null) {
            writer.print("<folderId>" + document.getFolder().getId() + "</folderId>");
        }
        if (document.getDocRef() != null) {
            writer.print("<docref>" + String.valueOf(document.getDocRef()) + "</docref>");
            if (document.getDocRefType() != null) {
                writer.print("<docrefType>" + document.getDocRefType() + "</docrefType>");
            }
        }
    }

    private void printCustomIdAndRevision(PrintWriter writer, Document document) {
        writer.print("<customId><![CDATA[" + (document.getCustomId() != null ? document.getCustomId() : "") + "]]></customId>");
        writer.print("<revision><![CDATA[" + (document.getRevision() != null ? document.getRevision() : "") + "]]></revision>");
    }

    private void findDocumentsByIds(HttpServletRequest request, Session session, List<Document> documentsInCurrentPage) throws PersistenceException {
        String[] idsArray;
        DocumentDAO dao = Context.get(DocumentDAO.class);
        String[] stringArray = idsArray = request.getParameter("docIds").split(",");
        int n = idsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Document doc = null;
            try {
                doc = (Document)dao.findById(Long.parseLong(id));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (doc != null && doc.getDeleted() != 1 && dao.isReadAllowed(Long.parseLong(id), session.getUserId())) {
                documentsInCurrentPage.add(doc);
            }
            ++n2;
        }
    }

    private void findDocumentsByStatus(Session session, int maxRecords, int page, Integer status, List<Document> documentsInCurrentPage) throws PersistenceException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        List<Document> docs = dao.findByLockUserAndStatus(session.getUserId(), status != null ? DocumentStatus.values()[status] : null);
        int begin = (page - 1) * maxRecords;
        int end = Math.min(begin + maxRecords - 1, docs.size() - 1);
        int i = begin;
        while (i <= end) {
            Document doc = docs.get(i);
            if (dao.isReadAllowed(doc.getId(), session.getUserId())) {
                documentsInCurrentPage.add(doc);
            }
            ++i;
        }
    }

    private Document findDocumentsByFilters(HttpServletRequest request, Session session, Locale locale, int maxRecords, int page, List<Document> documentsInCurrentPage, List<String> extendedAttributes, String extendedAttributesSpec, Map<String, Object> extendedAttributesValues) throws PersistenceException, IOException {
        UserDAO udao = Context.get(UserDAO.class);
        User sessionUser = (User)udao.findById(session.getUserId());
        udao.initialize(sessionUser);
        String sort = request.getParameter("sort");
        Long folderId = this.getFolderId(request, session);
        folderId = this.getFolder(folderId);
        Long formId = this.getFormId(request);
        String filename = this.getFilename(request);
        this.retrieveExtendedAttributesValues(locale, extendedAttributes, extendedAttributesSpec, extendedAttributesValues, folderId, formId);
        List<Document> documents = this.exeucuteQuey(request, extendedAttributes, extendedAttributesValues, sessionUser, folderId, formId, filename);
        this.sortDocuments(documents, sort);
        this.takeDocumentsInCurrentPage(documents, documentsInCurrentPage, maxRecords, page);
        Long hiliteDocId = this.getHiliteDocId(request);
        return this.retrieveHiliteDoc(documentsInCurrentPage, folderId, hiliteDocId);
    }

    private List<Document> exeucuteQuey(HttpServletRequest request, List<String> extendedAttributes, Map<String, Object> extendedAttributesValues, User user, Long folderId, Long formId, String filename) throws PersistenceException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        StringBuilder query = new StringBuilder("select A.id, A.customId, A.docRef, A.type, A.version, A.lastModified, A.date, A.publisher, A.creation, A.creator, A.fileSize, A.immutable, A.indexingStatus, A.lockUserId, A.fileName, A.status,\n       A.signed, A.type, A.rating, A.fileVersion, A.comment, A.workflowStatus, A.startPublishing, A.stopPublishing, A.published, A.extResId, B.name, A.docRefType, A.stamped, A.lockUser,\n       A.password, A.pages, A.workflowStatusDisplay, A.language, A.links+A.docAttrs, A.tgs, A.creatorId, A.publisherId, A.color, A.folder.id, A.tenantId, A.lastNote, A.revision\n  from Document as A\n  left outer join A.template as B\n where A.deleted = 0\n   and not A.status=");
        query.append(DocumentStatus.ARCHIVED.ordinal());
        if (folderId != null) {
            query.append(" and A.folder.id=" + String.valueOf(folderId));
            List<Long> forbiddenDocIds = this.getForbiddenDocumentIds(user, folderId);
            if (!forbiddenDocIds.isEmpty()) {
                query.append(" and A.id not in(");
                query.append(forbiddenDocIds.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")));
                query.append(") ");
            }
        }
        if (formId != null) {
            query.append(" and A.formId=" + Long.toString(formId));
        }
        if (StringUtils.isNotEmpty(request.getParameter(INDEXED))) {
            query.append(" and A.indexingStatus=" + request.getParameter(INDEXED));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filename != null) {
            query.append(" and lower(A.fileName) like :fileName ");
            params.put("fileName", "%" + filename.toLowerCase() + "%");
        }
        List<Object> records = new ArrayList();
        if (folderId != null || filename != null || formId != null || StringUtils.isNotEmpty(request.getParameter(INDEXED))) {
            records = dao.findByQuery(query.toString(), params, null);
        }
        return this.enrichRecords(records, extendedAttributes, extendedAttributesValues, user);
    }

    private List<Long> getForbiddenDocumentIds(User user, long folderId) throws PersistenceException {
        if (user.isAdmin()) {
            return new ArrayList<Long>();
        }
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        String groupIdsString = user.getGroups().stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(","));
        StringBuilder forbiddenDocsQuery = new StringBuilder("select ld_docid\n  from ld_document_acl, ld_document\n where ld_docid=ld_id\n   and ld_deleted = 0\n   and ld_read = 0\n   and ld_groupId in(");
        forbiddenDocsQuery.append(groupIdsString);
        forbiddenDocsQuery.append(") and ld_folderid = ");
        forbiddenDocsQuery.append(Long.toString(folderId));
        return docDao.queryForList(forbiddenDocsQuery.toString(), Long.class);
    }

    private List<Document> enrichRecords(List<?> records, List<String> extendedAttributes, Map<String, Object> extendedAttributesValues, User user) throws PersistenceException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        ArrayList<Document> documents = new ArrayList<Document>();
        int i = 0;
        while (i < records.size()) {
            block2: {
                Document doc;
                block3: {
                    Object[] cols;
                    block1: {
                        cols = (Object[])records.get(i);
                        doc = new Document();
                        doc.setId((Long)cols[0]);
                        doc.setDocRef((Long)cols[2]);
                        doc.setFileName((String)cols[14]);
                        doc.setType((String)cols[17]);
                        doc.setDocRefType((String)cols[27]);
                        doc.setColor((String)cols[38]);
                        doc.setTenantId((Long)cols[40]);
                        doc.setIndexingStatus((IndexingStatus)((Object)cols[12]));
                        Folder f = new Folder();
                        f.setId((Long)cols[39]);
                        doc.setFolder(f);
                        if (doc.getDocRef() == null || doc.getDocRef() == 0L) break block1;
                        long aliasId = doc.getId();
                        long aliasDocRef = doc.getDocRef();
                        String aliasDocRefType = doc.getDocRefType();
                        String aliasFileName = doc.getFileName();
                        String aliasColor = doc.getColor();
                        String aliasType = doc.getType();
                        int aliasIndexed = doc.getIndexed().ordinal();
                        doc = (Document)dao.findById(aliasDocRef);
                        if (doc == null) break block2;
                        dao.initialize(doc);
                        doc.setId(aliasId);
                        doc.setDocRef(aliasDocRef);
                        doc.setDocRefType(aliasDocRefType);
                        doc.setFileName(aliasFileName);
                        doc.setColor(aliasColor);
                        doc.setType(aliasType);
                        doc.setIndexingStatus(aliasIndexed);
                        this.enrichAliasExtendedAttributes(doc, aliasId, extendedAttributes, extendedAttributesValues);
                        break block3;
                    }
                    doc.setStartPublishing((Date)cols[22]);
                    doc.setStopPublishing((Date)cols[23]);
                    doc.setPublished((Integer)cols[24]);
                    this.enrichPublishedDocument(doc, cols, extendedAttributes, extendedAttributesValues, user);
                }
                this.addDocument(doc, documents, user);
            }
            ++i;
        }
        return documents;
    }

    private void enrichPublishedDocument(Document doc, Object[] cols, List<String> extendedAttributes, Map<String, Object> extendedAttributesValues, User user) {
        if (doc.isPublishing() || user.isMemberOf("admin") || user.isMemberOf("publisher")) {
            doc.setCustomId((String)cols[1]);
            doc.setVersion((String)cols[4]);
            doc.setLastModified((Date)cols[5]);
            doc.setDate((Date)cols[6]);
            doc.setPublisher((String)cols[7]);
            doc.setCreation((Date)cols[8]);
            doc.setCreator((String)cols[9]);
            doc.setFileSize((Long)cols[10]);
            doc.setImmutable((Integer)cols[11]);
            doc.setIndexingStatus((IndexingStatus)((Object)cols[12]));
            doc.setLockUserId((Long)cols[13]);
            doc.setStatus((DocumentStatus)((Object)cols[15]));
            doc.setSigned((Integer)cols[16]);
            doc.setRating((Integer)cols[18]);
            doc.setFileVersion((String)cols[19]);
            doc.setComment((String)cols[20]);
            doc.setLastNote((String)cols[41]);
            doc.setRevision((String)cols[42]);
            doc.setWorkflowStatus((String)cols[21]);
            doc.setExtResId((String)cols[25]);
            doc.setTemplateName((String)cols[26]);
            doc.setStamped((Integer)cols[28]);
            doc.setLockUser((String)cols[29]);
            doc.setPassword((String)cols[30]);
            doc.setPages((Integer)cols[31]);
            doc.setWorkflowStatusDisplay((String)cols[32]);
            doc.setLanguage((String)cols[33]);
            doc.setLinks((Integer)cols[34]);
            doc.setTgs((String)cols[35]);
            doc.setCreatorId((Long)cols[36]);
            doc.setPublisherId((Long)cols[37]);
            for (String name : extendedAttributes) {
                Object val = extendedAttributesValues.get(doc.getId() + "-" + name);
                if (val == null) continue;
                doc.setValue(name, val);
            }
        }
    }

    private void enrichAliasExtendedAttributes(Document doc, long aliasId, List<String> extendedAttributes, Map<String, Object> extendedAttributesValues) {
        if (doc.getTemplate() != null) {
            doc.setTemplateName(doc.getTemplate().getName());
        }
        for (String name : extendedAttributes) {
            String key = aliasId + "-" + name;
            if (extendedAttributesValues.containsKey(key) || doc.getValue(name) == null) continue;
            Attribute att = doc.getAttribute(name);
            if (att != null && (att.getType() == 6 || att.getType() == 4 || att.getType() == 7)) {
                extendedAttributesValues.put(key, att.getStringValue());
                doc.setValue(name, att.getStringValue());
                continue;
            }
            extendedAttributesValues.put(key, doc.getValue(name));
        }
    }

    private void addDocument(Document doc, List<Document> documents, User user) {
        if (doc.isPublishing() || user.isMemberOf("admin") || user.isMemberOf("publisher")) {
            documents.add(doc);
        }
    }

    private Document retrieveHiliteDoc(List<Document> documentRecords, Long folderId, Long hiliteDocId) throws PersistenceException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        Document hiliteDoc = null;
        if (hiliteDocId != null) {
            hiliteDoc = (Document)dao.findById(hiliteDocId);
            if (hiliteDoc != null && folderId != null && hiliteDoc.getFolder() != null && hiliteDoc.getFolder().getId() == folderId.longValue()) {
                dao.initialize(hiliteDoc);
            } else {
                hiliteDoc = null;
            }
        }
        if (hiliteDoc != null && !documentRecords.contains(hiliteDoc)) {
            documentRecords.add(0, hiliteDoc);
        }
        return hiliteDoc;
    }

    private void takeDocumentsInCurrentPage(List<Document> documents, List<Document> documentRecords, int maxRecords, int page) {
        int begin = (page - 1) * maxRecords;
        int end = Math.min(begin + maxRecords - 1, documents.size() - 1);
        int i = begin;
        while (i <= end) {
            documentRecords.add(documents.get(i));
            ++i;
        }
    }

    private void sortDocuments(List<Document> documents, String sort) {
        if (StringUtils.isNotEmpty(sort)) {
            StringBuilder ciSort = new StringBuilder();
            StringTokenizer st = new StringTokenizer(sort, ",", false);
            while (st.hasMoreElements()) {
                String token = (String)st.nextElement();
                String field = token.split(" ")[0].trim();
                String direction = token.split(" ")[1].trim();
                if (ciSort.length() > 0) {
                    ciSort.append(",");
                }
                ciSort.append("lower(");
                ciSort.append(field);
                ciSort.append(") ");
                ciSort.append(direction);
            }
            Collections.sort(documents, DocumentComparator.getComparator(ciSort.toString()));
        }
    }

    private void retrieveExtendedAttributesValues(Locale locale, List<String> extendedAttributes, String extendedAttributesSpec, Map<String, Object> extAttributesValues, Long folderId, Long formId) throws PersistenceException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        if (extendedAttributes.isEmpty()) {
            return;
        }
        log.debug("Search for extended attributes {}", (Object)extendedAttributesSpec);
        StringBuilder query = new StringBuilder("select ld_docid, ld_name, ld_type, ld_stringvalue, ld_intvalue, ld_doublevalue, ld_datevalue, ld_stringvalues ");
        query.append(" from ld_document_ext where ld_docid in (");
        query.append("select D.ld_id from ld_document D where D.ld_deleted=0 ");
        if (folderId != null) {
            query.append(" and D.ld_folderid=" + Long.toString(folderId));
        }
        if (formId != null) {
            query.append(" and D.ld_formid=" + Long.toString(formId));
        }
        query.append(") and ld_name in ");
        query.append(extendedAttributes.toString().replace("[", "('").replace("]", "')").replace(",", "','").replace(" ", ""));
        dao.query(query.toString(), new ExtendedAttributeRowMapper(extAttributesValues, locale), null);
    }

    private String getFilename(HttpServletRequest request) {
        String filename = null;
        if (StringUtils.isNotEmpty(request.getParameter("filename"))) {
            filename = request.getParameter("filename");
        }
        return filename;
    }

    private Long getFormId(HttpServletRequest request) {
        Long formId = null;
        if (StringUtils.isNotEmpty(request.getParameter("formId"))) {
            formId = Long.parseLong(request.getParameter("formId"));
        }
        return formId;
    }

    private Long getFolder(Long folderId) throws PersistenceException {
        FolderDAO fDao = Context.get(FolderDAO.class);
        Folder folder = (Folder)fDao.findById(folderId);
        if (folder.getFoldRef() != null) {
            folderId = folder.getFoldRef();
        }
        return folderId;
    }

    private Long getFolderId(HttpServletRequest request, Session session) throws PersistenceException, IOException {
        FolderDAO fDao = Context.get(FolderDAO.class);
        Long folderId = null;
        if (StringUtils.isNotEmpty(request.getParameter("folderId"))) {
            folderId = Long.parseLong(request.getParameter("folderId"));
        }
        if (folderId != null && session != null && !fDao.isReadAllowed(folderId, session.getUserId())) {
            throw new IOException(String.format("Folder %s is not accessible by user %s", folderId, session.getUsername()));
        }
        return folderId;
    }

    private String prepareExtendedAttributes(HttpServletRequest request, Session session, List<String> extendedAttributes) {
        String extAttributeNames = Context.get().getProperties().getProperty(session.getTenantName() + ".search.extattr");
        if (request.getParameter("extattr") != null) {
            extAttributeNames = request.getParameter("extattr");
        }
        if (StringUtils.isNotEmpty(extAttributeNames)) {
            StringTokenizer st = new StringTokenizer(extAttributeNames.trim(), ",;");
            while (st.hasMoreElements()) {
                extendedAttributes.add(st.nextToken().trim());
            }
        }
        return extAttributeNames;
    }

    private Long getHiliteDocId(HttpServletRequest request) {
        Long hiliteDocId = null;
        if (StringUtils.isNotEmpty(request.getParameter("hiliteDocId"))) {
            hiliteDocId = Long.parseLong(request.getParameter("hiliteDocId"));
        }
        return hiliteDocId;
    }

    private Integer getStatus(HttpServletRequest request) {
        Integer status = null;
        if (StringUtils.isNotEmpty(request.getParameter("status"))) {
            status = Integer.parseInt(request.getParameter("status"));
        }
        return status;
    }

    private int getPage(HttpServletRequest request) {
        int page = 1;
        if (StringUtils.isNotEmpty(request.getParameter("page"))) {
            page = Integer.parseInt(request.getParameter("page"));
        }
        return page;
    }

    private final class ExtendedAttributeRowMapper
    implements RowMapper<Long> {
        private final Map<String, Object> extAttributesValues;
        private final Locale locale;

        private ExtendedAttributeRowMapper(Map<String, Object> extAttributesValues, Locale locale) {
            this.extAttributesValues = extAttributesValues;
            this.locale = locale;
        }

        public Long mapRow(ResultSet rs, int row) throws SQLException {
            Long docId = rs.getLong(1);
            String name = rs.getString(2);
            int type = rs.getInt(3);
            String key = String.valueOf(docId) + "-" + name;
            if (type == 0) {
                if (StringUtils.isNotEmpty(rs.getString(8))) {
                    this.extAttributesValues.put(key, rs.getString(8));
                } else {
                    this.extAttributesValues.put(key, rs.getString(4));
                }
            } else if (type == 1) {
                this.extAttributesValues.put(key, rs.getLong(5));
            } else if (type == 2) {
                this.extAttributesValues.put(key, rs.getDouble(6));
            } else if (type == 3) {
                this.extAttributesValues.put(key, rs.getTimestamp(7));
            } else if (type == 4 || type == 6 || type == 7) {
                this.extAttributesValues.put(key, rs.getString(4));
            } else if (type == 5) {
                this.extAttributesValues.put(key, rs.getLong(5) == 1L ? I18N.message("true", this.locale) : I18N.message("false", this.locale));
            }
            return null;
        }
    }
}

