/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DocumentHistoryDataServlet
extends AbstractDataServlet {
    private static final String TENANT_ID = "tenantId";
    private static final String EVENT = "event";
    private static final String DOC_ID = "docId";
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws IOException, PersistenceException {
        MenuDAO mDao = Context.get(MenuDAO.class);
        boolean showSid = mDao.isReadEnable(1601L, session.getUserId());
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        StringBuilder query = new StringBuilder("select A.username, A.event, A.version, A.date, A.comment, A.filename, A.isNew, A.folderId, A.docId, A.path, A.sessionId, A.userId, A.reason, A.ip, A.device, A.geolocation, A.color, A.fileVersion, A.fileSize, A.keyLabel, A.revision from DocumentHistory A where A.deleted = 0 ");
        Map<String, Object> params = this.prepareQueryParams(request, query);
        List<Object[]> records = Context.get(DocumentHistoryDAO.class).findByQuery(query.toString(), params, max != null ? max : 100);
        HashSet<Long> docIds = new HashSet<Long>();
        Iterator<Object[]> iterator = records.iterator();
        while (iterator.hasNext()) {
            Object[] gridRecord;
            Object[] cols = gridRecord = iterator.next();
            if (request.getParameter("userId") != null) {
                if (docIds.contains(cols[8])) continue;
                docIds.add((Long)cols[8]);
            }
            this.printHistory(writer, cols, locale, showSid);
        }
        writer.write("</list>");
    }

    private void printHistory(PrintWriter writer, Object[] historyRecord, Locale locale, boolean showSid) {
        writer.print("<history>");
        writer.print("<user><![CDATA[" + String.valueOf(historyRecord[0]) + "]]></user>");
        writer.print("<event><![CDATA[" + I18N.message((String)historyRecord[1], locale) + "]]></event>");
        writer.print("<version>" + String.valueOf(historyRecord[2]) + "</version>");
        DateFormat df = this.getDateFormat();
        writer.print("<date>" + df.format((Date)historyRecord[3]) + "</date>");
        writer.print("<comment><![CDATA[" + String.valueOf(historyRecord[4] == null ? "" : historyRecord[4]) + "]]></comment>");
        writer.print("<filename><![CDATA[" + String.valueOf(historyRecord[5] == null ? "" : historyRecord[5]) + "]]></filename>");
        writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon(FileUtil.getExtension((String)historyRecord[5]))) + "</icon>");
        writer.print("<new>" + (1 == (Integer)historyRecord[6]) + "</new>");
        writer.print("<folderId>" + String.valueOf(historyRecord[7]) + "</folderId>");
        writer.print("<docId>" + String.valueOf(historyRecord[8]) + "</docId>");
        writer.print("<path><![CDATA[" + String.valueOf(historyRecord[9] == null ? "" : historyRecord[9]) + "]]></path>");
        if (showSid) {
            writer.print("<sid><![CDATA[" + String.valueOf(historyRecord[10] == null ? "" : historyRecord[10]) + "]]></sid>");
        }
        writer.print("<userId>" + String.valueOf(historyRecord[11]) + "</userId>");
        if (historyRecord[12] != null) {
            writer.print("<reason><![CDATA[" + String.valueOf(historyRecord[12]) + "]]></reason>");
        }
        writer.print("<ip><![CDATA[" + String.valueOf(historyRecord[13] == null ? "" : historyRecord[13]) + "]]></ip>");
        writer.print("<device><![CDATA[" + String.valueOf(historyRecord[14] == null ? "" : historyRecord[14]) + "]]></device>");
        writer.print("<geolocation><![CDATA[" + String.valueOf(historyRecord[15] == null ? "" : historyRecord[15]) + "]]></geolocation>");
        if (historyRecord[16] != null) {
            writer.write("<color><![CDATA[" + String.valueOf(historyRecord[16]) + "]]></color>");
        }
        writer.print("<fileVersion>" + String.valueOf(historyRecord[17] == null ? "" : historyRecord[17]) + "</fileVersion>");
        writer.print("<fileSize>" + String.valueOf(historyRecord[18] == null ? "" : historyRecord[18]) + "</fileSize>");
        if (historyRecord[19] != null) {
            writer.write("<key><![CDATA[" + String.valueOf(historyRecord[19]) + "]]></key>");
        }
        writer.write("<revision><![CDATA[" + StringUtils.defaultString((String)((String)historyRecord[20])) + "]]></revision>");
        writer.print("</history>");
    }

    private Map<String, Object> prepareQueryParams(HttpServletRequest request, StringBuilder query) throws PersistenceException {
        String event;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getParameter(DOC_ID) != null) {
            Long docId = Long.parseLong(request.getParameter(DOC_ID));
            DocumentDAO ddao = Context.get(DocumentDAO.class);
            Document doc = ddao.findDocument(docId);
            if (doc != null) {
                docId = doc.getId();
            }
            query.append(" and A.docId = :docId");
            params.put(DOC_ID, docId);
        }
        if (request.getParameter("userId") != null) {
            query.append(" and A.userId = :userId");
        }
        if (request.getParameter(TENANT_ID) != null) {
            query.append(" and A.tenantId = :tenantId");
            params.put(TENANT_ID, Long.parseLong(request.getParameter(TENANT_ID)));
        }
        if ((event = request.getParameter(EVENT)) != null) {
            if ((event = event.replaceAll("[^a-zA-Z0-9.,]", "")).contains(",")) {
                query.append(" and A.event in (");
                query.append(Arrays.asList(event.split("\\,")).stream().map(ev -> "'" + ev + "'").collect(Collectors.joining(",")));
                query.append(")");
            } else {
                query.append(" and A.event = :event");
                params.put(EVENT, event);
            }
        }
        query.append(" order by A.date desc ");
        return params;
    }
}

