/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class DocumentAliasesDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        Long docId = null;
        if (StringUtils.isNotEmpty(request.getParameter("docId"))) {
            docId = Long.parseLong(request.getParameter("docId"));
        }
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        Context context = Context.get();
        DocumentDAO dao = context.getBean(DocumentDAO.class);
        FolderDAO folderDAO = context.getBean(FolderDAO.class);
        Collection<Long> accessibleFolderIds = folderDAO.findFolderIdByUserId(session.getUserId(), null, true);
        StringBuilder query = new StringBuilder("select id, fileName, folder.id from Document where deleted = 0 and docRef = " + String.valueOf(docId));
        User user = session.getUser();
        if (!user.isMemberOf("admin")) {
            if (dao.isOracle()) {
                query.append(" and (folder.id,0) in ( ");
                boolean firstItem = true;
                for (Long l : accessibleFolderIds) {
                    if (!firstItem) {
                        query.append(",");
                    }
                    query.append("(");
                    query.append(l);
                    query.append(",0)");
                    firstItem = false;
                }
                query.append(" )");
            } else {
                query.append(" and folder.id in ");
                query.append(accessibleFolderIds.toString().replace('[', '(').replace(']', ')'));
            }
        }
        List<Object[]> records = dao.findByQuery(query.toString(), null, null);
        for (Object object : records) {
            Object[] cols = (Object[])object;
            writer.print("<alias>");
            writer.print("<id>" + String.valueOf(cols[0]) + "</id>");
            writer.print("<filename><![CDATA[" + String.valueOf(cols[1]) + "]]></filename>");
            writer.print("<folderId>" + String.valueOf(cols[2]) + "</folderId>");
            writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon(FileUtil.getExtension((String)cols[1]))) + "</icon>");
            writer.print("<path><![CDATA[" + folderDAO.computePathExtended((Long)cols[2]) + "/" + String.valueOf(cols[1]) + "]]></path>");
            writer.print("</alias>");
        }
        writer.write("</list>");
    }
}

