/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.security.Device;
import com.logicaldoc.core.security.DeviceDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;

public class DevicesDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws IOException {
        boolean trustedOnly = request.getParameter("trustedonly") != null;
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        List<Device> devices = this.getDevices(session, trustedOnly);
        for (Device device : devices) {
            if (device.getDeleted() == 1) continue;
            writer.print("<device>");
            writer.print("<id>" + device.getId() + "</id>");
            this.printLabel(device, writer);
            writer.print("<deviceId>" + device.getDeviceId() + "</deviceId>");
            this.printBrowser(device, writer);
            this.printOperativeSystem(device, writer);
            this.printType(device, writer);
            this.printDates(device, writer);
            writer.print("</device>");
        }
        writer.write("</list>");
    }

    private void printType(Device device, PrintWriter writer) {
        if (device.getType() != null) {
            writer.print("<type>" + device.getType() + "</type>");
        }
    }

    private void printLabel(Device device, PrintWriter writer) {
        if (device.getLabel() != null) {
            writer.print("<label><![CDATA[" + device.getLabel() + "]]></label>");
        }
    }

    private void printOperativeSystem(Device device, PrintWriter writer) {
        if (device.getOperativeSystem() != null) {
            writer.print("<os><![CDATA[" + device.getOperativeSystem() + "]]></os>");
        }
    }

    private void printBrowser(Device device, PrintWriter writer) {
        if (device.getBrowser() != null) {
            writer.print("<browser><![CDATA[" + device.getBrowser() + " v" + device.getBrowserVersion() + "]]></browser>");
        }
    }

    private List<Device> getDevices(Session session, boolean trustedOnly) {
        DeviceDAO dDao = Context.get(DeviceDAO.class);
        List<Device> devices = trustedOnly ? dDao.findTrustedDevices(session.getUserId()) : dDao.findByUserId(session.getUserId());
        return devices;
    }

    private void printDates(Device device, PrintWriter writer) {
        DateFormat df = this.getDateFormat();
        if (device.getCreation() != null) {
            writer.print("<creation>" + df.format(device.getCreation()) + "</creation>");
        }
        if (device.getLastLogin() != null) {
            writer.print("<lastlogin>" + df.format(device.getLastLogin()) + "</lastlogin>");
        }
    }
}

