/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.BookmarkDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;

public class BookmarksDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws IOException, PersistenceException {
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        BookmarkDAO dao = Context.get(BookmarkDAO.class);
        StringBuilder query = new StringBuilder("select A.id, A.fileType, A.title, A.description, A.position, A.userId, A.targetId, A.type, B.folder.id, B.color  from Bookmark A, Document B where A.type=0 and A.deleted = 0 and B.deleted = 0 and A.targetId = B.id and A.userId = " + session.getUserId());
        records.addAll(dao.findByQuery(query.toString(), null, null));
        query = new StringBuilder("select A.id, A.fileType, A.title, A.description, A.position, A.userId, A.targetId, A.type, A.targetId, B.color  from Bookmark A, Folder B where A.targetId = B.id and A.type=1 and A.deleted = 0 and A.userId = " + session.getUserId());
        records.addAll(dao.findByQuery(query.toString(), null, null));
        for (Object e : records) {
            this.printBookmark(e, writer);
        }
        writer.write("</list>");
    }

    private void printBookmark(Object bookmarkRecord, PrintWriter writer) {
        Object[] cols = (Object[])bookmarkRecord;
        writer.print("<bookmark>");
        writer.print("<id>" + String.valueOf(cols[0]) + "</id>");
        if (cols[7].toString().equals("0")) {
            writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon((String)cols[1])) + "</icon>");
        } else {
            writer.print("<icon>folder</icon>");
        }
        writer.print("<name><![CDATA[" + String.valueOf(this.printValue(cols[2])) + "]]></name>");
        writer.print("<description><![CDATA[" + String.valueOf(this.printValue(cols[3])) + "]]></description>");
        writer.print("<position>" + String.valueOf(this.printValue(cols[4])) + "</position>");
        writer.print("<userId>" + String.valueOf(this.printValue(cols[5])) + "</userId>");
        writer.print("<targetId>" + String.valueOf(this.printValue(cols[6])) + "</targetId>");
        writer.print("<type>" + String.valueOf(this.printValue(cols[7])) + "</type>");
        writer.print("<folderId>" + String.valueOf(this.printValue(cols[8])) + "</folderId>");
        if (cols[9] != null) {
            writer.print("<color><![CDATA[" + String.valueOf(this.printValue(cols[9])) + "]]></color>");
        }
        writer.print("</bookmark>");
    }

    private Object printValue(Object value) {
        return value == null ? "" : value.toString();
    }
}

