/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.AttributeSetDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AttributesDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        Long templateId = null;
        if (StringUtils.isNotEmpty(request.getParameter("templateId"))) {
            templateId = Long.parseLong(request.getParameter("templateId"));
        }
        boolean docevent = "docevent".equals(request.getParameter("context"));
        boolean sections = "true".equals(request.getParameter("sections"));
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        if (templateId == null) {
            if (docevent) {
                this.printAttibute("date", I18N.message("date", locale), 3, writer);
                this.printAttibute("event", I18N.message("event", locale), writer);
                this.printAttibute("path", I18N.message("path", locale), writer);
                this.printAttibute("reason", I18N.message("reason", locale), writer);
                this.printAttibute("user", I18N.message("user", locale), 4, writer);
            }
            this.printAttibute("customId", I18N.message("customid", locale), writer);
            this.printAttibute("filename", I18N.message("filename", locale), writer);
            this.printAttibute("lastModified", I18N.message("lastmodified", locale), writer);
            this.printAttibute("user", I18N.message("user", locale), 3, writer);
            this.printAttibute("created", I18N.message("createdon", locale), 3, writer);
            this.printAttibute("published", I18N.message("publishedon", locale), 3, writer);
            this.printAttibute("fileVersion", I18N.message("fileversion", locale), writer);
            this.printAttibute("version", I18N.message("version", locale), writer);
            this.printAttibute("revision", I18N.message("revision", locale), writer);
            this.printAttibute("type", I18N.message("type", locale), writer);
            this.printAttibute("size", I18N.message("size", locale), 1, writer);
            this.printAttibute("pages", I18N.message("pages", locale), 1, writer);
            this.printAttibute("creator", I18N.message("creator", locale), writer);
            this.printAttibute("publisher", I18N.message("publisher", locale), writer);
            this.printAttibute("comment", I18N.message("comment", locale), writer);
            this.printAttibute("lastNote", I18N.message("lastnote", locale), writer);
            this.printAttibute("template", I18N.message("template", locale), writer);
            this.printAttibute("tags", I18N.message("tags", locale), writer);
            this.printAttibute("workflowStatus", I18N.message("workflowstatus", locale), writer);
            this.printAttibute("startPublishing", I18N.message("startpublishing", locale), 3, writer);
            this.printAttibute("stopPublishing", I18N.message("stoppublishing", locale), 3, writer);
            this.printAttibute("folder", I18N.message("folder", locale), writer);
            this.printAttibute("folderId", I18N.message("folderId", locale), 1, writer);
            this.printAttibute("score", I18N.message("score", locale), 1, writer);
            this.printAttibute("rating", I18N.message("rating", locale), 1, writer);
            this.printAttibute("language", I18N.message("language", locale), writer);
            this.printAttibute("tenantId", I18N.message("tenantId", locale), 1, writer);
        }
        Map<Object, Object> attributes = new HashMap();
        if (templateId == null) {
            dao = Context.get(AttributeSetDAO.class);
            attributes = dao.findAttributes(session.getTenantId(), null);
        } else {
            dao = Context.get(TemplateDAO.class);
            Template template = (Template)((Object)dao.findById(templateId));
            dao.initialize(template);
            List<String> names = template.getAttributeNames();
            for (String name : names) {
                attributes.put(name, template.getAttribute(name));
            }
        }
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            Attribute attribute = (Attribute)entry.getValue();
            if (attribute.getHidden() == 1 || !sections && attribute.isSection()) continue;
            this.printAttibute("ext_" + (String)entry.getKey(), StringUtils.isNotEmpty(attribute.getLabel()) ? attribute.getLabel() : "", attribute.getType(), writer);
        }
        writer.write("</list>");
    }

    private void printAttibute(String name, String label, PrintWriter writer) {
        this.printAttibute(name, label, 0, writer);
    }

    private void printAttibute(String name, String label, int type, PrintWriter writer) {
        writer.print("<attribute>");
        writer.print("<name>" + name + "</name>");
        writer.print("<label><![CDATA[" + label + "]]></label>");
        writer.print("<type>" + type + "</type>");
        writer.print("</attribute>");
    }
}

