/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.metadata.AttributeSet;
import com.logicaldoc.core.metadata.AttributeSetDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class AttributeSetsDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        Integer type = null;
        if (request.getParameter("type") != null) {
            type = Integer.parseInt(request.getParameter("type"));
        }
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        if ("true".equals(request.getParameter("withempty"))) {
            writer.print("<attributeset>");
            writer.print("<id></id>");
            writer.print("<name> </name>");
            writer.print("<readonly>false</readonly>");
            writer.print("</attributeset>");
        }
        AttributeSetDAO dao = Context.get(AttributeSetDAO.class);
        List<Object> sets = null;
        sets = type != null ? dao.findByType(type, session.getTenantId()) : dao.findAll(session.getTenantId());
        for (AttributeSet set : sets) {
            writer.print("<attributeset>");
            writer.print("<id>" + set.getId() + "</id>");
            writer.print("<name><![CDATA[" + set.getName() + "]]></name>");
            writer.print("<label><![CDATA[" + StringUtils.defaultIfEmpty(set.getLabel(), set.getName()) + "]]></label>");
            writer.print("<description><![CDATA[" + set.getDescription() + "]]></description>");
            writer.print("<readonly>" + Boolean.toString(set.getReadonly() == 1) + "</readonly>");
            writer.print("<type>" + set.getType() + "</type>");
            writer.print("</attributeset>");
        }
        writer.write("</list>");
    }
}

