/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.menu.Menu;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.security.user.GroupType;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AclDataServlet
extends AbstractDataServlet {
    private static final String AVATAR_GROUP_AVATAR = "<avatar>group</avatar>";
    private static final String TYPE_CLOSED = "</type>";
    private static final String TYPE = "<type>";
    private static final String READ_CLOSED = "</read>";
    private static final String READ = "<read>";
    private static final String AVATAR_CLOSED = "</avatar>";
    private static final String AVATAR = "<avatar>";
    private static final String LIST_CLOSED = "</list>";
    private static final String ACE_CLOSED = "</ace>";
    private static final String ENTITYID_CLOSED = "</entityId>";
    private static final String ENTITYID = "<entityId>";
    private static final String ACE = "<ace>";
    private static final String AND_B_LD_TENANTID = " and B.ld_tenantid = ";
    private static final String LIST = "<list>";
    private static final String ENTITY = "<entity><![CDATA[";
    private static final String ENTITY_CLOSED = "]]></entity>";
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        String type;
        long id = Long.parseLong(request.getParameter("id"));
        switch (type = request.getParameter("type")) {
            case "menu": {
                this.menuAcl(response, id, session.getTenantId());
                break;
            }
            case "folder": {
                this.folderACL(response, id);
                break;
            }
            case "template": {
                this.templateACL(response, id);
                break;
            }
            default: {
                this.documentACL(response, id);
            }
        }
    }

    private Map<Long, String> getUsers(long tenantId) throws PersistenceException {
        HashMap<Long, String> users = new HashMap<Long, String>();
        UserDAO dao = Context.get(UserDAO.class);
        dao.queryForResultSet("select ld_id, ld_username, ld_firstname, ld_name from ld_user where ld_deleted=0 and ld_tenantid=" + tenantId, null, null, rows -> {
            while (rows.next()) {
                users.put(rows.getLong(1), rows.getString(3) + " " + rows.getString(4) + " (" + rows.getString(2) + ")");
            }
        });
        return users;
    }

    private void templateACL(HttpServletResponse response, long templateId) throws IOException, PersistenceException {
        TemplateDAO tDao = Context.get(TemplateDAO.class);
        Template template = (Template)tDao.findById(templateId);
        tDao.initialize(template);
        Map<Long, String> users = this.getUsers(template.getTenantId());
        PrintWriter writer = response.getWriter();
        writer.write(LIST);
        StringBuilder query = new StringBuilder("select A.ld_groupid, B.ld_name, B.ld_type, A.ld_write, A.ld_read from ld_template_acl A, ld_group B where A.ld_templateid = ");
        query.append("" + template.getId());
        query.append(AND_B_LD_TENANTID + template.getTenantId());
        query.append(" and B.ld_deleted=0 and A.ld_groupid = B.ld_id order by B.ld_name asc");
        tDao.queryForResultSet(query.toString(), null, null, rows -> {
            while (rows.next()) {
                long groupId = rows.getLong(1);
                String groupName = rows.getString(2);
                int groupType = rows.getInt(3);
                long userId = 0L;
                if (groupType == GroupType.USER.ordinal() && groupName != null) {
                    userId = Long.parseLong(groupName.substring(groupName.lastIndexOf(95) + 1));
                }
                writer.print(ACE);
                writer.print(ENTITYID + groupId + ENTITYID_CLOSED);
                if (groupType == GroupType.DEFAULT.ordinal()) {
                    writer.print(ENTITY + groupName + ENTITY_CLOSED);
                    writer.print(AVATAR_GROUP_AVATAR);
                } else {
                    writer.print(ENTITY + (String)users.get(userId) + ENTITY_CLOSED);
                    writer.print(AVATAR + userId + AVATAR_CLOSED);
                }
                writer.print("<write>" + (rows.getInt(4) == 1) + "</write>");
                writer.print(READ + (rows.getInt(5) == 1) + READ_CLOSED);
                writer.print(TYPE + groupType + TYPE_CLOSED);
                writer.print(ACE_CLOSED);
            }
        });
        writer.write(LIST_CLOSED);
    }

    private void documentACL(HttpServletResponse response, long documentId) throws IOException, PersistenceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document document = (Document)docDao.findById(documentId);
        docDao.initialize(document);
        Map<Long, String> users = this.getUsers(document.getTenantId());
        PrintWriter writer = response.getWriter();
        writer.write(LIST);
        StringBuilder query = new StringBuilder(" select A.ld_groupid, B.ld_name, B.ld_type, A.ld_write, 0, A.ld_security, A.ld_immutable, A.ld_delete,\n        A.ld_rename, 0, 0, A.ld_sign, A.ld_archive, A.ld_workflow, A.ld_download,\n        A.ld_calendar, A.ld_subscription, A.ld_print, A.ld_password, A.ld_move, A.ld_email, A.ld_automation,\n        0, A.ld_readingreq, A.ld_read, A.ld_preview, A.ld_customid, A.ld_revision\n   from ld_document_acl A, ld_group B\n  where A.ld_docid =\n");
        query.append(Long.toString(documentId));
        query.append(AND_B_LD_TENANTID + document.getTenantId());
        query.append(" and B.ld_deleted=0 and A.ld_groupid = B.ld_id order by B.ld_type asc, B.ld_name asc");
        docDao.queryForResultSet(query.toString(), null, null, rows -> {
            while (rows.next()) {
                this.printACE(writer, rows, users);
            }
        });
        writer.write(LIST_CLOSED);
    }

    private void folderACL(HttpServletResponse response, long folderId) throws IOException, PersistenceException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folder = (Folder)folderDao.findById(folderId);
        folderDao.initialize(folder);
        Folder ref = folder;
        if (folder.getSecurityRef() != null) {
            ref = (Folder)folderDao.findById(folder.getSecurityRef());
            folderDao.initialize(ref);
        }
        Map<Long, String> users = this.getUsers(ref.getTenantId());
        PrintWriter writer = response.getWriter();
        writer.write(LIST);
        StringBuilder query = new StringBuilder("select A.ld_groupid, B.ld_name, B.ld_type, A.ld_write, A.ld_add, A.ld_security, A.ld_immutable, A.ld_delete,\n       A.ld_rename, A.ld_import, A.ld_export, A.ld_sign, A.ld_archive, A.ld_workflow, A.ld_download,\n       A.ld_calendar, A.ld_subscription, A.ld_print, A.ld_password, A.ld_move, A.ld_email, A.ld_automation,\n       A.ld_store, A.ld_readingreq, A.ld_read, A.ld_preview, A.ld_customid, A.ld_revision\n  from ld_folder_acl A, ld_group B\n where A.ld_folderid =\n");
        query.append(Long.toString(ref.getId()));
        query.append(AND_B_LD_TENANTID + ref.getTenantId());
        query.append(" and B.ld_deleted=0 and A.ld_groupid = B.ld_id order by B.ld_type asc, B.ld_name asc");
        folderDao.queryForResultSet(query.toString(), null, null, rows -> {
            while (rows.next()) {
                this.printACE(writer, rows, users);
            }
        });
        writer.write(LIST_CLOSED);
    }

    private void menuAcl(HttpServletResponse response, long menuId, long tenantId) throws IOException, PersistenceException {
        MenuDAO menuDao = Context.get(MenuDAO.class);
        Menu menu = (Menu)menuDao.findById(menuId);
        menuDao.initialize(menu);
        Map<Long, String> users = this.getUsers(tenantId);
        PrintWriter writer = response.getWriter();
        writer.write(LIST);
        StringBuilder query = new StringBuilder("select A.ld_groupid, B.ld_name, B.ld_type, A.ld_read from ld_menu_acl A, ld_group B where A.ld_menuid = ");
        query.append("" + menu.getId());
        query.append(" and B.ld_deleted=0 and A.ld_groupid = B.ld_id and B.ld_tenantid = " + tenantId);
        query.append(" order by B.ld_type asc, B.ld_name asc");
        menuDao.queryForResultSet(query.toString(), null, null, rows -> {
            while (rows.next()) {
                long groupId = rows.getLong(1);
                String groupName = rows.getString(2);
                int groupType = rows.getInt(3);
                long userId = 0L;
                if (groupType == GroupType.USER.ordinal() && groupName != null) {
                    userId = Long.parseLong(groupName.substring(groupName.lastIndexOf(95) + 1));
                }
                writer.print(ACE);
                writer.print(ENTITYID + groupId + ENTITYID_CLOSED);
                if (groupType == GroupType.DEFAULT.ordinal()) {
                    writer.print(ENTITY + groupName + ENTITY_CLOSED);
                    writer.print(AVATAR_GROUP_AVATAR);
                } else {
                    writer.print(ENTITY + (String)users.get(userId) + ENTITY_CLOSED);
                    writer.print(AVATAR + userId + AVATAR_CLOSED);
                }
                writer.print(READ + this.intToBoolean(rows.getInt(4)) + READ_CLOSED);
                writer.print(TYPE + groupType + TYPE_CLOSED);
                writer.print(ACE_CLOSED);
            }
        });
        writer.write(LIST_CLOSED);
    }

    private void printACE(PrintWriter writer, ResultSet set, Map<Long, String> users) throws SQLException {
        long groupId = set.getLong(1);
        String groupName = set.getString(2);
        int groupType = set.getInt(3);
        long userId = 0L;
        if (groupType == GroupType.USER.ordinal() && groupName != null) {
            userId = Long.parseLong(groupName.substring(groupName.lastIndexOf(95) + 1));
        }
        writer.print(ACE);
        writer.print(ENTITYID + groupId + ENTITYID_CLOSED);
        if (groupType == GroupType.DEFAULT.ordinal()) {
            writer.print(ENTITY + groupName + ENTITY_CLOSED);
            writer.print(AVATAR_GROUP_AVATAR);
        } else {
            writer.print(ENTITY + users.get(userId) + ENTITY_CLOSED);
            writer.print(AVATAR + userId + AVATAR_CLOSED);
        }
        writer.print("<write>" + this.intToBoolean(set.getInt(4)) + "</write>");
        writer.print("<add>" + this.intToBoolean(set.getInt(5)) + "</add>");
        writer.print("<security>" + this.intToBoolean(set.getInt(6)) + "</security>");
        writer.print("<immutable>" + this.intToBoolean(set.getInt(7)) + "</immutable>");
        writer.print("<delete>" + this.intToBoolean(set.getInt(8)) + "</delete>");
        writer.print("<rename>" + this.intToBoolean(set.getInt(9)) + "</rename>");
        writer.print("<import>" + this.intToBoolean(set.getInt(10)) + "</import>");
        writer.print("<export>" + this.intToBoolean(set.getInt(11)) + "</export>");
        writer.print("<sign>" + this.intToBoolean(set.getInt(12)) + "</sign>");
        writer.print("<archive>" + this.intToBoolean(set.getInt(13)) + "</archive>");
        writer.print("<workflow>" + this.intToBoolean(set.getInt(14)) + "</workflow>");
        writer.print("<download>" + this.intToBoolean(set.getInt(15)) + "</download>");
        writer.print("<calendar>" + this.intToBoolean(set.getInt(16)) + "</calendar>");
        writer.print("<subscription>" + this.intToBoolean(set.getInt(17)) + "</subscription>");
        writer.print("<print>" + this.intToBoolean(set.getInt(18)) + "</print>");
        writer.print("<password>" + this.intToBoolean(set.getInt(19)) + "</password>");
        writer.print("<move>" + this.intToBoolean(set.getInt(20)) + "</move>");
        writer.print("<email>" + this.intToBoolean(set.getInt(21)) + "</email>");
        writer.print("<automation>" + this.intToBoolean(set.getInt(22)) + "</automation>");
        writer.print("<store>" + this.intToBoolean(set.getInt(23)) + "</store>");
        writer.print("<readingreq>" + this.intToBoolean(set.getInt(24)) + "</readingreq>");
        writer.print(READ + this.intToBoolean(set.getInt(25)) + READ_CLOSED);
        writer.print("<preview>" + this.intToBoolean(set.getInt(26)) + "</preview>");
        writer.print("<customid>" + this.intToBoolean(set.getInt(27)) + "</customid>");
        writer.print("<revision>" + this.intToBoolean(set.getInt(28)) + "</revision>");
        writer.print(TYPE + groupType + TYPE_CLOSED);
        writer.print(ACE_CLOSED);
    }

    private boolean intToBoolean(int val) {
        return val == 1;
    }
}

