/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.data;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractDataServlet.class);
    protected static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    protected AbstractDataServlet() {
    }

    protected boolean isSessionRequired() {
        return true;
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            Integer max = null;
            if (StringUtils.isNotEmpty(request.getParameter("max"))) {
                max = Integer.parseInt(request.getParameter("max"));
            }
            Locale locale = Locale.ENGLISH;
            if (StringUtils.isNotEmpty(request.getParameter("locale"))) {
                locale = LocaleUtil.toLocale(request.getParameter("locale"));
            }
            Session session = this.isSessionRequired() ? ServletUtil.validateSession(request) : null;
            this.service(request, response, session, max, locale);
        }
        catch (PersistenceException | IOException | NumberFormatException e) {
            log.error(e.getMessage(), e);
            ServletUtil.sendError(response, e.getMessage());
        }
    }

    protected abstract void service(HttpServletRequest var1, HttpServletResponse var2, Session var3, Integer var4, Locale var5) throws PersistenceException, IOException;
}

