/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionListener;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.spring.LDDeferredSecurityContext;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServlet
extends HttpServlet
implements SessionListener {
    public static final String UPLOADS = "uploads";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UploadServlet.class);
    private static int maxMemSize = 0x100000;

    public UploadServlet() {
        SessionManager.get().addListener(this);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            out.println("<HTML>");
            out.println("  <HEAD><TITLE>Upload Document Resource Servlet</TITLE></HEAD>");
            out.println("  <BODY>");
            out.print(" This servlet doesn't support GET method. Use POST instead. ");
            out.println("  </BODY>");
            out.println("</HTML>");
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static File getUploadDir(String sid) {
        File dir = new File(System.getProperty("java.io.tmpdir") + "/upload/" + sid);
        dir.mkdirs();
        dir.mkdir();
        return dir;
    }

    private static File getUploadDir(HttpSession httpSession) {
        File dir = new File(System.getProperty("java.io.tmpdir") + "/upload/" + httpSession.getId());
        dir.mkdirs();
        dir.mkdir();
        return dir;
    }

    private static File getUploadDir(HttpServletRequest request) {
        String sid = UploadServlet.getSid(request);
        if (StringUtils.isNotEmpty((CharSequence)sid) && SessionManager.get().get(sid) != null && SessionManager.get().get(sid).isOpen()) {
            return UploadServlet.getUploadDir(sid);
        }
        return UploadServlet.getUploadDir(request.getSession(true));
    }

    public static Map<String, File> getUploads(String sid) {
        Session session = SessionManager.get().get(sid);
        if (session != null && session.isOpen()) {
            HashMap uploadedFiles = (HashMap)session.getDictionary().get(UPLOADS);
            if (uploadedFiles == null) {
                uploadedFiles = new HashMap();
                session.getDictionary().put(UPLOADS, uploadedFiles);
            }
            return uploadedFiles;
        }
        return new HashMap<String, File>();
    }

    private static Map<String, File> getUploads(HttpSession httpSession) {
        HashMap uploads = (HashMap)httpSession.getAttribute(UPLOADS);
        if (uploads == null) {
            uploads = new HashMap();
            httpSession.setAttribute(UPLOADS, uploads);
        }
        return uploads;
    }

    public static Map<String, File> getUploads(HttpServletRequest request) {
        String sid = UploadServlet.getSid(request);
        if (StringUtils.isNotEmpty((CharSequence)sid) && SessionManager.get().get(sid) != null && SessionManager.get().get(sid).isOpen()) {
            return UploadServlet.getUploads(sid);
        }
        return UploadServlet.getUploads(request.getSession(true));
    }

    public static void cleanUploads(String sid) {
        FileUtil.delete(UploadServlet.getUploadDir(sid));
        Map<String, File> receivedFiles = UploadServlet.getUploads(sid);
        receivedFiles.clear();
    }

    public static void cleanUploads(HttpSession httpSession) {
        FileUtil.delete(UploadServlet.getUploadDir(httpSession));
        UploadServlet.getUploads(httpSession).clear();
    }

    protected static String getSid(HttpServletRequest request) {
        String sid = SessionManager.get().getSessionId(request);
        HttpSession session = SessionManager.get().getServletSession(sid);
        if (session == null) {
            request.getSession(true);
            if (sid != null) {
                LDDeferredSecurityContext.bindServletSession(sid, request);
            }
        }
        return sid;
    }

    protected void checkIfAllowedForUpload(String tenant, String fileName) throws ServletException {
        List<String> disallowedExtensions;
        String extension = FileUtil.getExtension(fileName).toLowerCase();
        String disallow = Context.get().getProperties().getString(tenant + ".upload.disallow");
        if (disallow != null && !disallow.isEmpty() && (disallowedExtensions = Arrays.asList((disallow = disallow.toLowerCase().replace(" ", "")).toLowerCase().split(","))).contains(extension)) {
            throw new ServletException("Disallowed extension: " + extension);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            File uploadDir = UploadServlet.getUploadDir(request);
            String sid = UploadServlet.getSid(request);
            String tenant = StringUtils.isNotEmpty((CharSequence)sid) && SessionManager.get().get(sid) != null ? SessionManager.get().get(sid).getTenantName() : "default";
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            if (!isMultipart) {
                out.println("<html>");
                out.println("<head>");
                out.println("<title>Upload</title>");
                out.println("</head>");
                out.println("<body>");
                out.println("<p>No file uploaded</p>");
                out.println("</body>");
                out.println("</html>");
                return;
            }
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(maxMemSize);
            factory.setRepository(uploadDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setFileSizeMax(Context.get().getProperties().getLong(tenant + ".upload.maxsize", 10L) * 1024L * 1024L);
            Map<String, File> uploadedFiles = UploadServlet.getUploads(request);
            List fileItems = upload.parseRequest(request);
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Upload</title>");
            out.println("</head>");
            out.println("<body>");
            for (FileItem fi : fileItems) {
                if (fi.isFormField()) continue;
                String fileName = fi.getName();
                this.checkIfAllowedForUpload(tenant, fileName);
                File file = new File(uploadDir.getAbsolutePath() + "/" + UUID.randomUUID().toString() + "." + FileUtil.getExtension(fileName));
                fi.write(file);
                if (uploadedFiles != null) {
                    uploadedFiles.put(fileName, file);
                }
                out.println("Uploaded Filename: " + fileName + "<br>");
            }
            out.println("</body>");
            out.println("</html>");
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            try {
                response.sendError(500, e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onSessionCreated(Session session) {
    }

    @Override
    public void onSessionClosed(Object sid) {
        try {
            FileUtils.forceDelete(UploadServlet.getUploadDir(sid.toString()));
        }
        catch (Exception e) {
            log.warn("Unable to clean the upload folder for session {}", sid);
        }
    }
}

