/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.ticket.Ticket;
import com.logicaldoc.core.ticket.TicketDAO;
import com.logicaldoc.gui.common.client.util.Util;
import com.logicaldoc.util.MimeType;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.DownloadServlet;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketDownload
extends HttpServlet {
    private static final String TICKET_ID = "ticketId";
    private static final long serialVersionUID = 9088160958327454062L;
    private static final Logger log = LoggerFactory.getLogger(TicketDownload.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String ticketId = request.getParameter(TICKET_ID);
        try {
            ticketId = this.getTicketId(request);
            Ticket ticket = this.getTicket(ticketId);
            Document document = this.getDocument(ticket);
            if (ticket.isTicketExpired() && !this.isPreviewDownload(ticketId, request, document)) {
                throw new IOException("Expired ticket");
            }
            String suffix = this.getSuffix(ticket, document, request);
            TenantDAO tenantDao = Context.get(TenantDAO.class);
            String tenantName = tenantDao.getTenantName(ticket.getTenantId());
            String behavior = request.getParameter("behavior");
            if (behavior == null) {
                behavior = Context.get().getProperties().getProperty(tenantName + ".downloadticket.behavior", "download");
            }
            request.setAttribute("open", (Object)Boolean.toString("display".equals(behavior)));
            this.downloadDocument(request, response, document, null, suffix, ticketId);
            if (this.isPreviewDownload(ticketId, request, document)) {
                request.getSession().removeAttribute(this.getPreviewAttributeName(ticketId));
                String viewMarker = "ticketviewed-" + ticketId;
                if (request.getSession().getAttribute(viewMarker) == null) {
                    ticket.setViews(ticket.getViews() + 1);
                    request.getSession().setAttribute(viewMarker, (Object)true);
                }
                if (this.isHtml(document)) {
                    suffix = "safe.html";
                }
            } else {
                this.increaseDownloadCount(request, ticket, document);
            }
            TicketDAO ticketDao = Context.get(TicketDAO.class);
            ticketDao.store(ticket);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            try {
                Throwable throwable = null;
                Object var6_11 = null;
                try (PrintWriter out = response.getWriter();){
                    out.println("Ticket " + ticketId + " is no more active" + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isHtml(Document document) {
        return document.getFileName().toLowerCase().endsWith(".html") || document.getFileName().toLowerCase().endsWith(".htm") || document.getFileName().toLowerCase().endsWith(".xhtml");
    }

    private void increaseDownloadCount(HttpServletRequest request, Ticket ticket, Document document) {
        if (!document.getFileName().toLowerCase().endsWith(".dcm") && !this.isHtml(document) || !"preview".equals(request.getParameter("control"))) {
            ticket.setCount(ticket.getCount() + 1);
        }
    }

    private boolean isPreviewDownload(String ticketId, HttpServletRequest request, Document document) {
        return request.getSession() != null && request.getSession().getAttribute(this.getPreviewAttributeName(ticketId)) != null || (this.isHtml(document) || Util.isMediaFile((String)document.getFileName())) && "preview".equals(request.getParameter("control"));
    }

    protected String getPreviewAttributeName(String ticketId) {
        return "preview-" + ticketId;
    }

    private String getSuffix(Ticket ticket, Document document, HttpServletRequest request) throws IOException {
        String suffix = ticket.getSuffix();
        if (request.getParameter("suffix") != null) {
            suffix = request.getParameter("suffix");
        }
        if ("pdf".equals(suffix)) {
            suffix = "conversion.pdf";
        }
        if ("conversion.pdf".equals(suffix)) {
            FormatConverterManager converter = Context.get(FormatConverterManager.class);
            converter.convertToPdf(document, null);
            if ("pdf".equalsIgnoreCase(FileUtil.getExtension(document.getFileName()))) {
                suffix = null;
            }
        }
        return suffix;
    }

    private Document getDocument(Ticket ticket) throws PersistenceException, IOException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(ticket.getDocId());
        if (doc.getDocRef() != null) {
            doc = (Document)docDao.findById(doc.getDocRef());
        }
        if (!doc.isPublishing()) {
            throw new IOException("Document not published");
        }
        return doc;
    }

    private Ticket getTicket(String ticketId) throws IOException {
        TicketDAO tktDao = Context.get(TicketDAO.class);
        Ticket ticket = tktDao.findByTicketId(ticketId);
        if (ticket == null || ticket.getDocId() == 0L) {
            throw new IOException("Unexisting ticket");
        }
        return ticket;
    }

    private String getTicketId(HttpServletRequest request) {
        String ticketId = request.getParameter(TICKET_ID);
        if (StringUtils.isEmpty(ticketId)) {
            ticketId = (String)request.getAttribute(TICKET_ID);
        }
        if (StringUtils.isEmpty(ticketId)) {
            HttpSession session = request.getSession();
            ticketId = (String)session.getAttribute(TICKET_ID);
        }
        log.debug("Download ticket ticketId={}", (Object)ticketId);
        return ticketId;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html");
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter out = response.getWriter();){
                out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                out.println("<HTML>");
                out.println("  <HEAD><TITLE>Download Ticket Action</TITLE></HEAD>");
                out.println("  <BODY>");
                out.print("    This is ");
                out.print(((Object)((Object)this)).getClass());
                out.println(", using the POST method");
                out.println("  </BODY>");
                out.println("</HTML>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void downloadDocument(HttpServletRequest request, HttpServletResponse response, Document document, String fileVersion, String suffix, String ticket) throws IOException, PersistenceException {
        DownloadServlet.processSafeHtml(suffix, null, document);
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(document, fileVersion, suffix);
        OutputStream os = null;
        try {
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (InputStream is = store.getStream(document.getId(), resource);){
                    Object filename = document.getFileName();
                    if (suffix != null && suffix.contains("pdf")) {
                        filename = document.getFileName() + ".pdf";
                    }
                    long size = store.size(document.getId(), resource);
                    String mimetype = MimeType.getByFilename((String)filename);
                    response.setContentType(mimetype);
                    ServletUtil.setContentDisposition(request, response, (String)filename);
                    response.setHeader("Accept-Ranges", "bytes");
                    response.setHeader("Content-Length", Long.toString(size));
                    os = response.getOutputStream();
                    int letter = 0;
                    while ((letter = is.read()) != -1) {
                        os.write(letter);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                log.error("Cannot open the stream {} {} {} of for ticket {}", document, fileVersion, suffix, ticket);
                throw ioe;
            }
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        DocumentHistory history = new DocumentHistory();
        history.setDocument(document);
        FolderDAO fdao = Context.get(FolderDAO.class);
        history.setPath(fdao.computePathExtended(document.getFolder().getId()));
        history.setEvent(this.isPreviewDownload(ticket, request, document) ? DocumentEvent.VIEWED : DocumentEvent.DOWNLOADED);
        history.setFilename(document.getFileName());
        history.setFolderId(document.getFolder().getId());
        history.setComment("Ticket " + ticket);
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        try {
            ddao.saveDocumentHistory(document, history);
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
    }
}

