/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.document.thumbnail.ThumbnailManager;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.authentication.InvalidSessionException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailServlet
extends HttpServlet {
    protected static final String SUFFIX = "suffix";
    public static final String DOC_ID = "docId";
    private static final String FILE_VERSION = "fileVersion";
    private static final String VERSION = "version";
    private static final long serialVersionUID = -6956612970433309888L;
    private static final Logger log = LoggerFactory.getLogger(ThumbnailServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String suffix = request.getParameter(SUFFIX);
        try {
            DocumentDAO docDao;
            Document doc;
            Store store = Context.get(Store.class);
            String id = request.getParameter(DOC_ID);
            long docId = Long.parseLong(id);
            if (StringUtils.isEmpty(suffix)) {
                suffix = "thumb.png";
            }
            if ((doc = (Document)(docDao = Context.get(DocumentDAO.class)).findById(docId)).getDocRef() != null) {
                doc = (Document)docDao.findById(doc.getDocRef());
                docId = doc.getId();
            }
            String fileVersion = this.getFileVersion(request, docId, doc);
            Session session = ServletUtil.validateSession(request);
            User user = session.getUser();
            this.checkPublication(doc, user);
            DocumentDAO dDao = Context.get(DocumentDAO.class);
            Set<Permission> allowedPermissions = dDao.getAllowedPermissions(docId, user.getId());
            if (!allowedPermissions.contains((Object)Permission.READ) || !allowedPermissions.contains((Object)Permission.PREVIEW)) {
                throw new PermissionException(user.getUsername(), doc.toString(), Permission.PREVIEW);
            }
            String resource = store.getResourceName(docId, fileVersion, suffix);
            this.createImageResource(session.getSid(), doc, fileVersion, resource);
            ServletUtil.downloadDocument(request, response, session.getSid(), docId, fileVersion, store.getResourceName(doc, fileVersion, suffix), suffix, user);
        }
        catch (PersistenceException | InvalidSessionException | PermissionException | ServletException | IOException | NumberFormatException e) {
            log.error(e.getMessage(), e);
            ServletUtil.sendError(response, e.getMessage());
        }
    }

    private void checkPublication(Document doc, User user) throws FileNotFoundException {
        if (!(doc == null || user.isMemberOf("admin") || user.isMemberOf("publisher") || doc.isPublishing())) {
            throw new FileNotFoundException("Document not published");
        }
    }

    private String getFileVersion(HttpServletRequest request, long docId, Document doc) throws PersistenceException {
        VersionDAO vDao;
        Version ver;
        String version = request.getParameter(VERSION);
        String fileVersion = request.getParameter(FILE_VERSION);
        if (StringUtils.isEmpty(fileVersion)) {
            fileVersion = doc.getFileVersion();
        }
        if (version != null && (ver = (vDao = Context.get(VersionDAO.class)).findByVersion(docId, version)) != null) {
            fileVersion = ver.getFileVersion();
        }
        return fileVersion;
    }

    protected void createImageResource(String sid, Document doc, String fileVersion, String resource) {
        this.buildThumbnail(sid, doc, fileVersion, resource);
        if (resource.endsWith("thumb.png")) {
            return;
        }
        if (resource.endsWith("tile.png")) {
            this.createTileImage(sid, doc, fileVersion, resource);
        } else if (resource.contains("thumb")) {
            this.createThumbnailImage(sid, doc, fileVersion, resource);
        } else {
            log.error("Unknow resource {}", (Object)resource);
        }
    }

    private void createThumbnailImage(String sid, Document doc, String fileVersion, String resource) {
        Store store = Context.get(Store.class);
        if (store.size(doc.getId(), resource) <= 0L) {
            try {
                String sizeStr = resource.substring(resource.indexOf(45) + 6, resource.lastIndexOf(46));
                ThumbnailManager thumbManager = Context.get(ThumbnailManager.class);
                thumbManager.createTumbnail(doc, fileVersion, Integer.parseInt(sizeStr), null, sid);
                log.debug("Created custom thumbnail {}", (Object)resource);
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
        }
    }

    private void createTileImage(String sid, Document doc, String fileVersion, String resource) {
        Store store = Context.get(Store.class);
        String tileResource = store.getResourceName(doc, fileVersion, "tile.png");
        if (store.size(doc.getId(), tileResource) <= 0L) {
            try {
                ThumbnailManager thumbManager = Context.get(ThumbnailManager.class);
                thumbManager.createTile(doc, fileVersion, sid);
                log.debug("Created tile {}", (Object)resource);
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
        }
    }

    private void buildThumbnail(String sid, Document doc, String fileVersion, String resource) {
        Store store = Context.get(Store.class);
        ThumbnailManager thumbManager = Context.get(ThumbnailManager.class);
        String thumbResource = store.getResourceName(doc, fileVersion, "thumb.png");
        if (store.size(doc.getId(), thumbResource) <= 0L) {
            try {
                thumbManager.createTumbnail(doc, fileVersion, sid);
                log.debug("Created thumbnail {}", (Object)resource);
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
        }
    }
}

