/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import java.io.File;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFolderCleaner {
    private static final Logger log = LoggerFactory.getLogger(TempFolderCleaner.class);

    public void clean() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        log.debug("Got temporary folder {}", (Object)tempDir.getPath());
        int retentionDays = 1;
        File[] fileArray = tempDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            long diff = new Date().getTime() - f.lastModified();
            if (f.isFile() && !f.getName().endsWith(".data") && diff > (long)(retentionDays * 24 * 60 * 60 * 1000)) {
                FileUtils.deleteQuietly(f);
                if (!f.exists()) {
                    log.debug("Deleted file {}", (Object)f.getPath());
                }
            }
            ++n2;
        }
    }
}

