/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.util.SystemUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.config.LogConfigurator;
import com.logicaldoc.util.config.OrderedProperties;
import com.logicaldoc.util.csv.CSVFileWriter;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDownload
extends HttpServlet {
    private static final String DOT_PROPERTIES = ".properties";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LogDownload.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ServletUtil.checkMenu(request, 72L);
        }
        catch (Exception t) {
            ServletUtil.sendError(response, t.getMessage());
        }
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
        String appender = request.getParameter("appender");
        File file = null;
        try {
            if ("all".equals(appender)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                response.setContentType("application/zip");
                response.setHeader("Content-Disposition", "attachment; filename=\"ldoc-log-" + df.format(new Date()) + ".zip\"");
                file = this.prepareAllSupportResources();
            } else if (appender != null) {
                response.setContentType("text/html");
                LogConfigurator conf = new LogConfigurator();
                if (conf.getFile(appender, true) != null) {
                    file = new File(conf.getFile(appender, true));
                }
            }
            if (file == null) {
                return;
            }
            this.downloadLogFile(response, appender, file);
        }
        catch (PersistenceException | IOException e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void downloadLogFile(HttpServletResponse response, String appender, File file) throws IOException {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                if (file.length() > 1L) {
                    response.setHeader("Content-Length", Long.toString(file.length()));
                    byte[] buf = new byte[1024];
                    int read = 1;
                    while (read > 0) {
                        read = ((InputStream)is).read(buf, 0, buf.length);
                        if (read <= 0) continue;
                        response.getOutputStream().write(buf, 0, read);
                    }
                } else {
                    response.setHeader("Content-Length", "0");
                    response.getWriter().println("");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if ("all".equals(appender) && file != null) {
                FileUtils.deleteQuietly(file);
            }
        }
    }

    private File prepareAllSupportResources() throws IOException, PersistenceException {
        File tmp = FileUtil.createTempFile("logs", ".zip");
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tmp));){
            LogConfigurator conf = new LogConfigurator();
            File logsDir = new File(conf.getLogsRoot());
            File[] files = logsDir.listFiles();
            Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
            HashMap<String, Integer> counter = new HashMap<String, Integer>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String baseName = StringUtils.substringBefore((String)FilenameUtils.getBaseName(file.getName()), (String)".");
                counter.computeIfAbsent(baseName, k -> 0);
                if (file.length() > 0L && (Integer)counter.get(baseName) < 10 && !file.getName().toLowerCase().contains(".html")) {
                    this.writeEntry(out, "logicaldoc/logs/" + file.getName(), file);
                    counter.computeIfPresent(baseName, (k, v) -> v + 1);
                }
                ++n2;
            }
            OrderedProperties prop = this.writeContextPropertiesDump(out);
            this.writeConfigFiles(out);
            Object env = SystemUtil.printEnvironment();
            env = (String)env + "\n\n" + this.printDatabaseEnvironment();
            File buf = FileUtil.createTempFile("environment", ".txt");
            FileUtil.writeFile((String)env, buf.getPath());
            this.writeEntry(out, "logicaldoc/conf/environment.txt", buf);
            FileUtil.delete(buf);
            ServletContext context = this.getServletContext();
            File webappFolder = new File(context.getRealPath("/WEB-INF/web.xml"));
            webappFolder = webappFolder.getParentFile().getParentFile().getParentFile().getParentFile();
            this.writeTomcatConfigFiles(out, webappFolder);
            this.writeTomcatLogs(out, webappFolder);
            this.writeUpdateLogs(out);
            this.writePatchLogs(out);
            this.dumpStats(out);
            this.dumpLegals(out);
            prop.store(new FileOutputStream(buf), "Support Request");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tmp;
    }

    private String printDatabaseEnvironment() {
        DocumentDAO dao = (DocumentDAO)Context.get("documentDAO");
        Properties prop = new Properties();
        prop.putAll(dao.getDatabaseMetadata());
        StringWriter writer = new StringWriter();
        try {
            prop.store(new PrintWriter(writer), "Database Environment");
            return writer.getBuffer().toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private void writeTomcatLogs(ZipOutputStream out, File webappDir) throws IOException {
        File logsDir = new File(webappDir.getPath() + "/logs");
        File[] files = logsDir.listFiles();
        Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String baseName = StringUtils.substringBefore((String)FilenameUtils.getBaseName(file.getName()), (String)".");
            counter.computeIfAbsent(baseName, k -> 0);
            if (file.length() > 0L && (Integer)counter.get(baseName) < 10) {
                this.writeEntry(out, "tomcat/logs/" + file.getName(), file);
                counter.computeIfPresent(file.getName(), (k, v) -> v + 1);
            }
            ++n2;
        }
    }

    private void writeTomcatConfigFiles(ZipOutputStream out, File webappDir) throws IOException {
        File[] files;
        File confDir = new File(webappDir.getPath() + "/conf");
        File[] fileArray = files = confDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory() && (file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(DOT_PROPERTIES) || file.getName().toLowerCase().endsWith(".policy"))) {
                this.writeEntry(out, "tomcat/conf/" + file.getName(), file);
            }
            ++n2;
        }
    }

    private void writeConfigFiles(ZipOutputStream out) throws IOException {
        File[] files;
        File confDir = new File(Context.get().getProperties().getProperty("LDOCHOME") + "/conf");
        File[] fileArray = files = confDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory() && (file.getName().toLowerCase().contains(DOT_PROPERTIES) || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".txt"))) {
                this.writeEntry(out, "logicaldoc/conf/" + file.getName(), file);
            }
            ++n2;
        }
    }

    private void writeUpdateLogs(ZipOutputStream out) throws IOException, PersistenceException {
        Properties buildProperties = this.loadBuildProperties();
        String dir = StringSubstitutor.replace((Object)buildProperties.getProperty("update.dir"), (Properties)buildProperties);
        File logsDir = new File(dir);
        File[] files = logsDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(".log")) {
                    this.writeEntry(out, "logicaldoc/updates/" + file.getName(), file);
                }
                ++n2;
            }
        }
        this.dumpUpdateTable(out);
    }

    private void dumpUpdateTable(ZipOutputStream out) throws IOException, PersistenceException {
        File buf = FileUtil.createTempFile("updates", ".csv");
        try {
            DocumentDAO dao = Context.get(DocumentDAO.class);
            dao.queryForResultSet("select ld_update, ld_date, ld_version from ld_update order by ld_date desc", null, null, rows -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (CSVFileWriter csv = new CSVFileWriter(buf.getAbsolutePath(), ',');){
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        while (rows.next()) {
                            csv.writeFields(List.of(df.format(rows.getDate(2)), rows.getString(3), rows.getString(1)));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            });
            this.writeEntry(out, "logicaldoc/updates/updates.csv", buf);
        }
        finally {
            FileUtil.delete(buf);
        }
    }

    private void dumpStats(ZipOutputStream out) throws IOException, PersistenceException {
        File buf = FileUtil.createTempFile("stats", ".csv");
        try {
            GenericDAO dao = Context.get(GenericDAO.class);
            dao.queryForResultSet("select ld_subtype, ld_tenantid, ld_integer1 from ld_generic where ld_type = 'stat' order by ld_subtype, ld_tenantid", null, null, rows -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (CSVFileWriter csv = new CSVFileWriter(buf.getAbsolutePath(), ',');){
                        csv.writeFields(List.of("Stat", "Tenant", "Value"));
                        while (rows.next()) {
                            csv.writeFields(List.of(rows.getString(1), Long.toString(rows.getLong(2)), Long.toString(rows.getLong(3))));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    throw new PersistenceException(ioe);
                }
            });
            this.writeEntry(out, "stats.csv", buf);
        }
        finally {
            FileUtil.delete(buf);
        }
    }

    private void dumpLegals(ZipOutputStream out) throws IOException, PersistenceException {
        File buf = FileUtil.createTempFile("legals", ".csv");
        try {
            GenericDAO dao = Context.get(GenericDAO.class);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            dao.queryForResultSet("select ld_name, ld_category, ld_title, ld_username, B.ld_date from ld_legal A, ld_legal_confirmation B where ld_legal=ld_name order by ld_name, B.ld_date desc", null, null, rows -> {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (CSVFileWriter csv = new CSVFileWriter(buf.getAbsolutePath(), ',');){
                        csv.writeFields(List.of("Legal", "Category", "Title", "Confirmed by", "Confirmed on"));
                        while (rows.next()) {
                            csv.writeFields(List.of(rows.getString(1), rows.getString(2), rows.getString(3), rows.getString(4), df.format(rows.getTimestamp(5))));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    throw new PersistenceException(ioe);
                }
            });
            this.writeEntry(out, "legals.csv", buf);
        }
        finally {
            FileUtil.delete(buf);
        }
    }

    private void writePatchLogs(ZipOutputStream out) throws IOException, PersistenceException {
        Properties buildProperties = this.loadBuildProperties();
        String dir = StringSubstitutor.replace((Object)buildProperties.getProperty("patch.dir"), (Properties)buildProperties);
        File logsDir = new File(dir);
        File[] files = logsDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(".log")) {
                    this.writeEntry(out, "logicaldoc/patches/" + file.getName(), file);
                }
                ++n2;
            }
        }
        this.dumpPatchTable(out);
    }

    private void dumpPatchTable(ZipOutputStream out) throws IOException, PersistenceException {
        File buf = FileUtil.createTempFile("patches", ".csv");
        try {
            DocumentDAO dao = Context.get(DocumentDAO.class);
            dao.queryForResultSet("select ld_patch, ld_date, ld_version from ld_patch order by ld_date desc", null, null, rows -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (CSVFileWriter csv = new CSVFileWriter(buf.getAbsolutePath(), ',');){
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        while (rows.next()) {
                            csv.writeFields(List.of(df.format(rows.getDate(2)), rows.getString(3), rows.getString(1)));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            });
            this.writeEntry(out, "logicaldoc/patches/patches.csv", buf);
        }
        finally {
            FileUtil.delete(buf);
        }
    }

    private Properties loadBuildProperties() throws IOException {
        Properties buildProperties = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(new File(Context.get().getProperties().getProperty("LDOCHOME") + "/conf/build.properties"));){
            buildProperties.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return buildProperties;
    }

    private OrderedProperties writeContextPropertiesDump(ZipOutputStream out) throws IOException {
        File buf = FileUtil.createTempFile("context", DOT_PROPERTIES);
        ContextProperties cp = Context.get().getProperties();
        OrderedProperties prop = new OrderedProperties();
        for (String key : cp.getKeys()) {
            if (key.contains("password")) continue;
            prop.put(key, cp.get(key));
        }
        prop.store(new FileOutputStream(buf), "Support Request");
        this.writeEntry(out, "logicaldoc/conf/context-dump.properties", buf);
        FileUtil.delete(buf);
        return prop;
    }

    public void writeEntry(ZipOutputStream out, String entry, File file) throws IOException {
        Throwable throwable = null;
        Object var7_6 = null;
        try (FileInputStream in = new FileInputStream(file);){
            out.putNextEntry(new ZipEntry(entry));
            byte[] b = new byte[1024];
            int count = 0;
            while ((count = in.read(b)) > 0) {
                out.write(b, 0, count);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doGet(request, response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

