/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.ResultSetWalker;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegalServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LegalServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String legal = request.getParameter("legal");
            if (StringUtils.isNotEmpty((CharSequence)legal)) {
                this.downloadLegal(request, response, legal);
            } else {
                this.listConfirmedLegals(request, response);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            ServletUtil.sendError(response, e.getMessage());
        }
    }

    private void listConfirmedLegals(HttpServletRequest request, HttpServletResponse response) throws IOException, PersistenceException {
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
        String userName = request.getParameter("user");
        final PrintWriter writer = response.getWriter();
        writer.write("<list>");
        final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        Context.get(UserDAO.class).queryForResultSet("select ld_name, ld_category, ld_title, B.ld_date from ld_legal A, ld_legal_confirmation B where ld_legal=ld_name and ld_username = :userName order by ld_sort asc, B.ld_date desc", Map.of("userName", userName), null, new ResultSetWalker(){

            @Override
            public void walk(ResultSet rows) throws SQLException {
                while (rows.next()) {
                    writer.print("<legal>");
                    writer.print("<name><![CDATA[" + rows.getString(1) + "]]></name>");
                    writer.print("<category><![CDATA[" + rows.getString(2) + "]]></category>");
                    writer.print("<title><![CDATA[" + rows.getString(3) + "]]></title>");
                    writer.print("<confirmed>" + df.format(rows.getTimestamp(4)) + "</confirmed>");
                    writer.print("</legal>");
                }
            }
        });
        writer.write("</list>");
    }

    private void downloadLegal(HttpServletRequest request, HttpServletResponse response, String legal) throws PersistenceException, IOException {
        String content = Context.get(DocumentDAO.class).queryForString("select ld_content from ld_legal where ld_name = :legal", Map.of("legal", legal));
        ServletUtil.setContentDisposition(request, response, legal + ".pdf");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] legalBytes = decoder.decode(content);
        Throwable throwable = null;
        Object var8_9 = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(legalBytes);){
            bis.transferTo((OutputStream)response.getOutputStream());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

