/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.transfer.ZipExport;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportZip
extends HttpServlet {
    private static final String DOC_ID = "docId";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ExportZip.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Session session = ServletUtil.validateSession(request);
            FolderDAO folderDao = Context.get(FolderDAO.class);
            Object folderId = request.getParameter("folderId");
            if (folderId != null) {
                Folder folder = folderDao.findFolder(Long.parseLong((String)folderId));
                folderId = "" + folder.getId();
            }
            String level = this.getLevel(request);
            ArrayList<Long> docIds = this.getDocIds(request, session.getUserId());
            ZipExport exporter = new ZipExport();
            if (level.equals("all")) {
                exporter.setAllLevel(true);
            }
            Throwable throwable = null;
            Object var10_12 = null;
            try (ByteArrayOutputStream bos = this.getZipFileOutputStream(session, (String)folderId, docIds, exporter);){
                String exportName = this.getExportName((String)folderId);
                response.setContentType("application/zip");
                response.setContentLength(bos.size());
                response.setHeader("Content-Disposition", "attachment; filename=\"" + exportName + ".zip\"");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0,pre-check=0");
                response.setHeader("Expires", "0");
                Throwable throwable2 = null;
                Object var14_18 = null;
                try (ServletOutputStream os = response.getOutputStream();){
                    bos.flush();
                    os.write(bos.toByteArray());
                    os.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private ByteArrayOutputStream getZipFileOutputStream(Session session, String folderId, ArrayList<Long> docIds, ZipExport exporter) throws PersistenceException {
        ByteArrayOutputStream bos = null;
        if (CollectionUtils.isNotEmpty(docIds)) {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSessionId(session.getSid());
            transaction.setEvent(DocumentEvent.DOWNLOADED);
            transaction.setSession(session);
            bos = exporter.process(docIds.toArray(new Long[0]), false, transaction);
        } else {
            FolderHistory transaction = new FolderHistory();
            transaction.setFolderId(Long.parseLong(folderId));
            transaction.setSession(session);
            bos = exporter.process(transaction, false);
        }
        return bos;
    }

    private String getExportName(String folderId) throws PersistenceException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Object exportName = "export";
        if (folderId != null) {
            Folder folder = (Folder)folderDao.findById(Long.parseLong(folderId));
            exportName = folder.getName().matches("[\\p{Punct}\\p{Space}\\p{IsLatin}\\p{Digit}]+") ? (String)exportName + "-" + folder.getName() : (String)exportName + "-" + folder.getId();
        }
        return exportName;
    }

    private ArrayList<Long> getDocIds(HttpServletRequest request, Long userId) throws PersistenceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        ArrayList<Long> docIds = new ArrayList<Long>();
        if (request.getParameterValues(DOC_ID) != null && request.getParameterValues(DOC_ID).length > 0) {
            String[] ids = request.getParameterValues(DOC_ID);
            int i = 0;
            while (i < ids.length) {
                Document doc = docDao.findDocument(Long.parseLong(ids[i]));
                Long docId = Long.parseLong(ids[i]);
                if (doc != null && folderDao.isDownloadllowed(doc.getFolder().getId(), userId) && !docIds.contains(docId)) {
                    docIds.add(docId);
                }
                ++i;
            }
        }
        return docIds;
    }

    private String getLevel(HttpServletRequest request) {
        String level = request.getParameter("level");
        if (level == null) {
            level = "all";
        }
        return level;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            out.println("<HTML>");
            out.println("  <HEAD><TITLE>Download Document Servlet</TITLE></HEAD>");
            out.println("  <BODY>");
            out.print("    This is ");
            out.print(((Object)((Object)this)).getClass());
            out.println(", using the POST method");
            out.println("  </BODY>");
            out.println("</HTML>");
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

