/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.util.spring.Context;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServlet
extends HttpServlet {
    private static final long serialVersionUID = -6956612970433309888L;
    private static final Logger log = LoggerFactory.getLogger("console");

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (Context.get().getProperties().getBoolean("echo.enabled", false) && log.isInfoEnabled()) {
            log.info(this.getUrl(request));
            log.info(this.getContent(request));
        }
    }

    private String getContent(HttpServletRequest request) throws IOException {
        String content = "";
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            content = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return content;
    }

    private String getUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String queryString = request.getQueryString();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        url.append(contextPath).append(servletPath);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }
}

